/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.netbeans.modules.autoupdate.AutoupdateType;
import org.netbeans.modules.autoupdate.Settings;
import org.netbeans.modules.autoupdate.Updates;
import org.netbeans.modules.autoupdate.XMLUpdates;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class XMLAutoupdateType
extends AutoupdateType {
    static final String PROP_URL = "URL";
    private URL url;
    private String defaultURL;
    private static final String UPDATE_VERSION_PROP = "netbeans.autoupdate.version";
    private static final String IDE_HASH_CODE = "netbeans.hash.code";
    public static final String UPDATE_VERSION = "1.20";
    private static final String SYSPROP_COUNTRY = "netbeans.autoupdate.country";
    private static final String SYSPROP_LANGUAGE = "netbeans.autoupdate.language";
    private static final String SYSPROP_VARIANT = "netbeans.autoupdate.variant";
    static final long serialVersionUID = 362844553432169452L;
    private String displayName = null;
    private FileObject typeFileObject = null;
    private String url_key;
    private String localizingBundleName;
    private boolean valid = true;

    public XMLAutoupdateType() {
        try {
            this.url = new URL(this.getDefaultURL());
        }
        catch (MalformedURLException e) {
            this.url = null;
        }
    }

    public XMLAutoupdateType(URL url) {
        this.url = url;
    }

    public XMLAutoupdateType(URL url, String displayName, String url_key, Boolean enabled) {
        this(url, displayName, null, url_key, enabled);
    }

    public XMLAutoupdateType(URL url, String displayName, FileObject fo, String url_key, Boolean enabled) {
        this(url, displayName, fo, url_key, enabled, null);
    }

    public XMLAutoupdateType(URL url, String displayName, FileObject fo, String url_key, Boolean enabled, String localizingBundleName) {
        this.typeFileObject = fo;
        this.url = url;
        this.displayName = displayName;
        this.url_key = url_key;
        this.localizingBundleName = localizingBundleName;
        if (enabled != null) {
            this.setEnabled(enabled);
        }
    }

    public static XMLAutoupdateType createXMLAutoupdateType(FileObject fo) throws IOException {
        URL url;
        String sKey = (String)fo.getAttribute("url_key");
        String remoteBundleName = (String)fo.getAttribute("SystemFileSystem.localizingBundle");
        ResourceBundle bundle = XMLAutoupdateType.getBundleFromName(remoteBundleName);
        if (sKey != null) {
            String localizedValue;
            try {
                localizedValue = bundle.getString(sKey);
            }
            catch (MissingResourceException mre) {
                localizedValue = "http://";
            }
            url = new URL(localizedValue);
        } else {
            Object o = fo.getAttribute("url");
            url = o instanceof String ? new URL((String)o) : (URL)o;
        }
        Boolean en = (Boolean)fo.getAttribute("enabled");
        return new XMLAutoupdateType(url, null, fo, sKey, en, remoteBundleName);
    }

    public String displayName() {
        if (this.displayName == null) {
            if (this.typeFileObject != null) {
                try {
                    FileSystem fs = this.typeFileObject.getFileSystem();
                    FileSystem.Status s = fs.getStatus();
                    String x = s.annotateName("", Collections.singleton(this.typeFileObject));
                    if (!x.equals("")) {
                        this.displayName = x;
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
            if (this.displayName == null) {
                this.displayName = NbBundle.getBundle((Class)Settings.class).getString("CTL_XMLAutoupdateType_Name");
            }
        }
        return this.displayName;
    }

    public URL getURL() {
        return this.url;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(XMLAutoupdateType.class);
    }

    public void setURL(URL url) {
        URL old = this.url;
        this.url = url;
        this.firePropertyChange(PROP_URL, old, url);
    }

    public Updates connectForUpdates() {
        return new XMLUpdates(this.modifyURL(this.url));
    }

    protected URL modifyURL(URL original) {
        URL updateURL = null;
        if (System.getProperty(UPDATE_VERSION_PROP) == null) {
            System.setProperty(UPDATE_VERSION_PROP, UPDATE_VERSION);
        }
        if (System.getProperty(IDE_HASH_CODE) == null) {
            String id = "";
            try {
                id = Settings.getShared().getIdeIdentity();
            }
            catch (NullPointerException npe) {
                ErrorManager.getDefault().log(16, "Warning: Property PROP_IDE_IDENTITY hasn't been initialized yet.");
            }
            String prefix = NbBundle.getBundle((Class)XMLAutoupdateType.class).getString("URL_Prefix_Hash_Code");
            System.setProperty(IDE_HASH_CODE, "".equals(id) ? prefix + "0" : prefix + id);
        }
        try {
            updateURL = new URL(this.encode(this.replace(original.toString())));
        }
        catch (MalformedURLException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return updateURL;
    }

    protected String replace(String string) {
        XMLAutoupdateType.setSystemProperties();
        if (string == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int prevIndex = 0;
        int index = 0;
        while ((index = string.indexOf("{", index)) != -1 && index < string.length() - 1) {
            if (string.charAt(index + 1) == '{' || string.charAt(index + 1) != '$') {
                ++index;
                continue;
            }
            sb.append(string.substring(prevIndex, index));
            int endBracketIndex = string.indexOf("}", index);
            if (endBracketIndex != -1) {
                String whatToReplace = string.substring(index + 2, endBracketIndex);
                sb.append(this.getReplacement(whatToReplace));
            }
            prevIndex = endBracketIndex == -1 ? index + 2 : endBracketIndex + 1;
            ++index;
        }
        if (prevIndex < string.length() - 1) {
            sb.append(string.substring(prevIndex));
        }
        return sb.toString();
    }

    boolean isValid() {
        return this.valid;
    }

    protected String getReplacement(String whatToReplace) {
        return System.getProperty(whatToReplace, "");
    }

    protected String encode(String stringURL) {
        String rval = stringURL;
        int q = stringURL.indexOf(63);
        if (q > 0) {
            StringBuffer buf = new StringBuffer(stringURL.substring(0, q + 1));
            StringTokenizer st = new StringTokenizer(stringURL.substring(q + 1), "&");
            while (st.hasMoreTokens()) {
                String a = st.nextToken();
                int ei = a.indexOf("=");
                if (ei < 0) {
                    buf.append(URLEncoder.encode(a));
                } else {
                    buf.append(URLEncoder.encode(a.substring(0, ei)));
                    buf.append("=");
                    String tna = a.substring(ei + 1);
                    int tni = tna.indexOf("%");
                    if (tni < 0) {
                        buf.append(URLEncoder.encode(tna));
                    } else {
                        buf.append(URLEncoder.encode(tna.substring(0, tni)));
                        buf.append("%");
                        buf.append(URLEncoder.encode(tna.substring(tni + 1)));
                    }
                }
                if (!st.hasMoreTokens()) continue;
                buf.append("&");
            }
            rval = buf.toString();
        }
        return rval;
    }

    private static ResourceBundle getOldLocalizingBundle() {
        return NbBundle.getBundle((Class)XMLAutoupdateType.class);
    }

    private static ResourceBundle getBundleFromName(String name) throws MissingResourceException {
        ResourceBundle bundle = null;
        bundle = name == null ? XMLAutoupdateType.getOldLocalizingBundle() : NbBundle.getBundle((String)name);
        return bundle;
    }

    private static void setSystemProperties() {
        if (System.getProperty(SYSPROP_COUNTRY, null) == null) {
            System.setProperty(SYSPROP_COUNTRY, Locale.getDefault().getCountry());
        }
        if (System.getProperty(SYSPROP_LANGUAGE, null) == null) {
            System.setProperty(SYSPROP_LANGUAGE, Locale.getDefault().getLanguage());
        }
        if (System.getProperty(SYSPROP_VARIANT, null) == null) {
            System.setProperty(SYSPROP_VARIANT, Locale.getDefault().getVariant());
        }
    }

    protected String getDefaultURL() {
        if (this.defaultURL == null) {
            ResourceBundle remoteBundle = null;
            try {
                remoteBundle = XMLAutoupdateType.getBundleFromName(this.localizingBundleName);
                this.defaultURL = this.url_key != null ? remoteBundle.getString(this.url_key) : remoteBundle.getString("URL_Default_N");
            }
            catch (MissingResourceException mre) {
                this.valid = false;
                return null;
            }
        }
        return this.defaultURL;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.url.toString().equals(this.getDefaultURL())) {
            out.writeObject(null);
        } else {
            out.writeObject(this.url);
        }
        out.writeObject(this.displayName);
        out.writeObject(this.url_key);
        out.writeObject(this.localizingBundleName);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        URL u = null;
        try {
            String remoteBundleName;
            String key;
            this.valid = true;
            u = (URL)in.readObject();
            String display = (String)in.readObject();
            if (display != null) {
                this.displayName = display;
            }
            if ((key = (String)in.readObject()) != null) {
                this.url_key = key;
            }
            if ((remoteBundleName = (String)in.readObject()) != null) {
                this.localizingBundleName = remoteBundleName;
            }
        }
        catch (OptionalDataException ode) {
            if (ode.eof) {
                u = null;
                this.setEnabled(true);
            }
            throw ode;
        }
        if (u == null || u.toString().startsWith("http://www.netbeans.org/updates/31_")) {
            String urlSpec = this.getDefaultURL();
            if (urlSpec != null) {
                this.setURL(new URL(urlSpec));
            }
        } else {
            this.setURL(u);
        }
        if (!this.isValid()) {
            this.setEnabled(false);
            this.displayName = NbBundle.getMessage((Class)XMLAutoupdateType.class, (String)"XMLAutoupdateType_InvalidSetting", (Object)this.displayName);
        }
    }
}

