/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.db.explorer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverListener;
import org.netbeans.modules.db.explorer.actions.AddDriverAction;
import org.netbeans.modules.db.explorer.driver.JDBCDriverConvertor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderLookup;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class JDBCDriverManager {
    private static JDBCDriverManager DEFAULT = null;
    private Lookup.Result result = this.getLookupResult();
    private List listeners = new ArrayList(1);

    public static synchronized JDBCDriverManager getDefault() {
        if (DEFAULT == null) {
            JDBCDriverConvertor.importOldDrivers();
            DEFAULT = new JDBCDriverManager();
        }
        return DEFAULT;
    }

    private JDBCDriverManager() {
        this.result.allInstances();
        this.result.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent e) {
                JDBCDriverManager.this.fireListeners();
            }
        });
    }

    public JDBCDriver[] getDrivers() {
        Collection drivers = this.result.allInstances();
        return drivers.toArray(new JDBCDriver[drivers.size()]);
    }

    public JDBCDriver[] getDrivers(String drvClass) {
        if (drvClass == null) {
            throw new NullPointerException();
        }
        LinkedList<JDBCDriver> result = new LinkedList<JDBCDriver>();
        JDBCDriver[] drvs = this.getDrivers();
        for (int i = 0; i < drvs.length; ++i) {
            if (!drvClass.equals(drvs[i].getClassName())) continue;
            result.add(drvs[i]);
        }
        return result.toArray(new JDBCDriver[result.size()]);
    }

    public void addDriver(JDBCDriver driver) throws DatabaseException {
        if (driver == null) {
            throw new NullPointerException();
        }
        try {
            JDBCDriverConvertor.create(driver);
        }
        catch (IOException ioe) {
            throw new DatabaseException(ioe);
        }
    }

    public void removeDriver(JDBCDriver driver) throws DatabaseException {
        try {
            JDBCDriverConvertor.remove(driver);
        }
        catch (IOException ioe) {
            throw new DatabaseException(ioe);
        }
    }

    public void showAddDriverDialog() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    new AddDriverAction.AddDriverDialogDisplayer().showDialog();
                }
            });
        } else {
            new AddDriverAction.AddDriverDialogDisplayer().showDialog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDriverListener(JDBCDriverListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDriverListener(JDBCDriverListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireListeners() {
        List list = this.listeners;
        synchronized (list) {
            ArrayList listenersCopy = new ArrayList(this.listeners);
        }
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            JDBCDriverListener listener = (JDBCDriverListener)i.next();
            listener.driversChanged();
        }
    }

    private synchronized Lookup.Result getLookupResult() {
        if (this.result == null) {
            FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("Databases/JDBCDrivers");
            DataFolder folder = DataFolder.findFolder((FileObject)fo);
            this.result = new FolderLookup((DataObject.Container)folder).getLookup().lookup(new Lookup.Template(JDBCDriver.class));
        }
        return this.result;
    }
}

