/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.jmi.mapping;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.mdr.JMIStreamFactory;

public class FileStreamFactory
extends JMIStreamFactory {
    private final File targetDir;
    private final long modelLastModified;

    public FileStreamFactory(File targetDir) {
        this(targetDir, null);
    }

    public FileStreamFactory(File targetDir, Date modelLastModified) {
        if (targetDir == null) {
            throw new IllegalArgumentException("ERROR: targetDir is null");
        }
        if (!targetDir.exists()) {
            throw new IllegalArgumentException("ERROR: targetDir does not exist");
        }
        if (!targetDir.isDirectory()) {
            throw new IllegalArgumentException("ERROR: targetDir has to be a directory");
        }
        this.targetDir = targetDir;
        this.modelLastModified = modelLastModified != null ? modelLastModified.getTime() : 0L;
    }

    public OutputStream createStream(List pkg, String className, String extension) throws IOException {
        File current = this.targetDir;
        Iterator it = pkg.iterator();
        while (it.hasNext()) {
            if ((current = new File(current, (String)it.next())).exists()) continue;
            current.mkdir();
        }
        return this.createStream(new File(current, className + "." + extension));
    }

    protected OutputStream createStream(File file) throws IOException {
        return this.modelLastModified == 0L || this.modelLastModified > file.lastModified() ? new FileOutputStream(file) : null;
    }
}

