/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.util.Collections;
import java.util.List;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;

public final class GeneratorUtils {
    public static final int GETTER = 1;
    public static final int SETTER = 2;

    private GeneratorUtils() {
    }

    private static String getCapitalizedName(String name) {
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    private static String[] getGetterSetterNames(Field f, boolean getter) {
        Type t;
        String[] result = getter ? ((t = f.getType()) instanceof PrimitiveType && PrimitiveTypeKindEnum.BOOLEAN.equals((Object)((PrimitiveType)t).getKind()) ? new String[]{"is" + GeneratorUtils.getCapitalizedName(f.getName()), "get" + GeneratorUtils.getCapitalizedName(f.getName())} : new String[]{"get" + GeneratorUtils.getCapitalizedName(f.getName())}) : new String[]{"set" + GeneratorUtils.getCapitalizedName(f.getName())};
        return result;
    }

    public static String getGetterSetterName(Field f, boolean getter) {
        return GeneratorUtils.getGetterSetterNames(f, getter)[0];
    }

    public static Method createGetterSetter(Field f, boolean getter, int position) {
        ClassDefinition where = f.getDeclaringClass();
        JavaModelPackage pack = (JavaModelPackage)where.refImmediatePackage();
        Method method = pack.getMethod().createMethod();
        boolean isStatic = false;
        TypeReference fieldTypeName = JavaModelUtil.resolveImportsForType((Element)where, (Type)f.getType());
        String fieldName = f.getName();
        method.setName(GeneratorUtils.getGetterSetterName(f, getter));
        method.setModifiers(1 | (isStatic ? 8 : 0));
        if (getter) {
            method.setBodyText("return " + fieldName + ";");
            method.setTypeName(fieldTypeName);
        } else {
            Parameter param = pack.getParameter().createParameter();
            String paramName = isStatic ? "a" + GeneratorUtils.getCapitalizedName(fieldName) : fieldName;
            param.setTypeName(fieldTypeName);
            param.setName(paramName);
            method.getParameters().add(param);
            if (isStatic) {
                method.setBodyText(fieldName + " = " + paramName + ";");
            } else {
                method.setBodyText("this." + fieldName + " = " + paramName + ";");
            }
            method.setType(pack.getPrimitiveType().resolve("void"));
        }
        List features = where.getFeatures();
        if (position == -1) {
            features.add(method);
        } else {
            Feature[] featuresArr = features.toArray(new Feature[0]);
            int afterThis = -1;
            int cntr = 0;
            while (cntr < featuresArr.length && JavaMetamodel.getManager().getElementPosition((Element)featuresArr[cntr]).getEnd().getOffset() < position) {
                afterThis = cntr++;
            }
            if (afterThis == -1) {
                features.add(method);
            } else {
                features.add(afterThis + 1, method);
            }
        }
        return method;
    }

    public static int checkForGetterSetter(Field f) {
        int cntr;
        ClassDefinition where = f.getDeclaringClass();
        String[] getterNames = GeneratorUtils.getGetterSetterNames(f, true);
        String[] setterNames = GeneratorUtils.getGetterSetterNames(f, false);
        boolean getterFound = false;
        boolean setterFound = false;
        List<Type> setterPars = Collections.singletonList(f.getType());
        for (cntr = 0; cntr < getterNames.length; ++cntr) {
            if (where.getMethod(getterNames[cntr], Collections.EMPTY_LIST, false) == null) continue;
            getterFound = true;
            break;
        }
        for (cntr = 0; cntr < setterNames.length; ++cntr) {
            if (where.getMethod(setterNames[cntr], setterPars, false) == null) continue;
            setterFound = true;
            break;
        }
        return (getterFound ? 1 : 0) | (setterFound ? 2 : 0);
    }

    public static void overrideMethod(ClassDefinition where, Method method, int position) {
        Method newMethod;
        int mods = method.getModifiers();
        List features = where.getContents();
        if (method.getResource().getName().endsWith(".class")) {
            newMethod = (Method)JavaModelUtil.duplicateInScope((Element)where, (Element)method);
        } else {
            Method tempMethod = (Method)method.duplicate();
            tempMethod.setJavadocText(null);
            tempMethod.setBody(null);
            newMethod = (Method)JavaModelUtil.duplicateInScope((Element)where, (Element)tempMethod);
            tempMethod.refDelete();
        }
        newMethod.setModifiers(mods & 0xFFFFFADF);
        if (position == -1) {
            features.add(newMethod);
        } else {
            ClassMember[] featuresArr = features.toArray(new ClassMember[0]);
            int afterThis = -1;
            int cntr = 0;
            while (cntr < featuresArr.length && JavaMetamodel.getManager().getElementPosition((Element)featuresArr[cntr]).getEnd().getOffset() < position) {
                afterThis = cntr++;
            }
            if (afterThis == -1) {
                features.add(newMethod);
            } else {
                features.add(afterThis + 1, newMethod);
            }
        }
    }
}

