/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.java.JCExpression;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Attribute;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.java.JMIUtils;
import org.netbeans.modules.editor.java.JavaCompletionProvider;
import org.netbeans.modules.editor.java.NbJMIPaintComponent;
import org.netbeans.modules.editor.java.NbJavaJMIFastImport;
import org.netbeans.modules.editor.java.NbJavaJMISyntaxSupport;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.util.RequestProcessor;

public abstract class NbJMIResultItem
implements CompletionQuery.ResultItem,
CompletionItem {
    protected int selectionStartOffset = -1;
    protected int selectionEndOffset = -1;
    protected int substituteOffset = -1;
    public static final String COMPLETION_SUBSTITUTE_TEXT = "completion-substitute-text";
    static String toAdd;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport;

    public abstract String getItemText();

    protected abstract Object getAssociatedObject();

    protected static Color getTypeColor(Type typ) {
        return typ instanceof PrimitiveType ? NbJMIPaintComponent.KEYWORD_COLOR : NbJMIPaintComponent.TYPE_COLOR;
    }

    public void setSubstituteOffset(int substituteOffset) {
        this.substituteOffset = substituteOffset;
    }

    public boolean substituteCommonText(JTextComponent c, int offset, int len, int subLen) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
        BaseDocument doc = (BaseDocument)c.getDocument();
        String text = this.getItemText();
        if (text != null) {
            if (toAdd != null && !toAdd.equals("\n")) {
                text = text + toAdd;
            }
            doc.atomicLock();
            try {
                CharSequence textToReplace = DocumentUtilities.getText((Document)doc, (int)offset, (int)len);
                if (CharSequenceUtilities.textEquals((CharSequence)text, (CharSequence)textToReplace)) {
                    boolean bl = false;
                    return bl;
                }
                doc.remove(offset, len);
                doc.insertString(offset, text, null);
                if (this.selectionStartOffset >= 0) {
                    c.select(offset + this.selectionStartOffset, offset + this.selectionEndOffset);
                }
            }
            catch (BadLocationException e) {
            }
            finally {
                doc.atomicUnlock();
            }
            return true;
        }
        return false;
    }

    public Component getPaintComponent(JList list, boolean isSelected, boolean cellHasFocus) {
        Component ret = this.getPaintComponent(isSelected);
        if (ret == null) {
            return null;
        }
        if (isSelected) {
            ret.setBackground(list.getSelectionBackground());
            ret.setForeground(list.getSelectionForeground());
        } else {
            ret.setBackground(list.getBackground());
            ret.setForeground(list.getForeground());
        }
        ret.getAccessibleContext().setAccessibleName(this.getItemText());
        ret.getAccessibleContext().setAccessibleDescription(this.getItemText());
        return ret;
    }

    public abstract Component getPaintComponent(boolean var1);

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        Component renderComponent = this.getPaintComponent(false);
        return renderComponent.getPreferredSize().width;
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        Component renderComponent = this.getPaintComponent(selected);
        renderComponent.setFont(defaultFont);
        renderComponent.setForeground(defaultColor);
        renderComponent.setBackground(backgroundColor);
        renderComponent.setBounds(0, 0, width, height);
        ((NbJMIPaintComponent)renderComponent).paintComponent(g);
    }

    public String toString() {
        return this.getItemText();
    }

    public void processKeyEvent(KeyEvent evt) {
        if (evt.getID() == 400) {
            Completion completion = Completion.get();
            switch (evt.getKeyChar()) {
                case ' ': {
                    if (evt.getModifiers() != 0) break;
                    completion.hideCompletion();
                    completion.hideDocumentation();
                    break;
                }
                case ',': 
                case ';': {
                    completion.hideCompletion();
                    completion.hideDocumentation();
                }
                case '.': {
                    if (!this.defaultAction((JTextComponent)evt.getSource(), Character.toString(evt.getKeyChar()))) break;
                    evt.consume();
                }
            }
        }
    }

    public CharSequence getSortText() {
        return this.getItemText();
    }

    public CharSequence getInsertPrefix() {
        return this.getItemText();
    }

    public CompletionTask createDocumentationTask() {
        return new AsyncCompletionTask((AsyncCompletionQuery)new JavaCompletionProvider.DocQuery(this), Registry.getMostActiveComponent());
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent c) {
        Completion completion = Completion.get();
        completion.hideCompletion();
        completion.hideDocumentation();
        this.defaultAction(c);
        return true;
    }

    public void defaultAction(JTextComponent component) {
        Completion completion = Completion.get();
        completion.hideCompletion();
        completion.hideDocumentation();
        this.defaultAction(component, "");
    }

    boolean defaultAction(JTextComponent component, String addText) {
        int substOffset = this.substituteOffset;
        if (substOffset == -1) {
            substOffset = component.getCaret().getDot();
        }
        toAdd = addText;
        return this.substituteText(component, substOffset, component.getCaret().getDot() - substOffset, false);
    }

    static class ExcStr {
        private String name;
        private Color typeColor;

        public ExcStr(String name, Color typeColor) {
            this.name = name;
            this.typeColor = typeColor;
        }

        public String getName() {
            return this.name;
        }

        public Color getTypeColor() {
            return this.typeColor;
        }
    }

    static class ParamStr {
        private String type;
        private String simpleType;
        private String prm;
        private boolean isVarArg;
        private Color typeColor;

        public ParamStr(String type, String simpleType, String prm, boolean isVarArg, Color typeColor) {
            this.type = type;
            this.simpleType = simpleType;
            this.prm = prm;
            this.isVarArg = isVarArg;
            this.typeColor = typeColor;
        }

        public String getTypeName() {
            return this.type;
        }

        public String getSimpleTypeName() {
            return this.simpleType;
        }

        public String getName() {
            return this.prm;
        }

        public boolean isVarArg() {
            return this.isVarArg;
        }

        public Color getTypeColor() {
            return this.typeColor;
        }
    }

    public static class StringResultItem
    extends NbJMIResultItem {
        private String str;
        private static NbJMIPaintComponent.NbStringPaintComponent stringComponent = null;

        public StringResultItem(String str) {
            this.str = str;
        }

        public String getItemText() {
            return this.str;
        }

        public Component getPaintComponent(boolean isSelected) {
            if (stringComponent == null) {
                stringComponent = new NbJMIPaintComponent.NbStringPaintComponent();
            }
            stringComponent.setSelected(isSelected);
            stringComponent.setString(this.str);
            return stringComponent;
        }

        public int getSortPriority() {
            return 50;
        }

        protected Object getAssociatedObject() {
            return this.str;
        }
    }

    public static class AttributeResultItem
    extends NbJMIResultItem {
        private Attribute attr;
        private String attrName;
        private String typeName;
        private Color typeColor;
        private String defaultValueText;
        private static NbJMIPaintComponent.NbAttributePaintComponent attrComponent = null;

        public AttributeResultItem(Attribute attr) {
            this.attr = attr;
            this.attrName = attr.getName();
            Type type = attr.getType();
            this.typeName = JMIUtils.getTypeName(type, false, false);
            this.typeColor = AttributeResultItem.getTypeColor(type);
            this.defaultValueText = attr.getDefaultValueText();
        }

        public String getItemText() {
            return this.attrName + "=";
        }

        public String getAttrName() {
            return this.attrName;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String getDefaultValueText() {
            return this.defaultValueText;
        }

        public Component getPaintComponent(boolean isSelected) {
            if (attrComponent == null) {
                attrComponent = new NbJMIPaintComponent.NbAttributePaintComponent();
            }
            attrComponent.setAttrName(this.attrName);
            attrComponent.setTypeName(this.typeName);
            attrComponent.setTypeColor(this.typeColor);
            attrComponent.setDefaultValueText(this.defaultValueText);
            attrComponent.setSelected(isSelected);
            return attrComponent;
        }

        protected Object getAssociatedObject() {
            return this.attr;
        }

        public int getSortPriority() {
            return 100;
        }
    }

    public static class AnnotationResultItem
    extends ClassResultItem {
        private int size = 0;
        private int defaultMembersCnt = 0;

        public AnnotationResultItem(AnnotationType annType, boolean displayFQN, boolean addImport) {
            super((JavaClass)annType, displayFQN, addImport, false);
            Iterator it = annType.getContents().iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof Attribute)) continue;
                Attribute attr = (Attribute)o;
                if (attr.getDefaultValueText() != null) {
                    ++this.defaultMembersCnt;
                }
                ++this.size;
            }
        }

        public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
            if (this.defaultMembersCnt != this.size) {
                if (toAdd.length() == 0) {
                    toAdd = "(";
                } else if (!"(".equals(toAdd)) {
                    toAdd = "()" + toAdd;
                }
            }
            return super.substituteText(c, offset, len, shift);
        }
    }

    public static class ClassResultItem
    extends NbJMIResultItem {
        private JavaClass cls;
        private boolean isInterface;
        private boolean isDeprecated;
        boolean addImport;
        boolean generateClassSkeleton;
        private String fqName = null;
        private String name = null;
        private static NbJMIPaintComponent.NbInterfacePaintComponent interfaceComponent = null;
        private static NbJMIPaintComponent.NbClassPaintComponent classComponent = null;
        private static NbJMIPaintComponent.NbEnumPaintComponent enumComponent = null;
        private static NbJMIPaintComponent.NbAnnotationPaintComponent annotationComponent = null;
        private static final boolean autoImportDisabled = Boolean.getBoolean("org.netbeans.java.editor.disableAutoImport");
        private static final boolean autoGenerationDisabled = Boolean.getBoolean("org.netbeans.java.editor.disableAutoClassSkeletonGeneration");
        private boolean displayFQN;

        public ClassResultItem(JavaClass cls, boolean displayFQN, boolean addImport, boolean generateClassSkeleton) {
            this.cls = cls;
            this.addImport = addImport && !autoImportDisabled;
            this.name = cls.getSimpleName();
            this.displayFQN = displayFQN;
            if (displayFQN || this.addImport) {
                this.fqName = cls.getName();
                int idx = this.fqName.indexOf(60);
                if (idx >= 0) {
                    this.fqName = this.fqName.substring(0, idx);
                }
                this.fqName = (idx = this.fqName.lastIndexOf(46)) >= 0 ? " (" + this.fqName.substring(0, idx) + ")" : "";
            } else {
                this.fqName = "";
            }
            this.isInterface = cls.isInterface();
            this.isDeprecated = cls.isDeprecated();
            this.addImport = addImport && !autoImportDisabled;
            this.generateClassSkeleton = generateClassSkeleton && !autoGenerationDisabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean substituteText(final JTextComponent c, int offset, int len, boolean shift) {
            final BaseDocument doc = (BaseDocument)c.getDocument();
            String text = this.generateClassSkeleton && this.cls instanceof ParameterizedType ? null : this.getItemText();
            int toAddDelta = 0;
            final boolean makeConstructor = "(".equals(toAdd);
            boolean ret = true;
            if (text != null) {
                if (toAdd != null && !toAdd.equals("\n")) {
                    text = text + toAdd;
                    if (makeConstructor) {
                        text = text + ")";
                    }
                    toAddDelta = toAdd.length();
                }
                doc.atomicLock();
                try {
                    CharSequence textToReplace = DocumentUtilities.getText((Document)doc, (int)offset, (int)len);
                    if (CharSequenceUtilities.textEquals((CharSequence)text, (CharSequence)textToReplace)) {
                        ret = false;
                    } else {
                        doc.remove(offset, len);
                        doc.insertString(offset, text, null);
                        if (makeConstructor) {
                            c.setCaretPosition(c.getCaretPosition() - 1);
                        }
                    }
                }
                catch (BadLocationException e) {
                }
                finally {
                    doc.atomicUnlock();
                }
            }
            final int toAddDeltaResult = toAddDelta;
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    StringBuffer sb;
                    block17: {
                        sb = new StringBuffer();
                        JMIUtils jmiUtils = JMIUtils.get(doc);
                        jmiUtils.beginTrans(true);
                        try {
                            if (!ClassResultItem.this.cls.isValid()) break block17;
                            HashMap<JavaClass, Boolean> cache = new HashMap<JavaClass, Boolean>();
                            NbJavaJMISyntaxSupport ssup = (NbJavaJMISyntaxSupport)doc.getSyntaxSupport().get(class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport = NbJMIResultItem.class$("org.netbeans.modules.editor.java.NbJavaJMISyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport);
                            JavaClass ctx = ssup.getJavaClass(c.getCaretPosition());
                            if (ClassResultItem.this.addImport && ctx != null && !ClassResultItem.this.cls.isInner()) {
                                JavaClass jc = ClassResultItem.this.cls instanceof ParameterizedType ? ((ParameterizedType)ClassResultItem.this.cls).getDefinition() : ClassResultItem.this.cls;
                                MultipartId mpid = JavaModelUtil.resolveImportsForClass((Element)ctx, (JavaClass)jc);
                                if (!jc.getSimpleName().equals(mpid.getName())) {
                                    doc.atomicLock();
                                    try {
                                        int pos = c.getCaretPosition() - toAddDeltaResult - ClassResultItem.this.name.length();
                                        doc.remove(pos, ClassResultItem.this.name.length());
                                        doc.insertString(pos, mpid.getName(), null);
                                    }
                                    catch (BadLocationException ble) {
                                    }
                                    finally {
                                        doc.atomicUnlock();
                                    }
                                    cache.put(jc, Boolean.TRUE);
                                } else {
                                    cache.put(jc, Boolean.FALSE);
                                }
                            }
                            if (!makeConstructor && ClassResultItem.this.checkClassSkeletonAutoGeneration()) {
                                sb.append("() {\n");
                                List methods = jmiUtils.findMethods((Type)ClassResultItem.this.cls, "", false, false, null, false, false, null, false, true);
                                Iterator it = methods.iterator();
                                while (it.hasNext()) {
                                    Method mtd = (Method)it.next();
                                    int mods = mtd.getModifiers();
                                    if (!Modifier.isAbstract(mods)) continue;
                                    sb.append(Modifier.toString(mods & 0xFFFFFADF));
                                    sb.append(' ');
                                    Type typ = mtd.getType();
                                    sb.append(JMIUtils.getTypeName(typ, typ instanceof JavaClass && ClassResultItem.this.useFQN((JavaClass)typ, ctx, cache), true));
                                    sb.append(' ');
                                    sb.append(mtd.getName());
                                    sb.append('(');
                                    Iterator itt = mtd.getParameters().iterator();
                                    while (itt.hasNext()) {
                                        Parameter prm = (Parameter)itt.next();
                                        sb.append(JMIUtils.getTypeName(typ, (typ = prm.getType()) instanceof JavaClass && ClassResultItem.this.useFQN((JavaClass)typ, ctx, cache), true));
                                        sb.append(' ');
                                        sb.append(prm.getName());
                                        if (prm.isVarArg()) {
                                            sb.append("...");
                                        }
                                        if (!itt.hasNext()) continue;
                                        sb.append(", ");
                                    }
                                    sb.append(')');
                                    List exs = mtd.getExceptions();
                                    if (!exs.isEmpty()) {
                                        sb.append(" throws ");
                                    }
                                    Iterator itt2 = exs.iterator();
                                    while (itt2.hasNext()) {
                                        JavaClass ex = (JavaClass)itt2.next();
                                        sb.append(JMIUtils.getTypeName((Type)ex, ClassResultItem.this.useFQN(ex, ctx, cache), true));
                                        if (!itt2.hasNext()) continue;
                                        sb.append(',');
                                    }
                                    sb.append(" {\n}\n");
                                }
                                sb.append('}');
                            }
                        }
                        finally {
                            jmiUtils.endTrans(false);
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            String skeleton = sb.toString();
                            if (skeleton != null && skeleton.length() > 0) {
                                doc.atomicLock();
                                try {
                                    int startOffset = c.getCaret().getDot();
                                    doc.insertString(startOffset, skeleton, null);
                                    int endOffset = c.getCaret().getDot();
                                    doc.getFormatter().reformat(doc, startOffset, endOffset);
                                }
                                catch (BadLocationException badLocationException) {
                                }
                                finally {
                                    doc.atomicUnlock();
                                }
                            }
                        }
                    });
                }
            });
            return ret;
        }

        private boolean useFQN(JavaClass cls, JavaClass ctx, Map cache) {
            Boolean b;
            if ((cls = (JavaClass)JMIUtils.getDefintion((Feature)cls)) instanceof TypeParameter) {
                cls = ((TypeParameter)cls).getSuperClass();
            }
            if ((b = (Boolean)cache.get(cls)) == null) {
                if (ctx != null) {
                    MultipartId mpid = JavaModelUtil.resolveImportsForClass((Element)ctx, (JavaClass)cls);
                    b = !cls.getSimpleName().equals(mpid.getName());
                } else {
                    b = Boolean.FALSE;
                }
                cache.put(cls, b);
            }
            return b;
        }

        public boolean substituteTextSimple(JTextComponent c, int offset, int len, boolean shift) {
            return super.substituteText(c, offset, len, shift);
        }

        public void processKeyEvent(KeyEvent evt) {
            if (evt.getID() == 401 && evt.getKeyCode() == 10 && evt.getModifiers() == 2) {
                this.substituteTextSimple((JTextComponent)evt.getSource());
                evt.consume();
            }
            if (!evt.isConsumed()) {
                super.processKeyEvent(evt);
            }
        }

        private void substituteTextSimple(JTextComponent component) {
            int substOffset = this.substituteOffset;
            if (substOffset == -1) {
                substOffset = component.getCaretPosition();
            }
            this.substituteTextSimple(component, substOffset, component.getCaretPosition() - substOffset, false);
            Completion.get().hideCompletion();
        }

        public boolean checkAutoImport(JTextComponent c) {
            if (this.addImport) {
                return new NbJavaJMIFastImport(c).checkAutoImport(this);
            }
            return false;
        }

        private boolean checkClassSkeletonAutoGeneration() {
            return this.generateClassSkeleton && (Modifier.isAbstract(this.cls.getModifiers()) || Modifier.isInterface(this.cls.getModifiers()));
        }

        public String getItemText() {
            return this.name;
        }

        public boolean instantSubstitution(JTextComponent c) {
            boolean ret;
            boolean bl = ret = !this.checkAutoImport(c) && !this.checkClassSkeletonAutoGeneration();
            if (ret) {
                super.instantSubstitution(c);
            }
            return ret;
        }

        public CharSequence getSortText() {
            return this.name + this.fqName;
        }

        public Component getPaintComponent(boolean isSelected) {
            if (this.cls instanceof AnnotationType) {
                if (annotationComponent == null) {
                    annotationComponent = new NbJMIPaintComponent.NbAnnotationPaintComponent();
                }
                annotationComponent.setSelected(isSelected);
                annotationComponent.setDeprecated(this.isDeprecated);
                annotationComponent.setSimpleClassName(this.name);
                annotationComponent.setFQName(this.fqName);
                if (this.displayFQN) {
                    annotationComponent.setCls(this.cls);
                }
                return annotationComponent;
            }
            if (this.cls instanceof JavaEnum) {
                if (enumComponent == null) {
                    enumComponent = new NbJMIPaintComponent.NbEnumPaintComponent();
                }
                enumComponent.setSelected(isSelected);
                enumComponent.setDeprecated(this.isDeprecated);
                enumComponent.setSimpleClassName(this.name);
                enumComponent.setFQName(this.fqName);
                if (this.displayFQN) {
                    enumComponent.setCls(this.cls);
                }
                return enumComponent;
            }
            if (this.isInterface) {
                if (interfaceComponent == null) {
                    interfaceComponent = new NbJMIPaintComponent.NbInterfacePaintComponent();
                }
                interfaceComponent.setSelected(isSelected);
                interfaceComponent.setDeprecated(this.isDeprecated);
                interfaceComponent.setSimpleClassName(this.name);
                interfaceComponent.setFQName(this.fqName);
                if (this.displayFQN) {
                    interfaceComponent.setCls(this.cls);
                }
                return interfaceComponent;
            }
            if (classComponent == null) {
                classComponent = new NbJMIPaintComponent.NbClassPaintComponent();
            }
            classComponent.setSelected(isSelected);
            classComponent.setDeprecated(this.isDeprecated);
            classComponent.setSimpleClassName(this.name);
            classComponent.setFQName(this.fqName);
            if (this.displayFQN) {
                classComponent.setCls(this.cls);
            }
            return classComponent;
        }

        protected Object getAssociatedObject() {
            return this.cls;
        }

        public int getSortPriority() {
            return 600;
        }
    }

    public static class PackageResultItem
    extends NbJMIResultItem {
        private boolean displayFullPackagePath;
        private JavaPackage pkg;
        private String pkgName;
        private static NbJMIPaintComponent.NbPackagePaintComponent pkgComponent = null;

        public PackageResultItem(JavaPackage pkg, boolean displayFullPackagePath) {
            this.pkg = pkg;
            this.displayFullPackagePath = displayFullPackagePath;
            this.pkgName = pkg.getName();
        }

        public String getItemText() {
            return this.displayFullPackagePath ? this.pkgName : this.pkgName.substring(this.pkgName.lastIndexOf(46) + 1);
        }

        public Component getPaintComponent(boolean isSelected) {
            if (pkgComponent == null) {
                pkgComponent = new NbJMIPaintComponent.NbPackagePaintComponent();
            }
            pkgComponent.setSelected(isSelected);
            pkgComponent.setPackageName(this.pkgName);
            pkgComponent.setDisplayFullPackagePath(this.displayFullPackagePath);
            return pkgComponent;
        }

        public int getSortPriority() {
            return 700;
        }

        protected Object getAssociatedObject() {
            return this.pkg;
        }
    }

    public static abstract class CallableFeatureResultItem
    extends NbJMIResultItem {
        JCExpression substituteExp;
        private CallableFeature cf;
        private List params = new ArrayList();
        private List excs = new ArrayList();
        private int modifiers;
        private String cfName;
        private String typeName;
        private Color typeColor;
        private boolean isDeprecated;
        private int activeParameterIndex = -1;
        private int varArgIndex = -1;

        public CallableFeatureResultItem(CallableFeature cf, JCExpression substituteExp, ClassDefinition context) {
            this.cf = cf;
            this.substituteExp = substituteExp;
            this.modifiers = cf.getModifiers();
            if (cf.getDeclaringClass() == (context instanceof ParameterizedType ? ((ParameterizedType)context).getDefinition() : context)) {
                this.modifiers |= 0x20000000;
            }
            this.cfName = cf.getName();
            Type tp = cf.getType();
            this.typeName = JMIUtils.getTypeName(tp, false, false);
            this.typeColor = CallableFeatureResultItem.getTypeColor(tp);
            this.isDeprecated = cf.isDeprecated();
            Iterator it = cf.getParameters().iterator();
            while (it.hasNext()) {
                Parameter prm = (Parameter)it.next();
                Type type = prm.getType();
                this.params.add(new ParamStr(type.getName(), JMIUtils.getTypeName(type, false, false), prm.getName(), prm.isVarArg(), CallableFeatureResultItem.getTypeColor(type)));
                if (!prm.isVarArg()) continue;
                this.varArgIndex = this.params.size() - 1;
            }
            it = cf.getExceptions().iterator();
            while (it.hasNext()) {
                JavaClass ex = (JavaClass)it.next();
                this.excs.add(new ExcStr(ex.getSimpleName(), CallableFeatureResultItem.getTypeColor((Type)ex)));
            }
        }

        public void processKeyEvent(KeyEvent evt) {
            super.processKeyEvent(evt);
            if (!evt.isConsumed() && evt.getID() == 400) {
                Completion completion = Completion.get();
                switch (evt.getKeyChar()) {
                    case '(': {
                        completion.hideCompletion();
                        completion.hideDocumentation();
                        if (!this.defaultAction((JTextComponent)evt.getSource(), Character.toString(evt.getKeyChar()))) break;
                        evt.consume();
                    }
                }
            }
        }

        public String getItemText() {
            return this.getName();
        }

        public String getTypeName() {
            return this.typeName;
        }

        public Color getTypeColor() {
            return this.typeColor;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public boolean isDeprecated() {
            return this.isDeprecated;
        }

        public String getName() {
            return this.cfName;
        }

        public List getParams() {
            return this.params;
        }

        public List getExceptions() {
            return this.excs;
        }

        public CharSequence getSortText() {
            return this.getName() + "#" + this.getParamsCountString() + "#" + this.printParams(false);
        }

        private String getParamsCountString() {
            int size = this.params.size();
            return (size < 10 ? "0" : "") + size;
        }

        protected Object getAssociatedObject() {
            return this.cf;
        }

        int getActiveParameterIndex() {
            return this.activeParameterIndex;
        }

        void setActiveParameterIndex(int activeParamIndex) {
            this.activeParameterIndex = activeParamIndex;
        }

        boolean isEnclosingCall() {
            return this.activeParameterIndex != -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
            boolean addSpace;
            BaseDocument doc = (BaseDocument)c.getDocument();
            String text = null;
            boolean addParams = true;
            for (JCExpression exp = this.substituteExp; exp != null; exp = exp.getParent()) {
                if (exp.getExpID() != 22) continue;
                addParams = false;
                break;
            }
            switch (this.substituteExp != null ? this.substituteExp.getExpID() : -1) {
                case 11: {
                    break;
                }
                case 10: {
                    boolean isVarArg;
                    Object o;
                    int parmsCnt = this.params.size();
                    if (parmsCnt == 0) {
                        if (this.getActiveParameterIndex() != -1) break;
                        try {
                            int fnwpos = Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)(offset + len));
                            if (fnwpos > -1 && doc.getChars(fnwpos, 1)[0] == ')') {
                                text = doc.getText(offset + len, fnwpos + 1 - offset - len);
                                len = fnwpos + 1 - offset;
                            }
                        }
                        catch (BadLocationException e) {
                            // empty catch block
                        }
                        if (text != null) break;
                        text = ")";
                        break;
                    }
                    int activeParamIndex = this.getActiveParameterIndex();
                    if (activeParamIndex != -1) {
                        String paramName;
                        boolean substed = false;
                        if (activeParamIndex < parmsCnt && (paramName = ((ParamStr)this.params.get(activeParamIndex)).getName()) != null) {
                            try {
                                doc.insertString(c.getCaretPosition(), paramName, null);
                                substed = true;
                            }
                            catch (BadLocationException e) {
                                // empty catch block
                            }
                        }
                        return substed;
                    }
                    int ind = this.substituteExp.getParameterCount() - 1;
                    boolean addSpace2 = false;
                    Formatter f = doc.getFormatter();
                    if (f instanceof ExtFormatter && (o = ((ExtFormatter)f).getSettingValue("java-format-space-after-comma")) instanceof Boolean && ((Boolean)o).booleanValue()) {
                        addSpace2 = true;
                    }
                    try {
                        if (addSpace2 && (ind == 0 || offset > 0 && Character.isWhitespace(DocumentUtilities.getText((Document)doc, (int)(offset - 1), (int)1).charAt(0)))) {
                            addSpace2 = false;
                        }
                    }
                    catch (BadLocationException e) {
                        // empty catch block
                    }
                    boolean bl = isVarArg = parmsCnt > 0 ? ((ParamStr)this.params.get(parmsCnt - 1)).isVarArg() : false;
                    if (ind >= parmsCnt && !isVarArg) break;
                    text = addSpace2 ? " " : "";
                    break;
                }
                default: {
                    text = this.getItemText();
                    addSpace = false;
                    boolean addClosingParen = false;
                    Formatter f = doc.getFormatter();
                    if (f instanceof ExtFormatter) {
                        Object o = ((ExtFormatter)f).getSettingValue("java-format-space-before-parenthesis");
                        if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
                            addSpace = true;
                        }
                        if ((o = ((ExtFormatter)f).getSettingValue("pair-characters-completion")) instanceof Boolean && ((Boolean)o).booleanValue()) {
                            addClosingParen = true;
                        }
                    }
                    if (!addParams) break;
                    String paramsText = null;
                    try {
                        int fnwpos = Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)(offset + len));
                        if (fnwpos > -1 && fnwpos <= Utilities.getRowEnd((BaseDocument)doc, (int)(offset + len)) && doc.getChars(fnwpos, 1)[0] == '(') {
                            paramsText = doc.getText(offset + len, fnwpos + 1 - offset - len);
                            if (addSpace && paramsText.length() < 2) {
                                text = text + ' ';
                            }
                            len = fnwpos + 1 - offset;
                            text = text + paramsText;
                            toAdd = null;
                        }
                    }
                    catch (BadLocationException e) {
                        // empty catch block
                    }
                    if (paramsText == null) {
                        if (addSpace) {
                            text = text + ' ';
                        }
                        text = text + '(';
                        if (this.params.size() > 0) {
                            this.selectionStartOffset = this.selectionEndOffset = text.length();
                            Completion completion = Completion.get();
                            completion.hideCompletion();
                            completion.hideDocumentation();
                            completion.showToolTip();
                        }
                        if (!addClosingParen) break;
                        text = text + ")";
                        break;
                    }
                    try {
                        int fnwpos = Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)(offset + len));
                        if (fnwpos <= -1 || doc.getChars(fnwpos, 1)[0] != ')') break;
                        paramsText = doc.getText(offset + len, fnwpos + 1 - offset - len);
                        len = fnwpos + 1 - offset;
                        if (this.params.size() > 0) {
                            this.selectionStartOffset = this.selectionEndOffset = text.length();
                        }
                        text = text + paramsText;
                        break;
                    }
                    catch (BadLocationException e) {
                        // empty catch block
                    }
                }
            }
            if (text != null) {
                if (toAdd != null && !toAdd.equals("\n") && !"(".equals(toAdd)) {
                    text = text + toAdd;
                }
                doc.atomicLock();
                try {
                    int index;
                    CharSequence textToReplace = DocumentUtilities.getText((Document)doc, (int)offset, (int)len);
                    if (CharSequenceUtilities.textEquals((CharSequence)text, (CharSequence)textToReplace)) {
                        c.setCaretPosition(offset + len);
                        addSpace = false;
                        return addSpace;
                    }
                    doc.remove(offset, len);
                    doc.insertString(offset, text, null);
                    if (this.selectionStartOffset >= 0) {
                        c.select(offset + this.selectionStartOffset, offset + this.selectionEndOffset);
                    } else if ("(".equals(toAdd) && (index = text.lastIndexOf(41)) > -1) {
                        c.setCaretPosition(offset + index);
                    }
                }
                catch (BadLocationException e) {
                }
                finally {
                    doc.atomicUnlock();
                }
                return true;
            }
            return false;
        }

        List createParamsList() {
            ArrayList<String> ret = new ArrayList<String>();
            Iterator it = this.params.iterator();
            while (it.hasNext()) {
                String name;
                StringBuffer sb = new StringBuffer();
                ParamStr ps = (ParamStr)it.next();
                sb.append(ps.getSimpleTypeName());
                if (ps.isVarArg()) {
                    sb.append("...");
                }
                if ((name = ps.getName()) != null && name.length() > 0) {
                    sb.append(" ");
                    sb.append(name);
                }
                if (it.hasNext()) {
                    sb.append(", ");
                }
                ret.add(sb.toString());
            }
            return ret;
        }

        int getCurrentParamIndex() {
            int idx = 0;
            if (this.substituteExp != null && this.substituteExp.getExpID() == 10) {
                idx = this.substituteExp.getParameterCount() - 1;
            }
            if (this.varArgIndex > -1 && this.varArgIndex < idx) {
                idx = this.varArgIndex;
            }
            return idx;
        }

        protected String printParams(boolean includeParamNames) {
            StringBuffer sb = new StringBuffer();
            sb.append("(");
            Iterator it = this.params.iterator();
            while (it.hasNext()) {
                String name;
                ParamStr ps = (ParamStr)it.next();
                sb.append(ps.getSimpleTypeName());
                if (ps.isVarArg()) {
                    sb.append("...");
                }
                if (includeParamNames && (name = ps.getName()) != null && name.length() > 0) {
                    sb.append(" ");
                    sb.append(name);
                }
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(")");
            return sb.toString();
        }

        protected String printExceptions() {
            StringBuffer sb = new StringBuffer();
            if (this.excs.size() > 0) {
                sb.append(" throws ");
                Iterator it = this.excs.iterator();
                while (it.hasNext()) {
                    ExcStr ex = (ExcStr)it.next();
                    sb.append(ex.getName());
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
            }
            return sb.toString();
        }
    }

    public static class ConstructorResultItem
    extends CallableFeatureResultItem {
        private static NbJMIPaintComponent.NbConstructorPaintComponent ctrComponent = null;

        public ConstructorResultItem(Constructor con, JCExpression substituteExp) {
            super((CallableFeature)con, substituteExp, null);
        }

        public String getName() {
            return this.getTypeName();
        }

        public Component getPaintComponent(boolean isSelected) {
            if (ctrComponent == null) {
                ctrComponent = new NbJMIPaintComponent.NbConstructorPaintComponent();
            }
            ctrComponent.setFeatureName(this.getName());
            ctrComponent.setModifiers(this.getModifiers());
            ctrComponent.setParams(this.getParams());
            ctrComponent.setExceptions(this.getExceptions());
            ctrComponent.setDeprecated(this.isDeprecated());
            ctrComponent.setSelected(isSelected);
            ctrComponent.setActiveParameterIndex(this.getActiveParameterIndex());
            return ctrComponent;
        }

        public int getSortPriority() {
            return this.isEnclosingCall() ? 5 : 400;
        }

        public String toString() {
            String mods = Modifier.toString(this.getModifiers()) + " ";
            return (mods.length() > 1 ? mods : "") + this.getName() + this.printParams(true) + this.printExceptions();
        }
    }

    public static class MethodResultItem
    extends CallableFeatureResultItem {
        private static NbJMIPaintComponent.NbMethodPaintComponent mtdComponent = null;

        public MethodResultItem(Method mtd, JCExpression substituteExp, ClassDefinition context) {
            super((CallableFeature)mtd, substituteExp, context);
        }

        public Component getPaintComponent(boolean isSelected) {
            if (mtdComponent == null) {
                mtdComponent = new NbJMIPaintComponent.NbMethodPaintComponent();
            }
            mtdComponent.setFeatureName(this.getName());
            mtdComponent.setModifiers(this.getModifiers());
            mtdComponent.setTypeName(this.getTypeName());
            mtdComponent.setTypeColor(this.getTypeColor());
            mtdComponent.setParams(this.getParams());
            mtdComponent.setExceptions(this.getExceptions());
            mtdComponent.setDeprecated(this.isDeprecated());
            mtdComponent.setSelected(isSelected);
            mtdComponent.setActiveParameterIndex(this.getActiveParameterIndex());
            return mtdComponent;
        }

        public int getSortPriority() {
            return this.isEnclosingCall() ? 10 : 500;
        }

        public String toString() {
            String mods = Modifier.toString(this.getModifiers()) + " ";
            return (mods.length() > 1 ? mods : "") + this.getTypeName() + " " + this.getName() + this.printParams(true) + this.printExceptions();
        }
    }

    public static class FieldResultItem
    extends NbJMIResultItem {
        private Field fld;
        private String typeName;
        private Color typeColor;
        private String fldName;
        private int modifiers;
        private boolean isDeprecated;
        private JavaClass owner;
        private ClassDefinition context;
        private static NbJMIPaintComponent.NbFieldPaintComponent fieldComponent = null;

        public FieldResultItem(Field fld, JavaClass owner, ClassDefinition context) {
            this.fld = fld;
            this.fldName = fld.getName();
            this.modifiers = fld.getModifiers();
            if (fld.getDeclaringClass() == (context instanceof ParameterizedType ? ((ParameterizedType)context).getDefinition() : context)) {
                this.modifiers |= 0x20000000;
            }
            Type type = fld.getType();
            this.typeName = JMIUtils.getTypeName(type, false, false);
            this.typeColor = FieldResultItem.getTypeColor(type);
            this.isDeprecated = fld.isDeprecated();
            this.owner = owner;
            this.context = owner != null ? context : null;
        }

        public String getItemText() {
            return this.fldName;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public String getFieldName() {
            return this.fldName;
        }

        public Component getPaintComponent(boolean isSelected) {
            if (fieldComponent == null) {
                fieldComponent = new NbJMIPaintComponent.NbFieldPaintComponent(false);
            }
            fieldComponent.setTypeName(this.typeName);
            fieldComponent.setFieldName(this.fldName);
            fieldComponent.setTypeColor(this.typeColor);
            fieldComponent.setModifiers(this.modifiers);
            fieldComponent.setSelected(isSelected);
            fieldComponent.setDeprecated(this.isDeprecated);
            return fieldComponent;
        }

        public boolean substituteText(final JTextComponent c, int offset, final int len, boolean shift) {
            if (this.context == null) {
                return super.substituteText(c, offset, len, shift);
            }
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    final BaseDocument doc = (BaseDocument)c.getDocument();
                    final StringBuffer sb = new StringBuffer();
                    JMIUtils jmiUtils = JMIUtils.get(doc);
                    jmiUtils.beginTrans(true);
                    try {
                        sb.append(FieldResultItem.this.context.isValid() && FieldResultItem.this.owner.isValid() ? JavaModelUtil.resolveImportsForClass((Element)FieldResultItem.this.context, (JavaClass)FieldResultItem.this.owner).getName() : FieldResultItem.this.typeName);
                    }
                    finally {
                        jmiUtils.endTrans(false);
                    }
                    sb.append(".");
                    sb.append(FieldResultItem.this.fldName);
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            String text = sb.toString();
                            if (text != null && text.length() > 0) {
                                int offset = c.getCaret().getDot() - len;
                                doc.atomicLock();
                                try {
                                    doc.remove(offset, len);
                                    doc.insertString(offset, text, null);
                                }
                                catch (BadLocationException badLocationException) {
                                }
                                finally {
                                    doc.atomicUnlock();
                                }
                            }
                        }
                    });
                }
            });
            return true;
        }

        protected Object getAssociatedObject() {
            return this.fld;
        }

        public int getSortPriority() {
            return 300;
        }

        public String toString() {
            String mods = Modifier.toString(this.modifiers) + " ";
            return (mods.length() > 1 ? mods : "") + this.typeName + " " + this.fldName;
        }
    }

    public static class VarResultItem
    extends NbJMIResultItem {
        private Type type;
        private String typeName;
        private Color typeColor;
        private String varName;
        private int modifiers;
        private static NbJMIPaintComponent.NbFieldPaintComponent fieldComponent = null;

        public VarResultItem(String varName, Type type, int modifiers) {
            this.type = type;
            this.varName = varName;
            this.modifiers = modifiers | 0x20000000;
            this.typeName = JMIUtils.getTypeName(type, false, false);
            this.typeColor = VarResultItem.getTypeColor(type);
        }

        public String getItemText() {
            return this.varName;
        }

        public Component getPaintComponent(boolean isSelected) {
            if (fieldComponent == null) {
                fieldComponent = new NbJMIPaintComponent.NbFieldPaintComponent(true);
            }
            fieldComponent.setTypeName(this.typeName);
            fieldComponent.setTypeColor(this.typeColor);
            fieldComponent.setFieldName(this.varName);
            fieldComponent.setModifiers(this.modifiers);
            fieldComponent.setSelected(isSelected);
            return fieldComponent;
        }

        protected Object getAssociatedObject() {
            return this;
        }

        public Type getType() {
            return this.type;
        }

        public int getSortPriority() {
            return 200;
        }

        public String toString() {
            String mods = Modifier.toString(this.modifiers) + " ";
            return (mods.length() > 1 ? mods : "") + this.typeName + " " + this.varName;
        }
    }
}

