/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification.ejb.rules.clazz;

import java.util.HashSet;
import java.util.Set;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.JEEVerificationProblemMark;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.ProblemFindingUtils;

public class BeanImplementsBI
extends AbstractRule {
    Set<String> unimplementedIFs = new HashSet<String>();

    public JEEVerificationProblemMark.Severity getSeverity() {
        return JEEVerificationProblemMark.Severity.WARNING;
    }

    protected String getMessageKey() {
        return "MSG_BeanImplementsBI";
    }

    protected Object[] getMessageParameters() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.unimplementedIFs) {
            sb.append(s).append(" ");
        }
        return new String[]{sb.toString()};
    }

    public void reset() {
        this.unimplementedIFs.clear();
    }

    public String getId() {
        return "BeanImplementsBI";
    }

    protected boolean isApplicable(Element subject, ProblemFinderContext ctx) {
        return ctx.isSessionBean() && super.isApplicable(subject, ctx);
    }

    public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (this.isApplicable(subject, ctx)) {
            HashSet<String> bis = new HashSet<String>(ctx.getLBIs());
            bis.addAll(ctx.getRBIs());
            JavaClass bean = ctx.getMainJavaClass();
            for (String bi : bis) {
                if (ProblemFindingUtils.isAssignableFrom(bi, bean)) continue;
                this.unimplementedIFs.add(bi);
            }
            if (!this.unimplementedIFs.isEmpty()) {
                return this.createProblem(ctx, subject);
            }
        }
        return null;
    }
}

