/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.html.HTMLCompletionResultItemPaintComponent;
import org.netbeans.editor.ext.html.HTMLSettingsDefaults;
import org.netbeans.editor.ext.html.HTMLSyntaxSupport;
import org.netbeans.editor.ext.html.HTMLTokenContext;
import org.netbeans.editor.ext.html.SyntaxElement;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.javadoc.HelpManager;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;

public class HTMLCompletionQuery
implements CompletionQuery {
    private static boolean lowerCase;
    private static final HTMLCompletionQuery DEFAULT;

    public static HTMLCompletionQuery getDefault() {
        return DEFAULT;
    }

    public CompletionQuery.Result query(JTextComponent component, int offset, SyntaxSupport support) {
        Class kitClass = Utilities.getKitClass((JTextComponent)component);
        BaseDocument doc = (BaseDocument)component.getDocument();
        return this.query(component, kitClass, doc, offset, support);
    }

    /*
     * Unable to fully structure code
     */
    CompletionQuery.Result query(JTextComponent component, Class kitClass, BaseDocument doc, int offset, SyntaxSupport support) {
        if (kitClass != null) {
            HTMLCompletionQuery.lowerCase = SettingsUtil.getBoolean((Class)kitClass, (String)"completion-lower-case", (Boolean)HTMLSettingsDefaults.defaultCompletionLowerCase);
        }
        if (doc.getLength() == 0) {
            return null;
        }
        sup = (HTMLSyntaxSupport)support.get(HTMLSyntaxSupport.class);
        if (sup == null) {
            return null;
        }
        dtd = sup.getDTD();
        if (dtd == null) {
            return null;
        }
        try {
            block62: {
                block60: {
                    block61: {
                        item = null;
                        prev = null;
                        inside = false;
                        item = sup.getTokenChain(offset, offset + 1);
                        if (item == null) break block60;
                        prev = item.getPrevious();
                        if (prev == null) break block61;
                        prevv = prev;
                        prevvImage = prevv.getImage();
                        if (prevv == null) ** GOTO lbl-1000
                        if (HTMLSyntaxSupport.isTag(prevv) && prevv.getTokenID().getNumericID() == 6) {
                            for (index = prevvImage.length() - 1; index > -1 && !Character.isLetter(prevvImage.charAt(index)); --index) {
                            }
                        } else lbl-1000:
                        // 2 sources

                        {
                            index = -1;
                        }
                        block7: do {
                            if (prevv.getTokenID() != HTMLTokenContext.TAG_OPEN && prevv.getTokenID() != HTMLTokenContext.TAG_CLOSE) continue;
                            prevvImage = prevv.getImage();
                            for (i = 0; i < prevvImage.length(); ++i) {
                                ch = prevvImage.charAt(i);
                                if (!Character.isLetter(ch)) continue;
                                index = i;
                                continue block7;
                            }
                        } while ((prevv = prevv.getPrevious()) != null && index == -1);
                        HTMLCompletionQuery.lowerCase = prevv != null && index != -1 ? Character.isUpperCase(prevvImage.charAt(index)) == false : true;
                    }
                    inside = item.getOffset() < offset;
                    break block62;
                }
                prev = sup.getTokenChain(offset - 1, offset);
            }
            v0 = begin = prev == null && inside == false;
            if (begin) {
                return null;
            }
            id = null;
            l = null;
            len = 1;
            itemOffset = 0;
            preText = null;
            if (inside) {
                id = item.getTokenID();
                preText = item.getImage().substring(0, offset - item.getOffset());
                itemOffset = item.getOffset();
            } else {
                id = prev.getTokenID();
                preText = prev.getImage().substring(0, offset - prev.getOffset());
                itemOffset = prev.getOffset();
            }
            if ((id == HTMLTokenContext.TEXT || id == HTMLTokenContext.VALUE) && preText.endsWith("&")) {
                l = this.translateCharRefs(offset - len, len, dtd.getCharRefList(""));
            } else if (id == HTMLTokenContext.CHARACTER) {
                if (inside || !preText.endsWith(";")) {
                    len = offset - itemOffset;
                    l = this.translateCharRefs(offset - len, len, dtd.getCharRefList(preText.substring(1)));
                }
            } else if (id == HTMLTokenContext.TAG_OPEN) {
                len = offset - itemOffset + 1;
                l = this.translateTags(itemOffset - 1, len, dtd.getElementList(preText));
                if (l.size() == 1 && preText.equals(itemText = (ti = (TagItem)l.get(0)).getItemText())) {
                    lookLenght = 10;
                    if (offset + lookLenght > doc.getLength()) {
                        lookLenght = doc.getLength() - offset;
                    }
                    if ((aheadChainToken = sup.getTokenChain(offset, offset + lookLenght)) != null && aheadChainToken.getTokenID().getNumericID() == 2 && (aheadChainToken = aheadChainToken.getNext()) != null && (aheadChainToken.getTokenID().getNumericID() == 5 || aheadChainToken.getTokenID().getNumericID() == 6)) {
                        l = null;
                    }
                }
            } else if (id != HTMLTokenContext.BLOCK_COMMENT && preText.endsWith("<")) {
                l = this.translateTags(offset - len, len, dtd.getElementList(""));
            } else if (id == HTMLTokenContext.TEXT && preText.endsWith("</")) {
                len = 2;
                l = sup.getPossibleEndTags(offset, "");
            } else if (id == HTMLTokenContext.TAG_OPEN_SYMBOL && preText.endsWith("</")) {
                len = 2;
                l = sup.getPossibleEndTags(offset, "");
            } else if (id == HTMLTokenContext.TAG_CLOSE) {
                len = offset - itemOffset;
                l = sup.getPossibleEndTags(offset, preText);
            } else if (id == HTMLTokenContext.TAG_CLOSE_SYMBOL) {
                l = sup.getAutocompletedEndTag(offset);
            } else if (id == HTMLTokenContext.WS || id == HTMLTokenContext.ARGUMENT) {
                elem = null;
                try {
                    elem = sup.getElementChain(offset);
                    if (elem == null || elem.getType() == 4 && ">".equals(elem.getText())) {
                        elem = sup.getElementChain(offset - 1);
                    }
                }
                catch (BadLocationException e) {
                    return null;
                }
                if (elem == null) {
                    return null;
                }
                if (elem.getType() == 4) {
                    tagElem = (SyntaxElement.Tag)elem;
                    tagName = tagElem.getName().toUpperCase();
                    tag = dtd.getElement(tagName);
                    if (tag == null) {
                        return null;
                    }
                    prefix = id == HTMLTokenContext.ARGUMENT ? preText : "";
                    len = prefix.length();
                    possible = tag.getAttributeList(prefix);
                    existing = tagElem.getAttributes();
                    v1 = wordAtCursor = item == null ? null : item.getImage();
                    if (wordAtCursor == null) {
                        wordAtCursor = "";
                    }
                    l = new ArrayList<E>();
                    for (DTD.Attribute attr : possible) {
                        aName = attr.getName();
                        if (!aName.equals(prefix) && (existing.contains(aName.toUpperCase()) || existing.contains(aName.toLowerCase())) && (!wordAtCursor.equals(aName) || prefix.length() <= 0)) continue;
                        l.add(attr);
                    }
                    l = this.translateAttribs(offset - len, len, l, tag);
                }
            } else if (id == HTMLTokenContext.VALUE || id == HTMLTokenContext.OPERATOR || id == HTMLTokenContext.WS && (inside != false ? prev : prev.getPrevious()).getTokenID() == HTMLTokenContext.OPERATOR) {
                elem = null;
                try {
                    elem = sup.getElementChain(offset);
                }
                catch (BadLocationException e) {
                    return null;
                }
                if (elem == null) {
                    return null;
                }
                if (elem.getType() == 2 && (elem = elem.getPrevious()) == null) {
                    return null;
                }
                if (elem.getType() == 4) {
                    tagElem = (SyntaxElement.Tag)elem;
                    tagName = tagElem.getName().toUpperCase();
                    tag = dtd.getElement(tagName);
                    if (tag == null) {
                        return null;
                    }
                    for (argItem = prev; argItem != null && argItem.getTokenID() != HTMLTokenContext.ARGUMENT; argItem = argItem.getPrevious()) {
                    }
                    if (argItem == null) {
                        return null;
                    }
                    argName = argItem.getImage().toLowerCase();
                    arg = tag.getAttribute(argName);
                    if (arg == null || arg.getType() != 1) {
                        return null;
                    }
                    if (id != HTMLTokenContext.VALUE) {
                        len = 0;
                        l = this.translateValues(offset - len, len, arg.getValueList(""));
                    } else {
                        len = offset - itemOffset;
                        quotationChar = null;
                        if (preText != null && preText.length() > 0) {
                            if (preText.substring(0, 1).equals("'")) {
                                quotationChar = "'";
                            }
                            if (preText.substring(0, 1).equals("\"")) {
                                quotationChar = "\"";
                            }
                        }
                        l = this.translateValues(offset - len, len, arg.getValueList(quotationChar == null ? preText : preText.substring(1)), quotationChar);
                    }
                }
            }
            if (l == null) {
                return null;
            }
            return new HTMLCompletionResult(component, "Results for DOCTYPE " + dtd.getIdentifier(), l, offset, len);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    List translateCharRefs(int offset, int length, List refs) {
        ArrayList<CharRefItem> result = new ArrayList<CharRefItem>(refs.size());
        Iterator i = refs.iterator();
        while (i.hasNext()) {
            String name = ((DTD.CharRef)i.next()).getName();
            result.add(new CharRefItem(name, offset, length, name));
        }
        return result;
    }

    List translateTags(int offset, int length, List tags) {
        ArrayList<TagItem> result = new ArrayList<TagItem>(tags.size());
        Iterator i = tags.iterator();
        while (i.hasNext()) {
            String name = ((DTD.Element)i.next()).getName();
            result.add(new TagItem(name, offset, length, name));
        }
        return result;
    }

    List translateAttribs(int offset, int length, List attribs, DTD.Element tag) {
        ArrayList<HTMLResultItem> result = new ArrayList<HTMLResultItem>(attribs.size());
        String tagName = tag.getName() + "#";
        for (DTD.Attribute attrib : attribs) {
            String name = attrib.getName();
            switch (attrib.getType()) {
                case 0: {
                    result.add(new BooleanAttribItem(name, offset, length, attrib.isRequired(), tagName + name));
                    break;
                }
                case 1: {
                    result.add(new SetAttribItem(name, offset, length, attrib.isRequired(), tagName + name));
                    break;
                }
                case 2: {
                    result.add(new PlainAttribItem(name, offset, length, attrib.isRequired(), tagName + name));
                }
            }
        }
        return result;
    }

    List translateValues(int offset, int length, List values) {
        return this.translateValues(offset, length, values, null);
    }

    List translateValues(int offset, int length, List values, String quotationChar) {
        if (values == null) {
            return new ArrayList(0);
        }
        ArrayList<ValueItem> result = new ArrayList<ValueItem>(values.size());
        Iterator i = values.iterator();
        while (i.hasNext()) {
            result.add(new ValueItem(((DTD.Value)i.next()).getName(), offset, length, quotationChar));
        }
        return result;
    }

    static {
        DEFAULT = new HTMLCompletionQuery();
    }

    public static class HTMLCompletionResult
    extends CompletionQuery.DefaultResult {
        private int substituteOffset;

        public HTMLCompletionResult(JTextComponent component, String title, List data, int offset, int len) {
            super(component, title, data, offset, len);
            this.substituteOffset = offset - len;
        }

        public int getSubstituteOffset() {
            return this.substituteOffset;
        }
    }

    public static class DocItem
    implements CompletionDocumentation {
        private String name;

        public DocItem(HTMLResultItem ri) {
            this(ri.getHelpID());
        }

        public DocItem(String name) {
            this.name = name;
        }

        public String getText() {
            String help = HelpManager.getDefault().getHelp(this.name);
            return help;
        }

        public URL getURL() {
            return HelpManager.getDefault().getHelpURL(this.name);
        }

        public CompletionDocumentation resolveLink(String link) {
            String currentLink = HelpManager.getDefault().findHelpItem(this.name).getFile();
            return new LinkDocItem(HelpManager.getDefault().getRelativeURL(HelpManager.getDefault().getHelpURL(this.name), link));
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    static class LinkDocItem
    implements CompletionDocumentation {
        private URL url;

        public LinkDocItem(URL url) {
            this.url = url;
        }

        public String getText() {
            return null;
        }

        public URL getURL() {
            return this.url;
        }

        public CompletionDocumentation resolveLink(String link) {
            return new LinkDocItem(HelpManager.getDefault().getRelativeURL(this.url, link));
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    static class DocQuery
    extends AsyncCompletionQuery {
        private HTMLResultItem item;

        DocQuery(HTMLResultItem item) {
            this.item = item;
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            if (this.item != null && this.item.getHelpID() != null && HelpManager.getDefault().findHelpItem(this.item.getHelpID()) != null) {
                resultSet.setDocumentation((CompletionDocumentation)new DocItem(this.item));
            }
            resultSet.finish();
        }
    }

    private static class ValueItem
    extends HTMLResultItem {
        private String quotationChar = null;

        public ValueItem(String name, int offset, int length, String quotationChar) {
            this(name, offset, length);
            this.quotationChar = quotationChar;
        }

        public ValueItem(String name, int offset, int length) {
            super(name, offset, length);
        }

        public CharSequence getInsertPrefix() {
            if (this.quotationChar == null) {
                return super.getInsertPrefix();
            }
            return this.quotationChar + super.getInsertPrefix();
        }

        Color getPaintColor() {
            return Color.magenta;
        }

        public boolean substituteText(JTextComponent c, int a, int b, boolean shift) {
            BaseDocument doc = (BaseDocument)c.getDocument();
            boolean hasQuote = false;
            try {
                String currentText = doc.getText(c.getCaretPosition(), 1);
                hasQuote = "\"".equals(currentText);
            }
            catch (BadLocationException ble) {
                // empty catch block
            }
            String quotedText = this.quotationChar == null ? this.baseText : this.quotationChar + this.baseText + (hasQuote ? "" : this.quotationChar);
            this.replaceText(c, quotedText);
            return !shift;
        }
    }

    private static class PlainAttribItem
    extends HTMLResultItem {
        boolean required;

        public PlainAttribItem(String name, int offset, int length, boolean required) {
            super(name, offset, length);
            this.required = required;
        }

        public PlainAttribItem(String name, int offset, int length, boolean required, String helpID) {
            super(name, offset, length, helpID);
            this.required = required;
        }

        Color getPaintColor() {
            return this.required ? Color.red : Color.green.darker();
        }

        public boolean substituteText(JTextComponent c, int a, int b, boolean shift) {
            this.replaceText(c, this.baseText + "=\"\"");
            Caret caret = c.getCaret();
            caret.setDot(caret.getDot() - 1);
            return false;
        }
    }

    private static class BooleanAttribItem
    extends HTMLResultItem {
        boolean required;

        public BooleanAttribItem(String name, int offset, int length, boolean required) {
            super(name, offset, length);
            this.required = required;
        }

        public BooleanAttribItem(String name, int offset, int length, boolean required, String helpID) {
            super(name, offset, length, helpID);
            this.required = required;
        }

        Color getPaintColor() {
            return this.required ? Color.red : Color.green.darker();
        }

        public boolean substituteText(JTextComponent c, int a, int b, boolean shift) {
            this.replaceText(c, shift ? this.baseText + " " : this.baseText);
            return false;
        }
    }

    private static class SetAttribItem
    extends HTMLResultItem {
        boolean required;

        public SetAttribItem(String name, int offset, int length, boolean required) {
            super(name, offset, length);
            this.required = required;
        }

        public SetAttribItem(String name, int offset, int length, boolean required, String helpID) {
            super(name, offset, length, helpID);
            this.required = required;
        }

        Color getPaintColor() {
            return this.required ? Color.red : Color.green.darker();
        }

        String getPaintText() {
            return this.baseText;
        }

        public String getItemText() {
            return this.baseText;
        }

        public boolean substituteText(JTextComponent c, int a, int b, boolean shift) {
            this.replaceText(c, this.baseText + "=\"\"");
            Caret caret = c.getCaret();
            caret.setDot(caret.getDot() - 1);
            return false;
        }
    }

    private static class TagItem
    extends HTMLResultItem {
        public TagItem(String name, int offset, int length) {
            super(name, offset, length);
        }

        public TagItem(String name, int offset, int length, String helpID) {
            super(name, offset, length, helpID);
        }

        public boolean substituteText(JTextComponent c, int a, int b, boolean shift) {
            this.replaceText(c, "<" + this.baseText + (shift ? " >" : ">"));
            if (shift) {
                Caret caret = c.getCaret();
                caret.setDot(caret.getDot() - 1);
            }
            Completion.get().showCompletion();
            return !shift;
        }

        Color getPaintColor() {
            return Color.blue;
        }

        public String getItemText() {
            return "<" + this.baseText + ">";
        }
    }

    private static class CharRefItem
    extends HTMLResultItem {
        public CharRefItem(String name, int offset, int length) {
            super(name, offset, length);
            this.baseText = name;
        }

        public CharRefItem(String name, int offset, int length, String helpID) {
            super(name, offset, length, helpID);
            this.baseText = name;
        }

        Color getPaintColor() {
            return Color.red.darker();
        }

        public CharSequence getSortText() {
            String itext = this.getItemText();
            return itext.endsWith(";") ? itext.substring(0, itext.length() - 1) : itext;
        }

        public String getItemText() {
            return "&" + this.baseText + ";";
        }
    }

    static class EndTagItem
    extends HTMLResultItem {
        private int order = 0;

        public EndTagItem(String baseText, int offset, int length) {
            super(baseText, offset, length);
        }

        public EndTagItem(String baseText, int offset, int length, String helpID) {
            super(baseText, offset, length, helpID);
        }

        public EndTagItem(String baseText, int offset, int length, String helpID, int order) {
            this(baseText, offset, length, helpID);
            this.order = order;
        }

        public CharSequence getSortText() {
            return this.getSortText(this.order);
        }

        private String getSortText(int index) {
            int zeros = index > 100 ? 0 : (index > 10 ? 1 : 2);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < zeros; ++i) {
                sb.append('0');
            }
            sb.append("" + index);
            return sb.toString();
        }

        Color getPaintColor() {
            return Color.blue;
        }

        public String getItemText() {
            return "</" + this.baseText + ">";
        }

        public boolean substituteText(JTextComponent c, int a, int b, boolean shift) {
            return super.substituteText(c, a, b, shift);
        }

        protected void reformat(JTextComponent component, String text) {
            try {
                BaseDocument doc = (BaseDocument)component.getDocument();
                ExtFormatter f = (ExtFormatter)doc.getFormatter();
                int[] fmtBlk = f.getReformatBlock(component, text);
                if (fmtBlk != null) {
                    fmtBlk[0] = Utilities.getRowStart((BaseDocument)doc, (int)fmtBlk[0]);
                    fmtBlk[1] = Utilities.getRowEnd((BaseDocument)doc, (int)fmtBlk[1]);
                    f.reformat(doc, fmtBlk[0], fmtBlk[1], true);
                }
            }
            catch (BadLocationException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class AutocompleteEndTagItem
    extends EndTagItem {
        public AutocompleteEndTagItem(String baseText, int offset) {
            this(baseText, offset, true);
        }

        public AutocompleteEndTagItem(String baseText, int offset, boolean changeCase) {
            super(baseText, offset, 0);
            if (!changeCase) {
                this.baseText = baseText;
            }
        }

        boolean replaceText(JTextComponent component, String text) {
            boolean replaced = super.replaceText(component, text);
            if (replaced) {
                component.setCaretPosition(this.offset);
            }
            return replaced;
        }

        protected void reformat(JTextComponent component, String text) {
            try {
                BaseDocument doc = (BaseDocument)component.getDocument();
                ExtFormatter f = (ExtFormatter)doc.getFormatter();
                int dotPos = component.getCaretPosition();
                f.reformat(doc, Utilities.getRowStart((BaseDocument)doc, (int)dotPos), Utilities.getRowEnd((BaseDocument)doc, (int)dotPos), true);
            }
            catch (BadLocationException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public CharSequence getInsertPrefix() {
            return null;
        }
    }

    public static abstract class HTMLResultItem
    implements CompletionQuery.ResultItem,
    CompletionItem {
        String baseText;
        int offset;
        int length;
        String helpID;
        boolean shift = false;
        private HTMLCompletionResultItemPaintComponent component;
        private static final int HTML_ITEMS_SORT_PRIORITY = 20;
        protected int selectionStartOffset = -1;
        protected int selectionEndOffset = -1;
        public static final String COMPLETION_SUBSTITUTE_TEXT = "completion-substitute-text";
        static int substituteOffset = -1;

        public HTMLResultItem(String baseText, int offset, int length) {
            this.baseText = lowerCase ? baseText.toLowerCase() : baseText.toUpperCase();
            this.offset = offset;
            this.length = length;
            this.helpID = null;
        }

        public HTMLResultItem(String baseText, int offset, int length, String helpID) {
            this(baseText, offset, length);
            this.helpID = helpID;
        }

        public int getSortPriority() {
            return 20;
        }

        public CharSequence getSortText() {
            return this.getItemText();
        }

        public CharSequence getInsertPrefix() {
            return this.getItemText();
        }

        public Component getPaintComponent(boolean isSelected) {
            HTMLCompletionResultItemPaintComponent.StringPaintComponent component = new HTMLCompletionResultItemPaintComponent.StringPaintComponent(this.getPaintColor());
            component.setSelected(isSelected);
            component.setString(this.getItemText());
            return component;
        }

        public int getPreferredWidth(Graphics g, Font defaultFont) {
            Component renderComponent = this.getPaintComponent(false);
            return renderComponent.getPreferredSize().width;
        }

        public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
            Component renderComponent = this.getPaintComponent(selected);
            renderComponent.setFont(defaultFont);
            renderComponent.setForeground(defaultColor);
            renderComponent.setBackground(backgroundColor);
            renderComponent.setBounds(0, 0, width, height);
            ((HTMLCompletionResultItemPaintComponent)renderComponent).paintComponent(g);
        }

        protected Object getAssociatedObject() {
            return this.getItemText();
        }

        public int getSubstituteOffset() {
            return substituteOffset;
        }

        public boolean instantSubstitution(JTextComponent c) {
            this.defaultAction(c);
            return true;
        }

        public CompletionTask createDocumentationTask() {
            return new AsyncCompletionTask((AsyncCompletionQuery)new DocQuery(this));
        }

        public CompletionTask createToolTipTask() {
            return null;
        }

        public int getImportance() {
            return 0;
        }

        public void processKeyEvent(KeyEvent e) {
            this.shift = e.getKeyCode() == 10 && e.getID() == 401 && e.isShiftDown();
        }

        public void defaultAction(JTextComponent component) {
            int substOffset = this.getSubstituteOffset();
            if (substOffset == -1) {
                substOffset = component.getCaretPosition();
            }
            if (!this.shift) {
                Completion.get().hideAll();
            }
            this.substituteText(component, substOffset, component.getCaretPosition() - substOffset, this.shift);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean replaceText(JTextComponent component, String text) {
            BaseDocument doc = (BaseDocument)component.getDocument();
            doc.atomicLock();
            try {
                String currentText = doc.getText(this.offset, doc.getLength() - this.offset < text.length() ? doc.getLength() - this.offset : text.length());
                if (!text.equals(currentText)) {
                    doc.remove(this.offset, this.length);
                    doc.insertString(this.offset, text, null);
                } else {
                    int newCaretPos = component.getCaret().getDot() + text.length() - this.length;
                    component.setCaretPosition(newCaretPos < doc.getLength() ? newCaretPos : doc.getLength());
                }
            }
            catch (BadLocationException exc) {
                boolean bl = false;
                return bl;
            }
            finally {
                doc.atomicUnlock();
            }
            return true;
        }

        protected void reformat(JTextComponent component, String text) {
        }

        public boolean substituteCommonText(JTextComponent c, int a, int b, int subLen) {
            String text = this.getItemText().substring(0, subLen);
            boolean replaced = this.replaceText(c, text);
            this.reformat(c, text);
            return replaced;
        }

        public boolean substituteText(JTextComponent c, int a, int b, boolean shift) {
            String text = this.getItemText();
            boolean replaced = this.replaceText(c, text);
            this.reformat(c, text);
            return replaced;
        }

        public Component getPaintComponent(JList list, boolean isSelected, boolean cellHasFocus) {
            Component ret = this.getPaintComponent(isSelected);
            if (ret == null) {
                return null;
            }
            if (isSelected) {
                ret.setBackground(list.getSelectionBackground());
                ret.setForeground(list.getSelectionForeground());
            } else {
                ret.setBackground(list.getBackground());
                ret.setForeground(list.getForeground());
            }
            ret.getAccessibleContext().setAccessibleName(this.getItemText());
            ret.getAccessibleContext().setAccessibleDescription(this.getItemText());
            return ret;
        }

        String getPaintText() {
            return this.getItemText();
        }

        abstract Color getPaintColor();

        public String getItemText() {
            return this.baseText;
        }

        public String getHelpID() {
            return this.helpID;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            String className = this.getClass().getName();
            className = className.substring(className.lastIndexOf(46) + 1);
            sb.append(className);
            sb.append('(');
            sb.append(this.getItemText());
            sb.append(';');
            sb.append(this.getSubstituteOffset());
            sb.append(';');
            sb.append(this.getHelpID());
            sb.append(')');
            return sb.toString();
        }
    }
}

