/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.io.File;
import org.netbeans.modules.openfile.OpenFileImpl;
import org.netbeans.modules.openfile.cli.Callback;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class OpenFile {
    static final /* synthetic */ boolean $assertionsDisabled;

    private OpenFile() {
    }

    private static OpenFileImpl getImpl() {
        return (OpenFileImpl)Lookup.getDefault().lookup(OpenFileImpl.class);
    }

    public static void open(String fileName) {
        OpenFile.openFile(new File(fileName), -1, null);
    }

    public static void open(FileObject fileObject) {
        OpenFile.getImpl().open(fileObject, -1, null);
    }

    static boolean openFile(File file, int line, Callback.Waiter waiter) {
        if (!OpenFile.checkFileExists(file)) {
            return false;
        }
        OpenFileImpl impl = OpenFile.getImpl();
        FileObject fileObject = impl.findFileObject(file);
        if (fileObject != null) {
            return impl.open(fileObject, line, waiter);
        }
        return false;
    }

    private static boolean checkFileExists(File file) {
        String errMsgKey;
        if (!file.exists()) {
            errMsgKey = "MSG_fileNotFound";
        } else if (OpenFile.isSpecifiedByUNCPath(file)) {
            errMsgKey = "MSG_UncNotSupported";
        } else if (!file.isFile()) {
            errMsgKey = "MSG_fileNotFound";
        } else {
            return true;
        }
        String fileName = file.toString();
        final String msg = NbBundle.getMessage((Class)OpenFileImpl.class, (String)errMsgKey, (Object)fileName);
        new Thread(new Runnable(){

            public void run() {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
            }
        }).start();
        return false;
    }

    static boolean isSpecifiedByUNCPath(File file) {
        if (!($assertionsDisabled || file != null && file.exists())) {
            throw new AssertionError();
        }
        file = FileUtil.normalizeFile((File)file);
        return file.getPath().startsWith("\\\\");
    }

    static {
        $assertionsDisabled = !OpenFile.class.desiredAssertionStatus();
    }
}

