/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutRegion;
import org.netbeans.modules.form.layoutdesign.VisualMapper;

public class LayoutUtils
implements LayoutConstants {
    private LayoutUtils() {
    }

    public static LayoutInterval getAdjacentEmptySpace(LayoutComponent comp, int dimension, int direction) {
        LayoutInterval parent;
        LayoutInterval interval = comp.getLayoutInterval(dimension);
        while ((parent = interval.getParent()) != null) {
            if (parent.isSequential()) {
                int index = parent.indexOf(interval);
                if (direction == 0) {
                    if (index == 0) {
                        interval = parent;
                        continue;
                    }
                    LayoutInterval candidate = parent.getSubInterval(index - 1);
                    return candidate.isEmptySpace() ? candidate : null;
                }
                if (index == parent.getSubIntervalCount() - 1) {
                    interval = parent;
                    continue;
                }
                LayoutInterval candidate = parent.getSubInterval(index + 1);
                return candidate.isEmptySpace() ? candidate : null;
            }
            if (LayoutInterval.isPlacedAtBorder(interval, dimension, direction)) {
                interval = parent;
                continue;
            }
            return null;
        }
        return null;
    }

    static LayoutInterval getOutermostComponent(LayoutInterval interval, int dimension, int alignment) {
        if (interval.isComponent()) {
            return interval;
        }
        assert (alignment == 0 || alignment == 1);
        if (interval.isSequential()) {
            int i;
            int d = alignment == 0 ? 1 : -1;
            int n = i = alignment == 0 ? 0 : interval.getSubIntervalCount() - 1;
            while (i >= 0 && i < interval.getSubIntervalCount()) {
                LayoutInterval li = interval.getSubInterval(i);
                if (li.isEmptySpace()) {
                    i += d;
                    continue;
                }
                return LayoutUtils.getOutermostComponent(li, dimension, alignment);
            }
        } else if (interval.isParallel()) {
            LayoutInterval best = null;
            int pos = Integer.MAX_VALUE;
            int n = interval.getSubIntervalCount();
            for (int i = 0; i < n; ++i) {
                LayoutInterval li = LayoutUtils.getOutermostComponent(interval.getSubInterval(i), dimension, alignment);
                if (li == null) continue;
                if (LayoutInterval.isAlignedAtBorder(li, interval, alignment)) {
                    return li;
                }
                int p = li.getCurrentSpace().positions[dimension][alignment] * (alignment == 0 ? 1 : -1);
                if (p >= pos) continue;
                best = li;
                pos = p;
            }
            return best;
        }
        return null;
    }

    static int getSizeOfDefaultGap(LayoutInterval interval, VisualMapper visualMapper) {
        assert (interval.isEmptySpace());
        LayoutInterval parent = interval.getParent();
        if (parent.isParallel()) {
            return interval.getPreferredSize();
        }
        LayoutInterval candidate = interval;
        LayoutInterval srcInt = null;
        LayoutInterval targetInt = null;
        while (parent != null && (srcInt == null || targetInt == null)) {
            int index = parent.indexOf(candidate);
            if (srcInt == null && index > 0) {
                srcInt = parent.getSubInterval(index - 1);
            }
            if (targetInt == null && index < parent.getSubIntervalCount() - 1) {
                targetInt = parent.getSubInterval(index + 1);
            }
            if (srcInt != null && targetInt != null) continue;
            do {
                candidate = parent;
            } while ((parent = parent.getParent()) != null && parent.isParallel());
        }
        List sources = LayoutUtils.edgeSubComponents(srcInt, 1);
        List targets = LayoutUtils.edgeSubComponents(targetInt, 0);
        return LayoutUtils.getSizeOfDefaultGap(sources, targets, visualMapper, null, Collections.EMPTY_MAP);
    }

    static int getSizeOfDefaultGap(List sources, List targets, VisualMapper visualMapper, String contId, Map boundsMap) {
        LayoutRegion region;
        if (sources != null && sources.isEmpty() || targets != null && targets.isEmpty()) {
            return 0;
        }
        sources = sources == null ? Collections.EMPTY_LIST : sources;
        targets = targets == null ? Collections.EMPTY_LIST : targets;
        int size = 0;
        boolean containerGap = false;
        int containerGapAlignment = -1;
        LayoutInterval temp = null;
        if (sources.isEmpty()) {
            if (targets.isEmpty()) {
                return 0;
            }
            containerGap = true;
            containerGapAlignment = 0;
            temp = (LayoutInterval)targets.get(0);
        } else {
            temp = (LayoutInterval)sources.get(0);
            if (targets.isEmpty()) {
                containerGap = true;
                containerGapAlignment = 1;
            }
        }
        int dimension = temp == temp.getComponent().getLayoutInterval(0) ? 0 : 1;
        int max = Short.MIN_VALUE;
        int min = Short.MAX_VALUE;
        boolean positionsNotUpdated = false;
        for (LayoutInterval source : sources) {
            region = LayoutUtils.sizeOfEmptySpaceHelper(source, boundsMap);
            int trailing = region.positions[dimension][1];
            if (trailing == Integer.MIN_VALUE) {
                positionsNotUpdated = true;
                break;
            }
            max = Math.max(max, trailing);
        }
        Iterator iter = targets.iterator();
        while (iter.hasNext()) {
            LayoutInterval target = (LayoutInterval)iter.next();
            region = LayoutUtils.sizeOfEmptySpaceHelper(target, boundsMap);
            int leading = region.positions[dimension][0];
            if (leading == Integer.MIN_VALUE) {
                positionsNotUpdated = true;
                break;
            }
            min = Math.min(min, leading);
        }
        if (containerGap) {
            Iterator iterator = iter = sources.isEmpty() ? targets.iterator() : sources.iterator();
            while (iter.hasNext()) {
                int delta;
                LayoutInterval interval = (LayoutInterval)iter.next();
                LayoutComponent component = interval.getComponent();
                LayoutRegion region2 = LayoutUtils.sizeOfEmptySpaceHelper(interval, boundsMap);
                String parentId = contId == null ? component.getParent().getId() : contId;
                int padding = visualMapper.getPreferredPaddingInParent(parentId, component.getId(), dimension, containerGapAlignment);
                int position = region2.positions[dimension][containerGapAlignment];
                int n = delta = containerGapAlignment == 0 ? position - min : max - position;
                if (!positionsNotUpdated) {
                    padding -= delta;
                }
                size = Math.max(size, padding);
            }
        } else {
            for (LayoutInterval srcCandidate : sources) {
                String srcId = srcCandidate.getComponent().getId();
                LayoutRegion srcRegion = LayoutUtils.sizeOfEmptySpaceHelper(srcCandidate, boundsMap);
                int srcDelta = max - srcRegion.positions[dimension][1];
                for (LayoutInterval targetCandidate : targets) {
                    String targetId = targetCandidate.getComponent().getId();
                    LayoutRegion targetRegion = LayoutUtils.sizeOfEmptySpaceHelper(targetCandidate, boundsMap);
                    int targetDelta = targetRegion.positions[dimension][0] - min;
                    int padding = visualMapper.getPreferredPadding(srcId, targetId, dimension, 0, 0);
                    if (!positionsNotUpdated) {
                        padding -= srcDelta + targetDelta;
                    }
                    size = Math.max(size, padding);
                }
            }
        }
        return size;
    }

    private static LayoutRegion sizeOfEmptySpaceHelper(LayoutInterval interval, Map boundsMap) {
        LayoutComponent component = interval.getComponent();
        String compId = component.getId();
        if (boundsMap.containsKey(compId)) {
            return (LayoutRegion)boundsMap.get(compId);
        }
        return interval.getCurrentSpace();
    }

    static int getVisualPosition(LayoutInterval interval, int dimension, int alignment) {
        if (interval.isEmptySpace()) {
            assert (alignment == 0 || alignment == 1);
            LayoutInterval neighbor = LayoutInterval.getDirectNeighbor(interval, alignment, false);
            if (neighbor != null) {
                interval = neighbor;
                alignment ^= 1;
            } else {
                interval = LayoutInterval.getFirstParent(interval, 103);
            }
        }
        return interval.getCurrentSpace().positions[dimension][alignment];
    }

    static List edgeSubComponents(LayoutInterval root, int edge) {
        LinkedList<LayoutInterval> components = null;
        LinkedList<LayoutInterval> candidates = new LinkedList<LayoutInterval>();
        if (root != null) {
            components = new LinkedList<LayoutInterval>();
            candidates.add(root);
        }
        while (!candidates.isEmpty()) {
            LayoutInterval candidate = (LayoutInterval)candidates.get(0);
            candidates.remove(candidate);
            if (candidate.isGroup()) {
                if (candidate.isSequential()) {
                    int index = edge == 0 ? 0 : candidate.getSubIntervalCount() - 1;
                    candidates.add(candidate.getSubInterval(index));
                    continue;
                }
                Iterator subs = candidate.getSubIntervals();
                while (subs.hasNext()) {
                    candidates.add((LayoutInterval)subs.next());
                }
                continue;
            }
            if (!candidate.isComponent()) continue;
            components.add(candidate);
        }
        return components;
    }

    static boolean contentOverlap(LayoutRegion space, LayoutInterval interval, int dimension) {
        return LayoutUtils.contentOverlap(space, interval, -1, -1, dimension);
    }

    static boolean contentOverlap(LayoutRegion space, LayoutInterval interval, int fromIndex, int toIndex, int dimension) {
        boolean overlap;
        LayoutRegion examinedSpace = interval.getCurrentSpace();
        if (!interval.isGroup()) {
            return LayoutRegion.overlap(space, examinedSpace, dimension, 0);
        }
        boolean bl = overlap = !examinedSpace.isSet(dimension) || LayoutRegion.overlap(space, examinedSpace, dimension, 0);
        if (overlap) {
            if (fromIndex < 0) {
                fromIndex = 0;
            }
            if (toIndex < 0) {
                toIndex = interval.getSubIntervalCount() - 1;
            }
            assert (fromIndex <= toIndex);
            overlap = false;
            for (int i = fromIndex; i <= toIndex; ++i) {
                LayoutInterval li = interval.getSubInterval(i);
                if (li.isEmptySpace() || !LayoutUtils.contentOverlap(space, li, dimension)) continue;
                overlap = true;
                break;
            }
        }
        return overlap;
    }

    static boolean contentOverlap(LayoutInterval interval1, LayoutInterval interval2, int dimension) {
        return LayoutUtils.contentOverlap(interval1, interval2, -1, -1, dimension);
    }

    static boolean contentOverlap(LayoutInterval interval1, LayoutInterval interval2, int fromIndex, int toIndex, int dimension) {
        if (!interval2.isGroup()) {
            if (!interval1.isGroup()) {
                return LayoutRegion.overlap(interval1.getCurrentSpace(), interval2.getCurrentSpace(), dimension, 0);
            }
            LayoutInterval temp = interval1;
            interval2 = interval1 = interval2;
        }
        LinkedList<LayoutInterval> int2list = null;
        LinkedList<LayoutInterval> addList = null;
        Iterator it1 = LayoutUtils.getComponentIterator(interval1);
        while (it1.hasNext()) {
            Iterator it2;
            LayoutRegion space1 = ((LayoutInterval)it1.next()).getCurrentSpace();
            Iterator iterator = it2 = int2list != null ? int2list.iterator() : LayoutUtils.getComponentIterator(interval2, fromIndex, toIndex);
            if (int2list == null && it1.hasNext()) {
                addList = int2list = new LinkedList<LayoutInterval>();
            }
            while (it2.hasNext()) {
                LayoutInterval li2 = (LayoutInterval)it2.next();
                if (LayoutRegion.overlap(space1, li2.getCurrentSpace(), dimension, 0)) {
                    return true;
                }
                if (addList == null) continue;
                addList.add(li2);
            }
            addList = null;
        }
        return false;
    }

    static boolean isOverlapPreventedInOtherDimension(LayoutInterval compInterval, LayoutInterval interval, int dimension) {
        int otherDim = dimension ^ 1;
        compInterval = (LayoutInterval)LayoutUtils.getComponentIterator(compInterval).next();
        LayoutComponent component = compInterval.getComponent();
        LayoutInterval otherCompInterval = component.getLayoutInterval(otherDim);
        Iterator it = LayoutUtils.getComponentIterator(interval);
        assert (it.hasNext());
        do {
            LayoutComponent comp;
            LayoutInterval otherInterval;
            LayoutInterval parent;
            if ((parent = LayoutInterval.getCommonParent(otherCompInterval, otherInterval = (comp = ((LayoutInterval)it.next()).getComponent()).getLayoutInterval(otherDim))) != null && !parent.isParallel()) continue;
            return false;
        } while (it.hasNext());
        return true;
    }

    static Iterator getComponentIterator(LayoutInterval interval) {
        return new ComponentIterator(interval, 0, interval.getSubIntervalCount() - 1);
    }

    static Iterator getComponentIterator(LayoutInterval interval, int startIndex, int endIndex) {
        return new ComponentIterator(interval, startIndex, endIndex);
    }

    private static class ComponentIterator
    implements Iterator {
        private LayoutInterval root;
        private int startIndex;
        private int endIndex;
        private boolean initialized;
        private int index;
        private LayoutInterval next;

        ComponentIterator(LayoutInterval interval, int startIndex, int endIndex) {
            this.root = interval;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.findNext();
            this.initialized = true;
        }

        private void findNext() {
            int idx;
            LayoutInterval parent;
            if (this.next == null) {
                if (this.initialized) {
                    return;
                }
                if (!this.root.isGroup()) {
                    if (this.root.isComponent()) {
                        this.next = this.root;
                    }
                    return;
                }
                parent = this.root;
                idx = this.startIndex;
            } else if (this.next != this.root) {
                parent = this.next.getParent();
                idx = this.index + 1;
            } else {
                this.next = null;
                return;
            }
            this.next = null;
            while (true) {
                if (idx < parent.getSubIntervalCount()) {
                    if (parent == this.root && idx > this.endIndex) {
                        return;
                    }
                    LayoutInterval sub = parent.getSubInterval(idx);
                    if (sub.isComponent()) {
                        this.next = sub;
                        this.index = idx;
                        return;
                    }
                    if (sub.isGroup()) {
                        parent = sub;
                        idx = 0;
                        continue;
                    }
                    ++idx;
                    continue;
                }
                if (parent == this.root) break;
                idx = parent.getParent().indexOf(parent) + 1;
                parent = parent.getParent();
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            LayoutInterval ret = this.next;
            this.findNext();
            return ret;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

