/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;
import org.netbeans.modules.debugger.jpda.models.ThisVariable;

public final class JPDAThreadImpl
implements JPDAThread {
    public static final String PROP_SUSPENDED = "suspended";
    private ThreadReference threadReference;
    private JPDADebuggerImpl debugger;
    private boolean suspended;
    private PropertyChangeSupport pch = new PropertyChangeSupport(this);
    private Object lastBottomSF;

    public JPDAThreadImpl(ThreadReference threadReference, JPDADebuggerImpl debugger) {
        this.threadReference = threadReference;
        this.debugger = debugger;
        this.suspended = threadReference.isSuspended();
    }

    public String getName() {
        try {
            return this.threadReference.name();
        }
        catch (ObjectCollectedException ex) {
            return "";
        }
        catch (VMDisconnectedException ex) {
            return "";
        }
    }

    public JPDAThreadGroup getParentThreadGroup() {
        try {
            ThreadGroupReference tgr = this.threadReference.threadGroup();
            if (tgr == null) {
                return null;
            }
            return this.debugger.getThreadGroup(tgr);
        }
        catch (ObjectCollectedException ex) {
            return null;
        }
        catch (VMDisconnectedException ex) {
            return null;
        }
    }

    public int getLineNumber(String stratum) {
        try {
            if (this.threadReference.frameCount() < 1) {
                return -1;
            }
            return this.threadReference.frame(0).location().lineNumber(stratum);
        }
        catch (ObjectCollectedException ex) {
        }
        catch (InvalidStackFrameException ex) {
        }
        catch (IncompatibleThreadStateException ex) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return -1;
    }

    public int getState() {
        try {
            return this.threadReference.status();
        }
        catch (ObjectCollectedException ex) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return -1;
    }

    public boolean isSuspended() {
        try {
            return this.threadReference.isSuspended();
        }
        catch (ObjectCollectedException ex) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return false;
    }

    public String getClassName() {
        try {
            if (this.threadReference.frameCount() < 1) {
                return "";
            }
            return this.threadReference.frame(0).location().declaringType().name();
        }
        catch (ObjectCollectedException ex) {
        }
        catch (InvalidStackFrameException ex) {
        }
        catch (IncompatibleThreadStateException ex) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return "";
    }

    public String getMethodName() {
        try {
            if (this.threadReference.frameCount() < 1) {
                return "";
            }
            return this.threadReference.frame(0).location().method().name();
        }
        catch (ObjectCollectedException ex) {
        }
        catch (InvalidStackFrameException ex) {
        }
        catch (IncompatibleThreadStateException ex) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return "";
    }

    public String getSourceName(String stratum) throws AbsentInformationException {
        try {
            if (this.threadReference.frameCount() < 1) {
                return "";
            }
            return this.threadReference.frame(0).location().sourceName(stratum);
        }
        catch (ObjectCollectedException ex) {
        }
        catch (InvalidStackFrameException ex) {
        }
        catch (IncompatibleThreadStateException ex) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return "";
    }

    public String getSourcePath(String stratum) throws AbsentInformationException {
        try {
            if (this.threadReference.frameCount() < 1) {
                return "";
            }
            return this.threadReference.frame(0).location().sourcePath(stratum);
        }
        catch (ObjectCollectedException ex) {
        }
        catch (InvalidStackFrameException ex) {
        }
        catch (IncompatibleThreadStateException ex) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return "";
    }

    public CallStackFrame[] getCallStack() throws AbsentInformationException {
        return this.getCallStack(0, this.getStackDepth());
    }

    public CallStackFrame[] getCallStack(int from, int to) throws AbsentInformationException {
        try {
            int max = this.threadReference.frameCount();
            from = Math.min(from, max);
            to = Math.min(to, max);
            List<StackFrame> l = this.threadReference.frames(from, to - from);
            int n = l.size();
            CallStackFrame[] frames = new CallStackFrame[n];
            for (int i = 0; i < n; ++i) {
                frames[i] = new CallStackFrameImpl(l.get(i), from + i, this.debugger);
            }
            return frames;
        }
        catch (IncompatibleThreadStateException ex) {
            AbsentInformationException aiex = new AbsentInformationException(ex.getLocalizedMessage());
            aiex.initCause(ex);
            throw aiex;
        }
        catch (ObjectCollectedException ocex) {
            AbsentInformationException aiex = new AbsentInformationException(ocex.getLocalizedMessage());
            aiex.initCause(ocex);
            throw aiex;
        }
        catch (VMDisconnectedException ex) {
            return new CallStackFrame[0];
        }
    }

    public int getStackDepth() {
        try {
            return this.threadReference.frameCount();
        }
        catch (ObjectCollectedException ex) {
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            // empty catch block
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        Boolean suspendedToFire = null;
        JPDAThreadImpl jPDAThreadImpl = this;
        synchronized (jPDAThreadImpl) {
            try {
                if (!this.isSuspended()) {
                    this.threadReference.suspend();
                    suspendedToFire = Boolean.TRUE;
                }
                this.suspended = true;
            }
            catch (ObjectCollectedException ex) {
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
        if (suspendedToFire != null) {
            this.pch.firePropertyChange(PROP_SUSPENDED, (Object)(suspendedToFire == false ? 1 : 0), suspendedToFire);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Boolean suspendedToFire = null;
        JPDAThreadImpl jPDAThreadImpl = this;
        synchronized (jPDAThreadImpl) {
            try {
                if (this.isSuspended()) {
                    for (int count = this.threadReference.suspendCount(); count > 0; --count) {
                        this.threadReference.resume();
                    }
                    suspendedToFire = Boolean.FALSE;
                }
                this.suspended = false;
            }
            catch (ObjectCollectedException ex) {
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
        if (suspendedToFire != null) {
            this.pch.firePropertyChange(PROP_SUSPENDED, (Object)(suspendedToFire == false ? 1 : 0), suspendedToFire);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyToBeRunning() {
        Boolean suspendedToFire = null;
        JPDAThreadImpl jPDAThreadImpl = this;
        synchronized (jPDAThreadImpl) {
            if (this.suspended) {
                this.suspended = false;
                suspendedToFire = Boolean.FALSE;
            }
        }
        if (suspendedToFire != null) {
            this.pch.firePropertyChange(PROP_SUSPENDED, (Object)(suspendedToFire == false ? 1 : 0), suspendedToFire);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySuspended() {
        Boolean suspendedToFire = null;
        JPDAThreadImpl jPDAThreadImpl = this;
        synchronized (jPDAThreadImpl) {
            if (!this.suspended && this.isSuspended()) {
                this.suspended = true;
                suspendedToFire = Boolean.TRUE;
            }
        }
        if (suspendedToFire != null) {
            this.pch.firePropertyChange(PROP_SUSPENDED, (Object)(suspendedToFire == false ? 1 : 0), suspendedToFire);
        }
    }

    public void interrupt() {
        try {
            if (this.isSuspended()) {
                return;
            }
            this.threadReference.interrupt();
        }
        catch (ObjectCollectedException ex) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    public void makeCurrent() {
        this.debugger.setCurrentThread(this);
    }

    public ObjectVariable getContendedMonitor() {
        try {
            ObjectReference or = this.threadReference.currentContendedMonitor();
            if (or == null) {
                return null;
            }
            return new ThisVariable(this.debugger, or, "");
        }
        catch (ObjectCollectedException ex) {
        }
        catch (IncompatibleThreadStateException e) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return null;
    }

    public ObjectVariable[] getOwnedMonitors() {
        try {
            List<ObjectReference> l = this.threadReference.ownedMonitors();
            int k = l.size();
            ObjectVariable[] vs = new ObjectVariable[k];
            for (int i = 0; i < k; ++i) {
                vs[i] = new ThisVariable(this.debugger, l.get(i), "");
            }
            return vs;
        }
        catch (ObjectCollectedException ex) {
        }
        catch (IncompatibleThreadStateException e) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return new ObjectVariable[0];
    }

    public ThreadReference getThreadReference() {
        return this.threadReference;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pch.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pch.removePropertyChangeListener(l);
    }

    private void fireSuspended(boolean suspended) {
        this.pch.firePropertyChange(PROP_SUSPENDED, (Object)(!suspended ? 1 : 0), (Object)suspended);
    }
}

