/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor.ui.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.db.api.sql.execute.SQLExecution;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public abstract class SQLExecutionBaseAction
extends AbstractAction
implements ContextAwareAction,
HelpCtx.Provider {
    static /* synthetic */ Class class$org$netbeans$modules$db$api$sql$execute$SQLExecution;

    public SQLExecutionBaseAction() {
        String iconBase;
        this.initialize();
        if (this.getValue("Name") == null) {
            this.putValue("Name", this.getDisplayName(null));
        }
        if ((iconBase = this.getIconBase()) != null) {
            this.putValue("iconBase", iconBase);
        }
    }

    protected void initialize() {
    }

    protected abstract String getDisplayName(SQLExecution var1);

    protected String getIconBase() {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean enable(SQLExecution sqlExecution) {
        return !sqlExecution.isExecuting();
    }

    protected abstract void actionPerformed(SQLExecution var1);

    public void actionPerformed(ActionEvent e) {
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ContextAwareDelegate(this, actionContext);
    }

    public static void notifyNoDatabaseConnection() {
        String message = NbBundle.getMessage((Class)SQLExecutionBaseAction.class, (String)"LBL_NoDatabaseConnection");
        NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)message, 2);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
    }

    static class ContextAwareDelegate
    extends AbstractAction
    implements Presenter.Toolbar,
    HelpCtx.Provider {
        private final SQLExecutionBaseAction parent;
        private final Lookup.Result result;
        private SQLExecution sqlExecution;
        private PropertyChangeListener listener;

        public ContextAwareDelegate(SQLExecutionBaseAction parent, Lookup actionContext) {
            this.parent = parent;
            this.result = actionContext.lookup(new Lookup.Template(class$org$netbeans$modules$db$api$sql$execute$SQLExecution == null ? (class$org$netbeans$modules$db$api$sql$execute$SQLExecution = SQLExecutionBaseAction.class$("org.netbeans.modules.db.api.sql.execute.SQLExecution")) : class$org$netbeans$modules$db$api$sql$execute$SQLExecution));
            this.result.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent ev) {
                    ContextAwareDelegate.this.resultChanged();
                }
            });
            this.resultChanged();
        }

        protected synchronized void setSQLExecution(SQLExecution sqlExecution) {
            this.sqlExecution = sqlExecution;
        }

        protected synchronized SQLExecution getSQLExecution() {
            return this.sqlExecution;
        }

        private synchronized void resultChanged() {
            Iterator iterator;
            if (this.sqlExecution != null) {
                this.sqlExecution.removePropertyChangeListener(this.listener);
            }
            if ((iterator = this.result.allInstances().iterator()).hasNext()) {
                this.setSQLExecution((SQLExecution)iterator.next());
                this.listener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        ContextAwareDelegate.this.propertyChanged(evt.getPropertyName());
                    }
                };
                this.sqlExecution.addPropertyChangeListener(this.listener);
                this.propertyChanged(null);
                if (iterator.hasNext()) {
                    ErrorManager.getDefault().log(16, "Multiple SQLExecution instances in the action context. Will only use the first one.");
                }
            } else {
                this.setSQLExecution(null);
                this.listener = null;
                this.propertyChanged(null);
            }
        }

        private void propertyChanged(String propertyName) {
            if (propertyName == null || "executing".equals(propertyName)) {
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        boolean enabled = false;
                        SQLExecution sqlExecution = ContextAwareDelegate.this.getSQLExecution();
                        if (sqlExecution != null) {
                            enabled = ContextAwareDelegate.this.parent.enable(sqlExecution);
                        }
                        String name = ContextAwareDelegate.this.parent.getDisplayName(sqlExecution);
                        ContextAwareDelegate.this.setEnabled(enabled);
                        ContextAwareDelegate.this.putValue("Name", name);
                    }
                });
            }
        }

        public void actionPerformed(ActionEvent e) {
            SQLExecution sqlExecution = this.getSQLExecution();
            if (sqlExecution != null) {
                this.parent.actionPerformed(sqlExecution);
            }
        }

        public Object getValue(String key) {
            Object value = super.getValue(key);
            if (value == null) {
                value = this.parent.getValue(key);
            }
            return value;
        }

        public HelpCtx getHelpCtx() {
            return this.parent.getHelpCtx();
        }

        public Component getToolbarPresenter() {
            return new Actions.ToolbarButton((Action)this);
        }
    }
}

