/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.nodes;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.Collection;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Binding;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.BindingsComponentFactory;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.BindingsHandler;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.BindingsHandlerChain;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.BindingsHandlerChains;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.BindingsHandlerClass;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.BindingsModel;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.BindingsModelFactory;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.DefinitionsBindings;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.GlobalBindings;
import org.netbeans.modules.websvc.core.webservices.ui.panels.MessageHandlerPanel;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;

public class ClientHandlerButtonListener
implements ActionListener {
    private MessageHandlerPanel panel;
    private BindingsModel bindingsModel;
    private Client client;
    private Node node;
    private JaxWsModel jaxWsModel;
    private FileObject bindingHandlerFO;
    private String wsdlRelativePath;
    private String bindingsHandlerFile;

    public ClientHandlerButtonListener(MessageHandlerPanel panel, BindingsModel bindingsModel, Client client, Node node, JaxWsModel jaxWsModel) {
        this.panel = panel;
        this.bindingsModel = bindingsModel;
        this.client = client;
        this.node = node;
        this.jaxWsModel = jaxWsModel;
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == NotifyDescriptor.OK_OPTION) {
            try {
                Binding binding;
                FileObject srcRoot = (FileObject)this.node.getLookup().lookup(FileObject.class);
                JAXWSClientSupport support = JAXWSClientSupport.getJaxWsClientSupport((FileObject)srcRoot);
                final FileObject bindingsFolder = support.getBindingsFolderForClient(this.node.getName(), true);
                Client client = (Client)this.node.getLookup().lookup(Client.class);
                assert (client != null);
                this.bindingsHandlerFile = client.getHandlerBindingFile();
                if (this.bindingsHandlerFile == null) {
                    String baseBindingsHandlerFile = this.node.getName() + "_handler";
                    this.bindingsHandlerFile = FileUtil.findFreeFileName((FileObject)bindingsFolder, (String)baseBindingsHandlerFile, (String)"xml") + ".xml";
                    client.setHandlerBindingFile(this.bindingsHandlerFile);
                }
                if (this.bindingsModel == null) {
                    final String bindingsContent = ClientHandlerButtonListener.readResource(Repository.getDefault().getDefaultFileSystem().findResource("jax-ws/default-binding-handler.xml").getInputStream());
                    bindingsFolder.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() throws IOException {
                            ClientHandlerButtonListener.this.bindingHandlerFO = FileUtil.createData((FileObject)bindingsFolder, (String)ClientHandlerButtonListener.this.bindingsHandlerFile);
                            BufferedWriter bw = null;
                            OutputStream os = null;
                            OutputStreamWriter osw = null;
                            FileLock lock = ClientHandlerButtonListener.this.bindingHandlerFO.lock();
                            try {
                                os = ClientHandlerButtonListener.this.bindingHandlerFO.getOutputStream(lock);
                                osw = new OutputStreamWriter(os);
                                bw = new BufferedWriter(osw);
                                bw.write(bindingsContent);
                            }
                            finally {
                                try {
                                    if (bw != null) {
                                        bw.close();
                                    }
                                    if (os != null) {
                                        os.close();
                                    }
                                    if (osw != null) {
                                        osw.close();
                                    }
                                }
                                catch (IOException e) {
                                    ErrorManager.getDefault().notify((Throwable)e);
                                }
                                if (lock != null) {
                                    lock.releaseLock();
                                }
                            }
                        }
                    });
                    ModelSource ms = Utilities.getModelSource((FileObject)this.bindingHandlerFO, (boolean)true);
                    this.bindingsModel = BindingsModelFactory.getDefault().getModel(ms);
                    FileObject localWsdlFile = support.getLocalWsdlFolderForClient(client.getName(), false).getFileObject(client.getLocalWsdlFile());
                    File f = FileUtil.toFile((FileObject)this.bindingHandlerFO);
                    String relativePath = Utilities.relativize((URI)f.toURI(), (URI)new URI(localWsdlFile.getURL().toExternalForm()));
                    GlobalBindings gb = this.bindingsModel.getGlobalBindings();
                    this.bindingsModel.startTransaction();
                    gb.setWsdlLocation(relativePath);
                    this.bindingsModel.endTransaction();
                }
                DefaultListModel listModel = this.panel.getListModel();
                GlobalBindings gb = this.bindingsModel.getGlobalBindings();
                DefinitionsBindings db = gb.getDefinitionsBindings();
                BindingsHandlerChains bhc = db.getHandlerChains();
                BindingsHandlerChain chain = bhc.getHandlerChains().iterator().next();
                BindingsComponentFactory factory = this.bindingsModel.getFactory();
                if (listModel.getSize() > 0) {
                    this.bindingsModel.startTransaction();
                    for (int i = 0; i < listModel.getSize(); ++i) {
                        String className = (String)listModel.getElementAt(i);
                        if (!this.isNewHandler(className, chain)) continue;
                        BindingsHandler handler = factory.createHandler();
                        BindingsHandlerClass handlerClass = factory.createHandlerClass();
                        handlerClass.setClassName(className);
                        handler.setHandlerClass(handlerClass);
                        chain.addHandler(handler);
                    }
                    this.bindingsModel.endTransaction();
                }
                if (this.bindingHandlerFO == null) {
                    this.bindingHandlerFO = bindingsFolder.getFileObject(client.getHandlerBindingFile());
                }
                Collection<BindingsHandler> handlers = chain.getHandlers();
                this.bindingsModel.startTransaction();
                for (BindingsHandler handler : handlers) {
                    String clsName = handler.getHandlerClass().getClassName();
                    if (this.isInModel(clsName, listModel)) continue;
                    chain.removeHandler(handler);
                }
                this.bindingsModel.endTransaction();
                DataObject dobj = DataObject.find((FileObject)this.bindingHandlerFO);
                if (dobj.isModified()) {
                    SaveCookie saveCookie = (SaveCookie)dobj.getCookie(SaveCookie.class);
                    saveCookie.save();
                }
                if (listModel.getSize() > 0) {
                    binding = client.getBindingByFileName(this.bindingsHandlerFile);
                    if (binding == null) {
                        binding = client.newBinding();
                        binding.setFileName(this.bindingsHandlerFile);
                        client.addBinding(binding);
                    }
                } else {
                    binding = client.getBindingByFileName(this.bindingsHandlerFile);
                    if (binding != null) {
                        client.removeBinding(binding);
                    }
                }
                this.jaxWsModel.write();
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    private boolean isInModel(String className, ListModel model) {
        for (int i = 0; i < model.getSize(); ++i) {
            String cls = (String)model.getElementAt(i);
            if (!className.equals(cls)) continue;
            return true;
        }
        return false;
    }

    private boolean isNewHandler(String className, BindingsHandlerChain handlerChain) {
        if (handlerChain != null) {
            Collection<BindingsHandler> handlers = handlerChain.getHandlers();
            for (BindingsHandler handler : handlers) {
                if (!handler.getHandlerClass().getClassName().equals(className)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readResource(InputStream is) throws IOException {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String lineSep = System.getProperty("line.separator");
            br = new BufferedReader(new InputStreamReader(is));
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append(lineSep);
                line = br.readLine();
            }
        }
        finally {
            br.close();
        }
        return sb.toString();
    }
}

