/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.nodes;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsRootChildren;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class JaxWsRootNode
extends AbstractNode
implements PropertyChangeListener {
    private PropertyEvaluator evaluator;
    private Project project;
    private boolean jsr109Supported;
    private static final Image WEB_SERVICES_BADGE = Utilities.loadImage((String)"org/netbeans/modules/websvc/core/webservices/ui/resources/webservicegroup.png", (boolean)true);
    static Icon folderIconCache;
    static Icon openedFolderIconCache;
    private final DataFolder srcFolder;

    public JaxWsRootNode(JaxWsModel jaxWsModel, FileObject srcRoot) {
        super((Children)new JaxWsRootChildren(jaxWsModel, srcRoot), JaxWsRootNode.createLookup(srcRoot));
        this.setDisplayName(NbBundle.getBundle(JaxWsRootNode.class).getString("LBL_WebServices"));
        this.srcFolder = srcRoot.isFolder() ? DataFolder.findFolder((FileObject)srcRoot) : null;
        this.project = FileOwnerQuery.getOwner((FileObject)srcRoot);
        if (!Util.isJavaEE5orHigher((Project)this.project)) {
            this.listenToServerChanges();
            this.jsr109Supported = this.isJsr109Supported();
        }
    }

    public Image getIcon(int type) {
        return this.computeIcon(false, type);
    }

    public Image getOpenedIcon(int type) {
        return this.computeIcon(true, type);
    }

    static synchronized Icon getFolderIcon(boolean opened) {
        if (openedFolderIconCache == null) {
            Node n = DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot()).getNodeDelegate();
            openedFolderIconCache = new ImageIcon(n.getOpenedIcon(1));
            folderIconCache = new ImageIcon(n.getIcon(1));
        }
        if (opened) {
            return openedFolderIconCache;
        }
        return folderIconCache;
    }

    private Image computeIcon(boolean opened, int type) {
        Icon icon = JaxWsRootNode.getFolderIcon(opened);
        Image image = ((ImageIcon)icon).getImage();
        image = Utilities.mergeImages((Image)image, (Image)WEB_SERVICES_BADGE, (int)7, (int)7);
        return image;
    }

    public Action[] getActions(boolean context) {
        return new Action[]{CommonProjectActions.newFileAction(), null, SystemAction.get(FindAction.class), null, SystemAction.get(PasteAction.class), null, SystemAction.get(ToolsAction.class)};
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private static Lookup createLookup(FileObject srcRoot) {
        Project owner = FileOwnerQuery.getOwner((FileObject)srcRoot);
        return owner != null ? Lookups.fixed((Object[])new Object[]{owner}) : null;
    }

    private void listenToServerChanges() {
        JAXWSSupport wss = JAXWSSupport.getJAXWSSupport((FileObject)this.project.getProjectDirectory());
        if (wss != null) {
            this.evaluator = wss.getAntProjectHelper().getStandardPropertyEvaluator();
            PropertyChangeListener pcl = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.evaluator);
            this.evaluator.addPropertyChangeListener(pcl);
        }
    }

    private boolean isJsr109Supported() {
        JAXWSSupport wss = JAXWSSupport.getJAXWSSupport((FileObject)this.project.getProjectDirectory());
        if (wss != null) {
            return this.isJsr109Supported(wss);
        }
        return false;
    }

    private boolean isJsr109Supported(JAXWSSupport wss) {
        J2eePlatform j2eePlatform;
        Map properties = wss.getAntProjectHelper().getStandardPropertyEvaluator().getProperties();
        String serverInstance = (String)properties.get("j2ee.server.instance");
        if (serverInstance != null && (j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstance)) != null) {
            return j2eePlatform.isToolSupported("jsr109");
        }
        return false;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        boolean newJsr109Supported;
        JAXWSSupport wss = JAXWSSupport.getJAXWSSupport((FileObject)this.project.getProjectDirectory());
        if (wss != null && wss.getServices().size() > 0 && "j2ee.server.instance".equals(evt.getPropertyName()) && this.jsr109Supported != (newJsr109Supported = this.isJsr109Supported(wss))) {
            JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
            boolean isJsr109Project = jaxWsModel.getJsr109();
            if (isJsr109Project != newJsr109Supported) {
                String msg = NbBundle.getMessage(JaxWsRootNode.class, (String)"MSG_IncompatibleWSServer");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 1));
            }
            this.jsr109Supported = newJsr109Supported;
        }
    }
}

