/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.util.Collection;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.junit.output.RegexpUtils;
import org.netbeans.modules.junit.output.Report;
import org.netbeans.modules.junit.output.TestsuiteNode;
import org.netbeans.modules.junit.wizards.Utils;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;

final class OutputUtils {
    private OutputUtils() {
    }

    static void openCallstackFrame(Node node, String frameInfo) {
        Report report = OutputUtils.getTestsuiteNode(node).getReport();
        Collection srcRoots = report.classpathSourceRoots;
        if (srcRoots == null || srcRoots.isEmpty()) {
            return;
        }
        FileObject[] srcRootsArr = new FileObject[srcRoots.size()];
        srcRoots.toArray(srcRootsArr);
        ClassPath srcClassPath = ClassPathSupport.createClassPath((FileObject[])srcRootsArr);
        int[] lineNumStorage = new int[1];
        FileObject file = OutputUtils.getFile(frameInfo, lineNumStorage, srcClassPath);
        Utils.openFile(file, lineNumStorage[0]);
    }

    private static TestsuiteNode getTestsuiteNode(Node node) {
        while (!(node instanceof TestsuiteNode)) {
            node = node.getParentNode();
        }
        return (TestsuiteNode)node;
    }

    private static FileObject getFile(String callstackLine, int[] lineNumStorage, ClassPath classPath) {
        String ending;
        String slashName;
        int lastSlashIndex;
        int lineNum;
        String fileName;
        String clsName;
        block11: {
            int bracketIndex = callstackLine.indexOf(40);
            String beforeBrackets = bracketIndex == -1 ? callstackLine : callstackLine.substring(0, bracketIndex).trim();
            String inBrackets = bracketIndex == -1 ? (String)null : callstackLine.substring(bracketIndex + 1, callstackLine.lastIndexOf(41));
            int lastDotIndex = beforeBrackets.lastIndexOf(46);
            clsName = beforeBrackets.substring(0, lastDotIndex);
            String methodName = beforeBrackets.substring(lastDotIndex + 1);
            fileName = null;
            lineNum = -1;
            if (inBrackets != null && RegexpUtils.getInstance().getLocationInFilePattern().matcher(inBrackets).matches()) {
                int ddotIndex = inBrackets.lastIndexOf(58);
                if (ddotIndex == -1) {
                    fileName = inBrackets;
                } else {
                    fileName = inBrackets.substring(0, ddotIndex);
                    try {
                        lineNum = Integer.parseInt(inBrackets.substring(ddotIndex + 1));
                        if (lineNum <= 0) {
                            lineNum = 1;
                        }
                    }
                    catch (NumberFormatException ex) {
                        if ($assertionsDisabled) break block11;
                        throw new AssertionError();
                    }
                }
            }
        }
        String clsNameSlash = clsName.replace('.', '/');
        if (fileName == null) {
            lastSlashIndex = clsNameSlash.length();
            slashName = clsNameSlash;
            ending = ".java";
        } else {
            lastSlashIndex = clsNameSlash.lastIndexOf(47);
            slashName = lastSlashIndex != -1 ? clsNameSlash.substring(0, lastSlashIndex) : clsNameSlash;
            ending = '/' + fileName;
        }
        String thePath = slashName + ending;
        FileObject file = classPath.findResource(thePath);
        while (file == null && lastSlashIndex != -1) {
            thePath = (slashName = slashName.substring(0, lastSlashIndex)) + ending;
            file = classPath.findResource(thePath);
            if (file != null) continue;
            lastSlashIndex = slashName.lastIndexOf(47, lastSlashIndex - 1);
        }
        if (file == null && fileName != null) {
            thePath = fileName;
            file = classPath.findResource(thePath);
        }
        if (file == null) {
            lineNum = -1;
        }
        lineNumStorage[0] = lineNum;
        return file;
    }
}

