/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.impl.InstancePropertiesImpl;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerException;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ServerTarget;
import org.netbeans.modules.j2ee.deployment.impl.ui.ProgressUI;
import org.netbeans.modules.j2ee.deployment.plugins.api.AntDeploymentProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.DatasourceManager;
import org.netbeans.modules.j2ee.deployment.plugins.api.FindJSPServlet;
import org.netbeans.modules.j2ee.deployment.plugins.api.IncrementalDeployment;
import org.netbeans.modules.j2ee.deployment.plugins.api.J2eePlatformFactory;
import org.netbeans.modules.j2ee.deployment.plugins.api.J2eePlatformImpl;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.j2ee.deployment.plugins.api.StartServer;
import org.netbeans.modules.j2ee.deployment.plugins.api.TargetModuleIDResolver;
import org.netbeans.modules.j2ee.deployment.plugins.api.UISupport;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerServerSettings;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerSupport;
import org.netbeans.modules.j2ee.deployment.profiler.spi.Profiler;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerInstance
implements Node.Cookie,
Comparable {
    public static final int STATE_WAITING = 1;
    public static final int STATE_STOPPED = 2;
    public static final int STATE_RUNNING = 3;
    public static final int STATE_DEBUGGING = 4;
    public static final int STATE_SUSPENDED = 5;
    public static final int STATE_PROFILING = 6;
    public static final int STATE_PROFILER_BLOCKING = 7;
    public static final int STATE_PROFILER_STARTING = 8;
    private static final int RUNNING_CHECK_TIMEOUT = 10000;
    private static final int DEBUGGING_CHECK_TIMEOUT = 10000;
    private static final long TIMEOUT = 1200000L;
    private final String url;
    private final Server server;
    private DeploymentManager manager;
    private DeploymentManager disconnectedManager;
    private IncrementalDeployment incrementalDeployment;
    private TargetModuleIDResolver tmidResolver;
    private J2eePlatform j2eePlatform;
    private J2eePlatformImpl j2eePlatformImpl;
    private StartServer startServer;
    private FindJSPServlet findJSPServlet;
    private DatasourceManager dsMgr;
    private DatasourceManager ddsMgr;
    private final Set targetsStartedByIde = new HashSet();
    private Map targets;
    private boolean managerStartedByIde = false;
    private ServerTarget coTarget = null;
    private boolean commandSucceed = false;
    private InstancePropertiesImpl instanceProperties;
    private HashMap debugInfo = new HashMap();
    private int serverState = 2;
    private List stateListeners = new ArrayList();
    private long lastCheck = 0L;
    private boolean isRunning = false;
    private static ServerInstance profiledServerInstance;
    private ProfilerServerSettings profilerSettings;
    private final DebuggerStateListener debuggerStateListener;

    public ServerInstance(Server server, String url) {
        this.server = server;
        this.url = url;
        this.instanceProperties = new InstancePropertiesImpl(url);
        this.debuggerStateListener = new DebuggerStateListener();
        DebuggerManager.getDebuggerManager().addDebuggerListener((DebuggerManagerListener)this.debuggerStateListener);
    }

    public InstancePropertiesImpl getInstanceProperties() {
        return this.instanceProperties;
    }

    public String getDisplayName() {
        return this.instanceProperties.getProperty("displayName");
    }

    public Server getServer() {
        return this.server;
    }

    public String getUrl() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentManager getDeploymentManager() {
        DeploymentManager managerTmp = null;
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            managerTmp = this.manager;
        }
        if (managerTmp != null) {
            return managerTmp;
        }
        try {
            FileObject fo = ServerRegistry.getInstanceFileObject(this.url);
            if (fo == null) {
                String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_NullInstanceFileObject", (Object)this.url);
                throw new IllegalStateException(msg);
            }
            String username = (String)fo.getAttribute("username");
            String password = (String)fo.getAttribute("password");
            managerTmp = this.server.getDeploymentManager(this.url, username, password);
            ServerInstance serverInstance2 = this;
            synchronized (serverInstance2) {
                this.manager = managerTmp;
            }
        }
        catch (DeploymentManagerCreationException e) {
            throw new RuntimeException(e);
        }
        return managerTmp;
    }

    public synchronized boolean isConnected() {
        return this.manager != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentManager getDisconnectedDeploymentManager() throws DeploymentManagerCreationException {
        DeploymentManager disconnectedManagerTmp = null;
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            disconnectedManagerTmp = this.disconnectedManager;
        }
        if (disconnectedManagerTmp != null) {
            return disconnectedManagerTmp;
        }
        FileObject fo = ServerRegistry.getInstanceFileObject(this.url);
        if (fo == null) {
            String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_NullInstanceFileObject", (Object)this.url);
            throw new IllegalStateException(msg);
        }
        disconnectedManagerTmp = this.server.getDisconnectedDeploymentManager(this.url);
        ServerInstance serverInstance2 = this;
        synchronized (serverInstance2) {
            this.disconnectedManager = disconnectedManagerTmp;
        }
        return disconnectedManagerTmp;
    }

    public J2eePlatform getJ2eePlatform() {
        return this.j2eePlatform;
    }

    public void setJ2eePlatform(J2eePlatform aJ2eePlatform) {
        this.j2eePlatform = aJ2eePlatform;
    }

    public J2eePlatformImpl getJ2eePlatformImpl() {
        J2eePlatformFactory fact;
        if (this.j2eePlatformImpl == null && (fact = this.server.getJ2eePlatformFactory()) != null) {
            try {
                this.j2eePlatformImpl = fact.getJ2eePlatformImpl(this.isConnected() ? this.getDeploymentManager() : this.getDisconnectedDeploymentManager());
            }
            catch (DeploymentManagerCreationException dmce) {
                ErrorManager.getDefault().notify((Throwable)dmce);
            }
        }
        return this.j2eePlatformImpl;
    }

    public ServerDebugInfo getServerDebugInfo(Target target) {
        assert (this.debugInfo != null);
        ServerDebugInfo sdi = null;
        if (target == null) {
            sdi = (ServerDebugInfo)this.debugInfo.get(null);
        } else {
            Iterator it = this.debugInfo.keySet().iterator();
            while (sdi == null && it.hasNext()) {
                Target t = (Target)it.next();
                if (t != target && (t == null || !t.getName().equals(target.getName()))) continue;
                sdi = (ServerDebugInfo)this.debugInfo.get(t);
            }
        }
        return sdi;
    }

    public void refresh() {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    int oldState = ServerInstance.this.getServerState();
                    ServerInstance.this.setServerState(1);
                    if (ServerInstance.this == profiledServerInstance) {
                        int profState = ProfilerSupport.getState();
                        if (profState == ProfilerSupport.STATE_STARTING) {
                            ServerInstance.this.setServerState(8);
                            return;
                        }
                        if (profState == ProfilerSupport.STATE_BLOCKING) {
                            ServerInstance.this.setServerState(7);
                            return;
                        }
                        if (profState == ProfilerSupport.STATE_PROFILING || profState == ProfilerSupport.STATE_RUNNING) {
                            ServerInstance.this.initCoTarget();
                            ServerInstance.this.setServerState(6);
                            return;
                        }
                        profiledServerInstance = null;
                    }
                    if (ServerInstance.this.isSuspended()) {
                        ServerInstance.this.setServerState(5);
                    } else if (ServerInstance.this.isDebuggable(null)) {
                        if (oldState != 5) {
                            ServerInstance.this.reset();
                        }
                        ServerInstance.this.initCoTarget();
                        ServerInstance.this.setServerState(4);
                    } else if (ServerInstance.this.isReallyRunning()) {
                        ServerInstance.this.reset();
                        ServerInstance.this.initCoTarget();
                        ServerInstance.this.setServerState(3);
                    } else {
                        ServerInstance.this.reset();
                        ServerInstance.this.setServerState(2);
                    }
                }
                finally {
                    if (ServerInstance.this.getServerState() == 1) {
                        ServerInstance.this.setServerState(2);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        DeploymentManager managerTmp = null;
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            managerTmp = this.manager;
            this.manager = null;
        }
        if (managerTmp != null) {
            managerTmp.release();
        }
        serverInstance = this;
        synchronized (serverInstance) {
            this.disconnectedManager = null;
            this.incrementalDeployment = null;
            this.tmidResolver = null;
            this.startServer = null;
            this.findJSPServlet = null;
            this.coTarget = null;
            this.targets = null;
        }
    }

    public void remove() {
        DebuggerManager.getDebuggerManager().removeDebuggerListener((DebuggerManagerListener)this.debuggerStateListener);
        this.stopIfStartedByIde();
        InputOutput io = UISupport.getServerIO(this.url);
        if (!io.isClosed()) {
            io.closeInputOutput();
        }
        ServerRegistry.getInstance().removeServerInstance(this.getUrl());
    }

    public void stopIfStartedByIde() {
        if (this.managerStartedByIde) {
            if (this.canStopDontWait()) {
                this.stopDontWait();
            } else {
                String title = NbBundle.getMessage(ServerInstance.class, (String)"LBL_ShutDownServer", (Object)this.getDisplayName());
                final ProgressUI progressUI = new ProgressUI(title, true, null);
                progressUI.start();
                RequestProcessor.getDefault().post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            Iterator it = ServerInstance.this.targetsStartedByIde.iterator();
                            while (it.hasNext()) {
                                ServerTarget serverTarget = ServerInstance.this.getServerTarget((String)it.next());
                                if (serverTarget == null) continue;
                                try {
                                    ServerInstance.this._stop(serverTarget.getTarget(), progressUI);
                                }
                                catch (ServerException ex) {
                                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                                }
                            }
                            if (ServerInstance.this.isReallyRunning() || ServerInstance.this.isSuspended()) {
                                try {
                                    ServerInstance.this._stop(progressUI);
                                }
                                catch (ServerException ex) {
                                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                                }
                            }
                        }
                        finally {
                            progressUI.finish();
                        }
                    }
                });
                progressUI.showProgressDialog();
            }
        }
    }

    public void setServerState(int newState) {
        int oldState = this.serverState;
        this.serverState = newState;
        this.fireStateChanged(oldState, newState);
    }

    public int getServerState() {
        return this.serverState;
    }

    public boolean isRemoveForbidden() {
        String removeForbid = this.instanceProperties.getProperty("removeForbidden");
        return Boolean.valueOf(removeForbid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerTarget[] getTargets() {
        Map targets = this.getTargetMap();
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            return targets.values().toArray(new ServerTarget[targets.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getTargetList() {
        Map targets = this.getTargetMap();
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            return targets.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getTargetMap() {
        HashMap<String, ServerTarget> tmpTargets = null;
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            tmpTargets = this.targets;
        }
        if (tmpTargets == null) {
            Target[] targs = null;
            StartServer startServer = this.getStartServer();
            try {
                if (!this.isRunning() && startServer != null && startServer.needsStartForTargetList()) {
                    this.start();
                }
                targs = this.getDeploymentManager().getTargets();
            }
            catch (IllegalStateException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            if (targs == null) {
                targs = new Target[]{};
            }
            tmpTargets = new HashMap<String, ServerTarget>();
            for (int i = 0; i < targs.length; ++i) {
                tmpTargets.put(targs[i].getName(), new ServerTarget(this, targs[i]));
            }
            ServerInstance serverInstance2 = this;
            synchronized (serverInstance2) {
                this.targets = tmpTargets;
            }
        }
        return tmpTargets;
    }

    public ServerTarget getServerTarget(String targetName) {
        return (ServerTarget)this.getTargetMap().get(targetName);
    }

    public Target getTarget(String targetName) {
        return this.getServerTarget(targetName).getTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StartServer getStartServer() {
        DeploymentManager dm = null;
        try {
            dm = this.getDisconnectedDeploymentManager();
        }
        catch (DeploymentManagerCreationException dmce) {
            throw new RuntimeException(dmce);
        }
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            if (this.startServer == null) {
                this.startServer = this.server.getOptionalFactory().getStartServer(dm);
            }
            return this.startServer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncrementalDeployment getIncrementalDeployment() {
        DeploymentManager dm = this.getDeploymentManager();
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            if (this.incrementalDeployment == null) {
                this.incrementalDeployment = this.server.getOptionalFactory().getIncrementalDeployment(dm);
            }
            return this.incrementalDeployment;
        }
    }

    public AntDeploymentProvider getAntDeploymentProvider() {
        try {
            return this.server.getOptionalFactory().getAntDeploymentProvider(this.getDisconnectedDeploymentManager());
        }
        catch (DeploymentManagerCreationException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetModuleIDResolver getTargetModuleIDResolver() {
        DeploymentManager dm = this.getDeploymentManager();
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            if (this.tmidResolver == null) {
                this.tmidResolver = this.server.getOptionalFactory().getTargetModuleIDResolver(dm);
            }
            return this.tmidResolver;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FindJSPServlet getFindJSPServlet() {
        DeploymentManager dm = null;
        try {
            dm = this.getDisconnectedDeploymentManager();
        }
        catch (DeploymentManagerCreationException dmce) {
            throw new RuntimeException(dmce);
        }
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            if (this.findJSPServlet == null) {
                this.findJSPServlet = this.server.getOptionalFactory().getFindJSPServlet(dm);
            }
            return this.findJSPServlet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatasourceManager getDatasourceManager() {
        DeploymentManager dm = this.getDeploymentManager();
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            if (this.dsMgr == null) {
                this.dsMgr = this.server.getOptionalFactory().getDatasourceManager(dm);
            }
            return this.dsMgr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatasourceManager getDisconnectedDatasourceManager() {
        DeploymentManager dm = null;
        try {
            dm = this.getDisconnectedDeploymentManager();
        }
        catch (DeploymentManagerCreationException dmce) {
            throw new RuntimeException(dmce);
        }
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            if (this.ddsMgr == null) {
                this.ddsMgr = this.server.getOptionalFactory().getDatasourceManager(dm);
            }
            return this.ddsMgr;
        }
    }

    public Set<Datasource> getDatasources() {
        DatasourceManager ddsMgr = this.getDisconnectedDatasourceManager();
        Set<Datasource> deployedDS = Collections.emptySet();
        if (ddsMgr != null) {
            deployedDS = ddsMgr.getDatasources();
        }
        return deployedDS;
    }

    public void deployDatasources(Set<Datasource> datasources) throws ConfigurationException, DatasourceAlreadyExistsException {
        DatasourceManager dsMgr = this.getDatasourceManager();
        if (dsMgr != null) {
            dsMgr.deployDatasources(datasources);
        }
    }

    public boolean isRunningLastCheck() {
        if (this.lastCheck > 0L) {
            return this.isRunning;
        }
        return false;
    }

    public boolean isReallyRunning() {
        return this.isRunningWithinMillis(0L);
    }

    public boolean isRunning() {
        return this.isRunningWithinMillis(2000L);
    }

    public boolean isRunningWithinMillis(long millisecs) {
        if (System.currentTimeMillis() - this.lastCheck < millisecs) {
            return this.isRunning;
        }
        final StartServer ss = this.getStartServer();
        this.isRunning = ss != null ? this.safeTrueTest(new SafeTrueTest(){

            public void run() {
                this.result = ss.isRunning();
            }
        }, 10000) : false;
        this.lastCheck = System.currentTimeMillis();
        return this.isRunning;
    }

    public boolean isDebuggable(final Target target) {
        final StartServer ss = this.getStartServer();
        if (ss != null) {
            return this.safeTrueTest(new SafeTrueTest(){

                public void run() {
                    this.result = ss.isDebuggable(target);
                }
            }, 10000);
        }
        return false;
    }

    public ConflictData anotherServerDebuggable(Target target) {
        Target t;
        ConflictData cd = null;
        StartServer thisSS = this.getStartServer();
        if (thisSS == null) {
            return null;
        }
        ServerDebugInfo thisSDI = this.getServerDebugInfo(target);
        if (thisSDI == null && (thisSDI = thisSS.getDebugInfo(t = this._retrieveTarget(target))) == null) {
            ErrorManager.getDefault().log(1, "DebuggerInfo cannot be found for: " + this.toString());
            return null;
        }
        ServerInstance[] serverInstances = ServerRegistry.getInstance().getServerInstances();
        for (int i = 0; cd == null && i < serverInstances.length; ++i) {
            Target t2;
            ServerDebugInfo sdi;
            ServerInstance si = serverInstances[i];
            if (this.url.equalsIgnoreCase(si.getUrl()) || !si.isDebuggable(null) || (sdi = si.getServerDebugInfo(t2 = si._retrieveTarget(null))) == null || !thisSDI.getTransport().equals(sdi.getTransport())) continue;
            if (thisSDI.getTransport() == "dt_socket") {
                if (!thisSDI.getHost().equalsIgnoreCase(sdi.getHost()) || thisSDI.getPort() != sdi.getPort()) continue;
                cd = new ConflictData(si, thisSDI);
                continue;
            }
            if (!thisSDI.getShmemName().equalsIgnoreCase(sdi.getShmemName())) continue;
            cd = new ConflictData(si, thisSDI);
        }
        return cd;
    }

    public boolean isSuspended() {
        Session[] sessions = DebuggerManager.getDebuggerManager().getSessions();
        Target target = this._retrieveTarget(null);
        ServerDebugInfo sdi = this.getServerDebugInfo(target);
        if (sdi == null) {
            ErrorManager.getDefault().log(1, "DebuggerInfo cannot be found for: " + this.toString());
            return false;
        }
        for (int i = 0; i < sessions.length; ++i) {
            String host;
            JPDADebugger jpda;
            Object d;
            String shmem;
            Object o;
            Session s = sessions[i];
            if (s == null || (o = s.lookupFirst(null, AttachingDICookie.class)) == null) continue;
            AttachingDICookie attCookie = (AttachingDICookie)o;
            if (!(sdi.getTransport().equals("dt_shmem") ? (shmem = attCookie.getSharedMemoryName()) != null && shmem.equalsIgnoreCase(sdi.getShmemName()) && (d = s.lookupFirst(null, JPDADebugger.class)) != null && (jpda = (JPDADebugger)d).getState() == 3 : (host = this.stripHostName(attCookie.getHostName())) != null && host.equalsIgnoreCase(this.stripHostName(sdi.getHost())) && attCookie.getPortNumber() == sdi.getPort() && (d = s.lookupFirst(null, JPDADebugger.class)) != null && (jpda = (JPDADebugger)d).getState() == 3)) continue;
            return true;
        }
        return false;
    }

    public boolean isDebugSupported() {
        StartServer ss = this.getStartServer();
        return ss.supportsStartDebugging(null);
    }

    public boolean isProfileSupported() {
        Profiler profiler = ServerRegistry.getProfiler();
        if (profiler == null) {
            return false;
        }
        StartServer ss = this.getStartServer();
        return ss.supportsStartProfiling(null);
    }

    public Set getTargetsStartedByIde() {
        HashSet<ServerTarget> ret = new HashSet<ServerTarget>();
        for (String targetName : this.targetsStartedByIde) {
            ret.add(this.getServerTarget(targetName));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ProgressUI ui) throws ServerException {
        try {
            this.setServerState(1);
            this.startTarget(null, ui);
        }
        finally {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDebug(ProgressUI ui) throws ServerException {
        try {
            this.setServerState(1);
            this.startTarget(null, ui, true);
            this._retrieveDebugInfo(null);
        }
        finally {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProfile(ProfilerServerSettings settings, boolean forceRestart, ProgressUI ui) throws ServerException {
        if (profiledServerInstance != null && profiledServerInstance != this) {
            String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_AnotherServerProfiling", (Object)profiledServerInstance.getDisplayName());
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg, 2);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) == NotifyDescriptor.CANCEL_OPTION) {
                String err = NbBundle.getMessage(ServerInstance.class, (String)"MSG_ProfilingCancelled", (Object)this.getDisplayName());
                throw new ServerException(err);
            }
        }
        try {
            this.setServerState(1);
            this.startProfileImpl(null, settings, forceRestart, ui);
        }
        finally {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(ProgressUI ui) throws ServerException {
        try {
            this.setServerState(1);
            boolean inDebug = this.isDebuggable(null);
            boolean inProfile = profiledServerInstance == this;
            boolean stopped = true;
            if (inProfile || this.isReallyRunning() || this.isSuspended()) {
                this._stop(ui);
            }
            if (stopped) {
                if (inProfile) {
                    this.startProfileImpl(null, this.profilerSettings, true, ui);
                } else if (inDebug) {
                    this.startDebugTarget(null, ui);
                } else {
                    this.startTarget(null, ui);
                }
            }
        }
        finally {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(ProgressUI ui) throws ServerException {
        try {
            this.setServerState(1);
            if (profiledServerInstance == this || this.isReallyRunning() || this.isSuspended()) {
                this._stop(ui);
            }
            this.debugInfo.clear();
        }
        finally {
            this.refresh();
        }
    }

    public DeploymentManager getDeploymentManagerForConfiguration() throws DeploymentManagerCreationException {
        StartServer ss = this.getStartServer();
        if (ss != null && ss.needsStartForConfigure()) {
            this.start();
            return this.getDeploymentManager();
        }
        return this.getDisconnectedDeploymentManager();
    }

    public void startTarget(Target target, ProgressUI ui) throws ServerException {
        this.startTarget(target, ui, false);
    }

    public void startDebugTarget(Target target, ProgressUI ui) throws ServerException {
        this.startTarget(target, ui, true);
        this._retrieveDebugInfo(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        if (SwingUtilities.isEventDispatchThread()) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    ServerInstance.this.start();
                }
            });
            return;
        }
        if (this.isRunning()) {
            return;
        }
        String title = NbBundle.getMessage(ServerInstance.class, (String)"LBL_StartServerProgressMonitor", (Object)this.getDisplayName());
        ProgressUI ui = new ProgressUI(title, false);
        try {
            ui.start();
            this.start(ui);
        }
        catch (ServerException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        finally {
            ui.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startProfile(ProfilerServerSettings settings, boolean forceRestart, Deployment.Logger logger) {
        String title = NbBundle.getMessage(ServerInstance.class, (String)"LBL_StartServerInProfileMode", (Object)this.getDisplayName());
        ProgressUI ui = new ProgressUI(title, false, logger);
        try {
            ui.start();
            this.startProfile(settings, forceRestart, ui);
            boolean bl = true;
            return bl;
        }
        catch (ServerException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            ui.finish();
        }
    }

    public void stopDontWait() {
        if (this.isReallyRunning()) {
            StartServer startServ = this.getStartServer();
            assert (startServ.canStopDeploymentManagerSilently()) : "server does not support silent stop of deployment manager";
            startServ.stopDeploymentManagerSilently();
        }
    }

    public boolean canStopDontWait() {
        StartServer startServ = this.getStartServer();
        return startServ.canStopDeploymentManagerSilently();
    }

    private void resolveServerConflict(Target target, ProgressUI ui, ConflictData cd) throws ServerException {
        ServerInstance si = cd.getServerInstance();
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ServerInstance.class, (String)"MSG_AnotherServerRunning", (Object[])new Object[]{si.getDisplayName(), cd.getServerDebugInfo().getHost(), cd.getServerDebugInfo().getTransport().equals("dt_socket") ? "socket" : "shared memory", cd.getServerDebugInfo().getTransport().equals("dt_socket") ? new Integer(cd.getServerDebugInfo().getPort()).toString() : cd.getServerDebugInfo().getShmemName()}), 3);
        nd.setOptionType(2);
        JButton yes = new JButton(NbBundle.getMessage(ServerInstance.class, (String)"MSG_AnotherServerStopYes"));
        JButton no = new JButton(NbBundle.getMessage(ServerInstance.class, (String)"MSG_AnotherServerStopNo"));
        yes.setDefaultCapable(true);
        nd.setOptions(new Object[]{yes, no});
        Object option = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        if (option != yes) {
            String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_ServerStartupCancelled", (Object)this.getDisplayName());
            throw new ServerException(msg);
        }
        if (!si.getStartServer().supportsStartDeploymentManager()) {
            String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_StartingThisServerNotSupported", (Object)this.getDisplayName());
            throw new ServerException(msg);
        }
        si.stop(ui);
    }

    private void startTarget(Target target, ProgressUI ui, boolean debugMode) throws ServerException {
        StartServer ss = this.getStartServer();
        if (ss == null) {
            ui.progress(NbBundle.getMessage(ServerInstance.class, (String)"MSG_PluginHasNoStartServerClass", (Object)this.getServer()));
            return;
        }
        if (this.isSuspended()) {
            String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_ServerSuspended", (Object)this.getServer());
            throw new ServerException(msg);
        }
        boolean canControlAdmin = ss.supportsStartDeploymentManager();
        boolean canDebug = ss.supportsStartDebugging(target);
        boolean needsRestart = ss.needsRestart(target);
        if (ss.isAlsoTargetServer(target)) {
            if (debugMode) {
                if (ss.isDebuggable(target)) {
                    if (!needsRestart) {
                        return;
                    }
                    if (!canControlAdmin || !canDebug) {
                        String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_RestartingThisServerNotSupported", (Object)this.getDisplayName());
                        throw new ServerException(msg);
                    }
                    this._stop(ui);
                } else if (this.isReallyRunning()) {
                    if (!canControlAdmin || !canDebug) {
                        String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_DebugginThisServerNotSupported", (Object)this.getDisplayName());
                        throw new ServerException(msg);
                    }
                    this._stop(ui);
                }
                if (!canDebug) {
                    String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_DebugginThisServerNotSupported", (Object)this.getDisplayName());
                    throw new ServerException(msg);
                }
                ConflictData cd = this.anotherServerDebuggable(target);
                if (cd != null) {
                    this.resolveServerConflict(target, ui, cd);
                }
                this._startDebug(target, ui);
            } else {
                if (this.isReallyRunning()) {
                    if (!needsRestart) {
                        return;
                    }
                    if (!canControlAdmin) {
                        String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_RestartingThisServerNotSupported", (Object)this.getDisplayName());
                        throw new ServerException(msg);
                    }
                    this._stop(ui);
                }
                if (!canControlAdmin) {
                    String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_StartingThisServerNotSupported", (Object)this.getDisplayName());
                    throw new ServerException(msg);
                }
                this._start(ui);
            }
        } else {
            if (!this.isReallyRunning()) {
                if (!canControlAdmin) {
                    String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_StartingThisServerNotSupported", (Object)this.getDisplayName());
                    throw new ServerException(msg);
                }
                this._start(ui);
            }
            if (debugMode) {
                if (ss.isDebuggable(target)) {
                    if (!needsRestart) {
                        return;
                    }
                    this._stop(target, ui);
                } else if (ss.isRunning(target)) {
                    this._stop(target, ui);
                }
                ConflictData cd = this.anotherServerDebuggable(target);
                if (cd != null) {
                    this.resolveServerConflict(target, ui, cd);
                }
                this._startDebug(target, ui);
            } else {
                if (ss.isRunning(target)) {
                    if (!needsRestart) {
                        return;
                    }
                    this._stop(target, ui);
                }
                this._start(target, ui);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void _start(ProgressUI ui) throws ServerException {
        String displayName = this.getDisplayName();
        ui.progress(NbBundle.getMessage(ServerInstance.class, (String)"MSG_StartingServer", (Object)displayName));
        ProgressObject po = null;
        StartProgressHandler handler = new StartProgressHandler();
        try {
            this.setCommandSucceeded(false);
            po = this.getStartServer().startDeploymentManager();
            if (ui != null) {
                ui.setProgressObject(po);
            }
            po.addProgressListener((ProgressListener)handler);
            if (ServerInstance.isProgressing(po)) {
                boolean done = this.sleep();
                if (!done) {
                    String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_StartServerTimeout", (Object)displayName);
                    throw new ServerException(msg);
                }
                if (!this.hasCommandSucceeded()) {
                    DeploymentStatus status = po.getDeploymentStatus();
                    throw new ServerException(status.getMessage());
                }
            } else if (ServerInstance.hasFailed(po)) {
                DeploymentStatus status = po.getDeploymentStatus();
                throw new ServerException(status.getMessage());
            }
            this.managerStartedByIde = true;
            this.coTarget = null;
            this.targets = null;
            this.initCoTarget();
        }
        finally {
            if (ui != null) {
                ui.setProgressObject(null);
            }
            if (po != null) {
                po.removeProgressListener((ProgressListener)handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void _startDebug(Target target, ProgressUI ui) throws ServerException {
        String displayName = this.getDisplayName();
        ui.progress(NbBundle.getMessage(ServerInstance.class, (String)"MSG_StartingDebugServer", (Object)displayName));
        ProgressObject po = null;
        StartProgressHandler handler = new StartProgressHandler();
        try {
            this.setCommandSucceeded(false);
            po = this.getStartServer().startDebugging(target);
            if (ui != null) {
                ui.setProgressObject(po);
            }
            po.addProgressListener((ProgressListener)handler);
            if (ServerInstance.isProgressing(po)) {
                boolean done = this.sleep();
                if (!done) {
                    String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_StartDebugTimeout", (Object)displayName);
                    throw new ServerException(msg);
                }
                if (!this.hasCommandSucceeded()) {
                    DeploymentStatus status = po.getDeploymentStatus();
                    throw new ServerException(status.getMessage());
                }
            } else if (ServerInstance.hasFailed(po)) {
                DeploymentStatus status = po.getDeploymentStatus();
                throw new ServerException(status.getMessage());
            }
            this.managerStartedByIde = true;
            this.coTarget = null;
            this.targets = null;
            this.initCoTarget();
        }
        finally {
            if (ui != null) {
                ui.setProgressObject(null);
            }
            if (po != null) {
                po.removeProgressListener((ProgressListener)handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void startProfileImpl(Target target, ProfilerServerSettings settings, boolean forceRestart, ProgressUI ui) throws ServerException {
        if (profiledServerInstance == this && !forceRestart && settings.equals(this.profilerSettings)) {
            return;
        }
        if (profiledServerInstance != null && profiledServerInstance != this) {
            profiledServerInstance.stop(ui);
            profiledServerInstance = null;
        }
        if (profiledServerInstance == this || this.isReallyRunning() || this.isDebuggable(target)) {
            this._stop(ui);
            this.debugInfo.clear();
            profiledServerInstance = null;
        }
        String displayName = this.getDisplayName();
        ui.progress(NbBundle.getMessage(ServerInstance.class, (String)"MSG_StartingProfileServer", (Object)displayName));
        ProgressObject po = null;
        StartProgressHandler handler = new StartProgressHandler();
        try {
            this.setCommandSucceeded(false);
            Profiler profiler = ServerRegistry.getProfiler();
            if (profiler == null) {
                String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_ProfilerNotRegistered");
                throw new ServerException(msg);
            }
            profiler.notifyStarting();
            po = this.getStartServer().startProfiling(target, settings);
            ui.setProgressObject(po);
            po.addProgressListener((ProgressListener)handler);
            if (ServerInstance.isProgressing(po)) {
                boolean done = this.sleep();
                if (!done) {
                    String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_StartProfileTimeout", (Object)displayName);
                    throw new ServerException(msg);
                }
                if (!this.hasCommandSucceeded()) {
                    DeploymentStatus status = po.getDeploymentStatus();
                    throw new ServerException(status.getMessage());
                }
            } else if (ServerInstance.hasFailed(po)) {
                DeploymentStatus status = po.getDeploymentStatus();
                throw new ServerException(status.getMessage());
            }
            profiledServerInstance = this;
            this.profilerSettings = settings;
            this.managerStartedByIde = true;
        }
        finally {
            if (ui != null) {
                ui.setProgressObject(null);
            }
            if (po != null) {
                po.removeProgressListener((ProgressListener)handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void shutdownProfiler(ProgressUI ui) throws ServerException {
        ui.progress(NbBundle.getMessage(ServerInstance.class, (String)"MSG_StoppingProfiler"));
        StartProgressHandler handler = new StartProgressHandler();
        ProgressObject po = null;
        try {
            Profiler profiler = ServerRegistry.getProfiler();
            if (profiler != null) {
                po = profiler.shutdown();
                ui.setProgressObject(po);
                po.addProgressListener((ProgressListener)handler);
                if (ServerInstance.isProgressing(po)) {
                    boolean done = this.sleep();
                    if (!done) {
                        String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_ProfilerShutdownTimeout");
                        throw new ServerException(msg);
                    }
                    if (!this.hasCommandSucceeded()) {
                        DeploymentStatus status = po.getDeploymentStatus();
                        throw new ServerException(status.getMessage());
                    }
                } else if (ServerInstance.hasFailed(po)) {
                    DeploymentStatus status = po.getDeploymentStatus();
                    throw new ServerException(status.getMessage());
                }
            }
        }
        finally {
            if (ui != null) {
                ui.setProgressObject(null);
            }
            if (po != null) {
                po.removeProgressListener((ProgressListener)handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void _stop(ProgressUI ui) throws ServerException {
        if (profiledServerInstance == this) {
            this.shutdownProfiler(ui);
            profiledServerInstance = null;
        }
        if (this.isSuspended()) {
            Target target = this._retrieveTarget(null);
            ServerDebugInfo sdi = this.getServerDebugInfo(target);
            Session[] sessions = DebuggerManager.getDebuggerManager().getSessions();
            for (int i = 0; i < sessions.length; ++i) {
                AttachingDICookie attCookie;
                Session s = sessions[i];
                if (s == null || (attCookie = (AttachingDICookie)s.lookupFirst(null, AttachingDICookie.class)) == null) continue;
                if (sdi.getTransport().equals("dt_shmem")) {
                    String shmem = attCookie.getSharedMemoryName();
                    if (shmem == null || !shmem.equalsIgnoreCase(sdi.getShmemName())) continue;
                    s.kill();
                    continue;
                }
                String host = this.stripHostName(attCookie.getHostName());
                if (host == null || !host.equalsIgnoreCase(this.stripHostName(sdi.getHost())) || attCookie.getPortNumber() != sdi.getPort()) continue;
                s.kill();
            }
        }
        String displayName = this.getDisplayName();
        ui.progress(NbBundle.getMessage(ServerInstance.class, (String)"MSG_StoppingServer", (Object)displayName));
        StartProgressHandler handler = new StartProgressHandler();
        ProgressObject po = null;
        try {
            this.setCommandSucceeded(false);
            po = this.getStartServer().stopDeploymentManager();
            ui.setProgressObject(po);
            po.addProgressListener((ProgressListener)handler);
            if (ServerInstance.isProgressing(po)) {
                boolean done = this.sleep();
                if (!done) {
                    String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_StopServerTimeout", (Object)displayName);
                    throw new ServerException(msg);
                }
                if (!this.hasCommandSucceeded()) {
                    DeploymentStatus status = po.getDeploymentStatus();
                    throw new ServerException(status.getMessage());
                }
            } else if (ServerInstance.hasFailed(po)) {
                DeploymentStatus status = po.getDeploymentStatus();
                throw new ServerException(status.getMessage());
            }
            this.managerStartedByIde = false;
            this.reset();
        }
        finally {
            if (ui != null) {
                ui.setProgressObject(null);
            }
            if (po != null) {
                po.removeProgressListener((ProgressListener)handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _start(Target target, ProgressUI ui) throws ServerException {
        ServerTarget serverTarget = this.getServerTarget(target.getName());
        if (serverTarget.isRunning()) {
            return;
        }
        String displayName = target.getName();
        ui.progress(NbBundle.getMessage(ServerInstance.class, (String)"MSG_StartingServer", (Object)displayName));
        StartProgressHandler handler = new StartProgressHandler();
        ProgressObject po = null;
        try {
            this.setCommandSucceeded(false);
            po = serverTarget.start();
            if (ui != null) {
                ui.setProgressObject(po);
            }
            po.addProgressListener((ProgressListener)handler);
            if (ServerInstance.isProgressing(po)) {
                boolean done = this.sleep();
                if (!done) {
                    String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_StartServerTimeout", (Object)displayName);
                    throw new ServerException(msg);
                }
                if (!this.hasCommandSucceeded()) {
                    DeploymentStatus status = po.getDeploymentStatus();
                    throw new ServerException(status.getMessage());
                }
            } else if (ServerInstance.hasFailed(po)) {
                DeploymentStatus status = po.getDeploymentStatus();
                throw new ServerException(status.getMessage());
            }
            this.targetsStartedByIde.add(serverTarget.getName());
        }
        finally {
            if (ui != null) {
                ui.setProgressObject(null);
            }
            if (po != null) {
                po.removeProgressListener((ProgressListener)handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _stop(Target target, ProgressUI ui) throws ServerException {
        ServerTarget serverTarget = this.getServerTarget(target.getName());
        if (serverTarget.isRunning()) {
            return;
        }
        String displayName = target.getName();
        ui.progress(NbBundle.getMessage(ServerInstance.class, (String)"MSG_StoppingServer", (Object)displayName));
        StartProgressHandler handler = new StartProgressHandler();
        ProgressObject po = null;
        try {
            this.setCommandSucceeded(false);
            po = serverTarget.stop();
            if (ui != null) {
                ui.setProgressObject(po);
            }
            po.addProgressListener((ProgressListener)handler);
            if (ServerInstance.isProgressing(po)) {
                boolean done = this.sleep();
                if (!done) {
                    String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_StopServerTimeout", (Object)displayName);
                    throw new ServerException(msg);
                }
                if (!this.hasCommandSucceeded()) {
                    DeploymentStatus status = po.getDeploymentStatus();
                    throw new ServerException(status.getMessage());
                }
            } else if (ServerInstance.hasFailed(po)) {
                DeploymentStatus status = po.getDeploymentStatus();
                throw new ServerException(status.getMessage());
            }
            this.targetsStartedByIde.remove(serverTarget.getName());
        }
        finally {
            if (ui != null) {
                ui.setProgressObject(null);
            }
            if (po != null) {
                po.removeProgressListener((ProgressListener)handler);
            }
        }
    }

    public boolean canStartServer() {
        return this.getStartServer() != null && this.getStartServer().supportsStartDeploymentManager();
    }

    private synchronized void wakeUp() {
        this.notify();
    }

    private synchronized boolean sleep() {
        try {
            long t0 = System.currentTimeMillis();
            this.wait(1200000L);
            return System.currentTimeMillis() - t0 < 1200000L;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isManagerOf(Target target) {
        return this.getTargetMap().keySet().contains(target.getName());
    }

    public synchronized ServerTarget getCoTarget() {
        return this.coTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCoTarget() {
        ServerTarget[] childs = this.getTargets();
        for (int i = 0; i < childs.length; ++i) {
            if (!this.getStartServer().isAlsoTargetServer(childs[i].getTarget())) continue;
            ServerInstance serverInstance = this;
            synchronized (serverInstance) {
                this.coTarget = childs[i];
                continue;
            }
        }
    }

    public boolean isDefault() {
        return this.url.equals(ServerRegistry.getInstance().getDefaultInstance().getUrl());
    }

    public String toString() {
        return this.getDisplayName();
    }

    public static boolean isProgressing(ProgressObject po) {
        StateType state = po.getDeploymentStatus().getState();
        return state == StateType.RUNNING || state == StateType.RELEASED;
    }

    public static boolean hasFailed(ProgressObject po) {
        StateType state = po.getDeploymentStatus().getState();
        return state == StateType.FAILED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStateListener(StateListener sl) {
        List list = this.stateListeners;
        synchronized (list) {
            this.stateListeners.add(sl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStateListener(StateListener sl) {
        List list = this.stateListeners;
        synchronized (list) {
            this.stateListeners.remove(sl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStateChanged(int oldState, int newState) {
        StateListener[] listeners;
        List list = this.stateListeners;
        synchronized (list) {
            listeners = this.stateListeners.toArray(new StateListener[this.stateListeners.size()]);
        }
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].stateChanged(oldState, newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean safeTrueTest(SafeTrueTest test, int timeout) {
        try {
            new RequestProcessor().post((Runnable)test).waitFinished((long)timeout);
        }
        catch (InterruptedException ie) {
            ErrorManager.getDefault().notify((Throwable)ie);
        }
        finally {
            return test.result();
        }
    }

    private synchronized boolean hasCommandSucceeded() {
        return this.commandSucceed;
    }

    private synchronized void setCommandSucceeded(boolean val) {
        this.commandSucceed = val;
    }

    private ServerDebugInfo _retrieveDebugInfo(Target target) {
        StartServer ss = this.getStartServer();
        if (ss == null) {
            return null;
        }
        Target t = this._retrieveTarget(target);
        ServerDebugInfo sdi = ss.getDebugInfo(t);
        if (sdi != null || t != null) {
            this.debugInfo.remove(t);
            this.debugInfo.put(t, sdi);
        }
        return sdi;
    }

    private Target _retrieveTarget(Target target) {
        StartServer ss = this.getStartServer();
        if (ss == null) {
            return null;
        }
        Target t = null;
        if (!this.isReallyRunning() && ss.needsStartForTargetList()) {
            if (t == null) {
                Iterator it = this.debugInfo.keySet().iterator();
                while (t == null && it.hasNext()) {
                    Target cachedTarget = (Target)it.next();
                    if (!ss.isAlsoTargetServer(cachedTarget)) continue;
                    t = cachedTarget;
                }
            } else if (ss.isAlsoTargetServer(target)) {
                t = target;
            }
        } else {
            ServerTarget[] targets = this.getTargets();
            for (int i = 0; t == null && i < targets.length; ++i) {
                if (!ss.isAlsoTargetServer(targets[i].getTarget())) continue;
                t = targets[i].getTarget();
            }
            if (t == null && targets.length > 0) {
                t = targets[0].getTarget();
            }
        }
        return t;
    }

    public int compareTo(Object other) {
        if (!(other instanceof ServerInstance)) {
            throw new IllegalArgumentException();
        }
        return this.getDisplayName().compareTo(((ServerInstance)other).getDisplayName());
    }

    private String stripHostName(String host) {
        if (host == null) {
            return null;
        }
        int idx = host.indexOf(46);
        return idx != -1 ? host.substring(0, idx) : host;
    }

    private class DebuggerStateListener
    extends DebuggerManagerAdapter {
        private RequestProcessor.Task refreshTask;

        private DebuggerStateListener() {
        }

        public void sessionAdded(Session session) {
            Target target = ServerInstance.this._retrieveTarget(null);
            ServerDebugInfo sdi = ServerInstance.this.getServerDebugInfo(target);
            if (sdi == null) {
                ErrorManager.getDefault().log(1, "DebuggerInfo cannot be found for: " + ServerInstance.this);
                return;
            }
            AttachingDICookie attCookie = (AttachingDICookie)session.lookupFirst(null, AttachingDICookie.class);
            if (attCookie == null) {
                ErrorManager.getDefault().log(1, "AttachingDICookie cannot be found for: " + ServerInstance.this);
                return;
            }
            if ("dt_shmem".equals(sdi.getTransport())) {
                String shmem = attCookie.getSharedMemoryName();
                if (shmem != null && shmem.equalsIgnoreCase(sdi.getShmemName())) {
                    this.registerListener(session);
                }
            } else {
                String host = ServerInstance.this.stripHostName(attCookie.getHostName());
                if (host != null && host.equalsIgnoreCase(ServerInstance.this.stripHostName(sdi.getHost())) && attCookie.getPortNumber() == sdi.getPort()) {
                    this.registerListener(session);
                }
            }
        }

        public synchronized void sessionRemoved(Session session) {
            this.refreshTask = null;
        }

        private void registerListener(Session session) {
            final JPDADebugger jpda = (JPDADebugger)session.lookupFirst(null, JPDADebugger.class);
            if (jpda != null) {
                jpda.addPropertyChangeListener("state", new PropertyChangeListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void propertyChange(PropertyChangeEvent evt) {
                        RequestProcessor.Task task;
                        DebuggerStateListener debuggerStateListener = DebuggerStateListener.this;
                        synchronized (debuggerStateListener) {
                            if (DebuggerStateListener.this.refreshTask == null) {
                                DebuggerStateListener.this.refreshTask = RequestProcessor.getDefault().create(new Runnable(){

                                    public void run() {
                                        if (jpda.getState() == 3) {
                                            ServerInstance.this.setServerState(5);
                                        } else {
                                            ServerInstance.this.setServerState(4);
                                        }
                                    }
                                });
                            }
                            task = DebuggerStateListener.this.refreshTask;
                        }
                        task.schedule(500);
                    }
                });
            }
        }
    }

    private static abstract class SafeTrueTest
    implements Runnable {
        protected boolean result = false;

        private SafeTrueTest() {
        }

        public abstract void run();

        public final boolean result() {
            return this.result;
        }
    }

    private static class ConflictData {
        private ServerInstance si;
        private ServerDebugInfo sdi;

        public ConflictData(ServerInstance si, ServerDebugInfo sdi) {
            this.si = si;
            this.sdi = sdi;
        }

        public ServerInstance getServerInstance() {
            return this.si;
        }

        public ServerDebugInfo getServerDebugInfo() {
            return this.sdi;
        }
    }

    public static interface StateListener {
        public void stateChanged(int var1, int var2);
    }

    private class StartProgressHandler
    implements ProgressListener {
        Boolean completed = null;

        public void handleProgressEvent(ProgressEvent progressEvent) {
            if (this.completed != null) {
                return;
            }
            DeploymentStatus status = progressEvent.getDeploymentStatus();
            if (status.isCompleted()) {
                this.completed = Boolean.TRUE;
                ServerInstance.this.setCommandSucceeded(true);
                ServerInstance.this.wakeUp();
            } else if (status.isFailed()) {
                this.completed = Boolean.FALSE;
                ServerInstance.this.wakeUp();
            }
        }

        public boolean isCompleted() {
            if (this.completed == null) {
                return false;
            }
            return this.completed;
        }
    }
}

