/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.plugins.api;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import org.netbeans.modules.j2ee.deployment.impl.InstancePropertiesImpl;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceCreationException;

public abstract class InstanceProperties {
    public static final String URL_ATTR = "url";
    public static final String USERNAME_ATTR = "username";
    public static final String PASSWORD_ATTR = "password";
    public static final String DISPLAY_NAME_ATTR = "displayName";
    public static final String REMOVE_FORBIDDEN = "removeForbidden";
    public static final String HTTP_PORT_NUMBER = "httpportnumber";
    private List changeListeners = Collections.synchronizedList(new LinkedList());

    public static InstanceProperties getInstanceProperties(String url) {
        ServerInstance inst = ServerRegistry.getInstance().getServerInstance(url);
        if (inst == null) {
            return null;
        }
        return inst.getInstanceProperties();
    }

    public static InstanceProperties createInstanceProperties(String url, String username, String password) throws InstanceCreationException {
        return InstanceProperties.createInstanceProperties(url, username, password, null);
    }

    public static InstanceProperties createInstanceProperties(String url, String username, String password, String displayName) throws InstanceCreationException {
        ServerRegistry registry = ServerRegistry.getInstance();
        registry.addInstance(url, username, password, displayName);
        ServerInstance inst = registry.getServerInstance(url);
        InstancePropertiesImpl ip = inst.getInstanceProperties();
        return ip;
    }

    public static String[] getInstanceList() {
        return ServerRegistry.getInstance().getInstanceURLs();
    }

    public static InstanceProperties getDefaultInstance() {
        return new InstancePropertiesImpl(ServerRegistry.getInstance().getDefaultInstance().getServerInstance());
    }

    public abstract void setProperties(Properties var1) throws IllegalStateException;

    public abstract void setProperty(String var1, String var2) throws IllegalStateException;

    public abstract String getProperty(String var1) throws IllegalStateException;

    public abstract Enumeration propertyNames() throws IllegalStateException;

    public abstract boolean isDefaultInstance();

    public abstract DeploymentManager getDeploymentManager();

    public abstract Target getDefaultTarget();

    public abstract void setAsDefaultServer(String var1);

    public abstract void refreshServerInstance();

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firePropertyChange(PropertyChangeEvent evt) {
        ArrayList cloned = null;
        InstanceProperties instanceProperties = this;
        synchronized (instanceProperties) {
            if (this.changeListeners != null) {
                cloned = new ArrayList();
                cloned.addAll(this.changeListeners);
            }
        }
        if (cloned != null) {
            Iterator i = cloned.iterator();
            while (i.hasNext()) {
                ((PropertyChangeListener)i.next()).propertyChange(evt);
            }
        }
    }
}

