/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.text.AbstractDocument;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.GlyphGutter;
import org.netbeans.editor.PopupManager;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.view.spi.LockView;

public class FoldingToolTip
extends JPanel {
    View view;
    EditorUI editorUI;
    public static final int BORDER_WIDTH = 2;

    public FoldingToolTip(View view, EditorUI editorUI) {
        this.view = view;
        this.editorUI = editorUI;
        Coloring defColoring = editorUI.getColoring("default");
        Color foreColor = defColoring != null ? defColoring.getForeColor() : null;
        this.setBorder(new LineBorder(foreColor == null ? Color.BLACK : foreColor));
        this.setOpaque(true);
    }

    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public void setSize(int width, int height) {
        int viewHeight = (int)this.view.getPreferredSpan(1);
        int viewWidth = (int)this.view.getPreferredSpan(0);
        if (height < 30) {
            this.putClientProperty(PopupManager.Placement.class, null);
        } else {
            height = Math.min(height, viewHeight);
        }
        width = Math.min(width, viewWidth);
        super.setSize(width, height += 4);
    }

    private void updateRenderingHints(Graphics g) {
        Map renderingHints;
        JTextComponent comp = this.editorUI.getComponent();
        if (comp == null) {
            return;
        }
        Object value = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (value == null) {
            value = Settings.getValue(Utilities.getKitClass(comp), "rendering-hints");
        }
        Map map = renderingHints = value instanceof Map ? value : null;
        if (renderingHints != null) {
            ((Graphics2D)g).setRenderingHints(renderingHints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void paintComponent(Graphics g) {
        this.updateRenderingHints(g);
        Rectangle shape = new Rectangle(this.getSize());
        Rectangle clip = g.getClipBounds();
        Coloring defaultColoring = this.editorUI.getColoring("default");
        if (defaultColoring != null && defaultColoring.getBackColor() != null) {
            g.setColor(defaultColoring.getBackColor());
        } else {
            g.setColor(SettingsDefaults.defaultBackColor);
        }
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        g.translate(2, 2);
        JTextComponent component = this.editorUI.getComponent();
        if (component == null) {
            return;
        }
        int sideBarWidth = this.editorUI.getSideBarWidth();
        GlyphGutter gg = this.editorUI.getGlyphGutter();
        if (gg != null) {
            block18: {
                View docView = null;
                if (this.view.getViewCount() == 1) {
                    docView = this.view.getView(0);
                }
                int y = 0;
                if (docView != null) {
                    AbstractDocument doc = (AbstractDocument)docView.getDocument();
                    doc.readLock();
                    try {
                        LockView lockView = LockView.get(docView);
                        if (lockView == null) break block18;
                        lockView.lock();
                        try {
                            for (int i = 0; i < docView.getViewCount(); y += this.editorUI.getLineHeight(), ++i) {
                                gg.paintGutterForView(g, docView.getView(i), y);
                            }
                            break block18;
                        }
                        finally {
                            lockView.unlock();
                        }
                    }
                    finally {
                        doc.readUnlock();
                    }
                }
                gg.paintGutterForView(g, this.view, 0);
            }
            g.translate(sideBarWidth, 0);
        }
        this.view.paint(g, shape);
        if (gg != null) {
            g.translate(-sideBarWidth, 0);
        }
        g.translate(-2, -2);
        if (defaultColoring != null && defaultColoring.getBackColor() != null) {
            g.setColor(defaultColoring.getBackColor());
        } else {
            g.setColor(SettingsDefaults.defaultBackColor);
        }
        int i = 1;
        while (i <= 2) {
            g.drawRect(clip.x + i, clip.y + i, clip.width - i * 2 - 1, clip.height - i * 2 - 1);
            ++i;
        }
        return;
    }
}

