/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.checkout;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class ProjectUtilities {
    private static final String ProjectTab_ID_LOGICAL = "projectTabLogical_tc";
    private static final String NEW_PROJECT_ACTION = "Actions/Project/org-netbeans-modules-project-ui-NewProject.instance";
    private static final String INITIAL_SOURCE_ROOT = "EXISTING_SOURCES_CURRENT_DIRECTORY";

    ProjectUtilities() {
    }

    public static void selectAndExpandProject(final Project p) {
        SwingUtilities.invokeLater(new Runnable(){
            final ExplorerManager.Provider ptLogial = ProjectUtilities.access$000("projectTabLogical_tc");

            public void run() {
                Node root = this.ptLogial.getExplorerManager().getRootContext();
                Node projNode = root.getChildren().findChild(ProjectUtils.getInformation((Project)p).getName());
                if (projNode != null) {
                    try {
                        this.ptLogial.getExplorerManager().setSelectedNodes(new Node[]{projNode});
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private static synchronized ExplorerManager.Provider findDefault(String tcID) {
        TopComponent tc = WindowManager.getDefault().findTopComponent(tcID);
        return (ExplorerManager.Provider)tc;
    }

    public static void newProjectWizard(File workingDirectory) {
        Action action = CommonProjectActions.newProjectAction();
        if (action != null) {
            File original = ProjectChooser.getProjectsFolder();
            ProjectChooser.setProjectsFolder((File)workingDirectory);
            FileObject workingFolder = FileUtil.toFileObject((File)workingDirectory);
            action.putValue("existingSourcesFolder", workingFolder);
            ProjectUtilities.performAction(action);
            ProjectChooser.setProjectsFolder((File)original);
        }
    }

    public static List scanForProjects(FileObject scanRoot) {
        return ProjectUtilities.scanForProjectsRecursively(scanRoot, 5);
    }

    private static List scanForProjectsRecursively(FileObject scanRoot, int deep) {
        if (deep <= 0) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<Project> projects = new LinkedList<Project>();
        ProjectManager projectManager = ProjectManager.getDefault();
        if (scanRoot.isFolder() && projectManager.isProject(scanRoot)) {
            try {
                Project prj = projectManager.findProject(scanRoot);
                projects.add(prj);
            }
            catch (IOException e) {
                ErrorManager.getDefault().annotate((Throwable)e, "CVS.PU: ignoring suspicious project folder...");
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        Enumeration en = scanRoot.getChildren(false);
        while (en.hasMoreElements()) {
            FileObject fo = (FileObject)en.nextElement();
            if (!fo.isFolder()) continue;
            List nested = ProjectUtilities.scanForProjectsRecursively(fo, deep - 1);
            projects.addAll(nested);
        }
        return projects;
    }

    private static Action findAction(String key) {
        FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource(key);
        if (fo != null && fo.isValid()) {
            try {
                Object instance;
                DataObject dob = DataObject.find((FileObject)fo);
                InstanceCookie ic = (InstanceCookie)dob.getCookie(InstanceCookie.class);
                if (ic != null && (instance = ic.instanceCreate()) instanceof Action) {
                    Action a = (Action)instance;
                    a.putValue("PRESELECT_CATEGORY", "General");
                    a.putValue("PRESELECT_TEMPLATE", null);
                    return a;
                }
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(16, (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private static boolean performAction(Action a) {
        if (a == null) {
            return false;
        }
        ActionEvent ae = new ActionEvent(ProjectUtilities.class, 1001, "command");
        try {
            a.actionPerformed(ae);
            return true;
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(16, (Throwable)e);
            return false;
        }
    }

    static /* synthetic */ ExplorerManager.Provider access$000(String x0) {
        return ProjectUtilities.findDefault(x0);
    }
}

