/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.palette.items;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFConfigDataObject;
import org.netbeans.modules.web.jsf.JSFConfigUtilities;
import org.netbeans.modules.web.jsf.config.model.FacesConfig;
import org.netbeans.modules.web.jsf.config.model.ManagedBean;
import org.netbeans.modules.web.jsf.palette.JSFPaletteUtilities;
import org.netbeans.modules.web.jsf.palette.items.JsfForm;
import org.netbeans.modules.web.jsf.palette.items.JsfTableCustomizer;
import org.netbeans.modules.web.jsf.wizards.JSFClinetGenerator;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.ActiveEditorDrop;

public class JsfTable
implements ActiveEditorDrop {
    private static String[] BEGIN = new String[]{"<h:form>\n <h:dataTable value=\"#'{'{0}'}'\" var=\"item\">\n", "<h:form>\n <h1><h:outputText value=\"List\"/></h1>\n <h:dataTable value=\"#'{'{0}'}'\" var=\"item\">\n"};
    private static String[] END = new String[]{"</h:dataTable>\n </h:form>\n", "</h:dataTable>\n </h:form>\n"};
    private static String[] ITEM = new String[]{"", "<h:column>\n <f:facet name=\"header\">\n <h:outputText value=\"{0}\"/>\n </f:facet>\n <h:outputText value=\"#'{'item.{2}'}'\"/>\n</h:column>\n", "<h:column>\n <f:facet name=\"header\">\n <h:outputText value=\"{0}\"/>\n </f:facet>\n <h:outputText value=\"#'{'item.{2}'}'\">\n <f:convertDateTime type=\"{3}\" pattern=\"{4}\" />\n</h:outputText>\n</h:column>\n", "<h:column>\n <f:facet name=\"header\">\n <h:outputText value=\"{0}\"/>\n </f:facet>\n<h:commandLink action=\"#'{'{4}'}'\" value=\"#'{'item.{2}'}'\"/>\n </h:column>\n"};
    private String variable = "";
    private String bean = "";
    private int formType = 0;
    private ArrayList managedBeans;

    public boolean handleTransfer(JTextComponent targetComponent) {
        JsfTableCustomizer c = new JsfTableCustomizer(this, targetComponent);
        boolean accept = c.showDialog();
        if (accept) {
            try {
                Caret caret = targetComponent.getCaret();
                int p0 = Math.min(caret.getDot(), caret.getMark());
                int p1 = Math.max(caret.getDot(), caret.getMark());
                int len = targetComponent.getDocument().getLength() - p1;
                boolean containsFView = targetComponent.getText(0, p0).contains("<f:view>") && targetComponent.getText(p1, len).contains("</f:view>");
                String body = this.createBody(targetComponent, !containsFView);
                JSFPaletteUtilities.insert(body, targetComponent);
            }
            catch (BadLocationException ble) {
                accept = false;
            }
        }
        return accept;
    }

    private String createBody(JTextComponent target, boolean surroundWithFView) {
        StringBuffer sb = new StringBuffer();
        if (surroundWithFView) {
            sb.append("<f:view>\n");
        }
        sb.append(MessageFormat.format(BEGIN[this.formType], this.variable));
        JavaClass jc = JsfForm.resolveJavaClass(target, this.bean);
        if (jc != null) {
            JsfTable.createTable(jc, this.variable, sb, "", null);
        }
        sb.append(END[this.formType]);
        if (surroundWithFView) {
            sb.append("</f:view>\n");
        }
        return sb.toString();
    }

    public static void createTable(JavaClass bean, String variable, StringBuffer sb, String commands, String setupDetail) {
        int formType = 1;
        Method[] methods = JsfForm.getEntityMethods(bean);
        boolean fieldAccess = JsfForm.isFieldAccess(bean);
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().startsWith("get")) continue;
            int isRelationship = JsfForm.isRelationship(methods[i], fieldAccess);
            String name = methods[i].getName().substring(3);
            String propName = name.substring(0, 1).toLowerCase() + name.substring(1);
            if (setupDetail != null && JsfForm.isId(methods[i], fieldAccess)) {
                String managedBeanName = JSFClinetGenerator.getManagedBeanName(JSFClinetGenerator.simpleClassName(bean.getName()));
                sb.append(MessageFormat.format(ITEM[3], name, variable, propName, propName, managedBeanName + "." + setupDetail));
                continue;
            }
            if ("java.util.Date".equals(methods[i].getType().getName())) {
                String temporal = JsfForm.getTemporal(methods[i], fieldAccess);
                if (temporal == null) {
                    sb.append(MessageFormat.format(ITEM[formType], name, variable, propName));
                    continue;
                }
                sb.append(MessageFormat.format(ITEM[2], name, variable, propName, temporal, JsfForm.getDateTimeFormat(temporal)));
                continue;
            }
            if (isRelationship != 0 && isRelationship != 1) continue;
            sb.append(MessageFormat.format(ITEM[formType], name, variable, propName));
        }
        sb.append(MessageFormat.format(commands, "item"));
    }

    public ManagedBean[] getManagedBeanNames(JTextComponent target) {
        this.managedBeans = new ArrayList();
        FileObject f = JsfForm.getFO(target);
        if (f != null) {
            WebModule wm = WebModule.getWebModule((FileObject)f);
            String[] configFiles = JSFConfigUtilities.getConfigFiles(wm.getDeploymentDescriptor());
            for (int i = 0; i < configFiles.length; ++i) {
                FileObject fo = wm.getDocumentBase().getFileObject(configFiles[i]);
                try {
                    JSFConfigDataObject configDO = (JSFConfigDataObject)DataObject.find((FileObject)fo);
                    FacesConfig config = configDO.getFacesConfig();
                    this.managedBeans.addAll(Arrays.asList(config.getManagedBean()));
                    continue;
                }
                catch (IOException ioex) {
                    ErrorManager.getDefault().notify((Throwable)ioex);
                }
            }
        }
        return this.managedBeans.toArray(new ManagedBean[this.managedBeans.size()]);
    }

    public String[] getMethodsForBean(ManagedBean bean, JTextComponent target) {
        JavaClass cls;
        JavaClass javaClass = cls = bean == null ? null : JMIUtils.findClass((String)bean.getManagedBeanClass(), (FileObject)JsfForm.getFO(target));
        if (cls == null) {
            return new String[0];
        }
        Method[] m = JMIUtils.getMethods((JavaClass)cls);
        String[] names = new String[m.length];
        for (int i = 0; i < m.length; ++i) {
            names[i] = m[i].getName();
        }
        return names;
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public String getBean() {
        return this.bean;
    }

    public void setBean(String collection) {
        this.bean = collection;
    }

    public int getFormType() {
        return this.formType;
    }

    public void setFormType(int formType) {
        this.formType = formType;
    }
}

