/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.refactoring;

import java.util.List;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImpl;
import org.netbeans.modules.web.jsf.refactoring.Occurrences;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;

public class JSFRenamePlugin
implements RefactoringPlugin {
    private static ThreadLocal semafor = new ThreadLocal();
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.web.jsf.refactoring");
    private final RenameRefactoring refactoring;

    public JSFRenamePlugin(RenameRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public Problem preCheck() {
        err.log("preCheck() called.");
        return null;
    }

    public Problem checkParameters() {
        err.log("checkParameters() called.");
        return null;
    }

    public Problem fastCheckParameters() {
        err.log("fastCheckParameters() called.");
        return null;
    }

    public void cancelRequest() {
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        if (semafor.get() == null) {
            semafor.set(new Object());
            Object element = this.refactoring.getRefactoredObject();
            err.log("Prepare refactoring: " + element);
            if (element instanceof JavaClass) {
                JavaClass jclass = (JavaClass)element;
                String newType = JSFRenamePlugin.renameClass(jclass.getName(), this.refactoring.getNewName());
                List<Occurrences.OccurrenceItem> items = Occurrences.getAllOccurrences(jclass, newType);
                for (Occurrences.OccurrenceItem item : items) {
                    refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new JSFConfigRenameClassElement(item));
                }
            }
            semafor.set(null);
        }
        return null;
    }

    private static boolean isEmpty(String str) {
        return str == null || "".equals(str.trim());
    }

    private static String renameClass(String originalFullyQualifiedName, String newName) {
        if (JSFRenamePlugin.isEmpty(originalFullyQualifiedName) || JSFRenamePlugin.isEmpty(newName)) {
            throw new IllegalArgumentException("Old and new name of the class must be given.");
        }
        int lastDot = originalFullyQualifiedName.lastIndexOf(46);
        if (lastDot <= 0) {
            return newName;
        }
        return originalFullyQualifiedName.substring(0, lastDot + 1) + newName;
    }

    public static class JSFConfigRenameClassElement
    extends SimpleRefactoringElementImpl
    implements ExternalChange {
        private Occurrences.OccurrenceItem item;

        JSFConfigRenameClassElement(Occurrences.OccurrenceItem item) {
            this.item = item;
        }

        public String getText() {
            return this.getDisplayText();
        }

        public String getDisplayText() {
            return this.item.getRenameMessage();
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            this.item.performRename();
        }

        public void undoExternalChange() {
            this.item.undoRename();
        }

        public Element getJavaElement() {
            return null;
        }

        public FileObject getParentFile() {
            return this.item.getConfigDO().getPrimaryFile();
        }

        public PositionBounds getPosition() {
            return this.item.getClassDefinitionPosition();
        }
    }
}

