/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.TabListPopupAction;
import org.netbeans.swing.tabcontrol.plaf.BasicScrollingTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.MetalEditorTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabCellRenderer;

public final class MetalEditorTabDisplayerUI
extends BasicScrollingTabDisplayerUI {
    private Rectangle scratch = new Rectangle();
    private static final int ICON_WIDTH = 11;
    private static final int ICON_HEIGHT = 11;
    private static final int[] xpoints = new int[20];
    private static final int[] ypoints = new int[20];

    public MetalEditorTabDisplayerUI(TabDisplayer displayer) {
        super(displayer);
    }

    protected TabCellRenderer createDefaultRenderer() {
        return new MetalEditorTabCellRenderer();
    }

    public static ComponentUI createUI(JComponent c) {
        return new MetalEditorTabDisplayerUI((TabDisplayer)c);
    }

    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(80, 28);
    }

    public Dimension getPreferredSize(JComponent c) {
        int prefHeight = 28;
        Graphics2D g = BasicScrollingTabDisplayerUI.getOffscreenGraphics();
        if (g != null) {
            FontMetrics fm = g.getFontMetrics(this.displayer.getFont());
            Insets ins = this.getTabAreaInsets();
            prefHeight = fm.getHeight() + ins.top + ins.bottom + 9;
        }
        return new Dimension(this.displayer.getWidth(), prefHeight);
    }

    protected int createRepaintPolicy() {
        return 164;
    }

    public Insets getTabAreaInsets() {
        return new Insets(0, 0, 4, 57);
    }

    public void install() {
        super.install();
        this.displayer.setBackground(UIManager.getColor("control"));
    }

    protected void paintAfterTabs(Graphics g) {
        Rectangle r = new Rectangle();
        this.getTabsVisibleArea(r);
        r.width = this.displayer.getWidth();
        g.setColor(this.displayer.isActive() ? this.defaultRenderer.getSelectedActivatedBackground() : this.defaultRenderer.getSelectedBackground());
        Insets ins = this.getTabAreaInsets();
        g.fillRect(r.x, r.y + r.height, r.x + r.width, this.displayer.getHeight() - (r.y + r.height));
        g.setColor(UIManager.getColor("controlHighlight"));
        int selEnd = 0;
        int i = this.selectionModel.getSelectedIndex();
        if (i != -1) {
            this.getTabRect(i, this.scratch);
            if (this.scratch.width != 0) {
                if (r.x < this.scratch.x) {
                    g.drawLine(r.x, this.displayer.getHeight() - ins.bottom, this.scratch.x - 1, this.displayer.getHeight() - ins.bottom);
                }
                if (this.scratch.x + this.scratch.width < r.x + r.width) {
                    selEnd = this.scratch.x + this.scratch.width;
                    g.drawLine(selEnd, this.displayer.getHeight() - ins.bottom, r.x + r.width, this.displayer.getHeight() - ins.bottom);
                }
            } else {
                g.drawLine(0, this.displayer.getHeight() - ins.bottom, this.displayer.getWidth(), this.displayer.getHeight() - ins.bottom);
            }
            g.setColor(UIManager.getColor("controlDkShadow"));
            g.drawLine(selEnd, this.displayer.getHeight() - 5, this.displayer.getWidth(), this.displayer.getHeight() - 5);
            return;
        }
        g.drawLine(r.x, this.displayer.getHeight() - ins.bottom, r.x + r.width, this.displayer.getHeight() - ins.bottom);
        g.setColor(UIManager.getColor("controlDkShadow"));
        g.drawLine(0, this.displayer.getHeight() - 5, this.displayer.getWidth(), this.displayer.getHeight() - 5);
    }

    protected LayoutManager createLayout() {
        return new MetalTabLayout();
    }

    protected AbstractButton[] createControlButtons() {
        AbstractButton[] result = new JButton[]{new BasicScrollingTabDisplayerUI.TimerButton(this.scroll().getBackwardAction()), new BasicScrollingTabDisplayerUI.TimerButton(this.scroll().getForwardAction()), new BasicScrollingTabDisplayerUI.OnPressButton(new TabListPopupAction(this.displayer))};
        MetalEditorTabDisplayerUI.configureButton(result[0], new LeftIcon());
        MetalEditorTabDisplayerUI.configureButton(result[1], new RightIcon());
        MetalEditorTabDisplayerUI.configureButton(result[2], new DownIcon());
        result[0].setPreferredSize(new Dimension(15, 17));
        result[1].setPreferredSize(new Dimension(17, 17));
        result[2].setPreferredSize(new Dimension(17, 17));
        result[0].setBorder(new PartialEtchedBorder(false));
        result[1].setBorder(new SpecEtchedBorder(true, true));
        result[2].setBorder(new SpecEtchedBorder(true, true));
        this.scroll().getBackwardAction().putValue("control", this.displayer);
        this.scroll().getForwardAction().putValue("control", this.displayer);
        return result;
    }

    private static void configureButton(JButton button, Icon icon) {
        button.setIcon(icon);
        button.setMargin(null);
        button.setText(null);
        button.putClientProperty("hideActionText", Boolean.TRUE);
        button.setFocusable(false);
    }

    private static class SpecEtchedBorder
    implements Border {
        private boolean fillRight;
        private boolean fillLeft;

        public SpecEtchedBorder(boolean fillRight, boolean fillLeft) {
            this.fillRight = fillRight;
            this.fillLeft = fillLeft;
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(2, 2, 2, 2);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(UIManager.getColor("controlHighlight"));
            g.drawLine(x + 1, y + 1, x + 1, y + height - 3);
            g.drawLine(x + 1, y + 1, x + width - 3, y + 1);
            g.drawLine(this.fillLeft ? x + 1 : x, y + height - 1, x + width, y + height - 1);
            g.drawLine(x + width - 1, y + 1, x + width - 1, y + height - (this.fillRight ? 0 : 3));
            g.setColor(UIManager.getColor("controlDkShadow"));
            g.drawLine(x, y, x + width + (this.fillRight ? -2 : -1), y);
            g.drawLine(x, y + (this.fillLeft ? 1 : 2), x, y + height - (this.fillLeft ? 2 : 3));
            g.drawLine(x + 2, y + height - 2, x + width - (this.fillRight ? 2 : 3), y + height - 2);
            g.drawLine(x + width - 2, y + 2, x + width - 2, y + height - 2);
        }
    }

    private static class PartialEtchedBorder
    implements Border {
        private boolean leftSide = false;

        public PartialEtchedBorder(boolean leftSide) {
            this.leftSide = leftSide;
        }

        public Insets getBorderInsets(Component c) {
            Insets ins = new Insets(2, this.leftSide ? 0 : 2, 2, this.leftSide ? 2 : 0);
            return ins;
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(UIManager.getColor("controlHighlight"));
            g.drawLine(this.leftSide ? x : x + 1, y + 1, this.leftSide ? x + width - 3 : x + width - 1, y + 1);
            g.drawLine(this.leftSide ? x : x + 1, y + --height, x + width, y + height);
            if (this.leftSide) {
                g.drawLine(x + width - 1, y + 1, x + width - 1, y + height);
            } else {
                g.drawLine(x + 1, y + 1, x + 1, y + height - 2);
            }
            g.setColor(UIManager.getColor("controlDkShadow"));
            g.drawLine(x, y, this.leftSide ? x + width - 2 : x + width - 1, y);
            g.drawLine(this.leftSide ? x : x + 2, y + height - 1, this.leftSide ? x + width - 2 : x + width, y + height - 1);
            if (this.leftSide) {
                g.drawLine(x + width - 2, y + 2, x + width - 2, y + height - 2);
            } else {
                g.drawLine(x, y, x, y + height - 1);
            }
        }
    }

    private static class DownIcon
    implements Icon {
        private DownIcon() {
        }

        public int getIconHeight() {
            return 11;
        }

        public int getIconWidth() {
            return 14;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            y -= 2;
            ++x;
            int wid = this.getIconWidth() - 2;
            if (wid % 2 == 0) {
                --wid;
            }
            int hi = this.getIconHeight();
            xpoints[0] = x + 1;
            ypoints[0] = y + hi / 2;
            xpoints[1] = x + wid - 1;
            ypoints[1] = ypoints[0];
            xpoints[2] = x + wid;
            ypoints[2] = ypoints[0];
            xpoints[3] = x + wid / 2;
            ypoints[3] = y + hi - 1;
            g.setColor(c.isEnabled() ? c.getForeground() : UIManager.getColor("controlShadow"));
            g.fillPolygon(xpoints, ypoints, 4);
        }
    }

    private static class RightIcon
    implements Icon {
        private RightIcon() {
        }

        public int getIconWidth() {
            return 11;
        }

        public int getIconHeight() {
            return 9;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(c.isEnabled() ? c.getForeground() : UIManager.getColor("controlShadow"));
            int wid = this.getIconWidth();
            int hi = this.getIconHeight() + 1;
            xpoints[0] = x + 3;
            ypoints[0] = (y -= 2) + 1;
            xpoints[1] = x + 3;
            ypoints[1] = y + hi + 1;
            xpoints[2] = x + (wid - 4) + 1;
            ypoints[2] = y + hi / 2 + 1;
            g.fillPolygon(xpoints, ypoints, 3);
        }
    }

    private static class LeftIcon
    implements Icon {
        private LeftIcon() {
        }

        public int getIconHeight() {
            return 11;
        }

        public int getIconWidth() {
            return 11;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(c.isEnabled() ? c.getForeground() : UIManager.getColor("controlShadow"));
            int wid = this.getIconWidth();
            int hi = this.getIconHeight() + 1;
            xpoints[0] = x + (wid - 4);
            ypoints[0] = (y -= 2) + 2;
            xpoints[1] = xpoints[0];
            ypoints[1] = y + hi + 1;
            xpoints[2] = x + 2;
            ypoints[2] = y + hi / 2 + 1;
            g.fillPolygon(xpoints, ypoints, 3);
        }
    }

    private class MetalTabLayout
    implements LayoutManager {
        private MetalTabLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void layoutContainer(Container parent) {
            Insets in = MetalEditorTabDisplayerUI.this.getTabAreaInsets();
            Component[] c = parent.getComponents();
            int x = parent.getWidth() - in.right + 3;
            int y = 0;
            for (int i = 0; i < c.length; ++i) {
                Dimension psize = c[i].getPreferredSize();
                y = in.top + 3;
                int w = Math.min(psize.width, parent.getWidth() - x);
                c[i].setBounds(x, y, w, Math.min(psize.height, parent.getHeight()));
                x += psize.width;
                if (i != 1) continue;
                x += 3;
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            return MetalEditorTabDisplayerUI.this.getPreferredSize((JComponent)parent);
        }

        public Dimension preferredLayoutSize(Container parent) {
            return MetalEditorTabDisplayerUI.this.getPreferredSize((JComponent)parent);
        }

        public void removeLayoutComponent(Component comp) {
        }
    }
}

