/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xsd;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.xml.xsd.Namespace;
import org.netbeans.modules.xml.xsd.SchemaElement;
import org.netbeans.modules.xml.xsd.XSDGrammar;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class XSDContentHandler
implements ContentHandler {
    private List elementsStack;
    private Map elements;
    private Map types;
    private PrintStream ps;
    private boolean resolveNamespaces;
    private Map uri2Namespace;
    private Map prefix2Namespace;
    private Namespace schemaNamespace;
    private Namespace targetNamespace;
    static final /* synthetic */ boolean $assertionsDisabled;

    public XSDContentHandler(PrintStream ps) {
        this.ps = ps;
        this.elements = new HashMap();
        this.types = new HashMap();
        this.elementsStack = new ArrayList();
        this.resolveNamespaces = true;
        this.uri2Namespace = new HashMap();
        this.prefix2Namespace = new HashMap();
    }

    public XSDGrammar getGrammar() {
        return new XSDGrammar(this.elements, this.types, this.targetNamespace, this.schemaNamespace);
    }

    private void println(String s) {
        this.ps.println(s);
    }

    private void printlnAttributes(Attributes atts) {
        this.println("START Attributes");
        for (int i = 0; i < atts.getLength(); ++i) {
            this.println("Attr[" + i + "] localname: " + atts.getLocalName(i) + " qname: " + atts.getQName(i) + " value: " + atts.getValue(i) + " URI: " + atts.getURI(i) + " type: " + atts.getType(i));
        }
        this.println("END Attributes");
    }

    private static void printlnElement(SchemaElement e, String prefix) {
        System.out.println(prefix + e.toString());
        Iterator it = e.getSubelements();
        while (it.hasNext()) {
            XSDContentHandler.printlnElement((SchemaElement)it.next(), prefix + "    ");
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    public void endDocument() throws SAXException {
        System.out.println("Stack size: " + this.elementsStack.size());
        SchemaElement e = (SchemaElement)this.elementsStack.get(0);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.elementsStack.remove(this.elementsStack.size() - 1);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
        this.elementsStack.add(SchemaElement.createSchemaElement(null, "TOP_LEVEL", null, null));
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.resolveNamespaces) {
            String uri;
            this.resolveNamespaces = false;
            for (int i = 0; i < atts.getLength(); ++i) {
                String name = atts.getQName(i);
                if (name.startsWith("xmlns")) {
                    uri = atts.getValue(i);
                    String prefix = Namespace.getSufix(name);
                    Namespace ns = new Namespace(uri, prefix);
                    if (prefix != null) {
                        this.prefix2Namespace.put(prefix, ns);
                    }
                    this.uri2Namespace.put(uri, ns);
                    System.err.println("NAMESPACE ADDED: " + prefix + " uri: " + uri);
                    continue;
                }
                System.err.println("ATTR not taken: " + name + " xxx " + atts.getQName(i) + " xxx " + atts.getValue(i));
            }
            String myprefix = Namespace.getPrefix(qName);
            Namespace xs = (Namespace)this.uri2Namespace.get("http://www.w3.org/2001/XMLSchema");
            if (!$assertionsDisabled && xs == null) {
                throw new AssertionError((Object)"Namespace http://www.w3.org/2001/XMLSchema not found");
            }
            if (myprefix == xs.getPrefix() || myprefix.equals(xs.getPrefix())) {
                this.schemaNamespace = xs;
                uri = atts.getValue("targetNamespace");
                this.targetNamespace = (Namespace)this.uri2Namespace.get(uri);
                if (!$assertionsDisabled && this.targetNamespace == null) {
                    throw new AssertionError();
                }
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Unknown schema, prefix of schema element does not match http://www.w3.org/2001/XMLSchema namespace");
            }
        }
        SchemaElement e = SchemaElement.createSchemaElement(namespaceURI, qName, atts, this.schemaNamespace.getPrefix());
        System.err.println("ELEMENTS ADDING: " + atts.getValue("name") + " qname: " + qName);
        SchemaElement parent = (SchemaElement)this.elementsStack.get(this.elementsStack.size() - 1);
        if (parent != null && parent.getSAXAttributes() != null) {
            System.err.println("INTO: " + parent.getSAXAttributes().getValue("name"));
        }
        this.elements.put(atts.getValue("name"), e);
        parent.addSubelement(e);
        this.elementsStack.add(e);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    static {
        $assertionsDisabled = !XSDContentHandler.class.desiredAssertionStatus();
    }
}

