/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Collection;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.ExClipboard;

public final class NbClipboard
extends ExClipboard
implements LookupListener,
AWTEventListener,
Runnable {
    private ErrorManager log;
    private Clipboard systemClipboard;
    private ExClipboard.Convertor[] convertors;
    private Lookup.Result result;
    private boolean slowSystemClipboard;
    private Transferable last;
    private long lastWindowActivated;
    private long lastWindowDeactivated;
    private Object lastWindowDeactivatedSource;
    private RequestProcessor.Task syncTask = new RequestProcessor("System clipboard synchronizer").create((Runnable)this);
    private Transferable data;
    private ClipboardOwner dataOwner;

    public NbClipboard() {
        super("NBClipboard");
        this.systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.log = ErrorManager.getDefault().getInstance("org.netbeans.core.NbClipboard");
        this.result = Lookup.getDefault().lookup(new Lookup.Template(ExClipboard.Convertor.class));
        this.result.addLookupListener((LookupListener)this);
        this.resultChanged(null);
        this.slowSystemClipboard = System.getProperty("netbeans.slow.system.clipboard.hack") != null ? Boolean.getBoolean("netbeans.slow.system.clipboard.hack") : true;
        if (this.slowSystemClipboard) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 64L);
        }
    }

    protected synchronized ExClipboard.Convertor[] getConvertors() {
        return this.convertors;
    }

    public synchronized void resultChanged(LookupEvent ev) {
        Collection c = this.result.allInstances();
        ExClipboard.Convertor[] temp = new ExClipboard.Convertor[c.size()];
        this.convertors = c.toArray(temp);
    }

    public synchronized void setContents(Transferable contents, ClipboardOwner owner) {
        if (this.log.isLoggable(1)) {
            this.log.log(1, "setContents called with: ");
            this.logFlavors(contents);
        }
        contents = this.convert(contents);
        if (this.log.isLoggable(1)) {
            this.log.log(1, "After conversion:");
            this.logFlavors(contents);
        }
        if (this.slowSystemClipboard) {
            super.setContents(contents, owner);
        } else {
            if (this.last != null) {
                NbClipboard.transferableOwnershipLost((Transferable)this.last);
            }
            this.last = contents;
        }
        this.data = contents;
        this.dataOwner = owner;
        this.syncTask.schedule(0);
        this.fireClipboardChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transferable getContents(Object requestor) {
        try {
            Transferable prev;
            if (this.slowSystemClipboard) {
                if (this.lastWindowActivated != 0L && this.lastWindowActivated + 100L < System.currentTimeMillis()) {
                    this.lastWindowActivated = 0L;
                    this.syncTask.schedule(0);
                    this.syncTask.waitFinished(100L);
                }
                prev = super.getContents(requestor);
            } else {
                this.syncTask.waitFinished();
                prev = this.systemClipboard.getContents(requestor);
            }
            NbClipboard nbClipboard = this;
            synchronized (nbClipboard) {
                if (this.log.isLoggable(1)) {
                    this.log.log(1, "getContents by " + requestor);
                    this.logFlavors(prev);
                }
                if (prev == null) {
                    return null;
                }
                Transferable res = this.convert(prev);
                if (this.log.isLoggable(1)) {
                    this.log.log(1, "getContents by " + requestor);
                    this.logFlavors(res);
                    res = new LoggableTransferable(res);
                }
                return res;
            }
        }
        catch (ThreadDeath ex) {
            throw ex;
        }
        catch (Throwable ex) {
            ErrorManager.getDefault().notify(ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Transferable contents = null;
        ClipboardOwner owner = null;
        NbClipboard nbClipboard = this;
        synchronized (nbClipboard) {
            if (this.data != null) {
                contents = this.data;
                owner = this.dataOwner;
            }
            this.data = null;
            this.dataOwner = null;
        }
        if (contents != null) {
            if (this.log.isLoggable(1)) {
                this.log.log(1, "systemClipboard updated:");
                this.logFlavors(contents);
            }
            this.systemClipboard.setContents(contents, owner);
            return;
        }
        try {
            Transferable transferable = this.systemClipboard.getContents(this);
            super.setContents(transferable, null);
            if (this.log.isLoggable(1)) {
                this.log.log(1, "internal clipboard updated:");
                this.logFlavors(transferable);
            }
            this.fireClipboardChange();
        }
        catch (ThreadDeath ex) {
            throw ex;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    final void waitFinished() {
        this.syncTask.waitFinished();
    }

    final void activateWindowHack(boolean reschedule) {
        this.lastWindowActivated = System.currentTimeMillis();
        if (reschedule) {
            this.syncTask.schedule(0);
        }
    }

    public void eventDispatched(AWTEvent ev) {
        if (!(ev instanceof WindowEvent)) {
            return;
        }
        if (ev.getID() == 206) {
            this.lastWindowDeactivated = System.currentTimeMillis();
            this.lastWindowDeactivatedSource = ev.getSource();
        }
        if (ev.getID() == 205) {
            if (System.currentTimeMillis() - this.lastWindowDeactivated < 100L && ev.getSource() == this.lastWindowDeactivatedSource) {
                this.activateWindowHack(false);
            }
            if (this.log.isLoggable(1)) {
                this.log.log(1, "window activated scheduling update");
            }
            this.syncTask.schedule(0);
        }
    }

    private void logFlavors(Transferable trans) {
        if (trans == null) {
            this.log.log(1, "  no clipboard contents");
        } else {
            DataFlavor[] arr = trans.getTransferDataFlavors();
            for (int i = 0; i < arr.length; ++i) {
                this.log.log(1, "  " + i + " = " + arr[i]);
            }
        }
    }

    private final class LoggableTransferable
    implements Transferable {
        private Transferable delegate;

        public LoggableTransferable(Transferable delegate) {
            this.delegate = delegate;
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            ErrorManager errorManager = NbClipboard.this.log;
            NbClipboard.this.log;
            errorManager.log(1, "Request for flavor: " + flavor);
            Object res = this.delegate.getTransferData(flavor);
            ErrorManager errorManager2 = NbClipboard.this.log;
            NbClipboard.this.log;
            errorManager2.log(1, "Returning value: " + res);
            return res;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.delegate.getTransferDataFlavors();
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            boolean res = this.delegate.isDataFlavorSupported(flavor);
            ErrorManager errorManager = NbClipboard.this.log;
            NbClipboard.this.log;
            errorManager.log(1, "isDataFlavorSupported: " + flavor + " result: " + res);
            return res;
        }
    }
}

