/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2ee.blueprints.ui.geocoder;

import com.sun.j2ee.blueprints.ui.geocoder.GeoPoint;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GeoCoder {
    private String applicationId = "com.sun.j2ee.blueprints.ui.geocoder";
    private Logger logger = Logger.getLogger("com.sun.j2ee.blueprints.ui.geocoder.GeoCoder", "com.sun.j2ee.blueprints.ui.MessageStrings");
    private String proxyHost = null;
    private int proxyPort = 0;
    private boolean proxySet = false;
    static final String APPLICATION_ID = "com.sun.j2ee.blueprints.ui.geocoder";
    private static final String SERVICE_URL = "http://api.local.yahoo.com/MapsService/V1/geocode";

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        if (applicationId == null) {
            throw new NullPointerException();
        }
        this.applicationId = applicationId;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        this.proxySet = false;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        this.proxySet = false;
    }

    public GeoPoint[] geoCode(String location) {
        if (location == null) {
            return null;
        }
        if (!this.proxySet) {
            this.setProxyConfiguration();
            this.proxySet = false;
        }
        String applicationId = this.getApplicationId();
        try {
            applicationId = URLEncoder.encode(applicationId, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.log(Level.WARNING, "geoCoder.encodeApplicationId", e);
            }
            throw new IllegalArgumentException(e.getMessage());
        }
        try {
            location = URLEncoder.encode(location, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.log(Level.WARNING, "geoCoder.encodeLocation", e);
            }
            throw new IllegalArgumentException(e.getMessage());
        }
        Document document = null;
        StringBuffer sb = new StringBuffer(SERVICE_URL);
        sb.append("?appid=");
        sb.append(applicationId);
        sb.append("&location=");
        sb.append(location);
        try {
            document = this.parseResponse(sb.toString());
            return this.convertResults(document);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return null;
    }

    private GeoPoint[] convertResults(Document document) {
        ArrayList<GeoPoint> results = new ArrayList<GeoPoint>();
        GeoPoint point = null;
        Element root = document.getDocumentElement();
        if (!"ResultSet".equals(root.getTagName())) {
            throw new IllegalArgumentException(root.getTagName());
        }
        NodeList outerList = root.getChildNodes();
        for (int i = 0; i < outerList.getLength(); ++i) {
            Node outer = outerList.item(i);
            if (!"Result".equals(outer.getNodeName())) {
                throw new IllegalArgumentException(outer.getNodeName());
            }
            point = new GeoPoint();
            NodeList innerList = outer.getChildNodes();
            for (int j = 0; j < innerList.getLength(); ++j) {
                Node inner = innerList.item(j);
                String name = inner.getNodeName();
                String text = null;
                NodeList bottomList = inner.getChildNodes();
                for (int k = 0; k < bottomList.getLength(); ++k) {
                    Node bottom = bottomList.item(k);
                    if (!"#text".equals(bottom.getNodeName())) continue;
                    text = bottom.getNodeValue().trim();
                    if (text.length() >= 1) break;
                    text = null;
                    break;
                }
                if ("Latitude".equals(name)) {
                    if (text == null) continue;
                    point.setLatitude(Double.valueOf(text));
                    continue;
                }
                if ("Longitude".equals(name)) {
                    if (text == null) continue;
                    point.setLongitude(Double.valueOf(text));
                    continue;
                }
                if ("Address".equals(name)) {
                    point.setAddress(text);
                    continue;
                }
                if ("City".equals(name)) {
                    point.setCity(text);
                    continue;
                }
                if ("State".equals(name)) {
                    point.setState(text);
                    continue;
                }
                if ("Zip".equals(name)) {
                    point.setZip(text);
                    continue;
                }
                if (!"Country".equals(name)) continue;
                point.setCountry(text);
            }
            results.add(point);
        }
        return results.toArray(new GeoPoint[results.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document parseResponse(String url) throws IOException, MalformedURLException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputStream stream = null;
        try {
            stream = new URL(url).openStream();
            Document document = db.parse(stream);
            return document;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private synchronized void setProxyConfiguration() {
        block3: {
            if (this.proxyHost == null || this.proxyPort == 0) {
                return;
            }
            try {
                System.setProperty("http.proxyHost", this.proxyHost);
                System.setProperty("http.proxyPort", "" + this.proxyPort);
            }
            catch (SecurityException e) {
                if (!this.logger.isLoggable(Level.WARNING)) break block3;
                this.logger.log(Level.WARNING, "geoCoder.setProxy", e);
            }
        }
    }
}

