/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.Argument;
import com.sun.mail.iap.BadCommandException;
import com.sun.mail.iap.CommandFailedException;
import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.Literal;
import com.sun.mail.iap.ParsingException;
import com.sun.mail.iap.Protocol;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.ACL;
import com.sun.mail.imap.Quota;
import com.sun.mail.imap.Rights;
import com.sun.mail.imap.protocol.BASE64MailboxEncoder;
import com.sun.mail.imap.protocol.BODY;
import com.sun.mail.imap.protocol.BODYSTRUCTURE;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.imap.protocol.IMAPResponse;
import com.sun.mail.imap.protocol.INTERNALDATE;
import com.sun.mail.imap.protocol.ListInfo;
import com.sun.mail.imap.protocol.MailboxInfo;
import com.sun.mail.imap.protocol.MessageSet;
import com.sun.mail.imap.protocol.Namespaces;
import com.sun.mail.imap.protocol.RFC822DATA;
import com.sun.mail.imap.protocol.SaslAuthenticator;
import com.sun.mail.imap.protocol.SearchSequence;
import com.sun.mail.imap.protocol.Status;
import com.sun.mail.imap.protocol.UID;
import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.BASE64EncoderStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.mail.Flags;
import javax.mail.internet.MimeUtility;
import javax.mail.search.SearchException;
import javax.mail.search.SearchTerm;

public class IMAPProtocol
extends Protocol {
    private boolean rev1 = false;
    private boolean authenticated;
    private Hashtable capabilities = null;
    private Vector authmechs = null;
    private String[] searchCharsets;
    private String name;
    private Properties props;
    private SaslAuthenticator saslAuthenticator;
    static /* synthetic */ Class class$javax$mail$Flags;

    public IMAPProtocol(String string, String string2, int n, boolean bl, PrintStream printStream, Properties properties, boolean bl2) throws IOException, ProtocolException {
        super(string2, n, bl, printStream, properties, "mail." + string, bl2);
        this.name = string;
        this.props = properties;
        if (this.capabilities == null) {
            this.capability();
        }
        if (this.hasCapability("IMAP4rev1")) {
            this.rev1 = true;
        }
        this.searchCharsets = new String[2];
        this.searchCharsets[0] = "UTF-8";
        this.searchCharsets[1] = MimeUtility.mimeCharset(MimeUtility.getDefaultJavaCharset());
    }

    public void capability() throws ProtocolException {
        Response[] responseArray = this.command("CAPABILITY", null);
        if (!responseArray[responseArray.length - 1].isOK()) {
            throw new ProtocolException(responseArray[responseArray.length - 1].toString());
        }
        this.capabilities = new Hashtable(10);
        this.authmechs = new Vector(5);
        int n = responseArray.length;
        for (int i = 0; i < n; ++i) {
            IMAPResponse iMAPResponse;
            if (!(responseArray[i] instanceof IMAPResponse) || !(iMAPResponse = (IMAPResponse)responseArray[i]).keyEquals("CAPABILITY")) continue;
            this.parseCapabilities(iMAPResponse);
        }
    }

    protected void setCapabilities(Response response) {
        byte by;
        while ((by = response.readByte()) > 0 && by != 91) {
        }
        if (by == 0) {
            return;
        }
        String string = response.readAtom();
        if (!string.equalsIgnoreCase("CAPABILITY")) {
            return;
        }
        this.capabilities = new Hashtable(10);
        this.authmechs = new Vector(5);
        this.parseCapabilities(response);
    }

    protected void parseCapabilities(Response response) {
        String string;
        while ((string = response.readAtom(']')) != null) {
            if (string.length() == 0) {
                if (response.peekByte() == 93) break;
                response.skipToken();
                continue;
            }
            this.capabilities.put(string.toUpperCase(), string);
            if (!string.regionMatches(true, 0, "AUTH=", 0, 5)) continue;
            this.authmechs.addElement(string.substring(5));
            if (!this.debug) continue;
            this.out.println("IMAP DEBUG: AUTH: " + string.substring(5));
        }
    }

    protected void processGreeting(Response response) throws ProtocolException {
        super.processGreeting(response);
        if (response.isOK()) {
            this.setCapabilities(response);
            return;
        }
        IMAPResponse iMAPResponse = (IMAPResponse)response;
        if (!iMAPResponse.keyEquals("PREAUTH")) {
            throw new ConnectionException(this, response);
        }
        this.authenticated = true;
        this.setCapabilities(response);
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public boolean isREV1() {
        return this.rev1;
    }

    protected boolean supportsNonSyncLiterals() {
        return this.hasCapability("LITERAL+");
    }

    public Response readResponse() throws IOException, ProtocolException {
        return IMAPResponse.readResponse(this);
    }

    public boolean hasCapability(String string) {
        return this.capabilities.containsKey(string.toUpperCase());
    }

    public void disconnect() {
        super.disconnect();
    }

    public void noop() throws ProtocolException {
        this.simpleCommand("NOOP", null);
    }

    public void logout() throws ProtocolException {
        Response[] responseArray = this.command("LOGOUT", null);
        this.authenticated = false;
        this.notifyResponseHandlers(responseArray);
        this.disconnect();
    }

    public void login(String string, String string2) throws ProtocolException {
        Argument argument = new Argument();
        argument.writeString(string);
        argument.writeString(string2);
        this.simpleCommand("LOGIN", argument);
        this.authenticated = true;
    }

    public void authlogin(String string, String string2) throws ProtocolException {
        Object object;
        Vector<Response> vector = new Vector<Response>();
        String string3 = null;
        Response response = null;
        boolean bl = false;
        try {
            string3 = this.writeCommand("AUTHENTICATE LOGIN", null);
        }
        catch (Exception exception) {
            response = Response.byeResponse(exception);
            bl = true;
        }
        OutputStream outputStream = this.getOutputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BASE64EncoderStream bASE64EncoderStream = new BASE64EncoderStream(byteArrayOutputStream, Integer.MAX_VALUE);
        byte[] byArray = new byte[]{13, 10};
        boolean bl2 = true;
        while (!bl) {
            try {
                response = this.readResponse();
                if (response.isContinuation()) {
                    if (bl2) {
                        object = string;
                        bl2 = false;
                    } else {
                        object = string2;
                    }
                    ((OutputStream)bASE64EncoderStream).write(ASCIIUtility.getBytes((String)object));
                    ((OutputStream)bASE64EncoderStream).flush();
                    byteArrayOutputStream.write(byArray);
                    outputStream.write(byteArrayOutputStream.toByteArray());
                    outputStream.flush();
                    byteArrayOutputStream.reset();
                    continue;
                }
                if (response.isTagged() && response.getTag().equals(string3)) {
                    bl = true;
                    continue;
                }
                if (response.isBYE()) {
                    bl = true;
                    continue;
                }
                vector.addElement(response);
            }
            catch (Exception exception) {
                response = Response.byeResponse(exception);
                bl = true;
            }
        }
        object = new Response[vector.size()];
        vector.copyInto((Object[])object);
        this.notifyResponseHandlers((Response[])object);
        this.handleResult(response);
        if (response.isOK()) {
            this.setCapabilities(response);
        }
        this.authenticated = true;
    }

    public void authplain(String string, String string2, String string3) throws ProtocolException {
        Vector<Response> vector = new Vector<Response>();
        String string4 = null;
        Response response = null;
        boolean bl = false;
        try {
            string4 = this.writeCommand("AUTHENTICATE PLAIN", null);
        }
        catch (Exception exception) {
            response = Response.byeResponse(exception);
            bl = true;
        }
        OutputStream outputStream = this.getOutputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BASE64EncoderStream bASE64EncoderStream = new BASE64EncoderStream(byteArrayOutputStream, Integer.MAX_VALUE);
        while (!bl) {
            try {
                response = this.readResponse();
                if (response.isContinuation()) {
                    String string5 = string + "\u0000" + string2 + "\u0000" + string3;
                    ((OutputStream)bASE64EncoderStream).write(ASCIIUtility.getBytes(string5));
                    ((OutputStream)bASE64EncoderStream).flush();
                    byteArrayOutputStream.write(CRLF);
                    outputStream.write(byteArrayOutputStream.toByteArray());
                    outputStream.flush();
                    byteArrayOutputStream.reset();
                    continue;
                }
                if (response.isTagged() && response.getTag().equals(string4)) {
                    bl = true;
                    continue;
                }
                if (response.isBYE()) {
                    bl = true;
                    continue;
                }
                vector.addElement(response);
            }
            catch (Exception exception) {
                response = Response.byeResponse(exception);
                bl = true;
            }
        }
        Object[] objectArray = new Response[vector.size()];
        vector.copyInto(objectArray);
        this.notifyResponseHandlers((Response[])objectArray);
        this.handleResult(response);
        if (response.isOK()) {
            this.setCapabilities(response);
        }
        this.authenticated = true;
    }

    public void sasllogin(String[] stringArray, String string, String string2, String string3, String string4) throws ProtocolException {
        Serializable serializable;
        if (this.saslAuthenticator == null) {
            try {
                serializable = Class.forName("com.sun.mail.imap.protocol.IMAPSaslAuthenticator");
                Constructor<?> constructor = ((Class)serializable).getConstructor(IMAPProtocol.class, String.class, Properties.class, Boolean.TYPE, PrintStream.class, String.class);
                this.saslAuthenticator = (SaslAuthenticator)constructor.newInstance(this, this.name, this.props, this.debug ? Boolean.TRUE : Boolean.FALSE, this.out, this.host);
            }
            catch (Exception exception) {
                if (this.debug) {
                    this.out.println("IMAP DEBUG: Can't load SASL authenticator: " + exception);
                }
                return;
            }
        }
        if (stringArray != null && stringArray.length > 0) {
            serializable = new Vector(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                if (!this.authmechs.contains(stringArray[i])) continue;
                ((Vector)serializable).addElement(stringArray[i]);
            }
        } else {
            serializable = this.authmechs;
        }
        Object[] objectArray = new String[((Vector)serializable).size()];
        ((Vector)serializable).copyInto(objectArray);
        if (this.saslAuthenticator.authenticate((String[])objectArray, string, string2, string3, string4)) {
            this.authenticated = true;
        }
    }

    OutputStream getIMAPOutputStream() {
        return this.getOutputStream();
    }

    public void proxyauth(String string) throws ProtocolException {
        Argument argument = new Argument();
        argument.writeString(string);
        this.simpleCommand("PROXYAUTH", argument);
    }

    public void startTLS() throws ProtocolException {
        try {
            super.startTLS("STARTTLS");
        }
        catch (ProtocolException protocolException) {
            throw protocolException;
        }
        catch (Exception exception) {
            Response[] responseArray = new Response[]{Response.byeResponse(exception)};
            this.notifyResponseHandlers(responseArray);
            this.disconnect();
        }
    }

    public MailboxInfo select(String string) throws ProtocolException {
        string = BASE64MailboxEncoder.encode(string);
        Argument argument = new Argument();
        argument.writeString(string);
        Response[] responseArray = this.command("SELECT", argument);
        MailboxInfo mailboxInfo = new MailboxInfo(responseArray);
        this.notifyResponseHandlers(responseArray);
        Response response = responseArray[responseArray.length - 1];
        if (response.isOK()) {
            mailboxInfo.mode = response.toString().indexOf("READ-ONLY") != -1 ? 1 : 2;
        }
        this.handleResult(response);
        return mailboxInfo;
    }

    public MailboxInfo examine(String string) throws ProtocolException {
        string = BASE64MailboxEncoder.encode(string);
        Argument argument = new Argument();
        argument.writeString(string);
        Response[] responseArray = this.command("EXAMINE", argument);
        MailboxInfo mailboxInfo = new MailboxInfo(responseArray);
        mailboxInfo.mode = 1;
        this.notifyResponseHandlers(responseArray);
        this.handleResult(responseArray[responseArray.length - 1]);
        return mailboxInfo;
    }

    public Status status(String string, String[] stringArray) throws ProtocolException {
        if (!this.isREV1() && !this.hasCapability("IMAP4SUNVERSION")) {
            throw new BadCommandException("STATUS not supported");
        }
        string = BASE64MailboxEncoder.encode(string);
        Argument argument = new Argument();
        argument.writeString(string);
        Argument argument2 = new Argument();
        if (stringArray == null) {
            stringArray = Status.standardItems;
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            argument2.writeAtom(stringArray[i]);
        }
        argument.writeArgument(argument2);
        Response[] responseArray = this.command("STATUS", argument);
        Status status = null;
        Response response = responseArray[responseArray.length - 1];
        if (response.isOK()) {
            int n2 = responseArray.length;
            for (int i = 0; i < n2; ++i) {
                IMAPResponse iMAPResponse;
                if (!(responseArray[i] instanceof IMAPResponse) || !(iMAPResponse = (IMAPResponse)responseArray[i]).keyEquals("STATUS")) continue;
                if (status == null) {
                    status = new Status(iMAPResponse);
                } else {
                    Status.add(status, new Status(iMAPResponse));
                }
                responseArray[i] = null;
            }
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
        return status;
    }

    public void create(String string) throws ProtocolException {
        string = BASE64MailboxEncoder.encode(string);
        Argument argument = new Argument();
        argument.writeString(string);
        this.simpleCommand("CREATE", argument);
    }

    public void delete(String string) throws ProtocolException {
        string = BASE64MailboxEncoder.encode(string);
        Argument argument = new Argument();
        argument.writeString(string);
        this.simpleCommand("DELETE", argument);
    }

    public void rename(String string, String string2) throws ProtocolException {
        string = BASE64MailboxEncoder.encode(string);
        string2 = BASE64MailboxEncoder.encode(string2);
        Argument argument = new Argument();
        argument.writeString(string);
        argument.writeString(string2);
        this.simpleCommand("RENAME", argument);
    }

    public void subscribe(String string) throws ProtocolException {
        Argument argument = new Argument();
        string = BASE64MailboxEncoder.encode(string);
        argument.writeString(string);
        this.simpleCommand("SUBSCRIBE", argument);
    }

    public void unsubscribe(String string) throws ProtocolException {
        Argument argument = new Argument();
        string = BASE64MailboxEncoder.encode(string);
        argument.writeString(string);
        this.simpleCommand("UNSUBSCRIBE", argument);
    }

    public ListInfo[] list(String string, String string2) throws ProtocolException {
        return this.doList("LIST", string, string2);
    }

    public ListInfo[] lsub(String string, String string2) throws ProtocolException {
        return this.doList("LSUB", string, string2);
    }

    private ListInfo[] doList(String string, String string2, String string3) throws ProtocolException {
        string2 = BASE64MailboxEncoder.encode(string2);
        string3 = BASE64MailboxEncoder.encode(string3);
        Argument argument = new Argument();
        argument.writeString(string2);
        argument.writeString(string3);
        Response[] responseArray = this.command(string, argument);
        Object[] objectArray = null;
        Response response = responseArray[responseArray.length - 1];
        if (response.isOK()) {
            Vector<ListInfo> vector = new Vector<ListInfo>(1);
            int n = responseArray.length;
            for (int i = 0; i < n; ++i) {
                IMAPResponse iMAPResponse;
                if (!(responseArray[i] instanceof IMAPResponse) || !(iMAPResponse = (IMAPResponse)responseArray[i]).keyEquals(string)) continue;
                vector.addElement(new ListInfo(iMAPResponse));
                responseArray[i] = null;
            }
            if (vector.size() > 0) {
                objectArray = new ListInfo[vector.size()];
                vector.copyInto(objectArray);
            }
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
        return objectArray;
    }

    public void append(String string, Flags flags, Date date, Literal literal) throws ProtocolException {
        string = BASE64MailboxEncoder.encode(string);
        Argument argument = new Argument();
        argument.writeString(string);
        if (flags != null) {
            flags.remove(Flags.Flag.RECENT);
        }
        argument.writeAtom(this.createFlagList(flags));
        if (date != null) {
            argument.writeString(INTERNALDATE.format(date));
        }
        argument.writeBytes(literal);
        this.simpleCommand("APPEND", argument);
    }

    public void check() throws ProtocolException {
        this.simpleCommand("CHECK", null);
    }

    public void close() throws ProtocolException {
        this.simpleCommand("CLOSE", null);
    }

    public void expunge() throws ProtocolException {
        this.simpleCommand("EXPUNGE", null);
    }

    public BODYSTRUCTURE fetchBodyStructure(int n) throws ProtocolException {
        Response[] responseArray = this.fetch(n, "BODYSTRUCTURE");
        this.notifyResponseHandlers(responseArray);
        Response response = responseArray[responseArray.length - 1];
        if (response.isOK()) {
            return (BODYSTRUCTURE)FetchResponse.getItem(responseArray, n, BODYSTRUCTURE.class);
        }
        if (response.isNO()) {
            return null;
        }
        this.handleResult(response);
        return null;
    }

    public BODY peekBody(int n, String string) throws ProtocolException {
        return this.fetchBody(n, string, true);
    }

    public BODY fetchBody(int n, String string) throws ProtocolException {
        return this.fetchBody(n, string, false);
    }

    private BODY fetchBody(int n, String string, boolean bl) throws ProtocolException {
        Response[] responseArray = bl ? this.fetch(n, "BODY.PEEK[" + (string == null ? "]" : string + "]")) : this.fetch(n, "BODY[" + (string == null ? "]" : string + "]"));
        this.notifyResponseHandlers(responseArray);
        Response response = responseArray[responseArray.length - 1];
        if (response.isOK()) {
            return (BODY)FetchResponse.getItem(responseArray, n, BODY.class);
        }
        if (response.isNO()) {
            return null;
        }
        this.handleResult(response);
        return null;
    }

    public BODY fetchBody(int n, String string, int n2, int n3) throws ProtocolException {
        Response[] responseArray = this.fetch(n, "BODY[" + (string == null ? "]<" : string + "]<") + String.valueOf(n2) + "." + String.valueOf(n3) + ">");
        this.notifyResponseHandlers(responseArray);
        Response response = responseArray[responseArray.length - 1];
        if (response.isOK()) {
            return (BODY)FetchResponse.getItem(responseArray, n, BODY.class);
        }
        if (response.isNO()) {
            return null;
        }
        this.handleResult(response);
        return null;
    }

    public RFC822DATA fetchRFC822(int n, String string) throws ProtocolException {
        Response[] responseArray = this.fetch(n, string == null ? "RFC822" : "RFC822." + string);
        this.notifyResponseHandlers(responseArray);
        Response response = responseArray[responseArray.length - 1];
        if (response.isOK()) {
            return (RFC822DATA)FetchResponse.getItem(responseArray, n, RFC822DATA.class);
        }
        if (response.isNO()) {
            return null;
        }
        this.handleResult(response);
        return null;
    }

    public Flags fetchFlags(int n) throws ProtocolException {
        Flags flags = null;
        Response[] responseArray = this.fetch(n, "FLAGS");
        int n2 = responseArray.length;
        for (int i = 0; i < n2; ++i) {
            if (responseArray[i] == null || !(responseArray[i] instanceof FetchResponse) || ((FetchResponse)responseArray[i]).getNumber() != n) continue;
            FetchResponse fetchResponse = (FetchResponse)responseArray[i];
            flags = (Flags)((Object)fetchResponse.getItem(class$javax$mail$Flags == null ? IMAPProtocol.class$("javax.mail.Flags") : class$javax$mail$Flags));
            if (flags == null) continue;
            responseArray[i] = null;
            break;
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(responseArray[responseArray.length - 1]);
        return flags;
    }

    public UID fetchUID(int n) throws ProtocolException {
        Response[] responseArray = this.fetch(n, "UID");
        this.notifyResponseHandlers(responseArray);
        Response response = responseArray[responseArray.length - 1];
        if (response.isOK()) {
            return (UID)FetchResponse.getItem(responseArray, n, UID.class);
        }
        if (response.isNO()) {
            return null;
        }
        this.handleResult(response);
        return null;
    }

    public UID fetchSequenceNumber(long l) throws ProtocolException {
        UID uID = null;
        Response[] responseArray = this.fetch(String.valueOf(l), "UID", true);
        int n = responseArray.length;
        for (int i = 0; i < n; ++i) {
            if (responseArray[i] == null || !(responseArray[i] instanceof FetchResponse)) continue;
            FetchResponse fetchResponse = (FetchResponse)responseArray[i];
            uID = (UID)fetchResponse.getItem(class$com$sun$mail$imap$protocol$UID == null ? IMAPProtocol.class$("com.sun.mail.imap.protocol.UID") : class$com$sun$mail$imap$protocol$UID);
            if (uID == null) continue;
            if (uID.uid == l) break;
            uID = null;
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(responseArray[responseArray.length - 1]);
        return uID;
    }

    public UID[] fetchSequenceNumbers(long l, long l2) throws ProtocolException {
        Response[] responseArray = this.fetch(String.valueOf(l) + ":" + (l2 == -1L ? "*" : String.valueOf(l2)), "UID", true);
        Vector<UID> vector = new Vector<UID>();
        int n = responseArray.length;
        for (int i = 0; i < n; ++i) {
            if (responseArray[i] == null || !(responseArray[i] instanceof FetchResponse)) continue;
            FetchResponse fetchResponse = (FetchResponse)responseArray[i];
            UID uID = (UID)fetchResponse.getItem(class$com$sun$mail$imap$protocol$UID == null ? IMAPProtocol.class$("com.sun.mail.imap.protocol.UID") : class$com$sun$mail$imap$protocol$UID);
            if (uID == null) continue;
            vector.addElement(uID);
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(responseArray[responseArray.length - 1]);
        Object[] objectArray = new UID[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public UID[] fetchSequenceNumbers(long[] lArray) throws ProtocolException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < lArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(String.valueOf(lArray[i]));
        }
        Response[] responseArray = this.fetch(stringBuffer.toString(), "UID", true);
        Vector<UID> vector = new Vector<UID>();
        int n = responseArray.length;
        for (int i = 0; i < n; ++i) {
            if (responseArray[i] == null || !(responseArray[i] instanceof FetchResponse)) continue;
            FetchResponse fetchResponse = (FetchResponse)responseArray[i];
            UID uID = (UID)fetchResponse.getItem(class$com$sun$mail$imap$protocol$UID == null ? IMAPProtocol.class$("com.sun.mail.imap.protocol.UID") : class$com$sun$mail$imap$protocol$UID);
            if (uID == null) continue;
            vector.addElement(uID);
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(responseArray[responseArray.length - 1]);
        Object[] objectArray = new UID[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Response[] fetch(MessageSet[] messageSetArray, String string) throws ProtocolException {
        return this.fetch(MessageSet.toString(messageSetArray), string, false);
    }

    public Response[] fetch(int n, int n2, String string) throws ProtocolException {
        return this.fetch(String.valueOf(n) + ":" + String.valueOf(n2), string, false);
    }

    public Response[] fetch(int n, String string) throws ProtocolException {
        return this.fetch(String.valueOf(n), string, false);
    }

    private Response[] fetch(String string, String string2, boolean bl) throws ProtocolException {
        if (bl) {
            return this.command("UID FETCH " + string + " (" + string2 + ")", null);
        }
        return this.command("FETCH " + string + " (" + string2 + ")", null);
    }

    public void copy(MessageSet[] messageSetArray, String string) throws ProtocolException {
        this.copy(MessageSet.toString(messageSetArray), string);
    }

    public void copy(int n, int n2, String string) throws ProtocolException {
        this.copy(String.valueOf(n) + ":" + String.valueOf(n2), string);
    }

    private void copy(String string, String string2) throws ProtocolException {
        string2 = BASE64MailboxEncoder.encode(string2);
        Argument argument = new Argument();
        argument.writeAtom(string);
        argument.writeString(string2);
        this.simpleCommand("COPY", argument);
    }

    public void storeFlags(MessageSet[] messageSetArray, Flags flags, boolean bl) throws ProtocolException {
        this.storeFlags(MessageSet.toString(messageSetArray), flags, bl);
    }

    public void storeFlags(int n, int n2, Flags flags, boolean bl) throws ProtocolException {
        this.storeFlags(String.valueOf(n) + ":" + String.valueOf(n2), flags, bl);
    }

    public void storeFlags(int n, Flags flags, boolean bl) throws ProtocolException {
        this.storeFlags(String.valueOf(n), flags, bl);
    }

    private void storeFlags(String string, Flags flags, boolean bl) throws ProtocolException {
        Response[] responseArray = bl ? this.command("STORE " + string + " +FLAGS " + this.createFlagList(flags), null) : this.command("STORE " + string + " -FLAGS " + this.createFlagList(flags), null);
        this.notifyResponseHandlers(responseArray);
        this.handleResult(responseArray[responseArray.length - 1]);
    }

    private String createFlagList(Flags flags) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Flags.Flag[] flagArray = flags.getSystemFlags();
        boolean bl = true;
        for (int i = 0; i < flagArray.length; ++i) {
            String string;
            Flags.Flag flag = flagArray[i];
            if (flag == Flags.Flag.ANSWERED) {
                string = "\\Answered";
            } else if (flag == Flags.Flag.DELETED) {
                string = "\\Deleted";
            } else if (flag == Flags.Flag.DRAFT) {
                string = "\\Draft";
            } else if (flag == Flags.Flag.FLAGGED) {
                string = "\\Flagged";
            } else if (flag == Flags.Flag.RECENT) {
                string = "\\Recent";
            } else {
                if (flag != Flags.Flag.SEEN) continue;
                string = "\\Seen";
            }
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(' ');
            }
            stringBuffer.append(string);
        }
        String[] stringArray = flags.getUserFlags();
        for (int i = 0; i < stringArray.length; ++i) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(' ');
            }
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public int[] search(MessageSet[] messageSetArray, SearchTerm searchTerm) throws ProtocolException, SearchException {
        return this.search(MessageSet.toString(messageSetArray), searchTerm);
    }

    public int[] search(SearchTerm searchTerm) throws ProtocolException, SearchException {
        return this.search("ALL", searchTerm);
    }

    private int[] search(String string, SearchTerm searchTerm) throws ProtocolException, SearchException {
        if (SearchSequence.isAscii(searchTerm)) {
            try {
                return this.issueSearch(string, searchTerm, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (int i = 0; i < this.searchCharsets.length; ++i) {
            if (this.searchCharsets[i] == null) continue;
            try {
                return this.issueSearch(string, searchTerm, this.searchCharsets[i]);
            }
            catch (CommandFailedException commandFailedException) {
                this.searchCharsets[i] = null;
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            catch (ProtocolException protocolException) {
                throw protocolException;
            }
            catch (SearchException searchException) {
                throw searchException;
            }
        }
        throw new SearchException("Search failed");
    }

    private int[] issueSearch(String string, SearchTerm searchTerm, String string2) throws ProtocolException, SearchException, IOException {
        Argument argument = SearchSequence.generateSequence(searchTerm, string2 == null ? null : MimeUtility.javaCharset(string2));
        argument.writeAtom(string);
        Response[] responseArray = string2 == null ? this.command("SEARCH", argument) : this.command("SEARCH CHARSET " + string2, argument);
        Response response = responseArray[responseArray.length - 1];
        int[] nArray = null;
        if (response.isOK()) {
            int n;
            Vector<Integer> vector = new Vector<Integer>();
            int n2 = responseArray.length;
            for (n = 0; n < n2; ++n) {
                int n3;
                IMAPResponse iMAPResponse;
                if (!(responseArray[n] instanceof IMAPResponse) || !(iMAPResponse = (IMAPResponse)responseArray[n]).keyEquals("SEARCH")) continue;
                while ((n3 = iMAPResponse.readNumber()) != -1) {
                    vector.addElement(new Integer(n3));
                }
                responseArray[n] = null;
            }
            n = vector.size();
            nArray = new int[n];
            for (n2 = 0; n2 < n; ++n2) {
                nArray[n2] = (Integer)vector.elementAt(n2);
            }
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
        return nArray;
    }

    public Namespaces namespace() throws ProtocolException {
        if (!this.hasCapability("NAMESPACE")) {
            throw new BadCommandException("NAMESPACE not supported");
        }
        Response[] responseArray = this.command("NAMESPACE", null);
        Namespaces namespaces = null;
        Response response = responseArray[responseArray.length - 1];
        if (response.isOK()) {
            int n = responseArray.length;
            for (int i = 0; i < n; ++i) {
                IMAPResponse iMAPResponse;
                if (!(responseArray[i] instanceof IMAPResponse) || !(iMAPResponse = (IMAPResponse)responseArray[i]).keyEquals("NAMESPACE")) continue;
                if (namespaces == null) {
                    namespaces = new Namespaces(iMAPResponse);
                }
                responseArray[i] = null;
            }
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
        return namespaces;
    }

    public Quota[] getQuotaRoot(String string) throws ProtocolException {
        if (!this.hasCapability("QUOTA")) {
            throw new BadCommandException("GETQUOTAROOT not supported");
        }
        string = BASE64MailboxEncoder.encode(string);
        Argument argument = new Argument();
        argument.writeString(string);
        Response[] responseArray = this.command("GETQUOTAROOT", argument);
        Response response = responseArray[responseArray.length - 1];
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        if (response.isOK()) {
            int n = responseArray.length;
            for (int i = 0; i < n; ++i) {
                Object object;
                if (!(responseArray[i] instanceof IMAPResponse)) continue;
                IMAPResponse iMAPResponse = (IMAPResponse)responseArray[i];
                if (iMAPResponse.keyEquals("QUOTAROOT")) {
                    iMAPResponse.readAtomString();
                    object = null;
                    while ((object = iMAPResponse.readAtomString()) != null) {
                        hashtable.put(object, new Quota((String)object));
                    }
                    responseArray[i] = null;
                    continue;
                }
                if (!iMAPResponse.keyEquals("QUOTA")) continue;
                object = this.parseQuota(iMAPResponse);
                Quota quota = (Quota)hashtable.get(((Quota)object).quotaRoot);
                if (quota == null || quota.resources != null) {
                    // empty if block
                }
                hashtable.put(((Quota)object).quotaRoot, object);
                responseArray[i] = null;
            }
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
        Quota[] quotaArray = new Quota[hashtable.size()];
        Enumeration enumeration = hashtable.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            quotaArray[n] = (Quota)enumeration.nextElement();
            ++n;
        }
        return quotaArray;
    }

    public Quota[] getQuota(String string) throws ProtocolException {
        if (!this.hasCapability("QUOTA")) {
            throw new BadCommandException("QUOTA not supported");
        }
        Argument argument = new Argument();
        argument.writeString(string);
        Response[] responseArray = this.command("GETQUOTA", argument);
        Quota quota = null;
        Vector<Quota> vector = new Vector<Quota>();
        Response response = responseArray[responseArray.length - 1];
        if (response.isOK()) {
            int n = responseArray.length;
            for (int i = 0; i < n; ++i) {
                IMAPResponse iMAPResponse;
                if (!(responseArray[i] instanceof IMAPResponse) || !(iMAPResponse = (IMAPResponse)responseArray[i]).keyEquals("QUOTA")) continue;
                quota = this.parseQuota(iMAPResponse);
                vector.addElement(quota);
                responseArray[i] = null;
            }
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
        Object[] objectArray = new Quota[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void setQuota(Quota quota) throws ProtocolException {
        if (!this.hasCapability("QUOTA")) {
            throw new BadCommandException("QUOTA not supported");
        }
        Argument argument = new Argument();
        argument.writeString(quota.quotaRoot);
        Argument argument2 = new Argument();
        if (quota.resources != null) {
            for (int i = 0; i < quota.resources.length; ++i) {
                argument2.writeAtom(quota.resources[i].name);
                argument2.writeNumber(quota.resources[i].limit);
            }
        }
        argument.writeArgument(argument2);
        Response[] responseArray = this.command("SETQUOTA", argument);
        Response response = responseArray[responseArray.length - 1];
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
    }

    private Quota parseQuota(Response response) throws ParsingException {
        String string = response.readAtomString();
        Quota quota = new Quota(string);
        response.skipSpaces();
        if (response.readByte() != 40) {
            throw new ParsingException("parse error in QUOTA");
        }
        Vector<Quota.Resource> vector = new Vector<Quota.Resource>();
        while (response.peekByte() != 41) {
            String string2 = response.readAtom();
            if (string2 == null) continue;
            long l = response.readLong();
            long l2 = response.readLong();
            Quota.Resource resource = new Quota.Resource(string2, l, l2);
            vector.addElement(resource);
        }
        response.readByte();
        quota.resources = new Quota.Resource[vector.size()];
        vector.copyInto(quota.resources);
        return quota;
    }

    public void setACL(String string, char c, ACL aCL) throws ProtocolException {
        if (!this.hasCapability("ACL")) {
            throw new BadCommandException("ACL not supported");
        }
        string = BASE64MailboxEncoder.encode(string);
        Argument argument = new Argument();
        argument.writeString(string);
        argument.writeString(aCL.getName());
        String string2 = aCL.getRights().toString();
        if (c == '+' || c == '-') {
            string2 = c + string2;
        }
        argument.writeString(string2);
        Response[] responseArray = this.command("SETACL", argument);
        Response response = responseArray[responseArray.length - 1];
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
    }

    public void deleteACL(String string, String string2) throws ProtocolException {
        if (!this.hasCapability("ACL")) {
            throw new BadCommandException("ACL not supported");
        }
        string = BASE64MailboxEncoder.encode(string);
        Argument argument = new Argument();
        argument.writeString(string);
        argument.writeString(string2);
        Response[] responseArray = this.command("DELETEACL", argument);
        Response response = responseArray[responseArray.length - 1];
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
    }

    public ACL[] getACL(String string) throws ProtocolException {
        if (!this.hasCapability("ACL")) {
            throw new BadCommandException("ACL not supported");
        }
        string = BASE64MailboxEncoder.encode(string);
        Argument argument = new Argument();
        argument.writeString(string);
        Response[] responseArray = this.command("GETACL", argument);
        Response response = responseArray[responseArray.length - 1];
        Vector<ACL> vector = new Vector<ACL>();
        if (response.isOK()) {
            int n = responseArray.length;
            for (int i = 0; i < n; ++i) {
                String string2;
                IMAPResponse iMAPResponse;
                if (!(responseArray[i] instanceof IMAPResponse) || !(iMAPResponse = (IMAPResponse)responseArray[i]).keyEquals("ACL")) continue;
                iMAPResponse.readAtomString();
                String string3 = null;
                while ((string3 = iMAPResponse.readAtom()) != null && (string2 = iMAPResponse.readAtomString()) != null) {
                    ACL aCL = new ACL(string3, new Rights(string2));
                    vector.addElement(aCL);
                }
                responseArray[i] = null;
            }
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
        Object[] objectArray = new ACL[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Rights[] listRights(String string, String string2) throws ProtocolException {
        if (!this.hasCapability("ACL")) {
            throw new BadCommandException("ACL not supported");
        }
        string = BASE64MailboxEncoder.encode(string);
        Argument argument = new Argument();
        argument.writeString(string);
        argument.writeString(string2);
        Response[] responseArray = this.command("LISTRIGHTS", argument);
        Response response = responseArray[responseArray.length - 1];
        Vector<Rights> vector = new Vector<Rights>();
        if (response.isOK()) {
            int n = responseArray.length;
            for (int i = 0; i < n; ++i) {
                String string3;
                IMAPResponse iMAPResponse;
                if (!(responseArray[i] instanceof IMAPResponse) || !(iMAPResponse = (IMAPResponse)responseArray[i]).keyEquals("LISTRIGHTS")) continue;
                iMAPResponse.readAtomString();
                iMAPResponse.readAtomString();
                while ((string3 = iMAPResponse.readAtomString()) != null) {
                    vector.addElement(new Rights(string3));
                }
                responseArray[i] = null;
            }
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
        Object[] objectArray = new Rights[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Rights myRights(String string) throws ProtocolException {
        if (!this.hasCapability("ACL")) {
            throw new BadCommandException("ACL not supported");
        }
        string = BASE64MailboxEncoder.encode(string);
        Argument argument = new Argument();
        argument.writeString(string);
        Response[] responseArray = this.command("MYRIGHTS", argument);
        Response response = responseArray[responseArray.length - 1];
        Rights rights = null;
        if (response.isOK()) {
            int n = responseArray.length;
            for (int i = 0; i < n; ++i) {
                IMAPResponse iMAPResponse;
                if (!(responseArray[i] instanceof IMAPResponse) || !(iMAPResponse = (IMAPResponse)responseArray[i]).keyEquals("MYRIGHTS")) continue;
                iMAPResponse.readAtomString();
                String string2 = iMAPResponse.readAtomString();
                if (rights == null) {
                    rights = new Rights(string2);
                }
                responseArray[i] = null;
            }
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
        return rights;
    }
}

