/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.suggestions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.apihole.tasklist.SPIHole;
import org.netbeans.modules.tasklist.providers.DocumentSuggestionProvider;
import org.netbeans.modules.tasklist.providers.SuggestionContext;
import org.netbeans.modules.tasklist.providers.SuggestionProvider;
import org.netbeans.modules.tasklist.suggestions.DefaultSuggestionManager;
import org.netbeans.modules.tasklist.suggestions.ProviderAcceptor;
import org.netbeans.modules.tasklist.suggestions.SPIMonitor;
import org.netbeans.modules.tasklist.suggestions.SuggestionImpl;
import org.netbeans.modules.tasklist.suggestions.SuggestionList;
import org.netbeans.modules.tasklist.suggestions.SuggestionProviders;
import org.netbeans.modules.tasklist.suggestions.SuggestionType;
import org.netbeans.modules.tasklist.suggestions.SuggestionTypes;
import org.netbeans.modules.tasklist.suggestions.SuggestionView;
import org.netbeans.modules.tasklist.suggestions.SuggestionsBroker;
import org.netbeans.modules.tasklist.suggestions.settings.ManagerSettings;
import org.openide.ErrorManager;
import org.openide.loaders.DataObject;
import org.openide.windows.TopComponent;

public final class SuggestionManagerImpl
extends DefaultSuggestionManager {
    private final boolean stats = System.getProperty("netbeans.tasklist.stats") != null;
    boolean running = false;
    boolean prepared = false;
    SuggestionProvider unfiltered = null;
    private SuggestionList list = null;
    private boolean switchingFiles = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean isObserved(String id) {
        TopComponent.Registry registry = TopComponent.getRegistry();
        Set opened = registry.getOpened();
        Iterator it = opened.iterator();
        while (it.hasNext()) {
            SuggestionView view;
            TopComponent next = (TopComponent)it.next();
            if (!(next instanceof SuggestionView) || !(view = (SuggestionView)next).isObserved(id)) continue;
            return true;
        }
        return false;
    }

    public void dispatchPrepare() {
        if (!this.prepared) {
            List providers = this.getProviders();
            ListIterator it = providers.listIterator();
            while (it.hasNext()) {
                SuggestionProvider provider = (SuggestionProvider)it.next();
                try {
                    provider.notifyPrepare();
                }
                catch (RuntimeException e) {
                    ErrorManager.getDefault().annotate((Throwable)e, "Skipping faulty provider (" + provider + ").");
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (Error e) {
                    ErrorManager.getDefault().annotate((Throwable)e, "Skipping faulty provider (" + provider + ").");
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
            this.prepared = true;
        }
    }

    public void dispatchRun() {
        if (!this.running) {
            if (!this.prepared) {
                this.dispatchPrepare();
            }
            List providers = this.getProviders();
            ListIterator it = providers.listIterator();
            while (it.hasNext()) {
                SuggestionProvider provider = (SuggestionProvider)it.next();
                if (this.unfiltered != null && this.unfiltered != provider) continue;
                try {
                    provider.notifyRun();
                }
                catch (RuntimeException e) {
                    ErrorManager.getDefault().annotate((Throwable)e, "Skipping faulty provider (" + provider + ").");
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (Error e) {
                    ErrorManager.getDefault().annotate((Throwable)e, "Skipping faulty provider (" + provider + ").");
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
            this.running = true;
        }
    }

    public void dispatchStop() {
        if (this.running) {
            List providers = this.getProviders();
            ListIterator it = providers.listIterator();
            while (it.hasNext()) {
                SuggestionProvider provider = (SuggestionProvider)it.next();
                if (this.unfiltered != null && this.unfiltered != provider) continue;
                try {
                    provider.notifyStop();
                }
                catch (RuntimeException e) {
                    ErrorManager.getDefault().annotate((Throwable)e, "Skipping faulty provider (" + provider + ").");
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (Error e) {
                    ErrorManager.getDefault().annotate((Throwable)e, "Skipping faulty provider (" + provider + ").");
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
            this.running = false;
        }
    }

    public void notifyViewClosed() {
        if (this.prepared) {
            if (this.running) {
                this.dispatchStop();
            }
            List providers = this.getProviders();
            ListIterator it = providers.listIterator();
            while (it.hasNext()) {
                SuggestionProvider provider = (SuggestionProvider)it.next();
                provider.notifyFinish();
            }
            this.prepared = false;
        }
    }

    public final SuggestionList getList() {
        if (this.list == null) {
            this.list = new SuggestionList();
        }
        return this.list;
    }

    public synchronized boolean isEnabled(String id) {
        ManagerSettings settings = ManagerSettings.getDefault();
        return settings != null ? settings.isEnabled(id) : true;
    }

    public synchronized void setEnabled(String id, boolean enabled, boolean dontSave) {
        SuggestionType type = SuggestionTypes.getDefault().getType(id);
        ManagerSettings.getDefault().setEnabled(id, enabled);
        this.toggleProvider(type, enabled);
        if (!dontSave) {
            this.writeTypeRegistry();
        }
    }

    private void toggleProvider(SuggestionType type, boolean enable) {
        SuggestionProvider provider = this.getProvider(type);
        if (provider == null) {
            return;
        }
        this.toggleProvider(provider, type, enable, false);
    }

    private void toggleProvider(SuggestionProvider provider, SuggestionType type, boolean enable, boolean allTypes) {
        if (enable) {
            provider.notifyPrepare();
            provider.notifyRun();
        } else {
            String typeName;
            if (!allTypes && !(typeName = provider.getType()).equals(type.getName()) && this.isEnabled(typeName)) {
                this.getList().removeCategory(type);
                return;
            }
            provider.notifyStop();
            provider.notifyFinish();
            typeName = provider.getType();
            if (this.isEnabled(typeName)) {
                this.getList().removeCategory(type);
                return;
            }
        }
    }

    public synchronized boolean isConfirm(SuggestionType type) {
        return ManagerSettings.getDefault().isConfirm(type);
    }

    synchronized void setConfirm(SuggestionType type, boolean confirm, boolean write) {
        ManagerSettings.getDefault().setConfirm(type, confirm);
        if (write) {
            this.writeTypeRegistry();
        }
    }

    public void notifyFiltered(SuggestionList tasklist, SuggestionType type) {
        Iterator it;
        List oldList;
        SuggestionType prevFilterType = this.getUnfilteredType();
        this.setUnfilteredType(type);
        if (type != null) {
            oldList = tasklist.getTasks();
            if (oldList != null) {
                ArrayList allTasks = new ArrayList(oldList.size());
                allTasks.addAll(oldList);
                tasklist.clear();
                Collection types = SuggestionTypes.getDefault().getAllTypes();
                Iterator it2 = types.iterator();
                while (it2.hasNext()) {
                    SuggestionType t = (SuggestionType)it2.next();
                    ArrayList<SuggestionImpl> list = new ArrayList<SuggestionImpl>(100);
                    Iterator all = allTasks.iterator();
                    SuggestionImpl category = tasklist.getCategoryTask(t, false);
                    tasklist.removeCategory(category, true);
                    while (all.hasNext()) {
                        SuggestionImpl sg = (SuggestionImpl)((Object)all.next());
                        if (sg.getSType() != t) continue;
                        if (sg == category && sg.hasSubtasks()) {
                            list.addAll(sg.getSubtasks());
                            continue;
                        }
                        list.add(sg);
                    }
                    this.register(t.getName(), list, null, tasklist, true);
                }
            }
        } else {
            tasklist.clearCategoryTasks();
            oldList = tasklist.getTasks();
            ArrayList suggestions = new ArrayList();
            if (oldList != null) {
                suggestions.addAll(oldList);
            }
            tasklist.clear();
            it = suggestions.iterator();
            ArrayList<SuggestionImpl> group = null;
            SuggestionType prevType = null;
            while (it.hasNext()) {
                SuggestionImpl s = (SuggestionImpl)((Object)it.next());
                if (s.getSType() != prevType) {
                    if (group != null) {
                        this.register(prevType.getName(), group, null, tasklist, true);
                        group.clear();
                    } else {
                        group = new ArrayList<SuggestionImpl>(50);
                    }
                    prevType = s.getSType();
                }
                if (group == null) {
                    group = new ArrayList(50);
                }
                group.add(s);
            }
            if (group != null && group.size() > 0) {
                this.register(prevType.getName(), group, null, tasklist, true);
            }
        }
        this.unfiltered = null;
        List providers = this.getProviders();
        SuggestionTypes suggestionTypes = SuggestionTypes.getDefault();
        it = providers.listIterator();
        while (it.hasNext()) {
            SuggestionType sg;
            SuggestionType tp;
            SuggestionProvider provider = (SuggestionProvider)it.next();
            String typeName = provider.getType();
            if (type != null) {
                boolean enabled = false;
                tp = suggestionTypes.getType(typeName);
                if (tp == type) {
                    enabled = true;
                }
                if (enabled) {
                    this.unfiltered = provider;
                    if (prevFilterType == null) continue;
                    sg = suggestionTypes.getType(typeName);
                    this.toggleProvider(provider, sg, true, true);
                    continue;
                }
                sg = suggestionTypes.getType(typeName);
                this.toggleProvider(provider, sg, false, true);
                continue;
            }
            boolean isPrev = false;
            tp = suggestionTypes.getType(typeName);
            if (prevFilterType == tp) {
                isPrev = true;
                break;
            }
            if (isPrev) continue;
            sg = suggestionTypes.getType(typeName);
            this.toggleProvider(provider, sg, true, true);
        }
    }

    public boolean isExpandedType(SuggestionType type) {
        return ManagerSettings.getDefault().isExpandedType(type);
    }

    public void setExpandedType(SuggestionType type, boolean expanded) {
        ManagerSettings.getDefault().setExpandedType(type, expanded);
    }

    public void register(String type, List add, List remove, Object request) {
        SPIMonitor.log("  Response on " + request + " " + type + " add: " + (add != null ? "" + add.size() : "null") + " remove:" + (remove != null ? "" + remove.size() : "null"));
        SuggestionList target = this.getList();
        if (target == null) {
            return;
        }
        if (type == null && add != null && remove != null) {
            this.register(type, null, remove, target, !this.switchingFiles);
            this.register(type, add, null, target, !this.switchingFiles);
        } else {
            this.register(type, add, remove, target, !this.switchingFiles);
        }
    }

    private boolean scanOnShow(DocumentSuggestionProvider provider) {
        return ManagerSettings.getDefault().isScanOnShow();
    }

    private boolean scanOnSave(DocumentSuggestionProvider provider) {
        return ManagerSettings.getDefault().isScanOnSave();
    }

    private boolean scanOnEdit(DocumentSuggestionProvider provider) {
        return ManagerSettings.getDefault().isScanOnEdit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void DELETE_dispatchRescan(Document document, DataObject dataobject, Object request, ProviderAcceptor acceptor) {
        if (!$assertionsDisabled && request == null) {
            throw new AssertionError((Object)"Precondition for SuggestionsBroker.getCurrRequest()");
        }
        if (!dataobject.isValid()) {
            return;
        }
        long start = 0L;
        long end = 0L;
        long total = 0L;
        List providers = this.getDocProviders();
        Iterator it = providers.iterator();
        SuggestionContext ctx = SPIHole.createSuggestionContext((DataObject)dataobject);
        while (it.hasNext()) {
            if (SuggestionsBroker.getDefault().getCurrRequest() != request) {
                return;
            }
            DocumentSuggestionProvider provider = (DocumentSuggestionProvider)it.next();
            if (!acceptor.accept((SuggestionProvider)provider) || this.unfiltered != null && provider != this.unfiltered) continue;
            if (this.stats) {
                start = System.currentTimeMillis();
            }
            try {
                SPIMonitor.log("Enter rescan " + request + " " + provider.getClass());
            }
            catch (RuntimeException e) {
                ErrorManager.getDefault().annotate((Throwable)e, "Skipping faulty provider (" + provider + ").");
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Error e) {
                ErrorManager.getDefault().annotate((Throwable)e, "Skipping faulty provider (" + provider + ").");
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            finally {
                SPIMonitor.log("Leave rescan " + request + " " + provider.getClass());
            }
            if (!this.stats) continue;
            end = System.currentTimeMillis();
            System.out.println("Scan time for provider " + provider.getClass().getName() + " = " + (end - start) + " ms");
            total += end - start;
        }
        if (this.stats) {
            System.out.println("TOTAL SCAN TIME = " + total + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List dispatchScan(DataObject dataobject, ProviderAcceptor acceptor) {
        if (!dataobject.isValid()) {
            return Collections.EMPTY_LIST;
        }
        long start = 0L;
        long end = 0L;
        long total = 0L;
        List providers = this.getDocProviders();
        Iterator it = providers.iterator();
        LinkedList result = new LinkedList();
        SuggestionContext ctx = SPIHole.createSuggestionContext((DataObject)dataobject);
        while (it.hasNext()) {
            DocumentSuggestionProvider provider = (DocumentSuggestionProvider)it.next();
            if (!acceptor.accept((SuggestionProvider)provider) || this.unfiltered != null && provider != this.unfiltered) continue;
            if (this.stats) {
                start = System.currentTimeMillis();
            }
            try {
                SPIMonitor.log("Enter scan " + provider.getClass());
                List found = provider.scan(ctx);
                if (found != null) {
                    result.addAll(found);
                }
            }
            catch (RuntimeException e) {
                ErrorManager.getDefault().annotate((Throwable)e, "Skipping faulty provider (" + provider + ").");
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Error e) {
                ErrorManager.getDefault().annotate((Throwable)e, "Skipping faulty provider (" + provider + ").");
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            finally {
                SPIMonitor.log("Leave rescan " + provider.getClass());
            }
            if (!this.stats) continue;
            end = System.currentTimeMillis();
            System.out.println("Scan time for provider " + provider.getClass().getName() + " = " + (end - start) + " ms");
            total += end - start;
        }
        if (this.stats) {
            System.out.println("TOTAL SCAN TIME = " + total + "\n");
        }
        return result;
    }

    void setFixing(boolean wait) {
        SuggestionsBroker.getDefault().setFixing(wait);
    }

    void editTypes(List enabled, List disabled, List confirmation) {
        SuggestionType type;
        Iterator it = enabled.iterator();
        while (it.hasNext()) {
            type = (SuggestionType)it.next();
            if (this.isEnabled(type.getName())) continue;
            this.setEnabled(type.getName(), true, true);
        }
        it = disabled.iterator();
        while (it.hasNext()) {
            type = (SuggestionType)it.next();
            if (!this.isEnabled(type.getName())) continue;
            this.setEnabled(type.getName(), false, true);
        }
        Iterator allIt = SuggestionTypes.getDefault().getAllTypes().iterator();
        while (allIt.hasNext()) {
            SuggestionType t = (SuggestionType)allIt.next();
            it = confirmation.iterator();
            boolean found = false;
            while (it.hasNext()) {
                SuggestionType type2 = (SuggestionType)it.next();
                if (type2 != t) continue;
                found = true;
                break;
            }
            this.setConfirm(t, !found, false);
        }
        this.writeTypeRegistry();
    }

    private void writeTypeRegistry() {
        ManagerSettings.getDefault().store();
    }

    private List getProviders() {
        return SuggestionProviders.getDefault().getProviders();
    }

    private List getDocProviders() {
        return SuggestionProviders.getDefault().getDocProviders();
    }

    private SuggestionProvider getProvider(SuggestionType type) {
        return SuggestionProviders.getDefault().getProvider(type);
    }

    static {
        $assertionsDisabled = !SuggestionManagerImpl.class.desiredAssertionStatus();
    }
}

