/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.netbeans.api.diff.Difference;

public class HuntDiff {
    private HuntDiff() {
    }

    public static Difference[] diff(String[] lines1, String[] lines2) {
        int m = lines1.length;
        int n = lines2.length;
        Line[] l2s = new Line[n + 1];
        for (int i = 1; i <= n; ++i) {
            l2s[i] = new Line(i, lines2[i - 1]);
        }
        Arrays.sort(l2s, 1, n + 1, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Line)o1).line.compareTo(((Line)o2).line);
            }

            public boolean equals(Object obj) {
                return obj == this;
            }
        });
        int[] equvalenceLines = new int[n + 1];
        boolean[] equivalence = new boolean[n + 1];
        for (int i = 1; i <= n; ++i) {
            Line l = l2s[i];
            equvalenceLines[i] = l.lineNo;
            equivalence[i] = i == n || !l.line.equals(l2s[i + 1].line);
        }
        equvalenceLines[0] = 0;
        equivalence[0] = true;
        int[] equivalenceAssoc = new int[m + 1];
        for (int i = 1; i <= m; ++i) {
            equivalenceAssoc[i] = HuntDiff.findAssoc(lines1[i - 1], l2s, equivalence);
        }
        l2s = null;
        Candidate[] K = new Candidate[Math.min(m, n) + 2];
        K[0] = new Candidate(0, 0, null);
        K[1] = new Candidate(m + 1, n + 1, null);
        int k = 0;
        for (int i = 1; i <= m; ++i) {
            if (equivalenceAssoc[i] == 0) continue;
            k = HuntDiff.merge(K, k, i, equvalenceLines, equivalence, equivalenceAssoc[i]);
        }
        int[] J = new int[m + 2];
        Candidate c = K[k];
        while (c != null) {
            J[((Candidate)c).a] = c.b;
            c = c.c;
        }
        List differences = HuntDiff.getDifferences(J, lines1, lines2);
        HuntDiff.cleanup(differences);
        return differences.toArray(new Difference[0]);
    }

    private static int findAssoc(String line1, Line[] l2s, boolean[] equivalence) {
        for (int j = 1; j < l2s.length; ++j) {
            if (!equivalence[j - 1] || !line1.equals(l2s[j].line)) continue;
            return j;
        }
        return 0;
    }

    private static int merge(Candidate[] K, int k, int i, int[] equvalenceLines, boolean[] equivalence, int p) {
        int r = 0;
        Candidate c = K[0];
        while (true) {
            int s;
            int j = equvalenceLines[p];
            for (s = r; s <= k && (K[s].b >= j || K[s + 1].b <= j); ++s) {
            }
            if (s <= k) {
                if (K[s + 1].b > j) {
                    Candidate newc = new Candidate(i, j, K[s]);
                    K[r] = c;
                    r = s + 1;
                    c = newc;
                }
                if (s == k) {
                    K[k + 2] = K[k + 1];
                    ++k;
                    break;
                }
            }
            if (equivalence[p]) break;
            ++p;
        }
        K[r] = c;
        return k;
    }

    private static List getDifferences(int[] J, String[] lines1, String[] lines2) {
        ArrayList<Difference> differences = new ArrayList<Difference>();
        int n = lines1.length;
        int m = lines2.length;
        int start1 = 1;
        int start2 = 1;
        while (true) {
            if (start1 <= n && J[start1] == start2) {
                ++start1;
                ++start2;
                continue;
            }
            if (start1 > n) break;
            if (J[start1] < start2) {
                int end1;
                StringBuffer deletedText = new StringBuffer();
                deletedText.append(lines1[start1 - 1]).append('\n');
                for (end1 = start1 + 1; end1 <= n && J[end1] < start2; ++end1) {
                    String line = lines1[end1 - 1];
                    deletedText.append(line).append('\n');
                }
                differences.add(new Difference(0, start1, end1 - 1, start2 - 1, 0, deletedText.toString(), null));
                start1 = end1;
            } else {
                int end2 = J[start1];
                StringBuffer addedText = new StringBuffer();
                for (int i = start2; i < end2; ++i) {
                    String line = lines2[i - 1];
                    addedText.append(line).append('\n');
                }
                differences.add(new Difference(1, start1 - 1, 0, start2, end2 - 1, null, addedText.toString()));
                start2 = end2;
            }
            if (start1 > n) break;
        }
        if (start2 <= m) {
            differences.add(new Difference(1, n, 0, start2, m, null, null));
        }
        return differences;
    }

    private static void cleanup(List diffs) {
        Difference last = null;
        for (int i = 0; i < diffs.size(); ++i) {
            Difference diff = (Difference)diffs.get(i);
            if (last != null && (diff.getType() == 1 && last.getType() == 0 || diff.getType() == 0 && last.getType() == 1)) {
                Difference del;
                Difference add;
                if (1 == diff.getType()) {
                    add = diff;
                    del = last;
                } else {
                    add = last;
                    del = diff;
                }
                int d1f1l1 = add.getFirstStart() - (del.getFirstEnd() - del.getFirstStart());
                int d2f1l1 = del.getFirstStart();
                if (d1f1l1 == d2f1l1) {
                    int d1f2l1 = add.getSecondStart() - (del.getFirstEnd() - del.getFirstStart());
                    int d2f2l1 = del.getSecondStart() + 1;
                    Difference newDiff = new Difference(2, d1f1l1, del.getFirstEnd(), add.getSecondStart(), add.getSecondEnd(), del.getFirstText(), add.getSecondText());
                    diffs.set(i - 1, newDiff);
                    diffs.remove(i);
                    --i;
                    diff = newDiff;
                }
            }
            last = diff;
        }
    }

    private static class Candidate {
        private int a;
        private int b;
        private Candidate c;

        public Candidate(int a, int b, Candidate c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }
    }

    private static class Line {
        public int lineNo;
        public String line;
        public int hash;

        public Line(int lineNo, String line) {
            this.lineNo = lineNo;
            this.line = line;
            this.hash = line.hashCode();
        }
    }
}

