/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.classpath.support.ProjectClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Element;

public final class ClassPathProviderImpl
implements ClassPathProvider {
    private final NbModuleProject project;
    private ClassPath boot;
    private ClassPath source;
    private ClassPath compile;
    private ClassPath execute;
    private ClassPath testSource;
    private ClassPath testCompile;
    private ClassPath testExecute;
    private ClassPath funcTestSource;
    private ClassPath funcTestCompile;
    private ClassPath funcTestExecute;
    private Map extraCompilationUnitsCompile = null;
    private Map extraCompilationUnitsExecute = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ClassPathProviderImpl(NbModuleProject project) {
        this.project = project;
    }

    public ClassPath findClassPath(FileObject file, String type) {
        if (type.equals("classpath/boot")) {
            if (this.boot == null) {
                this.boot = ClassPathFactory.createClassPath((ClassPathImplementation)this.createPathFromProperty("nbjdk.bootclasspath"));
            }
            return this.boot;
        }
        FileObject srcDir = this.project.getSourceDirectory();
        FileObject testSrcDir = this.project.getTestSourceDirectory();
        FileObject funcTestSrcDir = this.project.getFunctionalTestSourceDirectory();
        File dir = this.project.getClassesDirectory();
        FileObject classesDir = dir == null ? null : FileUtil.toFileObject((File)FileUtil.normalizeFile((File)dir));
        dir = this.project.getTestClassesDirectory();
        FileObject testClassesDir = dir == null ? null : FileUtil.toFileObject((File)FileUtil.normalizeFile((File)dir));
        File moduleJar = this.project.getModuleJarLocation();
        if (srcDir != null && (FileUtil.isParentOf((FileObject)srcDir, (FileObject)file) || file == srcDir)) {
            if (type.equals("classpath/compile")) {
                if (this.compile == null) {
                    this.compile = ClassPathFactory.createClassPath((ClassPathImplementation)this.createCompileClasspath());
                    Util.err.log("compile/execute-time classpath for " + this.project + ": " + this.compile);
                }
                return this.compile;
            }
            if (type.equals("classpath/execute")) {
                if (this.execute == null) {
                    this.execute = ClassPathFactory.createClassPath((ClassPathImplementation)this.createExecuteClasspath());
                }
                return this.execute;
            }
            if (type.equals("classpath/source")) {
                if (this.source == null) {
                    this.source = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{srcDir});
                }
                return this.source;
            }
        } else if (testSrcDir != null && (FileUtil.isParentOf((FileObject)testSrcDir, (FileObject)file) || file == testSrcDir)) {
            if (type.equals("classpath/compile")) {
                if (this.testCompile == null) {
                    this.testCompile = ClassPathFactory.createClassPath((ClassPathImplementation)this.createTestCompileClasspath());
                    Util.err.log("compile-time classpath for tests in " + this.project + ": " + this.testCompile);
                }
                return this.testCompile;
            }
            if (type.equals("classpath/execute")) {
                if (this.testExecute == null) {
                    this.testExecute = ClassPathFactory.createClassPath((ClassPathImplementation)this.createTestExecuteClasspath());
                    Util.err.log("runtime classpath for tests in " + this.project + ": " + this.testExecute);
                }
                return this.testExecute;
            }
            if (type.equals("classpath/source")) {
                if (this.testSource == null) {
                    this.testSource = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{testSrcDir});
                }
                return this.testSource;
            }
        } else if (funcTestSrcDir != null && (FileUtil.isParentOf((FileObject)funcTestSrcDir, (FileObject)file) || file == funcTestSrcDir)) {
            if (type.equals("classpath/source")) {
                if (this.funcTestSource == null) {
                    this.funcTestSource = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{funcTestSrcDir});
                }
                return this.funcTestSource;
            }
            if (type.equals("classpath/compile")) {
                if (this.funcTestCompile == null) {
                    this.funcTestCompile = ClassPathFactory.createClassPath((ClassPathImplementation)this.createFuncTestCompileClasspath());
                    Util.err.log("compile-time classpath for func tests in " + this.project + ": " + this.funcTestCompile);
                }
                return this.funcTestCompile;
            }
            if (type.equals("classpath/execute")) {
                if (this.funcTestExecute == null) {
                    this.funcTestExecute = ClassPathFactory.createClassPath((ClassPathImplementation)this.createFuncTestExecuteClasspath());
                }
                return this.funcTestExecute;
            }
        } else if (classesDir != null && (classesDir.equals(file) || FileUtil.isParentOf((FileObject)classesDir, (FileObject)file))) {
            if ("classpath/execute".equals(type)) {
                try {
                    ArrayList<PathResourceImplementation> roots = new ArrayList<PathResourceImplementation>();
                    roots.add(ClassPathSupport.createResource((URL)classesDir.getURL()));
                    roots.addAll(this.createCompileClasspath().getResources());
                    return ClassPathSupport.createClassPath(roots);
                }
                catch (FileStateInvalidException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                    return null;
                }
            }
        } else if (testClassesDir != null && (testClassesDir.equals(file) || FileUtil.isParentOf((FileObject)testClassesDir, (FileObject)file))) {
            if ("classpath/execute".equals(type)) {
                if (this.testExecute == null) {
                    this.testExecute = ClassPathFactory.createClassPath((ClassPathImplementation)this.createTestExecuteClasspath());
                    Util.err.log("runtime classpath for tests in " + this.project + ": " + this.testExecute);
                }
                return this.testExecute;
            }
        } else if (FileUtil.getArchiveFile((FileObject)file) != null && FileUtil.toFile((FileObject)FileUtil.getArchiveFile((FileObject)file)).equals(moduleJar) && file.equals(FileUtil.getArchiveRoot((FileObject)FileUtil.getArchiveFile((FileObject)file)))) {
            if ("classpath/execute".equals(type)) {
                ArrayList<PathResourceImplementation> roots = new ArrayList<PathResourceImplementation>();
                roots.add(ClassPathSupport.createResource((URL)Util.urlForJar(moduleJar)));
                roots.addAll(this.createCompileClasspath().getResources());
                return ClassPathSupport.createClassPath(roots);
            }
        } else {
            this.calculateExtraCompilationUnits();
            Iterator it = this.extraCompilationUnitsCompile.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                FileObject pkgroot = (FileObject)entry.getKey();
                if (!FileUtil.isParentOf((FileObject)pkgroot, (FileObject)file) && file != pkgroot) continue;
                if (type.equals("classpath/compile")) {
                    return (ClassPath)entry.getValue();
                }
                if (type.equals("classpath/execute")) {
                    return (ClassPath)this.extraCompilationUnitsExecute.get(pkgroot);
                }
                if (!type.equals("classpath/source")) break;
                return ClassPathSupport.createClassPath((FileObject[])new FileObject[]{pkgroot});
            }
        }
        return null;
    }

    private ClassPathImplementation createPathFromProperty(String prop) {
        return ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (PropertyEvaluator)this.project.evaluator(), (String[])new String[]{prop});
    }

    private ClassPathImplementation createCompileClasspath() {
        return this.createPathFromProperty("cp");
    }

    private void addPathFromProjectEvaluated(List entries, String path) {
        if (path != null) {
            String[] pieces = PropertyUtils.tokenizePath((String)path);
            for (int i = 0; i < pieces.length; ++i) {
                entries.add(ClassPathSupport.createResource((URL)Util.urlForDirOrJar(this.project.getHelper().resolveFile(pieces[i]))));
            }
        }
    }

    private ClassPathImplementation createTestCompileClasspath() {
        return this.createPathFromProperty("test.unit.cp");
    }

    private ClassPathImplementation createTestExecuteClasspath() {
        return this.createPathFromProperty("test.unit.run.cp");
    }

    private ClassPathImplementation createFuncTestCompileClasspath() {
        return this.createPathFromProperty("test.qa-functional.cp");
    }

    private ClassPathImplementation createFuncTestExecuteClasspath() {
        return this.createPathFromProperty("test.qa-functional.run.cp");
    }

    private ClassPathImplementation createExecuteClasspath() {
        return this.createPathFromProperty("run.cp");
    }

    private void calculateExtraCompilationUnits() {
        if (this.extraCompilationUnitsCompile != null) {
            return;
        }
        this.extraCompilationUnitsCompile = new HashMap();
        this.extraCompilationUnitsExecute = new HashMap();
        Iterator ecus = this.project.getExtraCompilationUnits().entrySet().iterator();
        while (ecus.hasNext()) {
            Map.Entry entry = ecus.next();
            FileObject pkgroot = (FileObject)entry.getKey();
            Element pkgrootEl = (Element)entry.getValue();
            Element classpathEl = Util.findElement(pkgrootEl, "classpath", "http://www.netbeans.org/ns/nb-module-project/2");
            if (!$assertionsDisabled && classpathEl == null) {
                throw new AssertionError((Object)("no <classpath> in " + pkgrootEl));
            }
            String classpathS = Util.findText(classpathEl);
            if (classpathS == null) {
                this.extraCompilationUnitsCompile.put(pkgroot, ClassPathSupport.createClassPath((URL[])new URL[0]));
                this.extraCompilationUnitsExecute.put(pkgroot, ClassPathSupport.createClassPath((URL[])new URL[0]));
                continue;
            }
            String classpathEval = this.project.evaluator().evaluate(classpathS);
            ArrayList entries = new ArrayList();
            this.addPathFromProjectEvaluated(entries, classpathEval);
            this.extraCompilationUnitsCompile.put(pkgroot, ClassPathSupport.createClassPath(entries));
            entries = new ArrayList(entries);
            Iterator pkgrootKids = Util.findSubElements(pkgrootEl).iterator();
            while (pkgrootKids.hasNext()) {
                Element kid = (Element)pkgrootKids.next();
                if (!kid.getLocalName().equals("built-to")) continue;
                String rawtext = Util.findText(kid);
                if (!$assertionsDisabled && rawtext == null) {
                    throw new AssertionError((Object)("Null content for <built-to> in " + this.project));
                }
                String text = this.project.evaluator().evaluate(rawtext);
                if (text == null) continue;
                this.addPathFromProjectEvaluated(entries, text);
            }
            this.extraCompilationUnitsExecute.put(pkgroot, ClassPathSupport.createClassPath(entries));
        }
    }

    public ClassPath[] getProjectClassPaths(String type) {
        FileObject srcDir;
        if ("classpath/boot".equals(type) && (srcDir = this.project.getSourceDirectory()) != null) {
            return new ClassPath[]{this.findClassPath(srcDir, "classpath/boot")};
        }
        ArrayList<Object> paths = new ArrayList<Object>(3);
        if ("classpath/compile".equals(type)) {
            FileObject funcTestSrcDir;
            FileObject testSrcDir;
            FileObject srcDir2 = this.project.getSourceDirectory();
            if (srcDir2 != null) {
                paths.add(this.findClassPath(srcDir2, "classpath/compile"));
            }
            if ((testSrcDir = this.project.getTestSourceDirectory()) != null) {
                paths.add(this.findClassPath(testSrcDir, "classpath/compile"));
            }
            if ((funcTestSrcDir = this.project.getFunctionalTestSourceDirectory()) != null) {
                paths.add(this.findClassPath(funcTestSrcDir, "classpath/compile"));
            }
            this.calculateExtraCompilationUnits();
            paths.addAll(this.extraCompilationUnitsCompile.values());
        } else if ("classpath/execute".equals(type)) {
            FileObject funcTestSrcDir;
            FileObject testSrcDir;
            FileObject srcDir3 = this.project.getSourceDirectory();
            if (srcDir3 != null) {
                paths.add(this.findClassPath(srcDir3, "classpath/execute"));
            }
            if ((testSrcDir = this.project.getTestSourceDirectory()) != null) {
                paths.add(this.findClassPath(testSrcDir, "classpath/execute"));
            }
            if ((funcTestSrcDir = this.project.getFunctionalTestSourceDirectory()) != null) {
                paths.add(this.findClassPath(funcTestSrcDir, "classpath/execute"));
            }
            this.calculateExtraCompilationUnits();
            paths.addAll(this.extraCompilationUnitsExecute.values());
        } else if ("classpath/source".equals(type)) {
            FileObject funcTestSrcDir;
            FileObject testSrcDir;
            FileObject srcDir4 = this.project.getSourceDirectory();
            if (srcDir4 != null) {
                paths.add(this.findClassPath(srcDir4, "classpath/source"));
            }
            if ((testSrcDir = this.project.getTestSourceDirectory()) != null) {
                paths.add(this.findClassPath(testSrcDir, "classpath/source"));
            }
            if ((funcTestSrcDir = this.project.getFunctionalTestSourceDirectory()) != null) {
                paths.add(this.findClassPath(funcTestSrcDir, "classpath/source"));
            }
            this.calculateExtraCompilationUnits();
            Iterator it = this.extraCompilationUnitsCompile.keySet().iterator();
            while (it.hasNext()) {
                paths.add(ClassPathSupport.createClassPath((FileObject[])new FileObject[]{(FileObject)it.next()}));
            }
        }
        return paths.toArray(new ClassPath[paths.size()]);
    }

    static {
        $assertionsDisabled = !ClassPathProviderImpl.class.desiredAssertionStatus();
    }
}

