/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveClassRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.ParametersPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.ui.MoveClassPanel;
import org.netbeans.modules.refactoring.ui.RefactoringUIBypass;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;

public class MoveClassUI
implements RefactoringUI,
RefactoringUIBypass {
    private JavaDataObject javaObject;
    private Resource resource;
    private JavaClass mainSourceClass;
    private MoveClassPanel panel;
    private MoveClassRefactoring refactoring;
    private String targetPkgName = "";
    private boolean disable;
    private JavaClass clazz = null;
    private FileObject targetFolder;
    private PasteType pasteType;

    static final String getString(String key) {
        return NbBundle.getMessage((Class)MoveClassUI.class, (String)key);
    }

    public MoveClassUI(JavaClass sourceClass) {
        this.resource = sourceClass.getResource();
        DataObject ob = JavaMetamodel.getManager().getDataObject(this.resource);
        if (ob instanceof JavaDataObject) {
            this.javaObject = (JavaDataObject)ob;
        }
        this.clazz = sourceClass;
        this.findMainClass();
    }

    public MoveClassUI(JavaDataObject javaObject) {
        this(javaObject, null, null);
    }

    public MoveClassUI(JavaDataObject javaObject, FileObject targetFolder, PasteType pasteType) {
        this.disable = targetFolder != null;
        this.targetFolder = targetFolder;
        this.javaObject = javaObject;
        this.pasteType = pasteType;
        this.resource = JavaModel.getResource((FileObject)javaObject.getPrimaryFile());
        this.findMainClass();
    }

    public String getName() {
        return MoveClassUI.getString("LBL_MoveClass");
    }

    public String getDescription() {
        if (this.mainSourceClass == null) {
            return new MessageFormat(MoveClassUI.getString("DSC_MoveClass")).format(new Object[]{this.javaObject.getName(), this.packageName()});
        }
        if (this.mainSourceClass.isValid()) {
            return new MessageFormat(MoveClassUI.getString("DSC_MoveClass")).format(new Object[]{this.mainSourceClass.getName(), this.packageName()});
        }
        return "";
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ParametersPanel parent) {
        if (this.panel == null) {
            ClassPath cp;
            String pkgName = null;
            if (this.targetFolder != null && (cp = ClassPath.getClassPath((FileObject)this.targetFolder, (String)"classpath/source")) != null) {
                pkgName = cp.getResourceName(this.targetFolder, '.', false);
            }
            this.panel = new MoveClassPanel(parent, pkgName != null ? pkgName : MoveClassUI.getResPackageName(this.mainSourceClass), new MessageFormat(MoveClassUI.getString("LBL_MoveClassNamed")).format(new Object[]{this.mainSourceClass == null ? "" : this.mainSourceClass.getName()}), (FileObject)(this.targetFolder != null ? this.targetFolder : (this.javaObject != null ? this.javaObject.getPrimaryFile() : null)));
            this.panel.setCombosEnabled(!this.disable);
        }
        return this.panel;
    }

    private static String getResPackageName(JavaClass cl) {
        if (cl == null) {
            return "";
        }
        Resource res = (Resource)cl.refImmediateComposite();
        String name = res.getName();
        int index = name.lastIndexOf(47);
        if (index == -1) {
            return "";
        }
        return name.substring(0, index).replace('/', '.');
    }

    private void findMainClass() {
        this.mainSourceClass = null;
        List list = this.resource.getClassifiers();
        int size = list.size();
        if (size == 0) {
            return;
        }
        if (size == 1) {
            this.mainSourceClass = (JavaClass)list.get(0);
            return;
        }
        String resName = this.resource.getName();
        int index_1 = resName.lastIndexOf(47);
        int index_2 = resName.indexOf(46);
        String mainClassName = null;
        if (index_2 > -1) {
            mainClassName = resName.substring(index_1 + 1, index_2);
        }
        Iterator iter = list.iterator();
        for (int x = 0; x < size; ++x) {
            JavaClass jc = (JavaClass)iter.next();
            if (mainClassName != null && mainClassName.equals(jc.getName())) {
                this.mainSourceClass = jc;
                return;
            }
            if ((jc.getModifiers() & 1) <= 0) continue;
            this.mainSourceClass = jc;
        }
        if (this.mainSourceClass == null) {
            this.mainSourceClass = (JavaClass)list.get(0);
        }
    }

    private String packageName() {
        return this.targetPkgName.trim().length() == 0 ? MoveClassUI.getString("LBL_DefaultPackage") : this.targetPkgName.trim();
    }

    private Problem setParameters(boolean checkOnly) {
        if (this.panel == null) {
            return null;
        }
        this.targetPkgName = this.panel.getPackageName();
        this.refactoring.setTargetPackageName(this.targetPkgName);
        this.refactoring.setTargetClassPathRoot(this.panel.getRootFolder());
        if (checkOnly) {
            return this.refactoring.fastCheckParameters();
        }
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        return this.setParameters(true);
    }

    public Problem setParameters() {
        return this.setParameters(false);
    }

    public AbstractRefactoring getRefactoring() {
        if (this.refactoring == null) {
            LinkedList<Resource> list = new LinkedList<Resource>();
            list.add(this.resource);
            this.refactoring = this.clazz != null ? new MoveClassRefactoring(this.clazz) : new MoveClassRefactoring(list);
        }
        return this.refactoring;
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(MoveClassUI.class);
    }

    public boolean isRefactoringBypassRequired() {
        return !this.panel.isUpdateReferences();
    }

    public void doRefactoringBypass() throws IOException {
        this.pasteType.paste();
    }
}

