/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.models;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.debugger.ui.actions.AddBreakpointAction;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class BreakpointsActionsProvider
implements NodeActionsProvider {
    private static final Action NEW_BREEAKPOINT_ACTION = new AbstractAction(NbBundle.getBundle((Class)BreakpointsActionsProvider.class).getString("CTL_BreakpointAction_New_Label")){

        public void actionPerformed(ActionEvent e) {
            new AddBreakpointAction().actionPerformed(null);
        }
    };
    private static final Action ENABLE_ALL_ACTION = new AbstractAction(NbBundle.getBundle((Class)BreakpointsActionsProvider.class).getString("CTL_BreakpointAction_EnableAll_Label")){

        public void actionPerformed(ActionEvent e) {
            DebuggerManager dm = DebuggerManager.getDebuggerManager();
            Breakpoint[] bs = dm.getBreakpoints();
            int k = bs.length;
            for (int i = 0; i < k; ++i) {
                bs[i].enable();
            }
        }
    };
    private static final Action DISABLE_ALL_ACTION = new AbstractAction(NbBundle.getBundle((Class)BreakpointsActionsProvider.class).getString("CTL_BreakpointAction_DisableAll_Label")){

        public void actionPerformed(ActionEvent e) {
            DebuggerManager dm = DebuggerManager.getDebuggerManager();
            Breakpoint[] bs = dm.getBreakpoints();
            int k = bs.length;
            for (int i = 0; i < k; ++i) {
                bs[i].disable();
            }
        }
    };
    private static final Action DELETE_ALL_ACTION = new AbstractAction(NbBundle.getBundle((Class)BreakpointsActionsProvider.class).getString("CTL_BreakpointAction_DeleteAll_Label")){

        public void actionPerformed(ActionEvent e) {
            DebuggerManager dm = DebuggerManager.getDebuggerManager();
            Breakpoint[] bs = dm.getBreakpoints();
            int k = bs.length;
            for (int i = 0; i < k; ++i) {
                dm.removeBreakpoint(bs[i]);
            }
        }
    };
    private static final Action ENABLE_ACTION = Models.createAction((String)NbBundle.getBundle((Class)BreakpointsActionsProvider.class).getString("CTL_BreakpointAction_Enable_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return true;
        }

        public void perform(Object[] nodes) {
            int k = nodes.length;
            for (int i = 0; i < k; ++i) {
                ((Breakpoint)nodes[i]).enable();
            }
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private static final Action DISABLE_ACTION = Models.createAction((String)NbBundle.getBundle((Class)BreakpointsActionsProvider.class).getString("CTL_BreakpointAction_Disable_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return true;
        }

        public void perform(Object[] nodes) {
            int k = nodes.length;
            for (int i = 0; i < k; ++i) {
                ((Breakpoint)nodes[i]).disable();
            }
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private static final Action DELETE_ACTION = Models.createAction((String)NbBundle.getBundle((Class)BreakpointsActionsProvider.class).getString("CTL_BreakpointAction_Delete_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return true;
        }

        public void perform(Object[] nodes) {
            DebuggerManager dm = DebuggerManager.getDebuggerManager();
            int k = nodes.length;
            for (int i = 0; i < k; ++i) {
                dm.removeBreakpoint((Breakpoint)nodes[i]);
            }
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private static final Action SET_GROUP_NAME_ACTION;
    private static final Action DELETE_ALL_ACTION_S;
    private static final Action ENABLE_ALL_ACTION_S;
    private static final Action DISABLE_ALL_ACTION_S;

    public Action[] getActions(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return new Action[]{NEW_BREEAKPOINT_ACTION, null, ENABLE_ALL_ACTION, DISABLE_ALL_ACTION, DELETE_ALL_ACTION, null};
        }
        if (node instanceof String) {
            return new Action[]{SET_GROUP_NAME_ACTION, null, ENABLE_ALL_ACTION_S, DISABLE_ALL_ACTION_S, DELETE_ALL_ACTION_S, null};
        }
        if (node instanceof Breakpoint) {
            if (((Breakpoint)node).isEnabled()) {
                return new Action[]{DISABLE_ACTION, DELETE_ACTION, SET_GROUP_NAME_ACTION, null, NEW_BREEAKPOINT_ACTION, null, ENABLE_ALL_ACTION, DISABLE_ALL_ACTION, DELETE_ALL_ACTION, null};
            }
            return new Action[]{ENABLE_ACTION, DELETE_ACTION, SET_GROUP_NAME_ACTION, null, NEW_BREEAKPOINT_ACTION, null, ENABLE_ALL_ACTION, DISABLE_ALL_ACTION, DELETE_ALL_ACTION, null};
        }
        throw new UnknownTypeException(node);
    }

    public void performDefaultAction(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return;
        }
        if (node instanceof String) {
            return;
        }
        if (node instanceof Breakpoint) {
            return;
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }

    private static void setGroupName(Object[] nodes) {
        NotifyDescriptor.InputLine descriptor = new NotifyDescriptor.InputLine(NbBundle.getBundle((Class)BreakpointsActionsProvider.class).getString("CTL_BreakpointAction_GroupDialog_NameLabel"), NbBundle.getBundle((Class)BreakpointsActionsProvider.class).getString("CTL_BreakpointAction_GroupDialog_Title"));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == NotifyDescriptor.OK_OPTION) {
            if (nodes[0] instanceof String) {
                String oldName = (String)nodes[0];
                Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
                int jj = bs.length;
                for (int j = 0; j < jj; ++j) {
                    if (!bs[j].getGroupName().equals(oldName)) continue;
                    bs[j].setGroupName(descriptor.getInputText());
                }
                return;
            }
            int k = nodes.length;
            for (int i = 0; i < k; ++i) {
                ((Breakpoint)nodes[i]).setGroupName(descriptor.getInputText());
            }
        }
    }

    static {
        DELETE_ACTION.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
        SET_GROUP_NAME_ACTION = Models.createAction((String)NbBundle.getBundle((Class)BreakpointsActionsProvider.class).getString("CTL_BreakpointAction_SetGroupName_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object node) {
                return true;
            }

            public void perform(Object[] nodes) {
                BreakpointsActionsProvider.setGroupName(nodes);
            }
        }, (int)Models.MULTISELECTION_TYPE_ALL);
        DELETE_ALL_ACTION_S = Models.createAction((String)NbBundle.getBundle((Class)BreakpointsActionsProvider.class).getString("CTL_BreakpointAction_DeleteAll_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object node) {
                return true;
            }

            public void perform(Object[] nodes) {
                String groupName = (String)nodes[0];
                DebuggerManager dm = DebuggerManager.getDebuggerManager();
                Breakpoint[] bs = dm.getBreakpoints();
                int k = bs.length;
                for (int i = 0; i < k; ++i) {
                    if (!bs[i].getGroupName().equals(groupName)) continue;
                    dm.removeBreakpoint(bs[i]);
                }
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
        ENABLE_ALL_ACTION_S = Models.createAction((String)NbBundle.getBundle((Class)BreakpointsActionsProvider.class).getString("CTL_BreakpointAction_EnableAll_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object node) {
                return true;
            }

            public void perform(Object[] nodes) {
                String groupName = (String)nodes[0];
                Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
                int k = bs.length;
                for (int i = 0; i < k; ++i) {
                    if (!bs[i].getGroupName().equals(groupName)) continue;
                    bs[i].enable();
                }
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
        DISABLE_ALL_ACTION_S = Models.createAction((String)NbBundle.getBundle((Class)BreakpointsActionsProvider.class).getString("CTL_BreakpointAction_DisableAll_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object node) {
                return true;
            }

            public void perform(Object[] nodes) {
                String groupName = (String)nodes[0];
                Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
                int k = bs.length;
                for (int i = 0; i < k; ++i) {
                    if (!bs[i].getGroupName().equals(groupName)) continue;
                    bs[i].disable();
                }
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }
}

