/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.nodes;

import java.util.List;
import java.util.regex.Pattern;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.NodeImpl;
import org.netbeans.modules.xml.xdm.nodes.Token;
import org.netbeans.modules.xml.xdm.nodes.TokenType;
import org.netbeans.modules.xml.xdm.visitor.XMLNodeVisitor;

public class Text
extends NodeImpl
implements Node,
org.w3c.dom.Text {
    private static final Pattern AMPERSAND_PATTERN = Pattern.compile("&amp;");
    private static final Pattern LESS_THAN_PATTERN = Pattern.compile("&lt;");
    private static final Pattern GREATER_THAN_PATTERN = Pattern.compile("&gt;");

    public void accept(XMLNodeVisitor visitor) {
        visitor.visit(this);
    }

    Text() {
    }

    Text(String text) {
        this();
        this.setText(text);
    }

    public String getNodeValue() {
        return this.getText();
    }

    public short getNodeType() {
        return 3;
    }

    public String getNodeName() {
        return "#text";
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getText() {
        StringBuilder txtBuf = new StringBuilder();
        for (Token token : this.getTokens()) {
            if (token.getType() != TokenType.TOKEN_CHARACTER_DATA) continue;
            txtBuf.append(token.getValue());
        }
        return this.removeEntityReference(txtBuf.toString());
    }

    public void setText(String text) {
        this.checkNotInTree();
        List<Token> tokens = this.getTokensForWrite();
        if (!tokens.isEmpty()) {
            tokens.clear();
        }
        if (text == null) {
            text = "";
        }
        text = this.insertEntityReference(text);
        tokens.add(Token.create(text, TokenType.TOKEN_CHARACTER_DATA));
    }

    public boolean isElementContentWhitespace() {
        return false;
    }

    public int getLength() {
        return -1;
    }

    public org.w3c.dom.Text replaceWholeText(String content) {
        return null;
    }

    public org.w3c.dom.Text splitText(int offset) {
        return null;
    }

    public String getWholeText() {
        return null;
    }

    public void setData(String text) {
        this.checkNotInTree();
        List<Token> tokens = this.getTokensForWrite();
        if (!tokens.isEmpty()) {
            tokens.clear();
        }
        if (text == null) {
            text = "";
        }
        tokens.add(Token.create(text, TokenType.TOKEN_CHARACTER_DATA));
    }

    public void appendData(String arg) {
    }

    public void replaceData(int offset, int count, String arg) {
    }

    public void insertData(int offset, String arg) {
    }

    public String substringData(int offset, int count) {
        return null;
    }

    public String getData() {
        StringBuilder txtBuf = new StringBuilder();
        for (Token token : this.getTokens()) {
            if (token.getType() != TokenType.TOKEN_CHARACTER_DATA) continue;
            txtBuf.append(token.getValue());
        }
        return txtBuf.toString();
    }

    public void deleteData(int offset, int count) {
    }

    private String insertEntityReference(String text) {
        String result = this.removeEntityReference(text);
        result = result.replaceAll("&", "&amp;");
        result = result.replaceAll("<", "&lt;");
        result = result.replaceAll(">", "&gt;");
        return result;
    }

    private String removeEntityReference(String text) {
        String result = text;
        result = AMPERSAND_PATTERN.matcher(result).replaceAll("&");
        result = LESS_THAN_PATTERN.matcher(result).replaceAll("<");
        result = GREATER_THAN_PATTERN.matcher(result).replaceAll(">");
        return result;
    }
}

