/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.modules.xml.xdm.nodes.Attribute;
import org.netbeans.modules.xml.xdm.nodes.CData;
import org.netbeans.modules.xml.xdm.nodes.Comment;
import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.Element;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.NodeImpl;
import org.netbeans.modules.xml.xdm.nodes.Text;
import org.netbeans.modules.xml.xdm.nodes.Token;
import org.netbeans.modules.xml.xdm.nodes.TokenType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLSyntaxParser {
    public Document parse(BaseDocument basedoc) throws IOException, BadLocationException {
        ExtSyntaxSupport sup = (ExtSyntaxSupport)basedoc.getSyntaxSupport();
        TokenItem token = sup.getTokenChain(0, basedoc.getLength());
        Stack<NodeImpl> stack = new Stack<NodeImpl>();
        Document doc = new Document();
        stack.push(doc);
        NodeImpl currentNode = doc;
        ArrayList<Token> currentTokens = new ArrayList<Token>();
        if (this.isValid(token) && token.getTokenID().getNumericID() == 1) {
            currentTokens.add(Token.create(token.getImage(), TokenType.TOKEN_CHARACTER_DATA));
            token = token.getNext();
            if (this.isValid(token) && token.getTokenID().getNumericID() != 13) {
                currentNode.setTokens(new ArrayList<Token>(currentTokens));
                currentTokens.clear();
            }
        }
        block15: while (token != null) {
            this.isValid(token);
            TokenID tokenId = token.getTokenID();
            int numericId = tokenId.getNumericID();
            String image = token.getImage();
            TokenType coreTokenId = TokenType.TOKEN_WHITESPACE;
            switch (numericId) {
                case 13: {
                    coreTokenId = TokenType.TOKEN_PI_START_TAG;
                    currentTokens.add(Token.create(image, coreTokenId));
                    break;
                }
                case 16: {
                    coreTokenId = TokenType.TOKEN_PI_END_TAG;
                    currentTokens.add(Token.create(image, coreTokenId));
                    if (currentNode instanceof Document) {
                        if (token.getNext().getTokenID().getNumericID() == 1) {
                            token = token.getNext();
                            currentTokens.add(Token.create(token.getImage(), TokenType.TOKEN_CHARACTER_DATA));
                        }
                        stack.push(currentNode);
                    }
                    ArrayList<Token> list = new ArrayList<Token>(currentNode.getTokens());
                    list.addAll(currentTokens);
                    currentNode.setTokens(list);
                    currentTokens.clear();
                    break;
                }
                case 4: {
                    int len = image.length();
                    if (image.charAt(len - 1) == '>') {
                        Token endToken = Token.create(image, TokenType.TOKEN_ELEMENT_END_TAG);
                        if (len == 2) {
                            currentNode = (NodeImpl)stack.pop();
                            endToken = Token.create(image, TokenType.TOKEN_ELEMENT_END_TAG);
                        } else if (!(currentNode instanceof Element)) {
                            currentNode = (NodeImpl)stack.peek();
                        }
                        currentTokens.add(endToken);
                        currentNode.getTokensForWrite().addAll(currentTokens);
                        currentTokens.clear();
                        break;
                    }
                    coreTokenId = TokenType.TOKEN_ELEMENT_START_TAG;
                    if (image.startsWith("</")) {
                        int nextNumericId;
                        currentNode = (NodeImpl)stack.pop();
                        if (!currentNode.getTokens().get(0).getValue().substring(1).equals(image.substring(2))) {
                            throw new IOException("Invalid token '" + image + "' found in document: " + "Please use the text editor to resolve the issues...");
                        }
                        String saveTokenImage = image;
                        currentTokens.add(Token.create(image, coreTokenId));
                        for (token = token.getNext(); token != null && (nextNumericId = token.getTokenID().getNumericID()) == 2; token = token.getNext()) {
                            coreTokenId = TokenType.TOKEN_WHITESPACE;
                            currentTokens.add(Token.create(token.getImage(), coreTokenId));
                        }
                        if (token != null && token.getImage().equals(">")) continue block15;
                        throw new IOException("Invalid token '" + saveTokenImage + "' does not end with '>': Please use the " + "text editor to resolve the issues...");
                    }
                    currentNode = new Element();
                    Node parent = (Node)stack.peek();
                    parent.appendChild(currentNode);
                    stack.push(currentNode);
                    currentTokens.add(Token.create(image, coreTokenId));
                    currentNode.setTokens(new ArrayList<Token>(currentTokens));
                    currentTokens.clear();
                    break;
                }
                case 5: {
                    coreTokenId = TokenType.TOKEN_ATTR_NAME;
                    currentNode = new Attribute();
                    Element parent = (Element)stack.peek();
                    parent.appendAttribute((Attribute)currentNode);
                    currentTokens.add(Token.create(image, coreTokenId));
                    break;
                }
                case 7: {
                    TokenItem nextToken = token.getNext();
                    this.isValid(nextToken);
                    int nextNumericId = nextToken.getTokenID().getNumericID();
                    while (nextNumericId == 7 || nextNumericId == 11) {
                        token = token.getNext();
                        image = image.concat(token.getImage());
                        nextNumericId = token.getNext().getTokenID().getNumericID();
                    }
                    coreTokenId = TokenType.TOKEN_ATTR_VAL;
                    currentTokens.add(Token.create(image, coreTokenId));
                    currentNode.setTokens(new ArrayList<Token>(currentTokens));
                    currentTokens.clear();
                    break;
                }
                case 8: {
                    Node parent = (Node)stack.peek();
                    currentTokens.add(Token.create(image, coreTokenId));
                    if (!image.endsWith(Token.COMMENT_END.getValue())) break;
                    String combinedString = this.combineString(currentTokens);
                    Comment comment = new Comment(combinedString);
                    if (parent instanceof Element) {
                        ((Element)parent).appendChild(comment, true);
                    } else {
                        if (numericId != 8 && token.getImage().trim().length() > 0) {
                            throw new IOException("Invalid token '" + token.getImage() + "' found in document: " + "Please use the text editor to resolve the issues...");
                        }
                        parent.appendChild(comment);
                    }
                    currentTokens.clear();
                    break;
                }
                case 1: 
                case 11: {
                    coreTokenId = TokenType.TOKEN_CHARACTER_DATA;
                    currentNode = new Text();
                    currentTokens.add(Token.create(image, coreTokenId));
                    if (numericId == 1) {
                        int nextNumericId;
                        while (token.getNext() != null && ((nextNumericId = token.getNext().getTokenID().getNumericID()) == 1 || nextNumericId == 11)) {
                            token = token.getNext();
                            currentTokens.add(Token.create(token.getImage(), coreTokenId));
                        }
                    }
                    currentNode.setTokens(new ArrayList<Token>(currentTokens));
                    Node parent = (Node)stack.peek();
                    if (parent instanceof Element) {
                        ((Element)parent).appendChild(currentNode, true);
                    } else {
                        if (numericId != 8 && token.getImage().trim().length() > 0) {
                            throw new IOException("Invalid token '" + token.getImage() + "' found in document: " + "Please use the text editor to resolve the issues...");
                        }
                        parent.appendChild(currentNode);
                    }
                    currentTokens.clear();
                    break;
                }
                case 2: {
                    coreTokenId = TokenType.TOKEN_WHITESPACE;
                    currentTokens.add(Token.create(image, coreTokenId));
                    break;
                }
                case 6: {
                    coreTokenId = TokenType.TOKEN_ATTR_EQUAL;
                    currentTokens.add(Token.create(image, coreTokenId));
                    break;
                }
                case 10: {
                    coreTokenId = TokenType.TOKEN_DTD_VAL;
                    currentTokens.add(Token.create(image, coreTokenId));
                    break;
                }
                case 15: {
                    coreTokenId = TokenType.TOKEN_PI_VAL;
                    currentTokens.add(Token.create(image, coreTokenId));
                    break;
                }
                case 14: {
                    coreTokenId = TokenType.TOKEN_PI_NAME;
                    currentTokens.add(Token.create(image, coreTokenId));
                    break;
                }
                case 17: {
                    Node parent = (Node)stack.peek();
                    CData cdata = new CData(image);
                    if (!(parent instanceof Element)) {
                        throw new IOException("CDATA is not valid as direct child of documentPlease use the text editor to resolve the issues...");
                    }
                    ((Element)parent).appendChild(cdata, true);
                    coreTokenId = TokenType.TOKEN_CDATA_VAL;
                    break;
                }
                default: {
                    throw new IOException("Invalid token '" + token.getImage() + "' found in document: " + "Please use the text editor to resolve the issues...");
                }
            }
            token = token.getNext();
        }
        Node result = (Node)stack.pop();
        if (result instanceof Document) {
            return (Document)result;
        }
        throw new IOException("Document not well formed/Invalid: Please use the text editor to resolve the issues...");
    }

    private boolean isValid(TokenItem token) throws IOException {
        if (token != null && token.getTokenID() != null) {
            return true;
        }
        throw new IOException("Document parsed is invalid: Please use the text editor to resolve the issues...");
    }

    private String combineString(List<Token> tokens) {
        StringBuilder sb = new StringBuilder();
        for (Token t : tokens) {
            sb.append(t.getValue());
        }
        return sb.toString();
    }
}

