/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.metadata;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jmi.reflect.RefFeatured;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.mdr.events.AssociationEvent;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.MDRChangeSource;
import org.netbeans.api.mdr.events.MDRPreChangeListener;
import org.netbeans.api.mdr.events.VetoChangeException;
import org.netbeans.jmi.javamodel.AnnotableElement;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.ErrorInfo;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypedElement;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.j2ee.metadata.ClassPathSourceCache;
import org.netbeans.modules.j2ee.metadata.CountLatch;
import org.netbeans.modules.j2ee.metadata.NNListener;
import org.netbeans.modules.j2ee.metadata.Utils;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NNMDRListener
implements MDRPreChangeListener {
    private static final RequestProcessor nnMDRListenerRP = new RequestProcessor(NNMDRListener.class.getName(), 1);
    private static final ErrorManager CP_LOGGER = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.metadata.NNMDRListener.cp");
    private static final boolean CP_LOG = CP_LOGGER.isLoggable(1);
    private static final ErrorManager LOGGER = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.metadata.NNMDRListener.nnListener");
    private static final boolean LOG = LOGGER.isLoggable(1);
    private static final boolean isNoScan = "true".equals(System.getProperty("netbeans.javacore.noscan"));
    private Set<FileObject> classpathRoots = new HashSet<FileObject>();
    private static NNMDRListener instance = new NNMDRListener();
    private volatile Map<NNListener, ClassPathSourceCache> listeners = new HashMap<NNListener, ClassPathSourceCache>(3);
    private CountLatch latch = new CountLatch();

    private NNMDRListener() {
    }

    public static NNMDRListener getDefault() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotationListener(final NNListener annotationListener) {
        if (CP_LOG) {
            CP_LOGGER.log("Adding NNListener: " + annotationListener);
        }
        final ClassPath annotationListenerClassPath = annotationListener.getClassPath();
        final ClassPathSourceCache classPathSourceCache = ClassPathSourceCache.newInstance(annotationListenerClassPath, !annotationListener.getPrimaryAnnotations().isEmpty());
        if (annotationListenerClassPath == null) {
            return;
        }
        NNMDRListener nNMDRListener = this;
        synchronized (nNMDRListener) {
            HashMap<NNListener, ClassPathSourceCache> listenersCopy = new HashMap<NNListener, ClassPathSourceCache>(this.listeners);
            listenersCopy.put(annotationListener, classPathSourceCache);
            this.listeners = listenersCopy;
        }
        classPathSourceCache.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("roots".equals(evt.getPropertyName())) {
                    NNMDRListener.this.handleClasspathListenerChange(classPathSourceCache);
                }
            }
        });
        this.handleClasspathListenerChange(classPathSourceCache);
        this.latch.countUp();
        nnMDRListenerRP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean waited = JavaMetamodel.getManager().waitScanFinished();
                if (CP_LOG && waited) {
                    CP_LOGGER.log("Was waiting for scan finished (while setting NNListener)");
                }
                JavaModel.getJavaRepository().beginTrans(false);
                try {
                    JavaModel.setClassPath((ClassPath)annotationListenerClassPath);
                    Collection<String> primaryAnnotations = annotationListener.getPrimaryAnnotations();
                    for (String annotationName : primaryAnnotations) {
                        for (Annotation annotation : NNMDRListener.this.getAnnotationUsages(annotationName, annotationListenerClassPath)) {
                            AnnotationType type = annotation.getType();
                            if (type == null) continue;
                            NNMDRListener.this.primaryAnnotationAddedForListener(annotationListener, annotation, type);
                        }
                    }
                    Collection<String> supportedAnnotations = annotationListener.getSupportedAnnotations();
                    for (String annotationName : supportedAnnotations) {
                        if (primaryAnnotations.contains(annotationName)) continue;
                        for (Annotation annotation : NNMDRListener.this.getAnnotationUsages(annotationName, annotationListenerClassPath)) {
                            AnnotationType type = annotation.getType();
                            if (type == null) continue;
                            NNMDRListener.this.annotationAddedForListener(annotationListener, annotation, type);
                        }
                    }
                }
                finally {
                    JavaModel.getJavaRepository().endTrans();
                    NNMDRListener.this.latch.countDown();
                }
            }
        });
    }

    public void waitScanFinished() {
        try {
            this.latch.await();
        }
        catch (InterruptedException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    public boolean isScanInProgress() {
        return this.latch.getCount() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void change(MDRChangeEvent event) {
        JavaModel.getJavaRepository().beginTrans(false);
        try {
            switch (event.getType()) {
                case 0x1010002: {
                    if (LOG) {
                        LOGGER.log("AttributeEvent.EVENT_ATTRIBUTE_ADD: " + event);
                    }
                    this.eventAttributeAdd((AttributeEvent)event);
                    return;
                }
                case 0x1010001: {
                    if (LOG) {
                        LOGGER.log("AttributeEvent.EVENT_ATTRIBUTE_SET: " + event);
                    }
                    this.eventAttributeSet((AttributeEvent)event);
                    return;
                }
                case 0x4010001: {
                    if (LOG) {
                        LOGGER.log("AssociationEvent.EVENT_ASSOCIATION_SET: " + event);
                    }
                    this.postEventAssociationSet((AssociationEvent)event);
                    return;
                }
            }
            return;
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void plannedChange(MDRChangeEvent event) throws VetoChangeException {
        JavaModel.getJavaRepository().beginTrans(false);
        try {
            switch (event.getType()) {
                case 0x1010004: {
                    if (LOG) {
                        LOGGER.log("PLANNED: AttributeEvent.EVENT_ATTRIBUTE_REMOVE - planned: " + event);
                    }
                    this.eventAttributeRemove((AttributeEvent)event);
                    return;
                }
                case 0x1010001: {
                    if (LOG) {
                        LOGGER.log("PLANNED: AttributeEvent.EVENT_ATTRIBUTE_SET - planned: " + event);
                    }
                    this.eventAttributeRemoveSet((AttributeEvent)event);
                    return;
                }
                case 0x4010001: {
                    if (LOG) {
                        LOGGER.log("AssociationEvent.EVENT_ASSOCIATION_SET - planned: " + event);
                    }
                    this.preEventAssociationSet((AssociationEvent)event);
                    return;
                }
            }
            return;
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
    }

    public void changeCancelled(MDRChangeEvent event) {
        if (LOG) {
            LOGGER.log("### ATTENTION !!! changeCancelled !!!");
        }
    }

    private void handleClasspathListenerChange(final ClassPathSourceCache classPathSourceCache) {
        nnMDRListenerRP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean waited = JavaMetamodel.getManager().waitScanFinished();
                if (CP_LOG && waited) {
                    CP_LOGGER.log("Was waiting for scan finished (while setting)");
                }
                FileObject[] roots = classPathSourceCache.getRoots();
                JavaModel.getJavaRepository().beginTrans(false);
                try {
                    for (int i = 0; i < roots.length; ++i) {
                        JavaModelPackage jmp;
                        if (NNMDRListener.this.classpathRoots.contains(roots[i])) continue;
                        if (CP_LOG) {
                            CP_LOGGER.log("New root added to classpath: " + FileUtil.getFileDisplayName((FileObject)roots[i]));
                        }
                        if ((jmp = JavaMetamodel.getManager().getJavaExtent(roots[i])) == null) {
                            jmp = JavaMetamodel.getManager().resolveJavaExtent(roots[i]);
                        }
                        if (CP_LOG && jmp == null) {
                            CP_LOGGER.log("Didn't resolve Java Extent for classpath root " + FileUtil.getFileDisplayName((FileObject)roots[i]));
                        }
                        if (!isNoScan) assert (jmp != null);
                        if (jmp == null) continue;
                        ((MDRChangeSource)jmp).addListener((MDRChangeListener)NNMDRListener.this);
                        NNMDRListener.this.classpathRoots.add(roots[i]);
                        if (!CP_LOG) continue;
                        CP_LOGGER.log("Added listener to " + FileUtil.getFileDisplayName((FileObject)roots[i]));
                    }
                }
                finally {
                    JavaModel.getJavaRepository().endTrans();
                }
            }
        });
    }

    private void eventAttributeRemoveSet(AttributeEvent event) {
        Object source;
        Object newValue;
        Object oldValue = event.getOldElement();
        if (Utilities.compareObjects((Object)oldValue, (Object)(newValue = event.getNewElement()))) {
            return;
        }
        String eventName = event.getAttributeName();
        if ("name".equals(eventName) && (source = event.getSource()) instanceof JavaClass) {
            this.classRemoved((JavaClass)source);
        }
    }

    private void eventAttributeSet(AttributeEvent event) {
        Object source;
        Object newValue;
        Object oldValue = event.getOldElement();
        if (Utilities.compareObjects((Object)oldValue, (Object)(newValue = event.getNewElement()))) {
            return;
        }
        if ("name".equals(event.getAttributeName())) {
            Object source2 = event.getSource();
            if (source2 instanceof Field || source2 instanceof Method) {
                ClassDefinition declClass = ((ClassMember)source2).getDeclaringClass();
                if (declClass instanceof JavaClass) {
                    JavaClass dclass = (JavaClass)declClass;
                    AnnotableElement anne = (AnnotableElement)source2;
                    for (Annotation nn : anne.getAnnotations()) {
                        AnnotationType type = nn.getType();
                        if (type != null) {
                            this.memberAnnotationRemoved(nn, (Type)type, dclass, (String)event.getOldElement(), ((TypedElement)source2).getType().getName(), source2 instanceof Field);
                        }
                        this.memberAnnotationAdded(nn, (Element)source2);
                    }
                }
            } else if (source2 instanceof JavaClass) {
                this.classAdded((JavaClass)source2);
            }
        } else if ("typeName".equals(event.getAttributeName())) {
            Object source3 = event.getSource();
            if (source3 != null && source3 instanceof Annotation) {
                Annotation a = (Annotation)source3;
                this.annotationAdded(a);
            }
        } else if ("value".equals(event.getAttributeName()) && (source = event.getSource()) instanceof AttributeValue) {
            this.attributeAdded((AttributeValue)source);
        }
    }

    private void eventAttributeAdd(AttributeEvent event) {
        Object newElement = event.getNewElement();
        if (newElement instanceof Annotation) {
            Annotation annotation = (Annotation)newElement;
            this.annotationAdded(annotation);
        } else if (newElement instanceof AttributeValue) {
            this.attributeAdded((AttributeValue)event.getNewElement());
        } else if ("classifiers".equals(event.getAttributeName())) {
            this.classAdded((JavaClass)event.getNewElement());
        }
    }

    private void preEventAssociationSet(AssociationEvent event) {
        RefObject fixedElement;
        if ("type".equals(event.getEndName()) && (fixedElement = event.getFixedElement()) instanceof Annotation) {
            this.annotationRemoved((Annotation)fixedElement, (Type)event.getOldElement());
        }
    }

    private void postEventAssociationSet(AssociationEvent event) {
        RefObject fixedElement;
        if ("type".equals(event.getEndName()) && (fixedElement = event.getFixedElement()) instanceof Annotation) {
            this.annotationAdded((Annotation)fixedElement);
        }
    }

    private void classAdded(JavaClass javaClass) {
        if (!javaClass.isValid()) {
            return;
        }
        List annotations = javaClass.getAnnotations();
        Iterator it = annotations.iterator();
        while (it.hasNext()) {
            this.annotationAdded((Annotation)it.next());
        }
        for (Object f : javaClass.getFeatures()) {
            if (!(f instanceof Method) && !(f instanceof Field)) continue;
            Iterator it2 = ((AnnotableElement)f).getAnnotations().iterator();
            while (it2.hasNext()) {
                this.memberAnnotationAdded((Annotation)it2.next(), (Element)f);
            }
        }
    }

    private void eventAttributeRemove(AttributeEvent event) {
        Object oldElement = event.getOldElement();
        if (oldElement instanceof Annotation) {
            AnnotationType type;
            Annotation annotation = (Annotation)oldElement;
            Resource resource = annotation.getResource();
            if (resource == null || resource.getStatus() == 16) {
                return;
            }
            List errors = resource.getErrors();
            if (errors.size() > 0) {
                for (Object elem : resource.getErrors()) {
                    if (elem instanceof ErrorInfo) {
                        ErrorInfo ei = (ErrorInfo)elem;
                        if ("cant.resolve.location".equals(ei.getErrorId())) continue;
                        return;
                    }
                    return;
                }
            }
            if ((type = annotation.getType()) != null) {
                this.annotationRemoved(annotation, (Type)type);
            }
        } else if (oldElement instanceof AttributeValue) {
            this.attributeRemoved((AttributeValue)oldElement);
        } else if (oldElement instanceof JavaClass) {
            this.classRemoved((JavaClass)oldElement);
        }
    }

    private void classRemoved(JavaClass javaClass) {
        for (NNListener annotationListener : this.listeners.keySet()) {
            annotationListener.classRemoved(javaClass.getName());
        }
    }

    private List<Annotation> getAnnotationUsages(String annotationClassName, ClassPath cp) {
        Resource[] resources;
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        AnnotationType annotationClass = (AnnotationType)this.resolveType(annotationClassName, cp);
        if (annotationClass == null) {
            return result;
        }
        if (CP_LOG && annotationClass == null) {
            CP_LOGGER.log("Didn't resolve " + annotationClassName + " annotation");
        }
        for (Resource resource : resources = ClassIndex.findResourcesForIdentifier((String)annotationClass.getSimpleName(), (boolean)true)) {
            List classes = resource.getClassifiers();
            for (JavaClass jc : classes) {
                this.findAnnotationsInClass(jc, annotationClass, result);
            }
        }
        return result;
    }

    private void findAnnotationsInClass(JavaClass jc, AnnotationType annotationType, List<Annotation> result) {
        this.findAnnotationsInList(jc.getAnnotations(), annotationType, result);
        List features = jc.getFeatures();
        for (Feature feature : features) {
            this.findAnnotationsInList(feature.getAnnotations(), annotationType, result);
        }
    }

    private void findAnnotationsInList(List<Annotation> list, AnnotationType annotationType, List<Annotation> result) {
        for (Annotation an : list) {
            if (!annotationType.equals(an.getType())) continue;
            result.add(an);
        }
    }

    private Type resolveType(String typeName, ClassPath cp) {
        JavaModelPackage jmp = JavaModel.getDefaultExtent();
        if (!isNoScan) assert (jmp != null) : "Default Java Extent wasn't resolved. Probably called BEFORE the roots were added to GlobalPathRegistry?";
        if (jmp == null) {
            return null;
        }
        Type result = jmp.getType().resolve(typeName);
        if (!(result instanceof UnresolvedClass)) {
            return result;
        }
        return null;
    }

    private void classAnnotationAddedForListener(NNListener nnListener, Annotation annotation, AnnotationType annotationType, JavaClass clazz, boolean findAllInClass) {
        if (annotationType != null) {
            nnListener.addClassAnnotation(clazz, annotation, annotationType);
        }
        if (findAllInClass) {
            String annotationName = annotationType.getName();
            if (nnListener.getPrimaryAnnotations().contains(annotationName)) {
                List annotations = clazz.getAnnotations();
                for (Annotation nn : annotations) {
                    AnnotationType type = nn.getType();
                    if (type == null) continue;
                    nnListener.addClassAnnotation(clazz, nn, type);
                }
                for (Object f : clazz.getFeatures()) {
                    if (!(f instanceof Method) && !(f instanceof Field)) continue;
                    for (Annotation memberNN : ((AnnotableElement)f).getAnnotations()) {
                        AnnotationType type = memberNN.getType();
                        if (type == null) continue;
                        nnListener.addMemberAnnotation(f instanceof Field, clazz, (Element)f, memberNN, type);
                    }
                }
            }
        }
    }

    private void classAnnotationRemoved(Annotation annotation, Type annoType, JavaClass javaClass) {
        for (Map.Entry<NNListener, ClassPathSourceCache> entry : this.listeners.entrySet()) {
            if (!entry.getValue().contains(JavaModel.getFileObject((Resource)javaClass.getResource()))) continue;
            NNListener nnListener = entry.getKey();
            if (annoType == null || !nnListener.getSupportedAnnotations().contains(annoType.getName())) continue;
            nnListener.removeClassAnnotation(javaClass, annotation, (AnnotationType)annoType);
        }
    }

    private void memberAnnotationAdded(Annotation annotation, Element te) {
        AnnotationType type = annotation.getType();
        if (type != null) {
            for (Map.Entry<NNListener, ClassPathSourceCache> entry : this.listeners.entrySet()) {
                ClassDefinition dclass;
                NNListener nnListener;
                if (!entry.getValue().contains(JavaModel.getFileObject((Resource)te.getResource())) || !(nnListener = entry.getKey()).getSupportedAnnotations().contains(type.getName()) || !((dclass = ((ClassMember)te).getDeclaringClass()) instanceof JavaClass)) continue;
                nnListener.addMemberAnnotation(te instanceof Field, (JavaClass)dclass, te, annotation, type);
            }
        }
    }

    private void memberAnnotationAddedForListener(NNListener nnListener, Annotation annotation, AnnotationType type, Element te) {
        ClassDefinition dclass;
        ClassPathSourceCache cpSourceCache;
        if (type != null && (cpSourceCache = this.listeners.get(nnListener)).contains(JavaModel.getFileObject((Resource)te.getResource())) && (dclass = ((ClassMember)te).getDeclaringClass()) instanceof JavaClass) {
            nnListener.addMemberAnnotation(te instanceof Field, (JavaClass)dclass, te, annotation, type);
        }
    }

    private void memberAnnotationRemoved(Annotation annotation, Type annoType, JavaClass javaClass, String memberName, String memberType, boolean field) {
        for (Map.Entry<NNListener, ClassPathSourceCache> entry : this.listeners.entrySet()) {
            if (!entry.getValue().contains(JavaModel.getFileObject((Resource)javaClass.getResource()))) continue;
            NNListener nnListener = entry.getKey();
            if (annoType == null || !nnListener.getSupportedAnnotations().contains(annoType.getName())) continue;
            nnListener.removeMemberAnnotation(field, javaClass, memberName, memberType, annotation, (AnnotationType)annoType);
        }
    }

    private void annotationAdded(Annotation annotation) {
        AnnotationType type = annotation.getType();
        if (type != null) {
            for (Map.Entry<NNListener, ClassPathSourceCache> entry : this.listeners.entrySet()) {
                NNListener nnListener;
                if (!entry.getValue().contains(JavaModel.getFileObject((Resource)annotation.getResource())) || !(nnListener = entry.getKey()).getSupportedAnnotations().contains(type.getName())) continue;
                this.annotationAddedForListener(nnListener, annotation, type);
            }
        }
    }

    private void annotationAddedForListener(NNListener nnListener, Annotation annotation, AnnotationType type) {
        RefFeatured refFeatured = annotation.refImmediateComposite();
        if (refFeatured instanceof JavaClass) {
            this.classAnnotationAddedForListener(nnListener, annotation, type, (JavaClass)refFeatured, true);
        } else if (refFeatured instanceof Field || refFeatured instanceof Method) {
            this.memberAnnotationAddedForListener(nnListener, annotation, type, (Element)refFeatured);
        }
    }

    private void primaryAnnotationAddedForListener(NNListener nnListener, Annotation annotation, AnnotationType type) {
        RefFeatured refFeatured = annotation.refImmediateComposite();
        if (refFeatured instanceof JavaClass) {
            this.classAnnotationAddedForListener(nnListener, annotation, type, (JavaClass)refFeatured, false);
        }
    }

    private void annotationRemoved(Annotation annotation, Type annoType) {
        RefFeatured refFeatured = annotation.refImmediateComposite();
        if (annoType != null) {
            ClassDefinition dclass;
            if (refFeatured instanceof JavaClass) {
                this.classAnnotationRemoved(annotation, annoType, (JavaClass)refFeatured);
            } else if ((refFeatured instanceof Field || refFeatured instanceof Method) && (dclass = ((ClassMember)refFeatured).getDeclaringClass()) instanceof JavaClass) {
                this.memberAnnotationRemoved(annotation, annoType, (JavaClass)dclass, ((NamedElement)refFeatured).getName(), ((TypedElement)refFeatured).getType().getName(), refFeatured instanceof Field);
            }
        }
    }

    private void attributeAdded(AttributeValue attributeValue) {
        Annotation annotation;
        AnnotationType type;
        RefFeatured refFeatured = attributeValue.refImmediateComposite();
        if (refFeatured instanceof Annotation && (type = (annotation = (Annotation)refFeatured).getType()) != null) {
            for (Map.Entry<NNListener, ClassPathSourceCache> entry : this.listeners.entrySet()) {
                NNListener nnListener;
                if (!entry.getValue().contains(JavaModel.getFileObject((Resource)annotation.getResource())) || !(nnListener = entry.getKey()).getSupportedAnnotations().contains(type.getName())) continue;
                this._attributeAdded(nnListener, annotation, type, attributeValue);
            }
        }
    }

    private void _attributeAdded(NNListener nnListener, Annotation annotation, AnnotationType type, AttributeValue attributeValue) {
        ClassDefinition dclass;
        RefFeatured refFeatured = annotation.refImmediateComposite();
        if (refFeatured instanceof JavaClass) {
            JavaClass jc = (JavaClass)refFeatured;
            nnListener.addClassAttribute(jc, annotation, type, attributeValue.getDefinition().getName(), Utils.stringValue(attributeValue));
        } else if ((refFeatured instanceof Field || refFeatured instanceof Method) && (dclass = ((ClassMember)refFeatured).getDeclaringClass()) instanceof JavaClass) {
            nnListener.addMemberAttribute((JavaClass)dclass, (Element)refFeatured, annotation, type, attributeValue.getDefinition().getName(), Utils.stringValue(attributeValue));
        }
    }

    private void attributeRemoved(AttributeValue attributeValue) {
        Annotation annotation;
        AnnotationType type;
        RefFeatured refFeatured = attributeValue.refImmediateComposite();
        if (refFeatured instanceof Annotation && (type = (annotation = (Annotation)refFeatured).getType()) != null) {
            for (Map.Entry<NNListener, ClassPathSourceCache> entry : this.listeners.entrySet()) {
                NNListener nnListener;
                if (!entry.getValue().contains(JavaModel.getFileObject((Resource)annotation.getResource())) || !(nnListener = entry.getKey()).getSupportedAnnotations().contains(type.getName())) continue;
                this._attributeRemoved(nnListener, annotation, type, attributeValue);
            }
        }
    }

    private void _attributeRemoved(NNListener nnListener, Annotation annotation, AnnotationType type, AttributeValue attributeValue) {
        ClassDefinition dclass;
        RefFeatured refFeatured = annotation.refImmediateComposite();
        if (refFeatured instanceof JavaClass) {
            JavaClass jc = (JavaClass)refFeatured;
            nnListener.removeClassAttribute(jc, annotation, type, attributeValue.getDefinition().getName());
        } else if ((refFeatured instanceof Field || refFeatured instanceof Method) && (dclass = ((ClassMember)refFeatured).getDeclaringClass()) instanceof JavaClass) {
            nnListener.removeMemberAttribute((JavaClass)dclass, (Element)refFeatured, annotation, type, attributeValue.getDefinition().getName());
        }
    }
}

