/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.dev.wizard;

import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.modules.websvc.dev.wizard.NoWSPortDefinedException;
import org.netbeans.modules.websvc.dev.wizard.WSGenerationUtil;
import org.netbeans.modules.websvc.dev.wizard.WebServiceGenerator;
import org.netbeans.modules.websvc.dev.wizard.WebServiceWizardDescriptor;
import org.netbeans.modules.websvc.dev.wizard.WebServiceWizardHelper;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class WebServiceWizard
implements WizardDescriptor.InstantiatingIterator {
    public int currentPanel = 0;
    private WizardDescriptor.Panel firstPanel;
    private WebServiceWizardDescriptor wsPanel;
    private WizardDescriptor wiz;
    private Project project;
    private String wsName;
    private WebServiceWizardHelper helper;
    private FileObject wsdlFO;
    private static final int STEP_ENTER_NAME = 0;
    private static final int STEP_SELECT_EXISTING_CODE = 1;
    private static int[][] stepPaths = new int[][]{{0}, {0, 1}, {0}, {0}};
    private static final String STEPNAME_ENTER_NAME = NbBundle.getMessage(WebServiceWizard.class, (String)"LBL_SpecifyWSInfo");
    private static final String STEPNAME_SELECT_EXISTING_CODE = NbBundle.getMessage(WebServiceWizard.class, (String)"LBL_SelectExistingCode");
    private static final String[][] stepPathNames = new String[][]{{STEPNAME_ENTER_NAME}, {STEPNAME_ENTER_NAME, STEPNAME_SELECT_EXISTING_CODE}, {STEPNAME_ENTER_NAME}, {STEPNAME_ENTER_NAME}};
    public static final int PATH_CREATE_FROM_SCRATCH = 0;
    public static final int PATH_CREATE_FROM_EXISTING_CODE = 1;
    public static final int PATH_CREATE_FROM_WSDL_FILE = 2;
    public static final int PATH_CREATE_FROM_WSDL_URL = 3;
    private static int currentWizardBranch = 0;
    private static final String[] stepClassNames = new String[]{"dummy", "org.netbeans.modules.websvc.dev.wizard.CreateWebServiceFromExistingCodePanel", "dummy", "dummy"};
    private static WizardDescriptor.Panel[] steps = new WizardDescriptor.Panel[]{null, null, null, null};
    public static final String WSDL_FILE_PATH = "wsdlfilepath";
    public static final String WSDL_FILE_URL = "wsdlfileurl";

    public static WebServiceWizard create() {
        return new WebServiceWizard();
    }

    public void initialize(WizardDescriptor wizard) {
        currentWizardBranch = 0;
        this.helper = new WebServiceWizardHelper();
        this.helper.setWizard(this);
        this.wiz = wizard;
        this.project = Templates.getProject((WizardDescriptor)this.wiz);
        SourceGroup[] sourceGroups = Util.getJavaSourceGroups((Project)this.project);
        this.wsPanel = new WebServiceWizardDescriptor(this.wiz, this.helper);
        this.firstPanel = sourceGroups.length == 0 ? Templates.createSimpleTargetChooser((Project)this.project, (SourceGroup[])sourceGroups, (WizardDescriptor.Panel)this.wsPanel) : JavaTemplates.createPackageChooser((Project)this.project, (SourceGroup[])sourceGroups, (WizardDescriptor.Panel)this.wsPanel, (boolean)true);
        this.wsPanel.setTargetChooserPanel(this.firstPanel);
        JComponent c = (JComponent)this.firstPanel.getComponent();
        Util.changeLabelInComponent((JComponent)c, (String)NbBundle.getMessage(Util.class, (String)"LBL_JavaTargetChooserPanelGUI_ClassName_Label"), (String)NbBundle.getMessage(WebServiceWizard.class, (String)"LBL_Webservice_Name"));
        Util.hideLabelAndLabelFor((JComponent)c, (String)NbBundle.getMessage(Util.class, (String)"LBL_JavaTargetChooserPanelGUI_CreatedFile_Label"));
    }

    private WizardDescriptor.Panel getStep(int step) {
        if (step == 0) {
            return this.firstPanel;
        }
        if (steps[step] != null) {
            return steps[step];
        }
        WizardDescriptor.Panel p = this.createWizardPanel(stepClassNames[step]);
        ((HasWizardHelper)p).setWizardHelper(this.helper);
        WebServiceWizard.steps[step] = p;
        return p;
    }

    public void uninitialize(WizardDescriptor wizard) {
    }

    public Set instantiate() throws IOException {
        Frame c = WindowManager.getDefault().getMainWindow();
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(WebServiceWizard.class, (String)"TXT_WebServiceGeneration"));
        handle.start(100);
        Runnable r = new Runnable(){

            public void run() {
                try {
                    WebServiceWizard.this.generateWebService(handle);
                }
                catch (Exception e) {
                    handle.finish();
                    String message = e.getLocalizedMessage();
                    if (message != null) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    }
                    ErrorManager.getDefault().notify(4096, (Throwable)e);
                }
            }
        };
        RequestProcessor.getDefault().post(r);
        return Collections.EMPTY_SET;
    }

    private void generateWebService(ProgressHandle handle) throws Exception {
        FileObject pkg = Templates.getTargetFolder((WizardDescriptor)this.wiz);
        this.wsName = Templates.getTargetName((WizardDescriptor)this.wiz);
        Project project = Templates.getProject((WizardDescriptor)this.wiz);
        WebServicesSupport wsSupport = WebServicesSupport.getWebServicesSupport((FileObject)pkg);
        assert (wsSupport != null);
        WebServiceGenerator generator = new WebServiceGenerator(wsSupport, this.wsName, pkg, project);
        if (this.helper.getCreateFrom() == 0) {
            handle.progress(NbBundle.getMessage(WebServiceWizard.class, (String)"MSG_GEN_SEI_AND_IMPL"), 50);
            generator.generateWebService();
        } else if (this.helper.getCreateFrom() == 1) {
            handle.progress(NbBundle.getMessage(WebServiceWizard.class, (String)"MSG_GEN_SEI_AND_IMPL"), 50);
            Node[] nodes = this.helper.getExistingCodeNodes();
            generator.generateWebService(nodes);
        } else {
            FileObject wsDDFolder = wsSupport.getWsDDFolder();
            FileObject wsdlFolder = wsDDFolder.getFileObject("wsdl");
            if (wsdlFolder == null) {
                wsdlFolder = wsDDFolder.createFolder("wsdl");
            }
            if (this.helper.getCreateFrom() == 2) {
                handle.progress(NbBundle.getMessage(WebServiceWizard.class, (String)"MSG_PARSING_WSDL"), 30);
                String wsdlFilePath = (String)this.wiz.getProperty(WSDL_FILE_PATH);
                File normalizedWsdlFilePath = FileUtil.normalizeFile((File)new File(wsdlFilePath));
                FileObject sourceWsdlFile = FileUtil.toFileObject((File)normalizedWsdlFilePath);
                if (sourceWsdlFile == null) {
                    String mes = NbBundle.getMessage(WebServiceWizard.class, (String)"MSG_CANNOT_GET_FILE_OBJECT", (Object)normalizedWsdlFilePath.getAbsolutePath());
                    throw new IOException(mes);
                }
                List schemaFiles = WSGenerationUtil.getSchemaNames(sourceWsdlFile, true);
                String changedWsName = null;
                try {
                    changedWsName = generator.parseWSDL(sourceWsdlFile.getInputStream());
                }
                catch (NoWSPortDefinedException exc) {
                    ErrorManager.getDefault().log(1, "WSDL does not contain any defined ports");
                    String mes = NbBundle.getMessage(WebServiceGenerator.class, (String)"ERR_WsdlNoPortDefined");
                    NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                    handle.finish();
                    return;
                }
                if (changedWsName == null) {
                    changedWsName = this.wsName;
                }
                handle.progress(NbBundle.getMessage(WebServiceWizard.class, (String)"MSG_CREATING_NEW_WSDL"), 50);
                this.wsdlFO = generator.generateWSDL("/org/netbeans/modules/websvc/dev/wizard/xsl/WSDL.xml", changedWsName, generator.getSoapBinding(), generator.getPortTypeName(), wsdlFolder, sourceWsdlFile.getParent(), this.wsName, new StreamSource(sourceWsdlFile.getInputStream()));
            } else if (this.helper.getCreateFrom() == 3) {
                handle.progress(NbBundle.getMessage(WebServiceWizard.class, (String)"MSG_PARSING_WSDL"), 30);
                String wsdlUrl = (String)this.wiz.getProperty(WSDL_FILE_URL);
                URL url = null;
                InputStream in = null;
                try {
                    url = new URL(wsdlUrl);
                    in = url.openStream();
                }
                catch (MalformedURLException e) {
                    String mes = NbBundle.getMessage(WebServiceWizard.class, (String)"MSG_CANNOT_LOCATE_URL", (Object)wsdlUrl);
                    throw new Exception(mes);
                }
                catch (IOException e) {
                    String mes = NbBundle.getMessage(WebServiceWizard.class, (String)"MSG_UNABLE_ACCESS_URL", (Object)wsdlUrl);
                    throw new Exception(mes);
                }
                String changedWsName = null;
                try {
                    changedWsName = generator.parseWSDL(in);
                }
                catch (NoWSPortDefinedException exc) {
                    ErrorManager.getDefault().log(1, "WSDL does not contain any defined ports");
                    String mes = NbBundle.getMessage(WebServiceGenerator.class, (String)"ERR_WsdlNoPortDefined");
                    NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                    handle.finish();
                    return;
                }
                if (changedWsName == null) {
                    changedWsName = this.wsName;
                }
                handle.progress(NbBundle.getMessage(WebServiceWizard.class, (String)"MSG_CREATING_NEW_WSDL"), 50);
                this.wsdlFO = generator.generateWSDL("/org/netbeans/modules/websvc/dev/wizard/xsl/WSDL.xml", changedWsName, generator.getSoapBinding(), generator.getPortTypeName(), wsdlFolder, this.wsName, new StreamSource(url.openStream()));
            }
        }
        URI targetNS = null;
        URI typeNS = null;
        try {
            targetNS = generator.getTargetNS();
            typeNS = generator.getDefaultTypeNS(this.wsName);
        }
        catch (URISyntaxException e) {
            String mes = NbBundle.getMessage(WebServiceWizard.class, (String)"MSG_INVALID_URL_SYNTAX");
            throw new Exception(mes);
        }
        handle.progress(NbBundle.getMessage(WebServiceWizard.class, (String)"MSG_CREATING_WSCOMPILE_ARTIFACTS"));
        String servantClassName = generator.getServantClassName();
        String seiClassName = generator.getSEIClassName();
        FileObject configFile = null;
        if (this.helper.getCreateFrom() == 2 || this.helper.getCreateFrom() == 3) {
            File wsdlFile = FileUtil.toFile((FileObject)this.wsdlFO);
            URI wsdlURI = wsdlFile.toURI();
            configFile = generator.generateConfigFile(wsdlURI);
        } else {
            configFile = generator.generateConfigFile(seiClassName, servantClassName, targetNS, typeNS);
        }
        handle.progress(70);
        if (this.helper.getCreateFrom() == 2 || this.helper.getCreateFrom() == 3) {
            wsSupport.addServiceImpl(this.wsName, configFile, true, generator.getWscompileFeatures());
            handle.progress(NbBundle.getMessage(WebServiceWizard.class, (String)"MSG_RUNNING_WSCOMPILE_TARGET"));
            String targetName = this.wsName + "_wscompile";
            ExecutorTask task = ActionUtils.runTarget((FileObject)this.findBuildXml(), (String[])new String[]{targetName}, null);
            task.waitFinished();
            if (task.result() != 0) {
                String mes = NbBundle.getMessage(WebServiceWizard.class, (String)"MSG_WSCOMPILE_UNSUCCESSFUL");
                wsSupport.removeProjectEntries(this.wsName);
                try {
                    this.deleteFile(configFile);
                    this.deleteFile(this.wsdlFO);
                }
                catch (IOException e) {
                    String message = NbBundle.getMessage(WebServiceWizard.class, (String)"MSG_UNABLE_DELETE_FILES");
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                }
                throw new Exception(mes);
            }
            handle.progress(90);
            this.addHeaderComments(this.wsName, servantClassName, pkg);
            wsSupport.addInfrastructure(servantClassName, pkg);
            String implClassName = servantClassName.substring(servantClassName.lastIndexOf(".") + 1);
            FileObject clz = pkg.getFileObject(implClassName, "java");
            DataObject dobj = DataObject.find((FileObject)clz);
            EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
            ec.open();
        } else {
            wsSupport.addServiceImpl(this.wsName, configFile, false);
            handle.progress(90);
        }
        wsSupport.addServiceEntriesToDD(this.wsName, seiClassName, servantClassName);
        handle.progress(NbBundle.getMessage(WebServiceWizard.class, (String)"MSG_ADDING_DD_ENTRIES"));
        String portTypeName = null;
        if (this.helper.getCreateFrom() == 2 || this.helper.getCreateFrom() == 3) {
            portTypeName = generator.getPortTypeName();
        }
        generator.addWebServiceEntry(seiClassName, portTypeName, targetNS);
        if (this.helper.getCreateFrom() == 1) {
            generator.addReferences(servantClassName, this.helper.getExistingCodeNodes());
        }
        handle.finish();
    }

    private void addHeaderComments(String wsName, String servantClassName, FileObject pkg) {
        String comment = NbBundle.getMessage(WebServiceWizard.class, (String)"MSG_WS_CLASS_COMMENT", (Object)wsName);
        StringBuffer buffer = new StringBuffer(comment + "\n");
        buffer.append(NbBundle.getMessage(WebServiceWizard.class, (String)"MSG_CREATED_COMMENT") + " " + DateFormat.getDateTimeInstance().format(new Date()) + "\n");
        buffer.append("@author " + System.getProperty("user.name"));
        JavaMetamodel.getManager().waitScanFinished();
        JavaClass clazz = JMIUtils.findClass((String)servantClassName);
        if (clazz != null) {
            String javadoc = clazz.getJavadocText();
            clazz.setJavadocText(buffer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFile(FileObject file) throws IOException {
        FileLock lock = null;
        try {
            lock = file.lock();
            file.delete(lock);
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
        }
    }

    private FileObject findBuildXml() {
        return this.project.getProjectDirectory().getFileObject("build.xml");
    }

    public void addChangeListener(ChangeListener l) {
        WebServiceWizardDescriptor p = null;
        for (int i = 0; i < stepPathNames[currentWizardBranch].length; ++i) {
            p = currentWizardBranch == 0 ? this.wsPanel : this.getStep(stepPaths[currentWizardBranch][i]);
            if (p == null) continue;
            p.addChangeListener(l);
        }
    }

    public WizardDescriptor.Panel current() {
        WizardDescriptor.Panel pnl = this.getStep(stepPaths[currentWizardBranch][this.currentPanel]);
        JComponent c = (JComponent)pnl.getComponent();
        if (this.currentPanel != 0) {
            ((HasWizardHelper)pnl).setWizardHelper(this.helper);
        }
        c.putClientProperty("WizardPanel_contentData", stepPathNames[currentWizardBranch]);
        c.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(this.currentPanel));
        return this.getStep(stepPaths[currentWizardBranch][this.currentPanel]);
    }

    public boolean hasNext() {
        return this.currentPanel + 1 < stepPaths[currentWizardBranch].length;
    }

    public boolean hasPrevious() {
        return this.currentPanel > 0;
    }

    public String name() {
        return NbBundle.getMessage(WebServiceWizard.class, (String)"LBL_Create_WS_Title");
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.currentPanel;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.currentPanel;
    }

    public void removeChangeListener(ChangeListener l) {
        WebServiceWizardDescriptor p = null;
        for (int i = 0; i < stepPathNames[currentWizardBranch].length; ++i) {
            p = currentWizardBranch == 0 ? this.wsPanel : this.getStep(stepPaths[currentWizardBranch][i]);
            if (p == null) continue;
            p.removeChangeListener(l);
        }
    }

    public void setPanelsAndSteps(int branch) {
        currentWizardBranch = branch;
    }

    protected int getCurrentPanelIndex() {
        return this.currentPanel;
    }

    protected WizardDescriptor.Panel createWizardPanel(String panelName) {
        try {
            Class<?> newClass = Class.forName(panelName);
            Constructor<?> cons = newClass.getDeclaredConstructor(WebServiceWizardHelper.class);
            return (WizardDescriptor.Panel)cons.newInstance(this.helper);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static interface HasWizardHelper {
        public void setWizardHelper(WebServiceWizardHelper var1);
    }
}

