/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5;

import java.util.WeakHashMap;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class TomcatFactory55
implements DeploymentFactory {
    public static final String SERVER_ID = "Tomcat55";
    public static final String tomcatUriPrefix = "tomcat55:";
    private static final String DISCONNECTED_URI = "tomcat55:jakarta-tomcat-5.5.x";
    private static TomcatFactory55 instance;
    private static ErrorManager err;
    private static final WeakHashMap managerCache;

    public static synchronized TomcatFactory55 create() {
        if (instance == null) {
            if (err.isLoggable(1)) {
                err.log("Creating TomcatFactory55");
            }
            instance = new TomcatFactory55();
            DeploymentFactoryManager.getInstance().registerDeploymentFactory((DeploymentFactory)instance);
        }
        return instance;
    }

    public static ErrorManager getEM() {
        return err;
    }

    public synchronized DeploymentManager getDeploymentManager(String uri, String uname, String passwd) throws DeploymentManagerCreationException {
        if (!this.handlesURI(uri)) {
            throw new DeploymentManagerCreationException("Invalid URI:" + uri);
        }
        InstanceProperties ip = InstanceProperties.getInstanceProperties((String)uri);
        if (ip == null && !DISCONNECTED_URI.equals(uri)) {
            throw new DeploymentManagerCreationException("Tomcat instance: " + uri + " is not registered in the IDE.");
        }
        TomcatManager tm = (TomcatManager)managerCache.get(ip);
        if (tm == null) {
            try {
                tm = new TomcatManager(true, uri.substring(tomcatUriPrefix.length()), 1);
                managerCache.put(ip, tm);
            }
            catch (IllegalArgumentException iae) {
                DeploymentManagerCreationException t = new DeploymentManagerCreationException("Cannot create deployment manager for Tomcat instance: " + uri + ".");
                throw (DeploymentManagerCreationException)t.initCause(iae);
            }
        }
        return tm;
    }

    public DeploymentManager getDisconnectedDeploymentManager(String uri) throws DeploymentManagerCreationException {
        return this.getDeploymentManager(uri, null, null);
    }

    public String getDisplayName() {
        return NbBundle.getMessage(TomcatFactory55.class, (String)"LBL_TomcatFactory55");
    }

    public String getProductVersion() {
        return NbBundle.getMessage(TomcatFactory55.class, (String)"LBL_TomcatFactoryVersion");
    }

    public boolean handlesURI(String str) {
        return str != null && str.startsWith(tomcatUriPrefix);
    }

    static {
        err = ErrorManager.getDefault().getInstance("org.netbeans.modules.tomcat5");
        managerCache = new WeakHashMap();
    }
}

