/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.util.Map;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;

public abstract class SyntaxElement {
    private JspSyntaxSupport support;
    private SyntaxElement previous;
    private SyntaxElement next;
    int offset;
    int length;

    public SyntaxElement(JspSyntaxSupport support, int from, int to) {
        this.support = support;
        this.offset = from;
        this.length = to - from;
    }

    public abstract int getCompletionContext();

    public int getElementOffset() {
        return this.offset;
    }

    public int getElementLength() {
        return this.length;
    }

    public SyntaxElement getPrevious() throws BadLocationException {
        if (this.previous == null) {
            this.previous = this.support.getPreviousElement(this.offset);
            if (this.previous != null) {
                this.previous.next = this;
            }
        }
        return this.previous;
    }

    public SyntaxElement getNext() throws BadLocationException {
        if (this.next == null) {
            this.next = this.support.getNextElement(this.offset + this.length);
            if (this.next != null) {
                this.next.previous = this;
            }
        }
        return this.next;
    }

    public String getImage() throws BadLocationException {
        return this.support.getDocument().getText(this.offset, this.length);
    }

    public String toString() {
        String content = "???";
        try {
            content = this.support.getDocument().getText(this.getElementOffset(), this.getElementLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return "Element [" + this.offset + "," + (this.offset + this.length - 1) + "] (" + content + ")";
    }

    public static class Directive
    extends TagDirective {
        public Directive(JspSyntaxSupport support, int from, int to, String name, Map attribs) {
            super(support, from, to, name, attribs);
        }

        public int getCompletionContext() {
            return 3;
        }

        public String toString() {
            return "JSP Directive " + super.toString();
        }
    }

    public static class Tag
    extends TagDirective {
        private boolean isClosed;

        public Tag(JspSyntaxSupport support, int from, int to, String name, Map attribs, boolean isClosed) {
            super(support, from, to, name, attribs);
            this.isClosed = isClosed;
        }

        public Tag(JspSyntaxSupport support, int from, int to, String name, Map attribs) {
            this(support, from, to, name, attribs, false);
        }

        public int getCompletionContext() {
            return 1;
        }

        public boolean isClosed() {
            return this.isClosed;
        }

        public String toString() {
            return "JSP Tag " + super.toString();
        }
    }

    public static abstract class TagDirective
    extends TagLikeElement {
        Map attribs;

        public TagDirective(JspSyntaxSupport support, int from, int to, String name, Map attribs) {
            super(support, from, to, name);
            this.attribs = attribs;
        }

        public Map getAttributes() {
            return this.attribs;
        }

        public String toString() {
            StringBuffer ret = new StringBuffer(super.toString() + " - {");
            for (Object next : this.attribs.keySet()) {
                ret.append(next).append("='").append(this.attribs.get(next)).append("', ");
            }
            ret.append("}");
            return ret.toString();
        }
    }

    public static class EndTag
    extends TagLikeElement {
        public EndTag(JspSyntaxSupport support, int from, int to, String name) {
            super(support, from, to, name);
        }

        public int getCompletionContext() {
            return 2;
        }

        public String toString() {
            return "JSP EndTag " + super.toString();
        }
    }

    public static abstract class TagLikeElement
    extends SyntaxElement {
        String name;

        public TagLikeElement(JspSyntaxSupport support, int from, int to, String name) {
            super(support, from, to);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return super.toString() + " - '" + this.name + "'";
        }
    }

    public static class Error
    extends SyntaxElement {
        public Error(JspSyntaxSupport support, int from, int to) {
            super(support, from, to);
        }

        public int getCompletionContext() {
            return 8;
        }

        public String toString() {
            return "JSP Error " + super.toString();
        }
    }

    public static class ScriptingL
    extends SyntaxElement {
        public ScriptingL(JspSyntaxSupport support, int from, int to) {
            super(support, from, to);
        }

        public int getCompletionContext() {
            return 7;
        }

        public String toString() {
            return "JSP Scripting Language " + super.toString();
        }
    }

    public static class ContentL
    extends SyntaxElement {
        public ContentL(JspSyntaxSupport support, int from, int to) {
            super(support, from, to);
        }

        public int getCompletionContext() {
            return 6;
        }

        public String toString() {
            return "JSP Content Language " + super.toString();
        }
    }

    public static class Text
    extends SyntaxElement {
        public Text(JspSyntaxSupport support, int from, int to) {
            super(support, from, to);
        }

        public int getCompletionContext() {
            return 5;
        }

        public String toString() {
            return "JSP Text " + super.toString();
        }
    }

    public static class ExpressionLanguage
    extends SyntaxElement {
        public ExpressionLanguage(JspSyntaxSupport support, int from, int to) {
            super(support, from, to);
        }

        public int getCompletionContext() {
            return 9;
        }

        public String toString() {
            return "Expression Language " + super.toString();
        }
    }

    public static class Comment
    extends SyntaxElement {
        public Comment(JspSyntaxSupport support, int from, int to) {
            super(support, from, to);
        }

        public int getCompletionContext() {
            return 4;
        }

        public String toString() {
            return "JSP Comment " + super.toString();
        }
    }
}

