# This file contains a map from internet top level domains to the spoken
# language[s] in the country associated with the domain.

# Top level domain list taken from http://data.iana.org/TLD/tlds-alpha-by-domain.txt
# Descriptions for most TLDs a can be found at http://en.wikipedia.org/wiki/List_of_Internet_top-level_domains

tld_to_language = {
    "ac"        : [],
    "ad"        : [],
    "ae"        : [],
    "aero"      : [],
    "af"        : [],
    "ag"        : [],
    "ai"        : [],
    "al"        : [],
    "am"        : [],
    "an"        : [],
    "ao"        : [],
    "aq"        : ["en"],
    "ar"        : ["pt"],
    "arpa"      : ["en"],
    "as"        : ["en"],
    "at"        : ["de"],
    "au"        : ["en"],
    "aw"        : [],
    "ax"        : [],
    "az"        : [],
    "ba"        : ["bs"],
    "bb"        : [],
    "bd"        : [],
    "be"        : ["nl", "fr"],
    "bf"        : [],
    "bg"        : [],
    "bh"        : [],
    "bi"        : [],
    "biz"       : [],
    "bj"        : [],
    "bm"        : [],
    "bn"        : [],
    "bo"        : [],
    "br"        : ["pt"],
    "bs"        : [],
    "bt"        : [],
    "bv"        : [],
    "bw"        : [],
    "by"        : [],
    "bz"        : [],
    "ca"        : ["en"],
    "cat"       : ["ca"],
    "cc"        : [],
    "cd"        : [],
    "cf"        : [],
    "cg"        : [],
    "ch"        : ["de"],
    "ci"        : [],
    "ck"        : [],
    "cl"        : [],
    "cm"        : [],
    "cn"        : ["zh"],
    "co"        : [],
    "com"       : [],
    "coop"      : [],
    "cr"        : ["es"],
    "cu"        : [],
    "cv"        : [],
    "cx"        : [],
    "cy"        : [],
    "cz"        : [],
    "de"        : ["de"],
    "dj"        : [],
    "dk"        : ["da"],
    "dm"        : [],
    "do"        : [],
    "dz"        : [],
    "ec"        : [],
    "edu"       : ["en"],
    "ee"        : ["et"],
    "eg"        : [],
    "er"        : [],
    "es"        : ["es"],
    "et"        : [],
    "eu"        : [],
    "fi"        : ["fi"],
    "fj"        : [],
    "fk"        : [],
    "fm"        : [],
    "fo"        : ["fo"],
    "fr"        : ["fr"],
    "ga"        : [],
    "gb"        : ["en"],
    "gd"        : [],
    "ge"        : ["ka"],
    "gf"        : [],
    "gg"        : [],
    "gh"        : [],
    "gi"        : [],
    "gl"        : [],
    "gm"        : [],
    "gn"        : [],
    "gov"       : ["en"],
    "gp"        : [],
    "gq"        : [],
    "gr"        : ["gr"],
    "gs"        : [],
    "gt"        : [],
    "gu"        : [],
    "gw"        : [],
    "gy"        : [],
    "hk"        : [],
    "hm"        : [],
    "hn"        : [],
    "hr"        : ["hr"],
    "ht"        : [],
    "hu"        : ["hu"],
    "id"        : [],
    "ie"        : [],
    "il"        : ["he"],
    "im"        : ["en"],
    "in"        : ["hi"],
    "info"      : [],
    "int"       : [],
    "io"        : ["en"],
    "iq"        : ["ar"],
    "ir"        : ["ar"],
    "is"        : ["is"],
    "it"        : ["it"],
    "je"        : ["en"],
    "jm"        : [],
    "jo"        : [],
    "jobs"      : [],
    "jp"        : ["ja"],
    "ke"        : [],
    "kg"        : [],
    "kh"        : [],
    "ki"        : [],
    "km"        : [],
    "kn"        : [],
    "kr"        : ["ko"],
    "kw"        : [],
    "ky"        : [],
    "kz"        : ["kk"],
    "la"        : [],
    "lb"        : [],
    "lc"        : [],
    "li"        : [],
    "lk"        : [],
    "lr"        : [],
    "ls"        : [],
    "lt"        : [],
    "lu"        : ["lb"],
    "lv"        : ["lv"],
    "ly"        : [],
    "ma"        : [],
    "mc"        : [],
    "md"        : ["mo"],
    "mg"        : ["mg"],
    "mh"        : [],
    "mil"       : ["en"],
    "mk"        : [],
    "ml"        : [],
    "mm"        : [],
    "mn"        : ["mn"],
    "mo"        : [],
    "mobi"      : [],
    "mp"        : [],
    "mq"        : [],
    "mr"        : [],
    "ms"        : [],
    "mt"        : ["mt"],
    "mu"        : [],
    "museum"    : [],
    "mv"        : [],
    "mw"        : [],
    "mx"        : [],
    "my"        : [],
    "mz"        : [],
    "na"        : [],
    "name"      : [],
    "nc"        : [],
    "ne"        : [],
    "net"       : [],
    "nf"        : [],
    "ng"        : [],
    "ni"        : [],
    "nl"        : ["nl"],
    "no"        : ["no"],
    "np"        : [],
    "nr"        : [],
    "nu"        : [],
    "nz"        : [],
    "om"        : ["en"],
    "org"       : [],
    "pa"        : [],
    "pe"        : [],
    "pf"        : [],
    "pg"        : [],
    "ph"        : [],
    "pk"        : [],
    "pl"        : ["pl"],
    "pm"        : [],
    "pn"        : [],
    "pr"        : ["es"],
    "pro"       : [],
    "ps"        : ["ar"],
    "pt"        : ["pt"],
    "pw"        : [],
    "py"        : [],
    "qa"        : [],
    "re"        : [],
    "ro"        : [],
    "ru"        : ["ru"],
    "rw"        : [],
    "sa"        : ["ar"],
    "sb"        : [],
    "sc"        : [],
    "sd"        : ["su"],
    "se"        : ["sv"],
    "sg"        : ["si"],
    "sh"        : [],
    "si"        : ["sl"],
    "sj"        : [],
    "sk"        : ["sk"],
    "sl"        : [],
    "sm"        : [],
    "sn"        : ["fr"],
    "so"        : ["so"],
    "sr"        : ["nl"],
    "st"        : [],
    "su"        : ["ru"],
    "sv"        : [],
    "sy"        : [],
    "sz"        : [],
    "tc"        : ["tr"],
    "td"        : [],
    "tel"       : [],
    "tf"        : [],
    "tg"        : ["to"],
    "th"        : ["th"],
    "tj"        : ["fa"],
    "tk"        : ["tk"],
    "tl"        : ["pt"],
    "tm"        : ["tk"],
    "tn"        : [],
    "to"        : [],
    "tp"        : ["pt"],
    "tr"        : [],
    "travel"    : [],
    "tt"        : [],
    "tv"        : [],
    "tw"        : ["zh"],
    "tz"        : [],
    "ua"        : [],
    "ug"        : [],
    "uk"        : ["en"],
    "um"        : ["en"],
    "us"        : ["en"],
    "uy"        : [],
    "uz"        : [],
    "va"        : ["it"],
    "vc"        : [],
    "ve"        : [],
    "vg"        : [],
    "vi"        : ["en"],
    "vn"        : ["vi"],
    "vu"        : [],
    "wf"        : [],
    "ws"        : ["sm"],
    "ye"        : [],
    "yt"        : [],
    "yu"        : ["sh"],
    "za"        : ["af"],
    "zm"        : [],
    "zw"        : [],
}

