'\"
'\" Generated from file '/usr/obj/i386/tcllib-1.11.1/tcllib-1.11.1/modules/counter/counter.man' by tcllib/doctools with format 'nroff'
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "counter" n 2.0.4 counter "Counters and Histograms"
.BS
.SH NAME
counter \- Procedures for counters and histograms
.SH SYNOPSIS
package require \fBTcl  8\fR
.sp
package require \fBcounter  ?2.0.4?\fR
.sp
\fB::counter::init\fR \fItag args\fR
.sp
\fB::counter::count\fR \fItag\fR ?\fIdelta\fR? ?\fIinstance\fR?
.sp
\fB::counter::start\fR \fItag instance\fR
.sp
\fB::counter::stop\fR \fItag instance\fR
.sp
\fB::counter::get\fR \fItag args\fR
.sp
\fB::counter::exists\fR \fItag\fR
.sp
\fB::counter::names\fR
.sp
\fB::counter::histHtmlDisplay\fR \fItag args\fR
.sp
\fB::counter::reset\fR \fItag args\fR
.sp
.BE
.SH DESCRIPTION
.PP
The \fBcounter\fR package provides a counter facility and can
compute statistics and histograms over the collected data.
.TP
\fB::counter::init\fR \fItag args\fR
This defines a counter with the name \fItag\fR.  The \fIargs\fR
determines the characteristics of the counter.  The \fIargs\fR are
.RS
.TP
\fB-group\fR \fIname\fR
Keep a grouped counter where the name of the histogram bucket is
passed into \fB::counter::count\fR.
.TP
\fB-hist\fR \fIbucketsize\fR
Accumulate the counter into histogram buckets of size
\fIbucketsize\fR.  For example, if the samples are millisecond time
values and \fIbucketsize\fR is 10, then each histogram bucket
represents time values of 0 to 10 msec, 10 to 20 msec, 20 to 30 msec,
and so on.
.TP
\fB-hist2x\fR \fIbucketsize\fR
Accumulate the statistic into histogram buckets.  The size of the
first bucket is \fIbucketsize\fR, each other bucket holds values 2
times the size of the previous bucket.  For example, if
\fIbucketsize\fR is 10, then each histogram bucket represents time
values of 0 to 10 msec, 10 to 20 msec, 20 to 40 msec, 40 to 80 msec,
and so on.
.TP
\fB-hist10x\fR \fIbucketsize\fR
Accumulate the statistic into histogram buckets.  The size of the
first bucket is \fIbucketsize\fR, each other bucket holds values 10
times the size of the previous bucket.  For example, if
\fIbucketsize\fR is 10, then each histogram bucket represents time
values of 0 to 10 msec, 10 to 100 msec, 100 to 1000 msec, and so on.
.TP
\fB-lastn\fR \fIN\fR
Save the last \fIN\fR values of the counter to maintain a "running
average" over the last \fIN\fR values.
.TP
\fB-timehist\fR \fIsecsPerMinute\fR
Keep a time-based histogram.  The counter is summed into a histogram
bucket based on the current time.  There are 60 per-minute buckets
that have a size determined by \fIsecsPerMinute\fR, which is normally
60, but for testing purposes can be less.  Every "hour" (i.e., 60
"minutes") the contents of the per-minute buckets are summed into the
next hourly bucket.  Every 24 "hours" the contents of the per-hour
buckets are summed into the next daily bucket.  The counter package
keeps all time-based histograms in sync, so the first
\fIsecsPerMinute\fR value seen by the package is used for all
subsequent time-based histograms.
.RE
.TP
\fB::counter::count\fR \fItag\fR ?\fIdelta\fR? ?\fIinstance\fR?
Increment the counter identified by \fItag\fR.  The default increment
is 1, although you can increment by any value, integer or real, by
specifying \fIdelta\fR.  You must declare each counter with
\fB::counter::init\fR to define the characteristics of counter before
you start to use it.  If the counter type is \fB-group\fR, then the
counter identified by \fIinstance\fR is incremented.
.TP
\fB::counter::start\fR \fItag instance\fR
Record the starting time of an interval.  The \fItag\fR is the name of
the counter defined as a \fB-hist\fR value-based histogram.  The
\fIinstance\fR is used to distinguish this interval from any other
intervals that might be overlapping this one.
.TP
\fB::counter::stop\fR \fItag instance\fR
Record the ending time of an interval.  The delta time since the
corresponding \fB::counter::start\fR call for \fIinstance\fR is
recorded in the histogram identified by \fItag\fR.
.TP
\fB::counter::get\fR \fItag args\fR
Return statistics about a counter identified by \fItag\fR.  The
\fIargs\fR determine what value to return:
.RS
.TP
\fB-total\fR
Return the total value of the counter.  This is the default if
\fIargs\fR is not specified.
.TP
\fB-totalVar\fR
Return the name of the total variable.  Useful for specifying with
-textvariable in a Tk widget.
.TP
\fB-N\fR
Return the number of samples accumulated into the counter.
.TP
\fB-avg\fR
Return the average of samples accumulated into the counter.
.TP
\fB-avgn\fR
Return the average over the last \fIN\fR samples taken.  The \fIN\fR
value is set in the \fB::counter::init\fR call.
.TP
\fB-hist\fR \fIbucket\fR
If \fIbucket\fR is specified, then the value in that bucket of the
histogram is returned.  Otherwise the complete histogram is returned
in array get format sorted by bucket.
.TP
\fB-histVar\fR
Return the name of the histogram array variable.
.TP
\fB-histHour\fR
Return the complete hourly histogram in array get format sorted by
bucket.
.TP
\fB-histHourVar\fR
Return the name of the hourly histogram array variable.
.TP
\fB-histDay\fR
Return the complete daily histogram in array get format sorted by
bucket.
.TP
\fB-histDayVar\fR
Return the name of the daily histogram array variable.
.TP
\fB-resetDate\fR
Return the clock seconds value recorded when the
counter was last reset.
.TP
\fB-all\fR
Return an array get of the array used to store the counter.  This
includes the total, the number of samples (N), and any type-specific
information.  This does not include the histogram array.
.RE
.TP
\fB::counter::exists\fR \fItag\fR
Returns 1 if the counter is defined.
.TP
\fB::counter::names\fR
Returns a list of all counters defined.
.TP
\fB::counter::histHtmlDisplay\fR \fItag args\fR
Generate HTML to display a histogram for a counter.  The \fIargs\fR
control the format of the display.  They are:
.RS
.TP
\fB-title\fR \fIstring\fR
Label to display above bar chart
.TP
\fB-unit\fR \fIunit\fR
Specify \fBminutes\fR, \fBhours\fR, or \fBdays\fR for the
time-base histograms.  For value-based histograms, the \fIunit\fR is
used in the title.
.TP
\fB-images\fR \fIurl\fR
URL of /images directory.
.TP
\fB-gif\fR \fIfilename\fR
Image for normal histogram bars.  The \fIfilename\fR is relative to
the \fB-images\fR directory.
.TP
\fB-ongif\fR \fIfilename\fR
Image for the active histogram bar.  The \fIfilename\fR is relative to
the \fB-images\fR directory.
.TP
\fB-max\fR \fIN\fR
Maximum number of value-based buckets to display.
.TP
\fB-height\fR \fIN\fR
Pixel height of the highest bar.
.TP
\fB-width\fR \fIN\fR
Pixel width of each bar.
.TP
\fB-skip\fR \fIN\fR
Buckets to skip when labeling value-based histograms.
.TP
\fB-format\fR \fIstring\fR
Format used to display labels of buckets.
.TP
\fB-text\fR \fIboolean\fR
If 1, a text version of the histogram is dumped, otherwise a graphical
one is generated.
.RE
.TP
\fB::counter::reset\fR \fItag args\fR
Resets the counter with the name \fItag\fR to an initial state. The
\fIargs\fR determine the new characteristics of the counter. They have
the same meaning as described for \fB::counter::init\fR.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIcounter\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
counting, histogram, statistics, tallying