'\"
'\" Generated from file '/usr/obj/i386/tcllib-1.11.1/tcllib-1.11.1/modules/docstrip/docstrip_util.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2003-2005 Lars Hellstrm <Lars dot Hellstrom at residenset dot net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "docstrip_util" n 1.2 docstrip "Literate programming tool"
.BS
.SH NAME
docstrip_util \- Docstrip-related utilities
.SH SYNOPSIS
package require \fBTcl  8.4\fR
.sp
package require \fBdocstrip::util  ?1.2?\fR
.sp
\fBdocstrip::util::ddt2man\fR \fItext\fR
.sp
\fBdocstrip::util::guards\fR \fIsubcmd\fR \fItext\fR
.sp
\fBdocstrip::util::thefile\fR \fIfilename\fR ?\fIoption\fR \fIvalue\fR ...?
.sp
.BE
.SH DESCRIPTION
The \fBdocstrip::util\fR package is meant for collecting various
utility procedures that may be useful for developers who make use of
the \fBdocstrip\fR package in some projects. It is separate from
the main package to avoid overhead for end-users.
.SH COMMANDS
.TP
\fBdocstrip::util::ddt2man\fR \fItext\fR
The \fBddt2man\fR command reformats \fItext\fR from the general
\fBdocstrip\fR format to \fBdoctools\fR "\fI.man\fR" format
(Tcl Markup Language for Manpages). The different line types are
treated as follows:
.RS
.TP
comment and metacomment lines
The '%' and '%%' prefixes are removed, the rest of the text is
kept as it is.
.TP
empty lines
These are kept as they are. (Effectively this means that they will
count as comment lines after a comment line and as code lines
after a code line.)
.TP
code lines
\fBexample_begin\fR and \fBexample_end\fR commands are placed
at the beginning and end of every block of consecutive code
lines. Brackets in a code line are converted to \fBlb\fR and
\fBrb\fR commands.
.TP
verbatim guards
These are processed as usual, so they do not show up in the
result but every line in a verbatim block is treated as a code
line.
.TP
other guards
These are treated as code lines, except that the actual guard is
\fBemph\fRasised.
.RE
At the time of writing, no project has employed \fBdoctools\fR
markup in master source files, so experience of what works well is
not available. A source file could however look as follows
.nf

   % [manpage_begin gcd n 1.0]
   % [moddesc {Greatest Common Divisor}]
   % [require gcd [opt 1.0]]
   % [description]
   %
   % [list_begin definitions]
   % [call [cmd gcd] [arg a] [arg b]]
   %   The [cmd gcd] procedure takes two arguments [arg a] and [arg b] which
   %   must be integers and returns their greatest common divisor.
   proc gcd {a b} {
   %   The first step is to take the absolute values of the arguments.
   %   This relieves us of having to worry about how signs will be treated
   %   by the remainder operation.
      set a [expr {abs($a)}]
      set b [expr {abs($b)}]
   %   The next line does all of Euclid's algorithm! We can make do
   %   without a temporary variable, since $a is substituted before the
   %   [lb]set a $b[rb] and thus continues to hold a reference to the
   %   "old" value of [var a].
      while {$b>0} { set b [expr { $a % [set a $b] }] }
   %   In Tcl 8.3 we might want to use [cmd set] instead of [cmd return]
   %   to get the slight advantage of byte-compilation.
   %<tcl83>  set a
   %<!tcl83>   return $a
   }
   % [list_end]
   %
   % [manpage_end]

.fi
If the above text is (suitably unindented and) fed through
\fBdocstrip::util::ddt2man\fR then the result will be a syntactically
correct \fBdoctools\fR manpage, even though its purpose is a
bit different.
.sp
It is suggested that master source code files with \fBdoctools\fR
markup are given the suffix "\fI.ddt\fR", hence the "ddt" in
\fBddt2man\fR.
.TP
\fBdocstrip::util::guards\fR \fIsubcmd\fR \fItext\fR
The \fBguards\fR command returns information (mostly of a
statistical nature) about the ordinary docstrip guards that occur
in the \fItext\fR. The \fIsubcmd\fR selects what is returned.
.RS
.TP
counts
List the guard expression terminals with counts. The format of
the return value is a dictionary which maps the terminal name to
the number of occurencies of it in the file.
.TP
exprcount
List the guard expressions with counts. The format of the return
value is a dictionary which maps the expression to the number of
occurencies of it in the file.
.TP
exprerr
List the syntactically incorrect guard expressions (e.g.
parentheses do not match, or a terminal is missing). The return
value is a list, with the elements in no particular order.
.TP
expressions
List the guard expressions. The return value is a list, with the
elements in no particular order.
.TP
exprmods
List the guard expressions with modifiers. The format of the return
value is a dictionary where each index is a guard expression and
each entry is a string with one character for every guard line that
has this expression. The characters in the entry specify what
modifier was used in that line: +, -, *, /, or (for guard without
modifier:) space. This is the most primitive form of the
information gathered by \fBguards\fR.
.TP
names
List the guard expression terminals. The return value is a list,
with the elements in no particular order.
.TP
rotten
List the malformed guard lines (this does not include lines where
only the expression is malformed, though). The format of the return
value is a dictionary which maps line numbers to their contents.
.RE
.TP
\fBdocstrip::util::thefile\fR \fIfilename\fR ?\fIoption\fR \fIvalue\fR ...?
The \fBthefile\fR command opens the file \fIfilename\fR, reads it to
end, closes it, and returns the contents. The option-value pairs are
passed on to \fBfconfigure\fR to configure the open file channel
before anything is read from it.
.PP
.SH "SEE ALSO"
docstrip, doctools, doctools_fmt
.SH KEYWORDS
.ddt, docstrip, doctools, documentation, literate programming, source
.SH COPYRIGHT
.nf
Copyright (c) 2003-2005 Lars Hellstrm <Lars dot Hellstrom at residenset dot net>

.fi