"""
$RCSfile: IXSLTMethod.py,v $

ZopeXMLMethods provides filters to apply to Zope objects for XML/XSLT
processing.  XSLTMethod associates XSLT transformers with XML
documents.

XSLTMethod automatically transforms an XML document via XSLT, where
the XML document is obtained from another Zope object via acquisition.
IXSLTMethod is the interface implemented by XSLTMethod.

Author: Craeg Strong <cstrong@arielpartners.com>
Modified by Philipp von Weitershausen <philikon@philikon.de>

$Id: IXSLTMethod.py,v 1.10 2003/03/30 03:45:47 cstrong Exp $
"""

__cvstag__  = '$Name:  $'[6:-2]
__date__    = '$Date: 2003/03/30 03:45:47 $'[6:-2]
__version__ = '$Revision: 1.10 $'[10:-2]

# Zope Base Classes
from Interface import Base

################################################################
# IXSLTMethod interface
################################################################

class IXSLTMethod(Base):
    """
    Automatically transforms an XML document via XSLT, where the XML
    document is obtained from another Zope object via acquisition.
    """

    def availableProcessors():
        """
        Return names of currently available XSLT processor libraries
        """

    def processor():
        """
        Obtain the object encapsulating the selected XSLT processor.
        """

    def getXslTransformer():
        """
        Obtain the Zope object holding the XSLT, or None if the name
        does not point to a valid object.
        """

    def getXmlSourceObject():
        """
        Retrieves the source Zope object (for XML content) via
        acquisition.
        """

    def transform(REQUEST):
        "Generate results using transformer and return them as a string"

    def setDebugLevel(debugLevel):
        "same as changing the property.  For use in scripts"

    def setCachingOn(REQUEST=None):
        "same as changing the property.  For use in scripts"

    def setCachingOff(REQUEST=None):
        "same as changing the property.  For use in scripts"
        
    def isDebugging():
        "Return true if and only if debugging is on."

    def isCachingOn():
        "Return TRUE if caching is turned on"
