/*
 *  Copyright (C) 2006  MakeHuman Project
 *
 *  This program is free software; you  can  redistribute  it  and/or
 *  modify  it  under  the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either  version  2  of
 *  the License, or (at your option) any later version.
 *
 *  This  program  is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the  implied  warranty  of
 *  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foun-
 *  dation, Inc., 59 Temple Place, Suite 330, Boston,  MA  02111-1307
 *  USA
 *  
 *  File   : PoseTarget.h
 *  Project: MakeHuman <info@makehuman.org>, http://www.makehuman.org/
 *  App    : makehuman
 *
 *  For individual developers look into the AUTHORS file.
 *   
 */
 
#ifndef POSETARGET_H
#define POSETARGET_H 1

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#include <vector>
#include <sstream>
#include <iostream>
#include <fstream>
#include "util.h"
#include "FileReader.h"
#include "PoseSemiTarget.h"

namespace Animorph {

class PoseTarget
{
private:
  PoseSemiTarget positiveTarget;
  PoseSemiTarget negativeTarget;
  bool negative;
  bool positive;
  vector <PoseSemiTarget> auxPositiveTargets;
  vector <PoseSemiTarget> auxNegativeTargets;
  
public:
  PoseTarget () 
  {
    negative = false;
    positive = false;
  }
  
  PoseSemiTarget &getPositiveTarget () {return positiveTarget;}
  PoseSemiTarget &getNegativeTarget () {return negativeTarget;}  
  bool hasNegative() const {return negative;}
  bool hasPositive() const {return positive;}  
  
  bool load(const std::string& filename, bool is_negative);
  
  void resetCenter();
  bool loadAuxiliaryRotation(const std::string& filename, bool is_negative);
  vector <PoseSemiTarget> &getAuxPositiveTargets() {return auxPositiveTargets;};
  vector <PoseSemiTarget> &getAuxNegativeTargets() {return auxNegativeTargets;};
};

}

#endif	// POSETARGET_H

