/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.IndexFileDeleter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiTermDocs;
import org.apache.lucene.index.MultiTermEnum;
import org.apache.lucene.index.MultiTermPositions;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.store.Directory;

public class MultiReader
extends IndexReader {
    private IndexReader[] subReaders;
    private int[] starts;
    private Hashtable normsCache = new Hashtable();
    private int maxDoc = 0;
    private int numDocs = -1;
    private boolean hasDeletions = false;
    private byte[] ones;

    public MultiReader(IndexReader[] subReaders) throws IOException {
        super(subReaders.length == 0 ? null : subReaders[0].directory());
        this.initialize(subReaders);
    }

    MultiReader(Directory directory, SegmentInfos sis, boolean closeDirectory, IndexReader[] subReaders) {
        super(directory, sis, closeDirectory);
        this.initialize(subReaders);
    }

    private void initialize(IndexReader[] subReaders) {
        this.subReaders = subReaders;
        this.starts = new int[subReaders.length + 1];
        for (int i = 0; i < subReaders.length; ++i) {
            this.starts[i] = this.maxDoc;
            this.maxDoc += subReaders[i].maxDoc();
            if (!subReaders[i].hasDeletions()) continue;
            this.hasDeletions = true;
        }
        this.starts[subReaders.length] = this.maxDoc;
    }

    public TermFreqVector[] getTermFreqVectors(int n) throws IOException {
        int i = this.readerIndex(n);
        return this.subReaders[i].getTermFreqVectors(n - this.starts[i]);
    }

    public TermFreqVector getTermFreqVector(int n, String field) throws IOException {
        int i = this.readerIndex(n);
        return this.subReaders[i].getTermFreqVector(n - this.starts[i], field);
    }

    public synchronized int numDocs() {
        if (this.numDocs == -1) {
            int n = 0;
            for (int i = 0; i < this.subReaders.length; ++i) {
                n += this.subReaders[i].numDocs();
            }
            this.numDocs = n;
        }
        return this.numDocs;
    }

    public int maxDoc() {
        return this.maxDoc;
    }

    public Document document(int n, FieldSelector fieldSelector) throws IOException {
        int i = this.readerIndex(n);
        return this.subReaders[i].document(n - this.starts[i], fieldSelector);
    }

    public boolean isDeleted(int n) {
        int i = this.readerIndex(n);
        return this.subReaders[i].isDeleted(n - this.starts[i]);
    }

    public boolean hasDeletions() {
        return this.hasDeletions;
    }

    protected void doDelete(int n) throws IOException {
        this.numDocs = -1;
        int i = this.readerIndex(n);
        this.subReaders[i].deleteDocument(n - this.starts[i]);
        this.hasDeletions = true;
    }

    protected void doUndeleteAll() throws IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].undeleteAll();
        }
        this.hasDeletions = false;
        this.numDocs = -1;
    }

    private int readerIndex(int n) {
        int lo = 0;
        int hi = this.subReaders.length - 1;
        while (hi >= lo) {
            int mid = lo + hi >> 1;
            int midValue = this.starts[mid];
            if (n < midValue) {
                hi = mid - 1;
                continue;
            }
            if (n > midValue) {
                lo = mid + 1;
                continue;
            }
            while (mid + 1 < this.subReaders.length && this.starts[mid + 1] == midValue) {
                ++mid;
            }
            return mid;
        }
        return hi;
    }

    public boolean hasNorms(String field) throws IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            if (!this.subReaders[i].hasNorms(field)) continue;
            return true;
        }
        return false;
    }

    private byte[] fakeNorms() {
        if (this.ones == null) {
            this.ones = SegmentReader.createFakeNorms(this.maxDoc());
        }
        return this.ones;
    }

    public synchronized byte[] norms(String field) throws IOException {
        byte[] bytes = (byte[])this.normsCache.get(field);
        if (bytes != null) {
            return bytes;
        }
        if (!this.hasNorms(field)) {
            return this.fakeNorms();
        }
        bytes = new byte[this.maxDoc()];
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].norms(field, bytes, this.starts[i]);
        }
        this.normsCache.put(field, bytes);
        return bytes;
    }

    public synchronized void norms(String field, byte[] result, int offset) throws IOException {
        byte[] bytes = (byte[])this.normsCache.get(field);
        if (bytes == null && !this.hasNorms(field)) {
            bytes = this.fakeNorms();
        }
        if (bytes != null) {
            System.arraycopy(bytes, 0, result, offset, this.maxDoc());
        }
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].norms(field, result, offset + this.starts[i]);
        }
    }

    protected void doSetNorm(int n, String field, byte value) throws IOException {
        this.normsCache.remove(field);
        int i = this.readerIndex(n);
        this.subReaders[i].setNorm(n - this.starts[i], field, value);
    }

    public TermEnum terms() throws IOException {
        return new MultiTermEnum(this.subReaders, this.starts, null);
    }

    public TermEnum terms(Term term) throws IOException {
        return new MultiTermEnum(this.subReaders, this.starts, term);
    }

    public int docFreq(Term t) throws IOException {
        int total = 0;
        for (int i = 0; i < this.subReaders.length; ++i) {
            total += this.subReaders[i].docFreq(t);
        }
        return total;
    }

    public TermDocs termDocs() throws IOException {
        return new MultiTermDocs(this.subReaders, this.starts);
    }

    public TermPositions termPositions() throws IOException {
        return new MultiTermPositions(this.subReaders, this.starts);
    }

    protected void setDeleter(IndexFileDeleter deleter) {
        this.deleter = deleter;
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].setDeleter(deleter);
        }
    }

    protected void doCommit() throws IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].commit();
        }
    }

    void startCommit() {
        super.startCommit();
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].startCommit();
        }
    }

    void rollbackCommit() {
        super.rollbackCommit();
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].rollbackCommit();
        }
    }

    protected synchronized void doClose() throws IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].close();
        }
    }

    public Collection getFieldNames(IndexReader.FieldOption fieldNames) {
        HashSet fieldSet = new HashSet();
        for (int i = 0; i < this.subReaders.length; ++i) {
            IndexReader reader = this.subReaders[i];
            Collection names = reader.getFieldNames(fieldNames);
            fieldSet.addAll(names);
        }
        return fieldSet;
    }
}

