/*
 * Decompiled with CFR 0.152.
 */
package msfgui;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import msfgui.Base64;
import msfgui.MsfException;
import msfgui.MsfguiApp;

public class MsfguiLog {
    protected final Map sessions = new HashMap();
    protected final ArrayList activityLog = new ArrayList();
    protected final DateFormat formatter;
    protected final Set hashes = new HashSet();
    protected final Pattern hashPattern;
    public static MsfguiLog defaultLog;

    public static void initDefaultLog() {
        defaultLog = new MsfguiLog();
    }

    public MsfguiLog() {
        this.formatter = DateFormat.getDateTimeInstance();
        this.activityLog.add(this.now() + " msfgui started.");
        this.hashPattern = Pattern.compile("\\w+:[0-9]+:\\w+:\\w+:::");
    }

    public void logHashes(String hashString) {
        for (String line : hashString.split("\n")) {
            if (!this.hashPattern.matcher(line).matches()) continue;
            this.hashes.add(line);
        }
    }

    public Set getHashes() {
        return this.hashes;
    }

    public void logSession(Map session) {
        if (this.sessions.get(session.get("id")) != null) {
            return;
        }
        this.sessions.put(session.get("id"), session);
        this.activityLog.add(this.now() + "  Session " + session.get("id") + " to " + session.get("tunnel_peer") + " opened.");
    }

    public void checkSessions(Map sessionsActive) {
        for (Object o : this.sessions.keySet()) {
            Map session = (Map)this.sessions.get(o);
            if (session.get("inactive") != null || sessionsActive.get(o) != null) continue;
            session.put("inactive", o);
            this.activityLog.add(this.now() + " Session " + o + " closed.");
        }
    }

    public void logMethodCall(String methodName, Object[] params) {
        try {
            if (methodName.startsWith("session.")) {
                if (methodName.endsWith("_write")) {
                    this.logConsole(params[0].toString(), new String(Base64.decode(params[1].toString())), true);
                } else if (methodName.endsWith("_script")) {
                    this.logConsole(params[0].toString(), "run " + params[1].toString(), true);
                } else if (methodName.endsWith("_upgrade")) {
                    this.activityLog.add(this.now() + " Session " + params[0] + " upgrade initiated.");
                }
            } else if (methodName.equals("module.execute")) {
                this.activityLog.add(this.now() + "  " + params[0] + " " + params[1] + " executed with options " + params[2]);
            } else if (methodName.equals("console.write")) {
                this.logConsole("Console " + params[0].toString(), new String(Base64.decode(params[1].toString())), true);
            } else if (methodName.equals("console.destroy")) {
                this.activityLog.add(this.now() + " Console " + params[0] + " destroyed.");
            } else if (methodName.equals("plugin.load")) {
                this.activityLog.add(this.now() + " Plugin " + params[0] + " loading.");
            } else if (methodName.equals("plugin.unload")) {
                this.activityLog.add(this.now() + " Plugin " + params[0] + " unloaded.");
            } else if (methodName.equals("db.connect")) {
                this.activityLog.add(this.now() + " Database connection started with options " + params[0]);
            }
        }
        catch (MsfException msfException) {
            // empty catch block
        }
    }

    public void logMethodReturn(String methodName, Object[] params, Object result) {
        try {
            if (methodName.equals("console.create")) {
                this.activityLog.add(this.now() + " Console " + ((Map)result).get("id") + " created.");
                this.sessions.put("Console " + ((Map)result).get("id"), result);
                ((Map)result).put("inactive", "console");
            } else if (methodName.equals("console.list")) {
                List consoles = (List)((Map)result).get("consoles");
                for (Object console : consoles) {
                    this.activityLog.add(this.now() + " Console " + ((Map)console).get("id") + " discovered.");
                    this.sessions.put("Console " + ((Map)console).get("id"), result);
                    ((Map)console).put("inactive", "console");
                }
            } else if (methodName.equals("console.read")) {
                String resString = new String(Base64.decode(((Map)result).get("data").toString()));
                this.logConsole("Console " + params[0], resString, false);
                this.logHashes(resString);
            } else if (methodName.startsWith("session.") && methodName.endsWith("_read")) {
                String resString = new String(Base64.decode(((Map)result).get("data").toString()));
                this.logConsole(params[0].toString(), resString, false);
                this.logHashes(resString);
            }
        }
        catch (MsfException mex) {
            // empty catch block
        }
    }

    public void logConsole(String sessionId, String message, boolean sending) {
        ArrayList<String> consoleLog;
        Map session = (Map)this.sessions.get(sessionId);
        if (session == null || message.length() == 0) {
            return;
        }
        if ((message.indexOf(10) - message.length()) % message.length() != -1) {
            message = "\n" + message;
        }
        if ((consoleLog = (ArrayList<String>)session.get("console")) == null) {
            consoleLog = new ArrayList<String>(30);
            session.put("console", consoleLog);
        }
        if (sending) {
            consoleLog.add(this.now() + " >>>" + message);
        } else {
            consoleLog.add(this.now() + " " + message);
        }
    }

    public String save() throws IOException {
        String destination = MsfguiApp.getTempFolder() + File.separator + "msfguilog_" + DateFormat.getDateTimeInstance(2, 2).format(new Date()).replaceAll("[, :]+", "-") + ".html";
        this.save(destination);
        return destination;
    }

    public String save(String filename) throws IOException {
        Map session;
        this.activityLog.add(this.now() + " msfgui log created.");
        FileWriter fout = new FileWriter(filename);
        fout.write("<html><head><style type=\"text/css\">\npre {font-size:9pt;}\ntd{font-size:11pt; padding-right: 10px; padding-top: 5px;}\nbody{ font:13px Arial,Helvetica,sans-serif;}\nh1 {border-bottom: 1px solid #BBBBBB; margin: 10px 0 15px 0;}\nh2 {margin: 0 0 10px 0 ;}\nh1.header  {font-size:3em;\nmargin:20px 0 30px;\ntext-align:center;}\ntr.sent td {background-color: #EEFFEE; color: black;}\ntr.recv td {background-color: #EEEEFF; color: black;}\ndiv.session {float: left; padding-right: 10px;}\n#page{margin:0 auto; padding:30px 200px;}\n</style></head>\n<body>\n<div id=\"page\"><h1 class=\"header\">msfgui</h1>");
        fout.write("<h1>Hosts</h1>");
        Set sessionsEntrySet = this.sessions.entrySet();
        if (this.sessions.isEmpty()) {
            fout.write("<p>None. Go exploit something next time.</p>");
        } else {
            fout.write("<table><thead><tr><td>host</td>\n");
            ArrayList<String> headers = new ArrayList<String>();
            headers.add("type");
            headers.add("via_exploit");
            headers.add("via_payload");
            headers.add("tunnel_peer");
            headers.add("tunnel_local");
            headers.add("desc");
            fout.write("<td>type</td><td>via_exploit</td><td>via_payload</td><td>tunnel_peer</td><td>tunnel_local</td><td>desc</td>");
            HashMap<String, HashSet<Map>> hashMap = new HashMap<String, HashSet<Map>>();
            for (Map.Entry e : sessionsEntrySet) {
                session = (Map)e.getValue();
                if (!session.containsKey("tunnel_peer")) continue;
                String host = session.get("tunnel_peer").toString().split(":")[0];
                HashSet<Map> hostSet = (HashSet<Map>)hashMap.get(host);
                if (hostSet == null) {
                    hostSet = new HashSet<Map>();
                    hashMap.put(host, hostSet);
                }
                hostSet.add(session);
            }
            fout.write("</tr></thead><tbody>\n");
            for (Map.Entry e : hashMap.entrySet()) {
                String key = e.getKey().toString();
                fout.write("<tr><td>" + key + "</td>\n");
                Set hostSessions = (Set)e.getValue();
                for (Object o : hostSessions) {
                    Map session2 = (Map)o;
                    for (Object e2 : headers) {
                        fout.write("<td>" + session2.get(e2) + "</td>");
                    }
                    fout.write("</tr>\n<tr><td></td>");
                }
                fout.write("</tr>");
            }
            fout.write("</tbody></table>\n\n");
        }
        fout.write("<h1>Activities</h1><table><tbody>\n");
        for (Object e : this.activityLog) {
            fout.write("<tr><td>" + e.toString() + "</td></tr>\n");
        }
        fout.write("</tbody></table>\n\n");
        fout.write("<h1>Session logs</h1>\n");
        for (Object object : sessionsEntrySet) {
            Map.Entry ent = (Map.Entry)object;
            Object log = ((Map)ent.getValue()).get("console");
            if (log == null) continue;
            session = (Map)ent.getValue();
            fout.write("<div class=\"session\"><h2>Session " + ent.getKey() + "</h2>");
            if (session.containsKey("tunnel_peer")) {
                fout.write("To " + session.get("tunnel_peer"));
            }
            fout.write("<table><tbody>\n");
            for (Object logEntry : (ArrayList)log) {
                String entryString = logEntry.toString();
                if ((entryString.indexOf(10) - entryString.length()) % entryString.length() != -1) {
                    entryString = "<pre>" + entryString + "</pre>";
                }
                if (entryString.contains(">>>")) {
                    fout.write("<tr class=\"sent\"><td>" + entryString + "</td></tr>\n");
                    continue;
                }
                fout.write("<tr class=\"recv\"><td>" + entryString + "</td></tr>\n");
            }
            fout.write("</tbody></table></div>");
        }
        fout.write("</body></html>\n");
        fout.flush();
        fout.close();
        return filename;
    }

    private String now() {
        return this.formatter.format(new Date());
    }
}

