/*
 * Decompiled with CFR 0.152.
 */
package msfgui;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import msfgui.MsfguiApp;
import msfgui.OptionsDialog;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class SearchDwldOptionsDialog
extends OptionsDialog {
    private ButtonGroup buttonGroup1;
    private JTextField dirField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JButton okButton;
    private JButton outDirButton;
    private JTextField outputDirField;
    private JCheckBox recursiveBox;
    private JTextField searchPatternField;

    public SearchDwldOptionsDialog(Frame parent, String currentDir) {
        super(parent, "Search/Download Options", true);
        this.initComponents();
        this.dirField.setText(currentDir);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.okButton = new JButton();
        this.jLabel1 = new JLabel();
        this.dirField = new JTextField();
        this.jLabel2 = new JLabel();
        this.searchPatternField = new JTextField();
        this.outputDirField = new JTextField();
        this.outDirButton = new JButton();
        this.recursiveBox = new JCheckBox();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SearchDwldOptionsDialog.this.closeDialog(evt);
            }
        });
        ResourceMap resourceMap = Application.getInstance(MsfguiApp.class).getContext().getResourceMap(SearchDwldOptionsDialog.class);
        this.okButton.setText(resourceMap.getString("okButton.text", new Object[0]));
        this.okButton.setName("okButton");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchDwldOptionsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.dirField.setText(resourceMap.getString("dirField.text", new Object[0]));
        this.dirField.setName("dirField");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.searchPatternField.setText(resourceMap.getString("searchPatternField.text", new Object[0]));
        this.searchPatternField.setName("searchPatternField");
        this.outputDirField.setText(resourceMap.getString("outputDirField.text", new Object[0]));
        this.outputDirField.setName("outputDirField");
        this.outDirButton.setText(resourceMap.getString("outDirButton.text", new Object[0]));
        this.outDirButton.setName("outDirButton");
        this.outDirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchDwldOptionsDialog.this.outDirButtonActionPerformed(evt);
            }
        });
        this.recursiveBox.setSelected(true);
        this.recursiveBox.setText(resourceMap.getString("recursiveBox.text", new Object[0]));
        this.recursiveBox.setName("recursiveBox");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dirField, -1, 322, Short.MAX_VALUE)).addComponent(this.okButton, GroupLayout.Alignment.TRAILING, -2, 67, -2).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchPatternField, -1, 404, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.recursiveBox)).addGroup(layout.createSequentialGroup().addComponent(this.outDirButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputDirField, -1, 418, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.dirField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.recursiveBox).addComponent(this.jLabel2).addComponent(this.searchPatternField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputDirField, -2, -1, -2).addComponent(this.outDirButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton).addContainerGap()));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        StringBuilder cmd = new StringBuilder("file_collector");
        if (this.dirField.getText().length() > 0) {
            cmd.append(" -d '").append(MsfguiApp.doubleBackslashes(this.dirField.getText())).append("'");
        }
        cmd.append(" -l ").append(this.outputDirField.getText());
        if (this.recursiveBox.isSelected()) {
            cmd.append(" -r ");
        }
        cmd.append(" -f ").append(this.searchPatternField.getText());
        String tempFileName = MsfguiApp.getTempFilename("foundfiles", ".txt");
        cmd.append(" -o \"").append(MsfguiApp.doubleBackslashes(tempFileName)).append("\"");
        cmd.append(" -i \"").append(MsfguiApp.doubleBackslashes(tempFileName)).append("\"");
        this.command = cmd.toString();
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void outDirButtonActionPerformed(ActionEvent evt) {
        JFileChooser choosy = MsfguiApp.fileChooser;
        int mode = choosy.getFileSelectionMode();
        choosy.setFileSelectionMode(1);
        if (choosy.showOpenDialog(this) == 0) {
            this.outputDirField.setText(choosy.getCurrentDirectory().getPath());
        }
        choosy.setFileSelectionMode(mode);
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }
}

