##
# $Id: mysql.rb 8242 2010-01-26 20:12:13Z jduck $
##

##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/framework/
##

###
# This module provides methods for communicating with a host running MySQL.
###


require 'msf/core'
require 'rbmysql'

module Msf
module Exploit::Remote::MYSQL

	include Exploit::Remote::Tcp

	def initialize(info = {})
		super

		register_options(
			[
				Opt::RHOST,
				Opt::RPORT(3306),
				OptString.new('USERNAME', [ false, 'The username to authenticate as' ]),
				OptString.new('PASSWORD', [ false, 'The password for the specified username' ]),
			], Msf::Exploit::Remote::MYSQL
		)
	end

	def mysql_login(user='root', pass='', db=nil)
		disconnect if self.sock
		connect

		@mysql_handle = ::RbMysql.connect({
			:host     => rhost,
			:port     => rport,
			:socket   => sock,
			:user     => user,
			:password => pass,
			:db       => db
		})
	end

	def mysql_logoff
		@mysql_handle = nil if @mysql_handle
		disconnect if self.sock
	end

	def mysql_login_datastore
		mysql_login(datastore['USERNAME'], datastore['PASSWORD'])
	end

	def mysql_query(sql)
		res = nil
		begin
			res = @mysql_handle.query(sql)
		rescue ::RbMysql::Error => e
			print_error("MySQL Error: #{e.class} #{e.to_s}")
			return
		end

		res
	end

end
end

