# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Guillaume Emont <guillaume@fluendo.com>

import os, shutil

from twisted.trial.unittest import TestCase

from elisa.core.utils import path_utils

class HaveFileTestMixin(TestCase):
    directory = u"test_path_utils_sync_test"
    filenames = (u"existing éëč", u"empty éëč", u"not_existing éëč")

    def _filenames(self):
        return [os.path.join(self.directory, filename) 
                        for filename in self.filenames]

    def setUp(self):
        if not os.path.exists(self.directory):
            os.mkdir(self.directory)

        self.existing, self.empty, self.not_existing = self._filenames()
        
        f = file(self.existing, "w")
        f.write("some unimportant string")
        f.close()

        f = file(self.empty, "w")
        f.close()

    def tearDown(self):
        shutil.rmtree(self.directory)

class HaveFileSyncTest(HaveFileTestMixin):
    def test_existing(self):
        self.assertTrue(path_utils.have_file_sync(self.existing))

    def test_empty(self):
        self.assertFalse(path_utils.have_file_sync(self.empty))

    def test_not_existing(self):
        self.assertFalse(path_utils.have_file_sync(self.not_existing))

class HaveFileTest(HaveFileTestMixin):
    def test_existing(self):
        dfr = path_utils.have_file(self.existing)
        dfr.addCallback(self.assertTrue)
        return dfr

    def test_empty(self):
        dfr = path_utils.have_file(self.empty)
        dfr.addCallback(self.assertFalse)
        return dfr

    def test_not_existing(self):
        dfr = path_utils.have_file(self.not_existing)
        dfr.addCallback(self.assertFalse)
        return dfr

