# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Olivier Tilloy <olivier@fluendo.com>

from twisted.trial.unittest import TestCase

from elisa.core.plugin import Plugin

from distutils.version import LooseVersion
import pkg_resources


class TestPlugin(TestCase):

    def test_runs_on_current_platform(self):
        # Monkey patch
        self._orig_get_platform = pkg_resources.get_platform
        pkg_resources.get_platform = lambda: 'linux-i686'

        plugin = Plugin()
        self.failUnless(plugin.runs_on_current_platform())
        plugin.platforms = ['linux']
        self.failUnless(plugin.runs_on_current_platform())
        plugin.platforms = ['win32']
        self.failIf(plugin.runs_on_current_platform())
        plugin.platforms = ['win32', 'linux']
        self.failUnless(plugin.runs_on_current_platform())

        # Unpatch
        pkg_resources.get_platform = self._orig_get_platform

    def test_from_distribution(self):
        distribution = \
            pkg_resources.Distribution(project_name='elisa-plugin-test',
                                       version='0.1.4')
        distribution.author = 'Elisa Developers'
        distribution.license = 'GPLv3'
        distribution.summary = 'A test plugin'
        distribution.description = 'A test plugin that does nothing.'
        plugin = Plugin.from_distribution(distribution)
        self.failUnlessEqual(plugin.name, 'elisa-plugin-test')
        self.failUnlessEqual(plugin.version, LooseVersion('0.1.4'))
        self.failUnlessEqual(plugin.author_name, 'Elisa Developers')
        self.failUnlessEqual(plugin.platforms, [])
        self.failUnlessEqual(plugin.license, 'GPLv3')
        self.failUnlessEqual(plugin.title, 'A test plugin')
        self.failUnlessEqual(plugin.description,
                             'A test plugin that does nothing.')

        # Now with a platform specified
        distribution.platform = 'linux'
        plugin = Plugin.from_distribution(distribution)
        self.failUnlessEqual(plugin.platforms, ['linux'])

    def test_from_dict(self):
        dictionary = {}
        dictionary['name'] = 'elisa-plugin-test'
        dictionary['tags'] = ['test', 'plugin', 'elisa']
        dictionary['uri'] = 'http://elisa-plugins.com/elisa-plugin-test'
        dictionary['summary'] = 'Test plugin'
        dictionary['description'] = 'A test plugin that does nothing.'
        dictionary['version'] = '0.1.4'
        dictionary['platforms'] = 'linux ,  win32'
        dictionary['ignored'] = 'skipped'
        plugin = Plugin.from_dict(dictionary)
        self.failUnlessEqual(plugin.name, 'elisa-plugin-test')
        self.failUnlessEqual(plugin.tags, ['test', 'plugin', 'elisa'])
        self.failUnlessEqual(plugin.uri,
                             'http://elisa-plugins.com/elisa-plugin-test')
        self.failUnlessEqual(plugin.title, 'Test plugin')
        self.failUnlessEqual(plugin.description,
                             'A test plugin that does nothing.')
        self.failUnlessEqual(plugin.version, LooseVersion('0.1.4'))
        self.failUnlessEqual(plugin.platforms, ['linux', 'win32'])
        self.failIf(hasattr(plugin, 'ignored'))
