/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

class SplashWindow
extends Window {
    public static final long serialVersionUID = 1L;
    int width;
    int height;
    Image splashImage;
    Window splash = this;

    public SplashWindow(Window window, Image image) {
        super(window);
        this.splashImage = image;
        this.width = image.getWidth(this) + 2;
        this.height = image.getHeight(this) + 2;
        this.setSize(this.width, this.height);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.width) / 2, (dimension.height - this.height) / 2);
        if (guiserver.MAC_OS_X) {
            this.setBackground(new Color(0, 0, 0, 0));
        }
        this.setVisible(true);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                SplashWindow.this.splash.dispose();
            }
        });
    }

    public void paint(Graphics graphics) {
        if (guiserver.MAC_OS_X) {
            graphics.setColor(new Color(0, 0, 0, 0));
            graphics.fillRect(0, 0, this.width, this.height);
            System.out.println("mac os x");
        } else {
            graphics.setColor(Color.lightGray);
            graphics.fill3DRect(0, 0, this.width, this.height, true);
        }
        if (this.splashImage != null) {
            graphics.drawImage(this.splashImage, 1, 1, this);
        }
    }
}

