# $Id: Male.pm,v 1.8 2005/05/22 17:02:30 peterhickman Exp $

package Data::RandomPerson::Names::Male;

use strict;
use warnings;

use base 'Data::RandomPerson::Names';

use Data::RandomPerson::Choice;

sub new {
    my ($class) = @_;

    my $self = bless {}, $class;

	$self->{choice} = Data::RandomPerson::Choice->new();

	$self->{choice}->add_list( qw/
              aaron		    abdul	      abe		abel
			  abraham	    abram	      adalberto		adam
			  adan		    adolfo	      adolph		adrian
			  agustin	    ahmad	      ahmed		al
			  alan		    albert	      alberto		alden
			  aldo		    alec	      alejandro		alex
			  alexander	    alexis	      alfonso		alfonzo
			  alfred	    alfredo	      ali		allan
			  allen		    alonso	      alonzo		alphonse
			  alphonso	    alton	      alva		alvaro
			  alvin		    amado	      ambrose		amos
			  anderson	    andre	      andrea		andreas
			  andres	    andrew	      andy		angel
			  angelo	    anibal	      anthony		antione
			  antoine	    anton	      antone		antonia
			  antonio	    antony	      antwan		archie
			  arden		    ariel	      arlen		arlie
			  armand	    armando	      arnold		arnoldo
			  arnulfo	    aron	      arron		art
			  arthur	    arturo	      asa		ashley
			  aubrey	    august	      augustine		augustus
			  aurelio	    austin	      avery		barney
			  barrett	    barry	      bart		barton
			  basil		    beau	      ben		benedict
			  benito	    benjamin	      bennett		bennie
			  benny		    benton	      bernard		bernardo
			  bernie	    berry	      bert		bertram
			  bill		    billie	      billy		blaine
			  blair		    blake	      bo		bob
			  bobbie	    bobby	      booker		boris
			  boyce		    boyd	      brad		bradford
			  bradley	    bradly	      brady		brain
			  branden	    brandon	      brant		brendan
			  brendon	    brent	      brenton		bret
			  brett		    brian	      brice		britt
			  brock		    broderick	      brooks		bruce
			  bruno		    bryan	      bryant		bryce
			  bryon		    buck	      bud		buddy
			  buford	    burl	      burt		burton
			  buster	    byron	      caleb		calvin
			  cameron	    carey	      carl		carlo
			  carlos	    carlton	      carmelo		carmen
			  carmine	    carol	      carrol		carroll
			  carson	    carter	      cary		casey
			  cecil		    cedric	      cedrick		cesar
			  chad		    chadwick	      chance		chang
			  charles	    charley	      charlie		chas
			  chase		    chauncey	      chester		chet
			  chi		    chong	      chris		christian
			  christoper	    christopher	      chuck		chung
			  clair		    clarence	      clark		claud
			  claude	    claudio	      clay		clayton
			  clement	    clemente	      cleo		cletus
			  cleveland	    cliff	      clifford		clifton
			  clint		    clinton	      clyde		cody
			  colby		    cole	      coleman		colin
			  collin	    colton	      columbus		connie
			  conrad	    cordell	      corey		cornelius
			  cornell	    cortez	      cory		courtney
			  coy		    craig	      cristobal		cristopher
			  cruz		    curt	      curtis		cyril
			  cyrus		    dale	      dallas		dalton
			  damian	    damien	      damion		damon
			  dan		    dana	      dane		danial
			  daniel	    danilo	      dannie		danny
			  dante		    darell	      daren		darin
			  dario		    darius	      darnell		daron
			  darrel	    darrell	      darren		darrick
			  darrin	    darron	      darryl		darwin
			  daryl		    dave	      david		davis
			  dean		    deandre	      deangelo		dee
			  del		    delbert	      delmar		delmer
			  demarcus	    demetrius	      denis		dennis
			  denny		    denver	      deon		derek
			  derick	    derrick	      deshawn		desmond
			  devin		    devon	      dewayne		dewey
			  dewitt	    dexter	      dick		diego
			  dillon	    dino	      dion		dirk
			  domenic	    domingo	      dominic		dominick
			  dominique	    don		      donald		dong
			  donn		    donnell	      donnie		donny
			  donovan	    donte	      dorian		dorsey
			  doug		    douglas	      douglass		doyle
			  drew		    duane	      dudley		duncan
			  dustin	    dusty	      dwain		dwayne
			  dwight	    dylan	      earl		earle
			  earnest	    ed		      eddie		eddy
			  edgar		    edgardo	      edison		edmond
			  edmund	    edmundo	      eduardo		edward
			  edwardo	    edwin	      efrain		efren
			  elbert	    elden	      eldon		eldridge
			  eli		    elias	      elijah		eliseo
			  elisha	    elliot	      elliott		ellis
			  ellsworth	    elmer	      elmo		eloy
			  elroy		    elton	      elvin		elvis
			  elwood	    emanuel	      emerson		emery
			  emil		    emile	      emilio		emmanuel
			  emmett	    emmitt	      emory		enoch
			  enrique	    erasmo	      eric		erich
			  erick		    erik	      erin		ernest
			  ernesto	    ernie	      errol		ervin
			  erwin		    esteban	      ethan		eugene
			  eugenio	    eusebio	      evan		everett
			  everette	    ezekiel	      ezequiel		ezra
			  fabian	    faustino	      fausto		federico
			  felipe	    felix	      felton		ferdinand
			  fermin	    fernando	      fidel		filiberto
			  fletcher	    florencio	      florentino	floyd
			  forest	    forrest	      foster		frances
			  francesco	    francis	      francisco		frank
			  frankie	    franklin	      franklyn		fred
			  freddie	    freddy	      frederic		frederick
			  fredric	    fredrick	      freeman		fritz
			  gabriel	    gail	      gale		galen
			  garfield	    garland	      garret		garrett
			  garry		    garth	      gary		gaston
			  gavin		    gayle	      gaylord		genaro
			  gene		    geoffrey	      george		gerald
			  geraldo	    gerard	      gerardo		german
			  gerry		    gil		      gilbert		gilberto
			  gino		    giovanni	      giuseppe		glen
			  glenn		    gonzalo	      gordon		grady
			  graham	    graig	      grant		granville
			  greg		    gregg	      gregorio		gregory
			  grover	    guadalupe	      guillermo		gus
			  gustavo	    guy		      hai		hal
			  hank		    hans	      harlan		harland
			  harley	    harold	      harris		harrison
			  harry		    harvey	      hassan		hayden
			  haywood	    heath	      hector		henry
			  herb		    herbert	      heriberto		herman
			  herschel	    hershel	      hilario		hilton
			  hipolito	    hiram	      hobert		hollis
			  homer		    hong	      horace		horacio
			  hosea		    houston	      howard		hoyt
			  hubert	    huey	      hugh		hugo
			  humberto	    hung	      hunter		hyman
			  ian		    ignacio	      ike		ira
			  irvin		    irving	      irwin		isaac
			  isaiah	    isaias	      isiah		isidro
			  ismael	    israel	      isreal		issac
			  ivan		    ivory	      jacinto		jack
			  jackie	    jackson	      jacob		jacques
			  jae		    jaime	      jake		jamaal
			  jamal		    jamar	      jame		jamel
			  james		    jamey	      jamie		jamison
			  jan		    jared	      jarod		jarred
			  jarrett	    jarrod	      jarvis		jason
			  jasper	    javier	      jay		jayson
			  jc		    jean	      jed		jeff
			  jefferey	    jefferson	      jeffery		jeffrey
			  jeffry	    jerald	      jeramy		jere
			  jeremiah	    jeremy	      jermaine		jerold
			  jerome	    jeromy	      jerrell		jerrod
			  jerrold	    jerry	      jess		jesse
			  jessie	    jesus	      jewel		jewell
			  jim		    jimmie	      jimmy		joan
			  joaquin	    jody	      joe		joel
			  joesph	    joey	      john		johnathan
			  johnathon	    johnie	      johnnie		johnny
			  johnson	    jon		      jonah		jonas
			  jonathan	    jonathon	      jordan		jordon
			  jorge		    jose	      josef		joseph
			  josh		    joshua	      josiah		jospeh
			  josue		    juan	      jude		judson
			  jules		    julian	      julio		julius
			  junior	    justin	      kareem		karl
			  kasey		    keenan	      keith		kelley
			  kelly		    kelvin	      ken		kendall
			  kendrick	    keneth	      kenneth		kennith
			  kenny		    kent	      kenton		kermit
			  kerry		    keven	      kevin		kieth
			  kim		    king	      kip		kirby
			  kirk		    korey	      kory		kraig
			  kris		    kristofer	      kristopher	kurt
			  kurtis	    kyle	      lacy		lamar
			  lamont	    lance	      landon		lane
			  lanny		    larry	      lauren		laurence
			  lavern	    laverne	      lawerence		lawrence
			  lazaro	    leandro	      lee		leif
			  leigh		    leland	      lemuel		len
			  lenard	    lenny	      leo		leon
			  leonard	    leonardo	      leonel		leopoldo
			  leroy		    les		      lesley		leslie
			  lester	    levi	      lewis		lincoln
			  lindsay	    lindsey	      lino		linwood
			  lionel	    lloyd	      logan		lon
			  long		    lonnie	      lonny		loren
			  lorenzo	    lou		      louie		louis
			  lowell	    loyd	      lucas		luciano
			  lucien	    lucio	      lucius		luigi
			  luis		    luke	      lupe		luther
			  lyle		    lyman	      lyndon		lynn
			  lynwood	    mac		      mack		major
			  malcolm	    malcom	      malik		man
			  manual	    manuel	      marc		marcel
			  marcelino	    marcellus	      marcelo		marco
			  marcos	    marcus	      margarito		maria
			  mariano	    mario	      marion		mark
			  markus	    marlin	      marlon		marquis
			  marshall	    martin	      marty		marvin
			  mary		    mason	      mathew		matt
			  matthew	    maurice	      mauricio		mauro
			  max		    maximo	      maxwell		maynard
			  mckinley	    mel		      melvin		merle
			  merlin	    merrill	      mervin		micah
			  michael	    michal	      michale		micheal
			  michel	    mickey	      miguel		mike
			  mikel		    milan	      miles		milford
			  millard	    milo	      milton		minh
			  miquel	    mitch	      mitchel		mitchell
			  modesto	    mohamed	      mohammad		mohammed
			  moises	    monroe	      monte		monty
			  morgan	    morris	      morton		mose
			  moses		    moshe	      murray		myles
			  myron		    napoleon	      nathan		nathanael
			  nathanial	    nathaniel	      neal		ned
			  neil		    nelson	      nestor		neville
			  newton	    nicholas	      nick		nickolas
			  nicky		    nicolas	      nigel		noah
			  noble		    noe		      noel		nolan
			  norbert	    norberto	      norman		normand
			  norris	    numbers	      octavio		odell
			  odis		    olen	      olin		oliver
			  ollie		    omar	      omer		oren
			  orlando	    orval	      orville		oscar
			  osvaldo	    oswaldo	      otha		otis
			  otto		    owen	      pablo		palmer
			  paris		    parker	      pasquale		pat
			  patricia	    patrick	      paul		pedro
			  percy		    perry	      pete		peter
			  phil		    philip	      phillip		pierre
			  porfirio	    porter	      preston		prince
			  quentin	    quincy	      quinn		quintin
			  quinton	    rafael	      raleigh		ralph
			  ramiro	    ramon	      randal		randall
			  randell	    randolph	      randy		raphael
			  rashad	    raul	      ray		rayford
			  raymon	    raymond	      raymundo		reed
			  refugio	    reggie	      reginald		reid
			  reinaldo	    renaldo	      renato		rene
			  reuben	    rex		      rey		reyes
			  reynaldo	    rhett	      ricardo		rich
			  richard	    richie	      rick		rickey
			  rickie	    ricky	      rico		rigoberto
			  riley		    rob		      robbie		robby
			  robert	    roberto	      robin		robt
			  rocco		    rocky	      rod		roderick
			  rodger	    rodney	      rodolfo		rodrick
			  rodrigo	    rogelio	      roger		roland
			  rolando	    rolf	      rolland		roman
			  romeo		    ron		      ronald		ronnie
			  ronny		    roosevelt	      rory		rosario
			  roscoe	    rosendo	      ross		roy
			  royal		    royce	      ruben		rubin
			  rudolf	    rudolph	      rudy		rueben
			  rufus		    rupert	      russ		russel
			  russell	    rusty	      ryan		sal
			  salvador	    salvatore	      sam		sammie
			  sammy		    samual	      samuel		sandy
			  sanford	    sang	      santiago		santo
			  santos	    saul	      scot		scott
			  scottie	    scotty	      sean		sebastian
			  sergio	    seth	      seymour		shad
			  shane		    shannon	      shaun		shawn
			  shayne	    shelby	      sheldon		shelton
			  sherman	    sherwood	      shirley		shon
			  sid		    sidney	      silas		simon
			  sol		    solomon	      son		sonny
			  spencer	    stacey	      stacy		stan
			  stanford	    stanley	      stanton		stefan
			  stephan	    stephen	      sterling		steve
			  steven	    stevie	      stewart		stuart
			  sung		    sydney	      sylvester		tad
			  tanner	    taylor	      ted		teddy
			  teodoro	    terence	      terrance		terrell
			  terrence	    terry	      thad		thaddeus
			  thanh		    theo	      theodore		theron
			  thomas	    thurman	      tim		timmy
			  timothy	    titus	      tobias		toby
			  tod		    todd	      tom		tomas
			  tommie	    tommy	      toney		tony
			  tory		    tracey	      tracy		travis
			  trent		    trenton	      trevor		trey
			  trinidad	    tristan	      troy		truman
			  tuan		    ty		      tyler		tyree
			  tyrell	    tyron	      tyrone		tyson
			  ulysses	    val		      valentin		valentine
			  van		    vance	      vaughn		vern
			  vernon	    vicente	      victor		vince
			  vincent	    vincenzo	      virgil		virgilio
			  vito		    von		      wade		waldo
			  walker	    wallace	      wally		walter
			  walton	    ward	      warner		warren
			  waylon	    wayne	      weldon		wendell
			  werner	    wes		      wesley		weston
			  whitney	    wilber	      wilbert		wilbur
			  wilburn	    wiley	      wilford		wilfred
			  wilfredo	    will	      willard		william
			  williams	    willian	      willie		willis
			  willy		    wilmer	      wilson		wilton
			  winford	    winfred	      winston		wm
			  woodrow	    wyatt	      xavier		yong
			  young		    zachariah	      zachary		zachery
			  zack		    zackary	      zane
			  / );

    return $self;
}

1;

__END__
=head1 NAME

Data::RandomPerson::Names::Male - A list of male names from some census data

=head1 VERSION

This document refers to version 0.4 of Data::RandomPerson::Names::Male, released Sept 13th, 2005

=head1 SYNOPSIS

  use Data::RandomPerson::Names::Male;

  my $m = Data::RandomPerson::Names::Male->new();

  print $m->get();

=head1 DESCRIPTION

=head2 Overview

Returns a random element from a list of male names culled from some census data.

=head2 Constructors and initialization

=over 4

=item new( )

Create the Data::RandomPerson::Names::Male object.

=back

=head2 Class and object methods

=over 4

=item get( )

Returns a random name from the list.

=item size( )

Returns the size of the list

=back

=head1 ENVIRONMENT

Perl 5

=head1 DIAGNOSTICS

None

=head1 BUGS

None so far

=head1 FILES

None

=head1 SEE ALSO

None

=head1 AUTHOR

Peter Hickman (peterhi@ntlworld.com)

=head1 COPYRIGHT

Copyright (c) 2005, Peter Hickman. All rights reserved. This module is
free software. It may be used, redistributed and/or modified under the
same terms as Perl itself.
