'''OpenGL extension EXT.multi_draw_arrays

This module customises the behaviour of the 
OpenGL.raw.GL.EXT.multi_draw_arrays to provide a more 
Python-friendly API
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.EXT.multi_draw_arrays import *
### END AUTOGENERATED SECTION
from OpenGL.lazywrapper import lazy
from OpenGL.GL.pointers import glDrawElements

@lazy( glMultiDrawElementsEXT )
def glMultiDrawElementsEXT(baseOperation, primtype, counts, typ, indices, primcount=None):
	"""Currently glMultiDrawElementsEXT is not working in the wrapper 
	
	We are replacing the code with a sequence of glDrawElements calls
	as per the spec for the function.  Basically we'd spend more effort
	making an array of array pointers than we would creating a simple
	iteration in Python.
	"""
	if primcount is not None:
		for i in xrange( primcount ):
			glDrawElements( primtype, counts[i], typ, indices[i] )
	else:
		for c,i in zip( counts, indices ):
			glDrawElements( primtype, c, typ, i )

#def convertIndices( arg, wrappedOperation, args ):
#	"""Convert indices to an array of arrays"""
#	return [
#		arrays.ArrayDatatype.asArray( element, args[2] )
#		for element in arg
#	]
#def resolveIndices( value ):
#	pointers = []
#	for v in value:
#		pointers.append( arrays.ArrayDatatype.voidDataPointer( v ) )
#	typ = ctypes.POINTER(None) * len(value)
#	return typ( *pointers )
#
#glMultiDrawElementsEXT = wrapper.wrapper( glMultiDrawElementsEXT ).setPyConverter(
#	'indices', convertIndices,
#).setCResolver( 
#	'indices', resolveIndices,
#).setPyConverter(
#	'count', arrays.AsArrayTyped( 'count', arrays.GLsizeiArray ),
#).setCResolver(
#	'count', arrays.ArrayDatatype.voidDataPointer ,
#)
